/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.i18n;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.cache.CmsVfsMemoryObjectCache;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsVfsBundleLoaderProperties;
import org.opencms.i18n.CmsVfsBundleParameters;
import org.opencms.i18n.I_CmsResourceBundle;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.xml.content.CmsVfsBundleLoaderXml;

public class CmsVfsResourceBundle
extends ResourceBundle
implements I_CmsResourceBundle {
    public static final String TYPE_PROPERTIES = "properties";
    public static final String TYPE_XML = "xml";
    protected static CmsObject m_cms;
    private static final Log LOG;
    private static CmsVfsMemoryObjectCache m_cache;
    protected I_Loader m_loader;
    protected CmsVfsBundleParameters m_parameters;

    public CmsVfsResourceBundle(CmsVfsBundleParameters params) {
        this.m_parameters = params;
        this.m_loader = CmsVfsResourceBundle.initLoader(params.getType());
    }

    public static void setCmsObject(CmsObject cms) {
        m_cms = cms;
    }

    private static I_Loader initLoader(String type) {
        if (TYPE_PROPERTIES.equals(type)) {
            return new CmsVfsBundleLoaderProperties();
        }
        if (TYPE_XML.equals(type)) {
            return new CmsVfsBundleLoaderXml();
        }
        return new CmsVfsBundleLoaderXml();
    }

    @Override
    public CmsVfsResourceBundle getClone() {
        return new CmsVfsResourceBundle(this.m_parameters);
    }

    @Override
    public Enumeration<String> getKeys() {
        Iterator myKeyIter;
        Iterator result = myKeyIter = this.handleKeySet().iterator();
        if (this.parent != null) {
            UnmodifiableIterator parentKeyIter = Iterators.forEnumeration(this.parent.getKeys());
            result = Iterators.concat(myKeyIter, (Iterator)parentKeyIter);
        }
        return Iterators.asEnumeration(result);
    }

    @Override
    public Locale getLocale() {
        return this.m_parameters.getLocale();
    }

    public CmsVfsBundleParameters getParameters() {
        return this.m_parameters;
    }

    @Override
    public void setLocale(Locale locale) {
    }

    @Override
    public void setParent(ResourceBundle p) {
        super.setParent(p);
    }

    protected String getFilePath() {
        return this.m_parameters.getBasePath();
    }

    @Override
    protected Object handleGetObject(String key) {
        Map<String, String> messages = this.getMessagesForLocale();
        return messages.get(key);
    }

    @Override
    protected Set<String> handleKeySet() {
        Map<String, String> messages = this.getMessagesForLocale();
        return messages.keySet();
    }

    private Map<Locale, Map<String, String>> getData() {
        Map<Locale, Map<String, String>> result = (Map<Locale, Map<String, String>>)m_cache.getCachedObject(m_cms, this.getFilePath());
        if (result == null) {
            try {
                result = this.m_loader.loadData(m_cms, this.m_parameters);
                m_cache.putCachedObject(m_cms, this.getFilePath(), result);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private Map<String, String> getMessagesForLocale() {
        Map<Locale, Map<String, String>> data = this.getData();
        if (data == null) {
            return Collections.emptyMap();
        }
        ArrayList<Locale> available = new ArrayList<Locale>(data.keySet());
        Locale bestMatchingLocale = OpenCms.getLocaleManager().getBestMatchingLocale(this.getLocale(), OpenCms.getLocaleManager().getDefaultLocales(), available);
        Map<String, String> bundleForLocale = data.get(bestMatchingLocale);
        if (bundleForLocale == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(bundleForLocale);
    }

    static {
        LOG = CmsLog.getLog(CmsVfsResourceBundle.class);
        m_cache = new CmsVfsMemoryObjectCache();
    }

    public static interface I_Loader {
        public Map<Locale, Map<String, String>> loadData(CmsObject var1, CmsVfsBundleParameters var2) throws Exception;
    }
}

