/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.importexport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.dom4j.Element;
import org.opencms.importexport.Messages;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.module.CmsModule;
import org.opencms.util.CmsStringUtil;

public class CmsExportParameters {
    private String m_additionalResourceList = null;
    private long m_contentAge;
    private boolean m_exportAccountData;
    private boolean m_exportAsFiles;
    private CmsModule.ExportMode m_exportMode = CmsModule.ExportMode.DEFAULT;
    private boolean m_exportProjectData;
    private boolean m_exportResourceData = true;
    private boolean m_includeSystemFolder = true;
    private boolean m_includeUnchangedResources = true;
    private boolean m_inProject;
    private Element m_moduleInfo;
    private String m_overrideSiteRoot;
    private String m_path;
    private boolean m_recursive = true;
    private List<String> m_resources;
    private boolean m_skipParentFolders;
    private boolean m_xmlValidation;
    private List<String> m_additionalResourcesToExportWithMetaData;

    public CmsExportParameters() {
    }

    public CmsExportParameters(String exportFile, Element moduleElement, boolean exportResourceData, boolean exportUserdata, boolean exportProjectData, List<String> resourcesToExport, boolean includeSystem, boolean includeUnchanged, long contentAge, boolean recursive, boolean inProject, CmsModule.ExportMode exportMode) {
        this.setPath(exportFile);
        this.setResources(resourcesToExport);
        this.setIncludeSystemFolder(includeSystem);
        this.setIncludeUnchangedResources(includeUnchanged);
        this.setModuleInfo(moduleElement);
        this.setExportAccountData(exportUserdata);
        this.setContentAge(contentAge);
        this.setRecursive(recursive);
        this.setExportResourceData(exportResourceData);
        this.setExportProjectData(exportProjectData);
        this.setInProject(inProject);
        this.setExportAsFiles(false);
        this.setExportMode(exportMode);
        this.setAdditionalResourcesToExportWithMetaData(null);
    }

    public CmsExportParameters(String exportFile, Element moduleElement, boolean exportResourceData, boolean exportUserdata, boolean exportProjectData, List<String> resourcesToExport, boolean includeSystem, boolean includeUnchanged, long contentAge, boolean recursive, boolean inProject, CmsModule.ExportMode exportMode, List<String> additionalResourcesToExportWithMetaData) {
        this.setPath(exportFile);
        this.setResources(resourcesToExport);
        this.setIncludeSystemFolder(includeSystem);
        this.setIncludeUnchangedResources(includeUnchanged);
        this.setModuleInfo(moduleElement);
        this.setExportAccountData(exportUserdata);
        this.setContentAge(contentAge);
        this.setRecursive(recursive);
        this.setExportResourceData(exportResourceData);
        this.setExportProjectData(exportProjectData);
        this.setInProject(inProject);
        this.setExportAsFiles(false);
        this.setExportMode(exportMode);
        this.setAdditionalResourcesToExportWithMetaData(additionalResourcesToExportWithMetaData);
    }

    public void addAdditionalResources() {
        if (this.m_additionalResourceList != null) {
            HashSet<String> resources = new HashSet<String>();
            resources.addAll(this.getResources());
            for (String line : this.m_additionalResourceList.split("\n")) {
                if ((line = line.trim()).length() <= 0) continue;
                resources.add(line);
            }
            this.setResources(new ArrayList<String>(resources));
            this.m_additionalResourceList = null;
        }
    }

    public String getAdditionalResourceList() {
        return this.m_additionalResourceList;
    }

    public long getContentAge() {
        return this.m_contentAge;
    }

    public CmsModule.ExportMode getExportMode() {
        return this.m_exportMode;
    }

    public Element getModuleInfo() {
        return this.m_moduleInfo;
    }

    public String getPath() {
        if (this.m_path != null && !this.isExportAsFiles() && !this.m_path.toLowerCase().endsWith(".zip")) {
            this.m_path = this.m_path + ".zip";
        }
        return this.m_path;
    }

    public List<String> getResources() {
        if (this.m_resources == null) {
            return Collections.emptyList();
        }
        return this.m_resources;
    }

    public List<String> getResourcesToExportWithMetaData() {
        return null != this.m_additionalResourcesToExportWithMetaData ? this.m_additionalResourcesToExportWithMetaData : Collections.emptyList();
    }

    public boolean isExportAccountData() {
        return this.m_exportAccountData;
    }

    public boolean isExportAsFiles() {
        return this.m_exportAsFiles;
    }

    public boolean isExportProjectData() {
        return this.m_exportProjectData;
    }

    public boolean isExportResourceData() {
        return this.m_exportResourceData;
    }

    public boolean isIncludeSystemFolder() {
        return this.m_includeSystemFolder;
    }

    public boolean isIncludeUnchangedResources() {
        return this.m_includeUnchangedResources;
    }

    public boolean isInProject() {
        return this.m_inProject;
    }

    public boolean isRecursive() {
        return this.m_recursive;
    }

    public boolean isSkipParentFolders() {
        return this.m_skipParentFolders;
    }

    public boolean isXmlValidation() {
        return this.m_xmlValidation;
    }

    public void setAdditionalResourceList(String additionalResourceList) {
        this.m_additionalResourceList = additionalResourceList;
    }

    public void setAdditionalResourcesToExportWithMetaData(List<String> resourcesToExportWithMetaData) {
        this.m_additionalResourcesToExportWithMetaData = resourcesToExportWithMetaData;
    }

    public void setContentAge(long contentAge) {
        if (contentAge < 0L) {
            String ageString = Long.toString(contentAge);
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_BAD_CONTENT_AGE_1", ageString));
        }
        this.m_contentAge = contentAge;
    }

    public void setExportAccountData(boolean exportAccountData) {
        this.m_exportAccountData = exportAccountData;
    }

    public void setExportAsFiles(boolean exportAsFiles) {
        this.m_exportAsFiles = exportAsFiles;
    }

    public void setExportMode(CmsModule.ExportMode exportMode) {
        this.m_exportMode = null != exportMode ? exportMode : CmsModule.ExportMode.DEFAULT;
    }

    public void setExportProjectData(boolean exportProjectData) {
        this.m_exportProjectData = exportProjectData;
    }

    public void setExportResourceData(boolean exportResourceData) {
        this.m_exportResourceData = exportResourceData;
    }

    public void setIncludeSystemFolder(boolean includeSystemFolder) {
        this.m_includeSystemFolder = includeSystemFolder;
    }

    public void setIncludeUnchangedResources(boolean includeUnchangedResources) {
        this.m_includeUnchangedResources = includeUnchangedResources;
    }

    public void setInProject(boolean inProject) {
        this.m_inProject = inProject;
    }

    public void setModuleInfo(Element moduleInfo) {
        this.m_moduleInfo = moduleInfo;
    }

    public void setPath(String path) {
        if (CmsStringUtil.isEmpty(path) || !path.trim().equals(path)) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_BAD_FILE_NAME_1", path));
        }
        this.m_path = path;
    }

    public void setRecursive(boolean recursive) {
        this.m_recursive = recursive;
    }

    public void setResources(List<String> resources) {
        this.m_resources = resources;
    }

    public void setSkipParentFolders(boolean skipSuperFolders) {
        this.m_skipParentFolders = skipSuperFolders;
    }

    public void setXmlValidation(boolean xmlValidation) {
        this.m_xmlValidation = xmlValidation;
    }
}

