/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.logging.Log;
import org.opencms.ade.containerpage.CmsContainerpageActionElement;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.history.CmsHistoryResourceHandler;
import org.opencms.flex.CmsFlexController;
import org.opencms.gwt.CmsGwtActionElement;
import org.opencms.i18n.CmsEncoder;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.jsp.CmsJspTagEditable;
import org.opencms.jsp.Messages;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.editors.directedit.CmsAdvancedDirectEditProvider;
import org.opencms.workplace.editors.directedit.CmsDirectEditMode;

public class CmsJspTagEnableAde
extends BodyTagSupport {
    private static final Log LOG = CmsLog.getLog(CmsJspTagEnableAde.class);
    private static final long serialVersionUID = 8447599916548975733L;

    public static void enableAdeTagAction(PageContext context) throws JspException {
        ServletRequest req = context.getRequest();
        if (CmsHistoryResourceHandler.isHistoryRequest(req)) {
            return;
        }
        CmsFlexController controller = CmsFlexController.getController(req);
        CmsObject cms = controller.getCmsObject();
        if (cms.getRequestContext().getCurrentProject().isOnlineProject()) {
            return;
        }
        if (CmsResource.isTemporaryFileName(cms.getRequestContext().getUri())) {
            return;
        }
        CmsJspTagEnableAde.updateDirectEditFlagInSession(req);
        if (CmsJspTagEnableAde.isDirectEditDisabled(req)) {
            try {
                String buttonLeft = null;
                Integer left = (Integer)((HttpServletRequest)req).getSession().getAttribute("__buttonLeft");
                buttonLeft = left != null ? left.toString() + "px" : "20%";
                String titleMessage = Messages.get().getBundle(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms)).key("GUI_TOOLBAR_ENABLE_EDIT_MODE_0");
                context.getOut().print(CmsJspTagEnableAde.getPreviewInclude(buttonLeft, titleMessage));
            }
            catch (IOException e) {
                throw new JspException((Throwable)e);
            }
        }
        CmsAdvancedDirectEditProvider eb = new CmsAdvancedDirectEditProvider();
        eb.init(cms, CmsDirectEditMode.TRUE, "");
        CmsJspTagEditable.setDirectEditProvider(context, eb);
        try {
            CmsContainerpageActionElement actionEl = new CmsContainerpageActionElement(context, (HttpServletRequest)req, (HttpServletResponse)context.getResponse());
            context.getOut().print(actionEl.exportAll());
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
    }

    public static boolean isDirectEditDisabled(ServletRequest request) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(request.getParameter("__templateContext"))) {
            return true;
        }
        String disabledParam = request.getParameter("__disableDirectEdit");
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(disabledParam)) {
            return Boolean.parseBoolean(disabledParam);
        }
        HttpSession session = ((HttpServletRequest)request).getSession(false);
        Boolean disabledAttr = null == session ? null : (Boolean)session.getAttribute("__disableDirectEdit");
        return disabledAttr != null && disabledAttr != false;
    }

    public static void removeDirectEditFlagFromSession(HttpSession session) {
        session.removeAttribute("__disableDirectEdit");
    }

    public static void updateDirectEditFlagInSession(ServletRequest request) {
        String disabledParam = request.getParameter("__disableDirectEdit");
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(disabledParam)) {
            if (Boolean.parseBoolean(disabledParam)) {
                ((HttpServletRequest)request).getSession().setAttribute("__disableDirectEdit", (Object)Boolean.TRUE);
                String buttonLeft = request.getParameter("__buttonLeft");
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(buttonLeft)) {
                    Integer left = null;
                    try {
                        left = Integer.valueOf(buttonLeft);
                        if (left > 0) {
                            ((HttpServletRequest)request).getSession().setAttribute("__buttonLeft", (Object)left);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else {
                ((HttpServletRequest)request).getSession().removeAttribute("__disableDirectEdit");
            }
        }
    }

    private static String getPreviewInclude(String buttonLeft, String titleMessage) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<style type=\"text/css\"> @import url(\"").append(CmsGwtActionElement.getFontIconCssLink()).append("\"); </style>\n");
        String heartbeatUrl = CmsStringUtil.joinPaths(OpenCms.getStaticExportManager().getVfsPrefix(), "/handleBuiltinService/", "/updateSession");
        JSONObject previewSettings = new JSONObject();
        try {
            previewSettings.put("heartbeatUrl", heartbeatUrl);
            previewSettings.put("buttonLeft", buttonLeft);
            previewSettings.put("titleMessage", CmsEncoder.escapeXml(titleMessage));
        }
        catch (JSONException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        buffer.append("<script>\nvar previewSettings = " + previewSettings.toString() + ";\n</script>\n");
        buffer.append("<script src=\"" + CmsWorkplace.getStaticResourceUri("/ade/page-preview.js") + "\"></script>\n");
        return buffer.toString();
    }

    public int doEndTag() throws JspException {
        CmsJspTagEnableAde.enableAdeTagAction(this.pageContext);
        if (OpenCms.getSystemInfo().getServletContainerSettings().isReleaseTagsAfterEnd()) {
            this.release();
        }
        return 6;
    }

    public int doStartTag() {
        return 1;
    }
}

