/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanCodex;
import com.google.web.bindery.autobean.vm.AutoBeanFactorySource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResourceFilter;
import org.opencms.flex.CmsFlexController;
import org.opencms.gwt.shared.I_CmsAutoBeanFactory;
import org.opencms.gwt.shared.I_CmsListAddMetadata;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.search.config.parser.simplesearch.CmsConfigurationBean;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;

public class CmsJspTagEnableListAdd
extends SimpleTagSupport {
    private static final Log LOG = CmsLog.getLog(CmsJspTagEnableListAdd.class);
    private String m_postCreateHandler;
    private List<String> m_types = new ArrayList<String>();
    private String m_uploadFolder;

    public void doTag() throws IOException {
        PageContext pageContext = (PageContext)this.getJspContext();
        CmsFlexController controller = CmsFlexController.getController(pageContext.getRequest());
        CmsObject cms = controller.getCmsObject();
        CmsJspStandardContextBean standardContext = CmsJspStandardContextBean.getInstance(pageContext.getRequest());
        if (standardContext.getIsEditMode()) {
            I_CmsAutoBeanFactory beanFactory = (I_CmsAutoBeanFactory)AutoBeanFactorySource.create(I_CmsAutoBeanFactory.class);
            AutoBean<I_CmsListAddMetadata> bean = beanFactory.createListAddMetadata();
            ((I_CmsListAddMetadata)bean.as()).setTypes(this.m_types);
            ((I_CmsListAddMetadata)bean.as()).setPostCreateHandler(this.m_postCreateHandler);
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_uploadFolder) && !"none".equals(this.m_uploadFolder)) {
                try {
                    cms.readResource(this.m_uploadFolder, CmsResourceFilter.IGNORE_EXPIRATION);
                    ((I_CmsListAddMetadata)bean.as()).setUploadFolder(this.m_uploadFolder);
                }
                catch (CmsException e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            String jsonData = AutoBeanCodex.encode(bean).getPayload();
            StringBuilder buffer = new StringBuilder();
            buffer.append("<div style='display: none !important;' data-oc-listadd='");
            buffer.append(CmsEncoder.escapeXml(jsonData));
            buffer.append("'></div>");
            pageContext.getOut().println(buffer.toString());
        }
    }

    public void setPostCreateHandler(String postCreateHandler) {
        this.m_postCreateHandler = postCreateHandler;
    }

    public void setTypes(Object typesObj) throws JspException {
        if (typesObj instanceof String) {
            String[] tokens = ((String)typesObj).split(",");
            this.setTypes(Arrays.asList(tokens));
        } else if (typesObj instanceof Collection) {
            Collection types = (Collection)typesObj;
            this.m_types = types.stream().map(type -> CmsConfigurationBean.getResourceTypeForDisplayType("" + type).trim()).distinct().collect(Collectors.toList());
        } else {
            throw new JspException("Invalid type for types attribute of enable-list-add tag: " + typesObj);
        }
    }

    public void setUploadFolder(String uploadFolder) {
        this.m_uploadFolder = uploadFolder;
    }
}

