/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.formatters.CmsFormatterConfigurationCacheState;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.flex.CmsFlexController;
import org.opencms.jsp.CmsJspTagDisplay;
import org.opencms.jsp.I_CmsJspTagParamParent;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.I_CmsFormatterBean;

public class CmsJspTagSimpleDisplay
extends BodyTagSupport
implements I_CmsJspTagParamParent {
    private static final Log LOG = CmsLog.getLog(CmsJspTagSimpleDisplay.class);
    private static final long serialVersionUID = 2285680951218629093L;
    private Boolean m_cacheable;
    private boolean m_canCreate;
    private boolean m_canDelete;
    private String m_creationSiteMap;
    private boolean m_editable;
    private String m_formatterKey;
    private String m_formatterPath;
    private Map<String, String> m_parameterMap = new LinkedHashMap<String, String>();
    private boolean m_passSettings;
    private String m_postCreateHandler;
    private Map<String, String> m_settings;
    private String m_uploadFolder;
    private String m_value;

    @Override
    public void addParameter(String name, String value) {
        if (name == null || value == null) {
            return;
        }
        this.m_parameterMap.put(name, value);
    }

    public int doEndTag() {
        ServletRequest request = this.pageContext.getRequest();
        ServletResponse response = this.pageContext.getResponse();
        if (CmsFlexController.isCmsRequest(request)) {
            CmsObject cms = CmsFlexController.getCmsObject(request);
            try {
                boolean isOnline = cms.getRequestContext().getCurrentProject().isOnlineProject();
                CmsResource res = null;
                if (CmsUUID.isValidUUID(this.m_value)) {
                    CmsUUID structureId = new CmsUUID(this.m_value);
                    res = isOnline ? cms.readResource(structureId) : cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
                } else {
                    res = isOnline ? cms.readResource(this.m_value) : cms.readResource(this.m_value, CmsResourceFilter.IGNORE_EXPIRATION);
                }
                CmsADEConfigData config = OpenCms.getADEManager().lookupConfigurationWithCache(cms, cms.getRequestContext().getRootUri());
                I_CmsFormatterBean formatter = this.getFormatterBean(cms, config);
                HashMap<String, String> settings = new HashMap<String, String>();
                for (Map.Entry<String, String> entry : this.m_parameterMap.entrySet()) {
                    String settingKeySuffix = CmsJspTagDisplay.getSettingKeyForMatchingFormatterPrefix(config, formatter, entry.getKey());
                    if (settingKeySuffix != null) {
                        settings.put(settingKeySuffix, entry.getValue());
                        continue;
                    }
                    if (settings.containsKey(entry.getKey())) continue;
                    settings.put(entry.getKey(), entry.getValue());
                }
                CmsJspTagDisplay.displayAction(res, formatter, settings, this.isCacheable(), this.m_editable, this.m_canCreate, this.m_canDelete, this.m_creationSiteMap, this.m_postCreateHandler, this.m_uploadFolder, this.pageContext, request, response);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        this.release();
        return 6;
    }

    public int doStartTag() {
        CmsJspStandardContextBean.CmsContainerElementWrapper element;
        if (Boolean.valueOf(this.m_passSettings).booleanValue() && (element = CmsJspStandardContextBean.getInstance(this.pageContext.getRequest()).getElement()) != null) {
            this.m_parameterMap.putAll(((CmsContainerElementBean)element).getSettings());
        }
        if (this.m_settings != null) {
            this.m_parameterMap.putAll(this.m_settings);
        }
        return 2;
    }

    public boolean getEditable() {
        return this.m_editable;
    }

    public boolean getPassSettings() {
        return this.m_passSettings;
    }

    public Map<String, String> getSettings() {
        return this.m_settings;
    }

    public String getValue() {
        return this.m_value;
    }

    public void release() {
        super.release();
        this.m_parameterMap.clear();
        this.m_settings = null;
        this.m_passSettings = false;
        this.m_editable = false;
        this.m_value = null;
    }

    public void setCacheable(boolean cacheable) {
        this.m_cacheable = cacheable;
    }

    public void setCreate(boolean canCreate) {
        this.m_canCreate = canCreate;
    }

    public void setCreate(String canCreate) {
        this.m_canCreate = Boolean.valueOf(canCreate);
    }

    public void setCreationSiteMap(String sitePath) {
        this.m_creationSiteMap = sitePath;
    }

    public void setDelete(boolean canDelete) {
        this.m_canDelete = canDelete;
    }

    public void setDelete(String canDelete) {
        this.m_canDelete = Boolean.valueOf(canDelete);
    }

    public void setEditable(boolean editable) {
        this.m_editable = editable;
    }

    public void setEditable(String editable) {
        this.m_editable = Boolean.valueOf(editable);
    }

    public void setFormatter(String formatter) {
        this.m_formatterPath = formatter;
    }

    public void setFormatterKey(String formatterKey) {
        this.m_formatterKey = formatterKey;
    }

    public void setPassSettings(Boolean passSettings) {
        this.m_passSettings = passSettings;
    }

    public void setPostCreateHandler(String postCreateHandler) {
        this.m_postCreateHandler = postCreateHandler;
    }

    public void setSettings(Map<String, String> settings) {
        this.m_settings = settings;
    }

    public void setUploadFolder(String uploadFolder) {
        this.m_uploadFolder = uploadFolder;
    }

    public void setValue(String value) {
        this.m_value = value;
    }

    private I_CmsFormatterBean getFormatterBean(CmsObject cms, CmsADEConfigData config) throws CmsException {
        I_CmsFormatterBean formatterForKey;
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_formatterKey) && (formatterForKey = config.findFormatter(this.m_formatterKey)) != null) {
            return formatterForKey;
        }
        CmsResource formatterResource = cms.readResource(this.m_formatterPath);
        CmsFormatterConfigurationCacheState formatterCache = OpenCms.getADEManager().getCachedFormatters(cms.getRequestContext().getCurrentProject().isOnlineProject());
        I_CmsFormatterBean formatter = formatterCache.getFormatters().get(formatterResource.getStructureId());
        return formatter;
    }

    private boolean isCacheable() {
        return this.m_cacheable == null || this.m_cacheable != false;
    }
}

