/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.jsp.JspException;
import org.apache.commons.logging.Log;
import org.opencms.ade.publish.CmsPublishListHelper;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.collectors.I_CmsCollectorPublishListProvider;
import org.opencms.flex.CmsFlexController;
import org.opencms.gwt.shared.I_CmsContentLoadCollectorInfo;
import org.opencms.jsp.CmsContentLoadCollectorInfo;
import org.opencms.jsp.CmsJspScopedVarBodyTagSuport;
import org.opencms.jsp.CmsJspTagEditable;
import org.opencms.jsp.Messages;
import org.opencms.jsp.search.config.CmsSearchConfiguration;
import org.opencms.jsp.search.config.parser.CmsSimpleSearchConfigurationParser;
import org.opencms.jsp.search.config.parser.simplesearch.CmsConfigParserUtils;
import org.opencms.jsp.search.config.parser.simplesearch.CmsConfigurationBean;
import org.opencms.jsp.search.controller.CmsSearchController;
import org.opencms.jsp.search.controller.I_CmsSearchControllerCommon;
import org.opencms.jsp.search.controller.I_CmsSearchControllerMain;
import org.opencms.jsp.search.result.CmsSearchResultWrapper;
import org.opencms.jsp.search.result.I_CmsSearchResultWrapper;
import org.opencms.jsp.util.CmsJspElFunctions;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchException;
import org.opencms.search.CmsSearchResource;
import org.opencms.search.solr.CmsSolrIndex;
import org.opencms.search.solr.CmsSolrQuery;
import org.opencms.search.solr.CmsSolrResultList;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsUUID;

public class CmsJspTagSimpleSearch
extends CmsJspScopedVarBodyTagSuport
implements I_CmsCollectorPublishListProvider {
    public static final int DEFAULT_CONTENTINFO_ROWS = 600;
    private static final Log LOG = CmsLog.getLog(CmsJspTagSimpleSearch.class);
    private static final long serialVersionUID = -12197069109672022L;
    private Integer m_addContentInfoForEntries;
    private Object m_configFile;
    private String m_configString;
    private CmsSolrIndex m_index;
    private I_CmsSearchControllerMain m_searchController;

    public static Set<CmsResource> getPublishResourcesInternal(CmsObject cms, I_CmsContentLoadCollectorInfo info) throws CmsException {
        CmsSolrIndex solrOnline = OpenCms.getSearchManager().getIndexSolr("Solr Online");
        CmsSolrIndex solrOffline = OpenCms.getSearchManager().getIndexSolr("Solr Offline");
        HashSet<CmsResource> result = new HashSet<CmsResource>();
        try {
            Map<String, String[]> searchParams = CmsRequestUtil.createParameterMap(info.getCollectorParams(), true, null);
            CmsSolrResultList offlineResults = solrOffline.search(CmsPublishListHelper.adjustCmsObject(cms, false), new CmsSolrQuery(null, searchParams), true);
            HashSet<String> offlineIds = new HashSet<String>(offlineResults.size());
            for (CmsSearchResource offlineResult : offlineResults) {
                offlineIds.add(offlineResult.getField("id"));
            }
            for (String id : offlineIds) {
                CmsResource resource = cms.readResource(new CmsUUID(id));
                if (resource.getState().isUnchanged()) continue;
                result.add(resource);
            }
            CmsSolrResultList onlineResults = solrOnline.search(CmsPublishListHelper.adjustCmsObject(cms, true), new CmsSolrQuery(null, searchParams), true);
            HashSet<String> deletedIds = new HashSet<String>(onlineResults.size());
            for (CmsSearchResource onlineResult : onlineResults) {
                String uuid = onlineResult.getField("id");
                if (offlineIds.contains(uuid)) continue;
                deletedIds.add(uuid);
            }
            for (String uuid : deletedIds) {
                CmsResource resource = cms.readResource(new CmsUUID(uuid), CmsResourceFilter.ALL);
                if (resource.getState().isUnchanged()) continue;
                result.add(resource);
            }
        }
        catch (CmsSearchException e) {
            LOG.warn((Object)Messages.get().getBundle().key("LOG_TAG_SEARCH_SEARCH_FAILED_0"), (Throwable)e);
        }
        return result;
    }

    public int doEndTag() throws JspException {
        this.release();
        return super.doEndTag();
    }

    public int doStartTag() throws JspException, CmsIllegalArgumentException {
        CmsFlexController controller = CmsFlexController.getController(this.pageContext.getRequest());
        CmsObject cms = controller.getCmsObject();
        try {
            CmsSearchConfiguration config = null;
            CmsResource resource = CmsJspElFunctions.convertRawResource(cms, this.m_configFile);
            CmsConfigurationBean configBean = CmsConfigParserUtils.parseListConfiguration(cms, resource);
            config = new CmsSearchConfiguration(new CmsSimpleSearchConfigurationParser(cms, configBean, this.m_configString), cms);
            this.m_searchController = new CmsSearchController(config);
            String indexName = this.m_searchController.getCommon().getConfig().getSolrIndex();
            if (indexName != null && !indexName.trim().isEmpty()) {
                this.m_index = OpenCms.getSearchManager().getIndexSolr(indexName);
            }
            if (this.m_index == null) {
                this.m_index = OpenCms.getSearchManager().getIndexSolr(cms.getRequestContext().getCurrentProject().isOnlineProject() ? "Solr Online" : "Solr Offline");
            }
            this.storeAttribute(this.getVar(), this.getSearchResults(cms));
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            controller.setThrowable(e, cms.getRequestContext().getUri());
            throw new JspException((Throwable)e);
        }
        if (!cms.getRequestContext().getCurrentProject().isOnlineProject() && this.m_addContentInfoForEntries != null && "Solr Offline".equals(this.m_searchController.getCommon().getConfig().getSolrIndex())) {
            CmsSolrQuery query = new CmsSolrQuery();
            this.m_searchController.addQueryParts(query, cms);
            query.setStart(0);
            query.setRows(this.m_addContentInfoForEntries);
            query.setFields(new String[]{"id"});
            query.setFacet(false);
            CmsContentLoadCollectorInfo info = new CmsContentLoadCollectorInfo();
            info.setCollectorClass(this.getClass().getName());
            String queryString = query.toQueryString();
            if (queryString.length() > 0) {
                queryString = queryString.substring(1).replace('+', ' ');
            }
            info.setCollectorParams(queryString);
            info.setId(new CmsUUID().getStringValue());
            if (CmsJspTagEditable.getDirectEditProvider(this.pageContext) != null) {
                try {
                    CmsJspTagEditable.getDirectEditProvider(this.pageContext).insertDirectEditListMetadata(this.pageContext, info);
                }
                catch (JspException e) {
                    LOG.error((Object)"Could not write content info.", (Throwable)e);
                }
            }
        }
        return 1;
    }

    public Object getConfigFile() {
        return this.m_configFile;
    }

    public String getConfigString() {
        return this.m_configString;
    }

    @Override
    public Set<CmsResource> getPublishResources(CmsObject cms, I_CmsContentLoadCollectorInfo info) throws CmsException {
        return CmsJspTagSimpleSearch.getPublishResourcesInternal(cms, info);
    }

    @Override
    public void release() {
        this.m_configFile = null;
        this.m_configString = null;
        this.m_searchController = null;
        this.m_index = null;
        this.m_addContentInfoForEntries = null;
        super.release();
    }

    public void setAddContentInfo(Boolean doAddInfo) {
        if (doAddInfo != null && doAddInfo.booleanValue() && null == this.m_addContentInfoForEntries) {
            this.m_addContentInfoForEntries = 600;
        }
    }

    public void setConfigFile(String fileName) {
        this.m_configFile = fileName;
    }

    public void setConfigString(String configString) {
        this.m_configString = configString;
    }

    public void setContentInfoMaxItems(Integer maxItems) {
        if (null != maxItems) {
            this.m_addContentInfoForEntries = maxItems;
        }
    }

    private I_CmsSearchResultWrapper getSearchResults(CmsObject cms) {
        this.m_searchController.updateFromRequestParameters(this.pageContext.getRequest().getParameterMap(), false);
        I_CmsSearchControllerCommon common = this.m_searchController.getCommon();
        if (common.getState().getQuery().isEmpty() && !common.getConfig().getIgnoreQueryParam() && !common.getConfig().getSearchForEmptyQueryParam()) {
            return new CmsSearchResultWrapper(this.m_searchController, null, null, cms, null);
        }
        Map<String, String[]> queryParams = null;
        boolean isEditMode = CmsJspTagEditable.isEditableRequest(this.pageContext.getRequest());
        if (isEditMode) {
            String params = "";
            if (common.getConfig().getIgnoreReleaseDate()) {
                params = params + "&fq=released:[* TO *]";
            }
            if (common.getConfig().getIgnoreExpirationDate()) {
                params = params + "&fq=expired:[* TO *]";
            }
            if (!params.isEmpty()) {
                queryParams = CmsRequestUtil.createParameterMap(params.substring(1));
            }
        }
        CmsSolrQuery query = new CmsSolrQuery(null, queryParams);
        this.m_searchController.addQueryParts(query, cms);
        try {
            CmsSolrResultList solrResultList = this.m_index.search(cms, query.clone(), true, null, false, isEditMode ? CmsResourceFilter.IGNORE_EXPIRATION : null, this.m_searchController.getCommon().getConfig().getMaxReturnedResults());
            return new CmsSearchResultWrapper(this.m_searchController, solrResultList, query, cms, null);
        }
        catch (CmsSearchException e) {
            LOG.warn((Object)Messages.get().getBundle().key("LOG_TAG_SEARCH_SEARCH_FAILED_0"), (Throwable)e);
            return new CmsSearchResultWrapper(this.m_searchController, null, query, cms, e);
        }
    }
}

