/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.decorator;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.htmlparser.Tag;
import org.htmlparser.Text;
import org.htmlparser.util.Translate;
import org.opencms.file.CmsObject;
import org.opencms.jsp.decorator.CmsDecorationBundle;
import org.opencms.jsp.decorator.CmsDecorationObject;
import org.opencms.jsp.decorator.CmsDecoratorConfiguration;
import org.opencms.jsp.decorator.I_CmsDecoratorConfiguration;
import org.opencms.jsp.decorator.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsHtmlParser;
import org.opencms.util.CmsStringUtil;

public class CmsHtmlDecorator
extends CmsHtmlParser {
    private static final String[] DELIMITERS = new String[]{" ", ",", ".", ";", ":", "!", "(", ")", "'", "?", "/", "\u00a7", "\"", "&nbsp;", "&quot;", "\r\n", "\n"};
    private static final String[] DELIMITERS_SECOND_LEVEL = new String[]{"-", "@", "/", "&frasl;", ".", ",", "(", ")", "{", "}", "[", "]", "\"", "&quot;", "!", "?", ";", "&", "&amp;", "%", "\u00a7", "&sect;"};
    private static final int FORWARD_LOOKUP = 10;
    private static final Log LOG = CmsLog.getLog(CmsHtmlDecorator.class);
    private static final String[] NON_TRANSLATORS = new String[]{"&nbsp;", "&quot;"};
    I_CmsDecoratorConfiguration m_config;
    CmsDecorationBundle m_decorations;
    private CmsObject m_cms;
    private boolean m_decorate;

    public CmsHtmlDecorator(CmsObject cms) throws CmsException {
        this.m_config = new CmsDecoratorConfiguration(cms);
        this.m_decorations = this.m_config.getDecorations();
        this.m_result = new StringBuffer(512);
        this.m_echo = true;
        this.m_decorate = true;
    }

    public CmsHtmlDecorator(CmsObject cms, I_CmsDecoratorConfiguration config) {
        this.m_config = config;
        this.m_decorations = config.getDecorations();
        this.m_result = new StringBuffer(512);
        this.m_echo = true;
        this.m_decorate = true;
        this.m_cms = cms;
    }

    public static List<String> splitAsList(String source, String[] delimiters, boolean trim, boolean includeDelimiters) {
        int delimPos;
        int j;
        ArrayList<String> result = new ArrayList<String>();
        String delimiter = "";
        int i = 0;
        int l = source.length();
        int n = -1;
        int max = Integer.MAX_VALUE;
        for (j = 0; j < delimiters.length; ++j) {
            delimPos = source.indexOf(delimiters[j]);
            if (delimPos <= -1 || delimPos >= max) continue;
            max = delimPos;
            n = delimPos;
            delimiter = delimiters[j];
        }
        while (n != -1) {
            if (i < n || i > 0 && i < l) {
                result.add(trim ? source.substring(i, n).trim() : source.substring(i, n));
                if (includeDelimiters && n + delimiter.length() <= l) {
                    result.add(source.substring(n, n + delimiter.length()));
                }
            } else if (includeDelimiters && source.startsWith(delimiter)) {
                result.add(delimiter);
            }
            i = n + delimiter.length();
            max = Integer.MAX_VALUE;
            n = -1;
            for (j = 0; j < delimiters.length; ++j) {
                delimPos = source.indexOf(delimiters[j], i);
                if (delimPos <= -1 || delimPos >= max) continue;
                max = delimPos;
                n = delimPos;
                delimiter = delimiters[j];
            }
        }
        if (n < 0) {
            n = source.length();
        }
        if (i < n) {
            result.add(trim ? source.substring(i).trim() : source.substring(i));
        }
        return result;
    }

    public String doDecoration(String html, String encoding) throws Exception {
        return this.process(html, encoding);
    }

    public void resetDecorationDefinitions() {
        this.m_config.resetMarkedDecorations();
    }

    @Override
    public void visitStringNode(Text text) {
        this.appendText(text.toPlainTextString(), DELIMITERS, true);
    }

    @Override
    public void visitTag(Tag tag) {
        super.visitTag(tag);
        String tagname = tag.getTagName();
        if (this.m_config.isExcluded(tagname)) {
            this.m_decorate = false;
        } else {
            this.m_decorate = true;
            if (this.m_config.isExcludedAttr(tag)) {
                this.m_decorate = false;
            }
        }
    }

    private void appendText(String text, String[] delimiters, boolean recursive) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_HTML_DECORATOR_APPEND_TEXT_2", this.m_config, text));
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(text) && this.m_decorate) {
            List<String> wordList = CmsHtmlDecorator.splitAsList(text, delimiters, false, true);
            int wordCount = wordList.size();
            for (int i = 0; i < wordCount; ++i) {
                String word = wordList.get(i);
                boolean alreadyDecorated = false;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_HTML_DECORATOR_PROCESS_WORD_2", word, this.mustDecode(word, wordList, i)));
                }
                if (this.mustDecode(word, wordList, i)) {
                    word = Translate.decode((String)word);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_HTML_DECORATOR_DECODED_WORD_1", word));
                    }
                }
                CmsDecorationObject decObj = null;
                CmsDecorationObject wordDecObj = null;
                if (!this.hasDelimiter(word, delimiters)) {
                    wordDecObj = (CmsDecorationObject)this.m_decorations.get(word);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_HTML_DECORATOR_DECORATION_FOUND_2", wordDecObj, word));
                }
                if (recursive && this.hasDelimiter(word, DELIMITERS_SECOND_LEVEL) && !this.startsWithDelimiter(word, DELIMITERS_SECOND_LEVEL)) {
                    String nextWord;
                    String secondLevel = word;
                    if (i < wordCount - 1 && !(nextWord = wordList.get(i + 1)).equals(" ")) {
                        String afterNextWord = "";
                        if (i < wordCount - 2) {
                            afterNextWord = wordList.get(i + 2);
                        }
                        if (nextWord.contains("&") && afterNextWord.equals(";")) {
                            secondLevel = word + nextWord + ";";
                            i += 2;
                        } else {
                            secondLevel = word + nextWord;
                            ++i;
                        }
                    }
                    int sizeBefore = this.m_result.length();
                    this.appendText(secondLevel, DELIMITERS_SECOND_LEVEL, false);
                    if (sizeBefore != this.m_result.length()) {
                        alreadyDecorated = true;
                    }
                } else {
                    StringBuffer decKey = new StringBuffer();
                    decKey.append(word);
                    int forwardLookup = wordList.size() - i - 1;
                    if (forwardLookup > 10) {
                        forwardLookup = 10;
                    }
                    if (i < wordCount - forwardLookup) {
                        for (int j = 1; j <= forwardLookup; ++j) {
                            decKey.append(wordList.get(i + j));
                            decObj = (CmsDecorationObject)this.m_decorations.get(decKey.toString());
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)Messages.get().getBundle().key("LOG_HTML_DECORATOR_DECORATION_FOUND_FWL_3", decObj, word, j));
                            }
                            if (decObj == null) continue;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)Messages.get().getBundle().key("LOG_HTML_DECORATOR_DECORATION_APPEND_DECORATION_1", decObj.getContentDecoration(this.m_config, decKey.toString(), this.m_cms.getRequestContext().getLocale().toString())));
                            }
                            this.m_result.append(decObj.getContentDecoration(this.m_config, decKey.toString(), this.m_cms.getRequestContext().getLocale().toString()));
                            i += j;
                            alreadyDecorated = true;
                            break;
                        }
                    }
                    if (decObj == null && wordDecObj == null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)Messages.get().getBundle().key("LOG_HTML_DECORATOR_DECORATION_APPEND_WORD_1", word));
                        }
                        this.m_result.append(word);
                    }
                }
                if (wordDecObj == null || alreadyDecorated) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_HTML_DECORATOR_DECORATION_APPEND_DECORATION_1", wordDecObj.getContentDecoration(this.m_config, word, this.m_cms.getRequestContext().getLocale().toString())));
                }
                this.m_result.append(wordDecObj.getContentDecoration(this.m_config, word, this.m_cms.getRequestContext().getLocale().toString()));
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_HTML_DECORATOR_DECORATION_APPEND_ORIGINALTEXT_1", text));
            }
            this.m_result.append(text);
        }
        this.m_decorate = true;
    }

    private boolean hasDelimiter(String word, String[] delimiters) {
        boolean delim = false;
        for (int i = 0; i < delimiters.length; ++i) {
            if (word.indexOf(delimiters[i]) <= -1) continue;
            delim = true;
            break;
        }
        return delim;
    }

    private boolean mustDecode(String word, List<String> wordList, int count) {
        boolean decode = true;
        String nextWord = null;
        if (count < wordList.size() - 1) {
            nextWord = wordList.get(count + 1);
        }
        if (nextWord != null && word.indexOf("&") > -1 && nextWord.startsWith(";")) {
            return false;
        }
        for (int i = 0; i < NON_TRANSLATORS.length; ++i) {
            if (!word.startsWith(NON_TRANSLATORS[i])) continue;
            decode = false;
            break;
        }
        return decode;
    }

    private boolean startsWithDelimiter(String word, String[] delimiters) {
        boolean delim = false;
        for (int i = 0; i < delimiters.length; ++i) {
            if (!word.startsWith(delimiters[i])) continue;
            delim = true;
            break;
        }
        return delim;
    }
}

