/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.jsonpart;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CmsJsonPart {
    public static final String END = "\u0007ENDJSONPART";
    private static Pattern FORMAT_PATTERN = Pattern.compile("BEGINJSONPART\u0007(.*?)\u0007(.*?)\u0007ENDJSONPART", 32);
    private String m_key;
    private String m_value;

    public CmsJsonPart(String key, String value) {
        this.m_key = key;
        this.m_value = value;
    }

    public static final String getHeader(String key) {
        return "BEGINJSONPART\u0007" + key + "\u0007";
    }

    public static List<CmsJsonPart> parseJsonParts(String text) {
        ArrayList result = Lists.newArrayList();
        Matcher matcher = FORMAT_PATTERN.matcher(text);
        while (matcher.find()) {
            String key = matcher.group(1);
            String value = matcher.group(2);
            CmsJsonPart part = new CmsJsonPart(key, value);
            result.add(part);
        }
        return result;
    }

    public String getKey() {
        return this.m_key;
    }

    public String getValue() {
        return this.m_value;
    }
}

