/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.search.config.parser.simplesearch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.jsp.search.config.parser.simplesearch.CmsCategoryFolderRestrictionBean;
import org.opencms.jsp.search.config.parser.simplesearch.CmsGeoFilterBean;
import org.opencms.jsp.search.config.parser.simplesearch.daterestrictions.I_CmsDateRestriction;
import org.opencms.jsp.search.config.parser.simplesearch.preconfiguredrestrictions.CmsRestrictionsBean;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsUUID;

public class CmsConfigurationBean {
    public static final String N_TITLE = "Title";
    public static final String PARAM_TITLE = "Title";
    public static final String PARAM_FILTER_MULTI_DAY = "FilterMultiDay";
    public static final String PARAM_FILTER_QUERY = "FilterQuery";
    public static final String PARAM_SORT_ORDER = "SortOrder";
    public static final String PARAM_SHOW_EXPIRED = "ShowExpired";
    public static final String PARAM_MAX_RESULTS = "MaxResults";
    static final Log LOG = CmsLog.getLog(CmsConfigurationBean.class.getName());
    private static final String ADDITIONAL_PARAM_MAX_RETURNED_RESULTS = "maxresults";
    private Map<String, String> m_additionalParameters;
    private List<CmsUUID> m_blacklist;
    private List<String> m_categories;
    private CombinationMode m_categoryMode;
    private I_CmsDateRestriction m_dateRestriction;
    private List<String> m_dislayTypes;
    private CmsGeoFilterBean m_geoFilter;
    private List<String> m_folders;
    private Map<String, String> m_parameterFields;
    private CmsRestrictionsBean m_preconfiguredRestrictions;
    private List<CmsCategoryFolderRestrictionBean> m_categoryFolderRestrictions = new ArrayList<CmsCategoryFolderRestrictionBean>();

    public CmsConfigurationBean() {
        this.m_parameterFields = new HashMap<String, String>();
    }

    public static String getResourceTypeForDisplayType(String displayType) {
        String type = displayType;
        if (type.contains(":")) {
            type = type.substring(0, type.indexOf(":"));
        }
        return type;
    }

    public void addCategoryFolderFilter(CmsCategoryFolderRestrictionBean listCategoryFolderRestrictionBean) {
        this.m_categoryFolderRestrictions.add(listCategoryFolderRestrictionBean);
    }

    public Map<String, String> getAdditionalParameters() {
        return this.m_additionalParameters;
    }

    public List<CmsUUID> getBlacklist() {
        return this.m_blacklist;
    }

    public List<String> getCategories() {
        return this.m_categories;
    }

    public List<CmsCategoryFolderRestrictionBean> getCategoryFolderRestrictions() {
        return this.m_categoryFolderRestrictions;
    }

    public CombinationMode getCategoryMode() {
        return this.m_categoryMode;
    }

    public I_CmsDateRestriction getDateRestriction() {
        return this.m_dateRestriction;
    }

    public List<String> getDisplayTypes() {
        return this.m_dislayTypes;
    }

    public String getFilterQuery() {
        return this.m_parameterFields.get(PARAM_FILTER_QUERY);
    }

    public List<String> getFolders() {
        return this.m_folders;
    }

    public CmsGeoFilterBean getGeoFilter() {
        return this.m_geoFilter;
    }

    public Integer getMaximallyReturnedResults() {
        block4: {
            String resString = this.m_parameterFields.get(PARAM_MAX_RESULTS);
            if (null == resString) {
                this.m_additionalParameters.get(ADDITIONAL_PARAM_MAX_RETURNED_RESULTS);
            }
            if (null != resString) {
                try {
                    return Integer.valueOf(resString);
                }
                catch (NumberFormatException e) {
                    if (!LOG.isErrorEnabled()) break block4;
                    LOG.error((Object)("Ignoring invalid maxresults param " + resString + " in list-config."));
                }
            }
        }
        return null;
    }

    public Map<String, String> getParameters() {
        return this.m_parameterFields;
    }

    public String getParameterValue(String key) {
        return this.m_parameterFields.get(key);
    }

    public CmsRestrictionsBean getPreconfiguredRestrictions() {
        return this.m_preconfiguredRestrictions;
    }

    public String getSortOrder() {
        return this.getParameterValue(PARAM_SORT_ORDER);
    }

    public List<String> getTypes() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.m_dislayTypes != null) {
            for (String displayType : this.m_dislayTypes) {
                String type = CmsConfigurationBean.getResourceTypeForDisplayType(displayType);
                if (result.contains(type)) continue;
                result.add(type);
            }
        }
        return result;
    }

    public boolean hasPreconfiguredRestrictions() {
        return null != this.m_preconfiguredRestrictions && this.m_preconfiguredRestrictions.hasRestrictions();
    }

    public boolean hasTypeSpecificRestriction(String type) {
        return null != this.m_preconfiguredRestrictions && this.m_preconfiguredRestrictions.hasRestrictionForType(type);
    }

    public boolean isShowExpired() {
        return Boolean.parseBoolean(this.m_parameterFields.get(PARAM_SHOW_EXPIRED));
    }

    public void setAdditionalParameters(Map<String, String> additionalParameters) {
        this.m_additionalParameters = additionalParameters;
    }

    public void setBlacklist(List<CmsUUID> blacklist) {
        this.m_blacklist = blacklist;
    }

    public void setCategories(List<String> categories) {
        this.m_categories = categories;
    }

    public void setCategoryMode(CombinationMode categoryMode) {
        this.m_categoryMode = categoryMode;
    }

    public void setDateRestriction(I_CmsDateRestriction restriction) {
        this.m_dateRestriction = restriction;
    }

    public void setDisplayTypes(List<String> displayTypes) {
        this.m_dislayTypes = displayTypes;
    }

    public void setFolders(List<String> folders) {
        this.m_folders = folders;
    }

    public void setGeoFilter(CmsGeoFilterBean geoFilter) {
        this.m_geoFilter = geoFilter;
    }

    public void setParameterValue(String name, String value) {
        this.m_parameterFields.put(name, value);
    }

    public void setPreconfiguredRestrictions(CmsRestrictionsBean restrictionBean) {
        this.m_preconfiguredRestrictions = restrictionBean;
    }

    public static enum CombinationMode {
        AND,
        OR;

    }
}

