/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.search.config.parser.simplesearch.preconfiguredrestrictions;

import java.util.Locale;
import org.opencms.jsp.search.config.parser.simplesearch.CmsConfigurationBean;

public class CmsRestrictionRule {
    private static String LOCALE_PLACEHOLDER = "#";
    private String m_type;
    private String m_field;
    private MatchType m_match;
    private CmsConfigurationBean.CombinationMode m_combinationModeBetweenFields;
    private CmsConfigurationBean.CombinationMode m_combinationModeInField;

    public CmsRestrictionRule(String field) {
        this(field, null, null, null, null);
    }

    public CmsRestrictionRule(String field, String type, MatchType matchType, CmsConfigurationBean.CombinationMode combinationModeBetweenFields, CmsConfigurationBean.CombinationMode combinationModeInField) {
        this.m_field = field;
        this.m_type = type;
        this.m_match = null == matchType ? MatchType.DEFAULT : matchType;
        this.m_combinationModeBetweenFields = null == combinationModeBetweenFields ? CmsConfigurationBean.CombinationMode.OR : combinationModeBetweenFields;
        this.m_combinationModeInField = null == combinationModeInField ? this.m_combinationModeBetweenFields : combinationModeInField;
    }

    public CmsConfigurationBean.CombinationMode getCombinationModeBetweenFields() {
        return this.m_combinationModeBetweenFields;
    }

    public CmsConfigurationBean.CombinationMode getCombinationModeInField() {
        return this.m_combinationModeInField;
    }

    public String getFieldForLocale(Locale l) {
        return this.m_field.replace(LOCALE_PLACEHOLDER, l.toString());
    }

    public MatchType getMatchType() {
        return this.m_match;
    }

    public String getRawField() {
        return this.m_field;
    }

    public String getType() {
        return this.m_type;
    }

    public static enum MatchType {
        EXACT,
        DEFAULT,
        POSTFIX,
        PREFIX,
        INFIX;

    }
}

