/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.search.config.parser.simplesearch.preconfiguredrestrictions;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.opencms.jsp.search.config.parser.simplesearch.CmsConfigurationBean;
import org.opencms.jsp.search.config.parser.simplesearch.Messages;
import org.opencms.jsp.search.config.parser.simplesearch.preconfiguredrestrictions.CmsRestrictionRule;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;

public final class CmsRestrictionRuleParser {
    private static final Log LOG = CmsLog.getLog(CmsRestrictionRuleParser.class.getName());
    private static String PREFIX_TYPE = "type=";
    private static String PREFIX_FIELD = "field=";
    private static String PREFIX_MATCH = "match=";
    private static String PREFIX_COMBINE = "combine=";

    private CmsRestrictionRuleParser() {
    }

    public static CmsRestrictionRule parseRule(String rule) throws CmsException {
        if (rule != null && rule.length() > 0) {
            String[] ruleParts = rule.split(",");
            if (ruleParts.length == 1) {
                if (!rule.contains("=")) {
                    return new CmsRestrictionRule(rule);
                }
                if (rule.startsWith(PREFIX_FIELD)) {
                    return new CmsRestrictionRule(rule.substring(PREFIX_FIELD.length()));
                }
                throw new CmsException(Messages.get().container("ERR_WRONG_CONFIGURATION_SYNTAX_1", rule));
            }
            String field = null;
            String type = null;
            CmsRestrictionRule.MatchType match = null;
            CmsConfigurationBean.CombinationMode modeBetweenFields = null;
            CmsConfigurationBean.CombinationMode modeInField = null;
            for (String rulePart : Arrays.asList(ruleParts)) {
                if (rulePart.startsWith(PREFIX_FIELD)) {
                    field = rulePart.substring(PREFIX_FIELD.length());
                    continue;
                }
                if (rulePart.startsWith(PREFIX_COMBINE)) {
                    String modeString = rulePart.substring(PREFIX_COMBINE.length());
                    try {
                        if (modeString.contains("-")) {
                            String[] modes = modeString.split("-");
                            modeBetweenFields = CmsConfigurationBean.CombinationMode.valueOf(modes[0].toUpperCase());
                            modeInField = CmsConfigurationBean.CombinationMode.valueOf(modes[1].toUpperCase());
                        }
                        modeBetweenFields = CmsConfigurationBean.CombinationMode.valueOf(modeString.toUpperCase());
                    }
                    catch (Throwable t) {
                        LOG.info((Object)("Invalid combination mode '" + modeString + "' is ignored"));
                    }
                    continue;
                }
                if (rulePart.startsWith(PREFIX_MATCH)) {
                    String matchString = rulePart.substring(PREFIX_MATCH.length());
                    try {
                        match = CmsRestrictionRule.MatchType.valueOf(matchString.toUpperCase());
                    }
                    catch (Throwable t) {
                        LOG.info((Object)("Invalid match type \"" + matchString + "\" is ignored."));
                        match = CmsRestrictionRule.MatchType.DEFAULT;
                    }
                    continue;
                }
                if (rulePart.startsWith(PREFIX_TYPE)) {
                    type = rulePart.substring(PREFIX_TYPE.length());
                    continue;
                }
                LOG.info((Object)("Invalid rule part '" + rulePart + "' is ignored."));
            }
            if (field != null) {
                return new CmsRestrictionRule(field, type, match, modeBetweenFields, modeInField);
            }
            throw new CmsException(Messages.get().container("ERR_WRONG_CONFIGURATION_SYNTAX_1", rule));
        }
        throw new CmsException(Messages.get().container("ERR_WRONG_CONFIGURATION_SYNTAX_1", rule));
    }
}

