/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.search.controller;

import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationSortOption;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationSorting;
import org.opencms.jsp.search.controller.I_CmsSearchControllerSorting;
import org.opencms.jsp.search.state.CmsSearchStateSorting;
import org.opencms.jsp.search.state.I_CmsSearchStateSorting;
import org.opencms.search.solr.CmsSolrQuery;

public class CmsSearchControllerSorting
implements I_CmsSearchControllerSorting {
    private final I_CmsSearchConfigurationSorting m_config;
    private final I_CmsSearchStateSorting m_state;

    public CmsSearchControllerSorting(I_CmsSearchConfigurationSorting config) {
        this.m_config = config;
        this.m_state = new CmsSearchStateSorting();
        this.m_state.setSelectedOption(this.m_config.getDefaultSortOption());
    }

    @Override
    public void addParametersForCurrentState(Map<String, String[]> parameters) {
        if (null != this.m_state.getSelected() && this.m_config.getDefaultSortOption() != this.m_state.getCheckSelected()) {
            parameters.put(this.m_config.getSortParam(), new String[]{this.m_state.getSelected().getParamValue()});
        }
    }

    @Override
    public void addQueryParts(CmsSolrQuery query, CmsObject cms) {
        if (this.m_state.getSelected() != null) {
            query.set("sort", new String[]{this.m_state.getSelected().getSolrValue()});
        }
    }

    @Override
    public I_CmsSearchConfigurationSorting getConfig() {
        return this.m_config;
    }

    @Override
    public I_CmsSearchStateSorting getState() {
        return this.m_state;
    }

    @Override
    public void updateForQueryChange() {
    }

    @Override
    public void updateFromRequestParameters(Map<String, String[]> parameters, boolean isReloaded) {
        String[] sortValues;
        if (parameters.containsKey(this.m_config.getSortParam()) && (sortValues = parameters.get(this.m_config.getSortParam())).length > 0) {
            String sortValue = sortValues[0];
            for (I_CmsSearchConfigurationSortOption sortOption : this.m_config.getSortOptions()) {
                if (!sortOption.getParamValue().equals(sortValue)) continue;
                this.m_state.setSelectedOption(sortOption);
                return;
            }
        }
    }
}

