/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.userdata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.Rule;
import org.apache.commons.logging.Log;
import org.apache.commons.mail.EmailException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsUserSearchParameters;
import org.opencms.jsp.userdata.CmsUserDataRequestConfig;
import org.opencms.jsp.userdata.CmsUserDataRequestException;
import org.opencms.jsp.userdata.CmsUserDataRequestInfo;
import org.opencms.jsp.userdata.CmsUserDataRequestStore;
import org.opencms.jsp.userdata.CmsUserDataRequestType;
import org.opencms.jsp.userdata.I_CmsUserDataDomain;
import org.opencms.jsp.userdata.I_CmsUserDataDomainProvider;
import org.opencms.jsp.userdata.Messages;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.mail.CmsHtmlMail;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.I_CmsReport;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.xml.sax.Attributes;

public class CmsUserDataRequestManager {
    public static final String FUNCTION_NAME = "userdatarequest";
    public static final String N_USERDATA = "userdata";
    public static final String A_AUTOLOAD = "autoload";
    public static final String N_USERDATA_DOMAIN = "userdata-domain";
    private static final Log LOG = CmsLog.getLog(CmsUserDataRequestManager.class);
    private CmsObject m_adminCms;
    private List<I_CmsUserDataDomain> m_configuredDomains = new ArrayList<I_CmsUserDataDomain>();
    private CmsUserDataRequestStore m_requestStore = new CmsUserDataRequestStore();
    private boolean m_autoload;
    private List<I_CmsUserDataDomain> m_allDomains = new ArrayList<I_CmsUserDataDomain>();

    public static void addDigesterRules(final Digester digester, String basePath) {
        digester.addObjectCreate(basePath, CmsUserDataRequestManager.class);
        digester.addRule(basePath, new Rule(){
            private boolean m_autoload;

            public void begin(String namespace, String name, Attributes attributes) throws Exception {
                this.m_autoload = Boolean.parseBoolean(attributes.getValue(CmsUserDataRequestManager.A_AUTOLOAD));
            }

            public void end(String namespace, String name) throws Exception {
                CmsUserDataRequestManager manager = (CmsUserDataRequestManager)digester.peek();
                manager.setAutoload(this.m_autoload);
            }
        });
        String domainPath = basePath + "/" + N_USERDATA_DOMAIN;
        digester.addObjectCreate(domainPath, null, "class");
        digester.addSetNext(domainPath, "addUserDataDomain");
    }

    public static List<CmsUser> getUsersByEmail(CmsObject cms, String email) throws CmsException {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(email)) {
            return new ArrayList<CmsUser>();
        }
        CmsUserSearchParameters params = new CmsUserSearchParameters();
        params.setPaging(9999, 1);
        params.setFilterEmail(email);
        params.setSorting(CmsUserSearchParameters.SortKey.email, true);
        List<CmsUser> users = OpenCms.getOrgUnitManager().searchUsers(cms, params);
        return users;
    }

    public void addUserDataDomain(I_CmsUserDataDomain domain) {
        this.checkNotInitialized();
        this.m_configuredDomains.add(domain);
    }

    public void appendToXml(org.dom4j.Element element) {
        org.dom4j.Element root = element.addElement(N_USERDATA);
        if (this.isAutoload()) {
            root.addAttribute(A_AUTOLOAD, "true");
        }
        for (I_CmsUserDataDomain domain : this.m_configuredDomains) {
            String clsName = domain.getClass().getName();
            org.dom4j.Element domainElem = root.addElement(N_USERDATA_DOMAIN);
            domainElem.addAttribute("class", clsName);
            CmsParameterConfiguration config = domain.getConfiguration();
            config.appendToXml(domainElem);
        }
    }

    public void checkNotInitialized() {
        if (this.m_adminCms != null) {
            throw new IllegalStateException("CmsUserDataRequestManager already initialized.");
        }
    }

    public List<I_CmsUserDataDomain> getAllDomains() {
        return this.m_allDomains;
    }

    public boolean getInfoForEmail(CmsObject cms, I_CmsUserDataDomain.Mode mode, String email, List<String> searchStrings, Element root, I_CmsReport report) throws CmsException {
        OpenCms.getRoleManager().checkRole(cms, CmsRole.ROOT_ADMIN);
        return this.internalGetInfoForEmail(cms, mode, email, searchStrings, root, report);
    }

    public boolean getInfoForUser(CmsObject cms, I_CmsUserDataDomain.Mode mode, CmsUser user, Element root, I_CmsReport report) throws CmsException {
        OpenCms.getRoleManager().checkRole(cms, CmsRole.ROOT_ADMIN);
        return this.internalGetInfoForUser(cms, mode, user, root, report);
    }

    public CmsUserDataRequestStore getRequestStore() {
        return this.m_requestStore;
    }

    public void initialize(CmsObject cms) {
        this.checkNotInitialized();
        this.m_adminCms = cms;
        this.m_allDomains.addAll(this.m_configuredDomains);
        if (this.m_autoload) {
            this.m_allDomains.addAll(this.loadUserDataDomainsFromClasses());
        }
        for (I_CmsUserDataDomain domain : this.m_allDomains) {
            domain.initialize(cms);
        }
        this.m_requestStore.initialize(cms);
    }

    public Optional<CmsUserDataRequestConfig> loadConfig(CmsObject cms, String path) {
        LOG.debug((Object)("loading user data request config for path " + path));
        if (path == null) {
            LOG.info((Object)"path is null");
            return Optional.empty();
        }
        try {
            CmsResource resource = cms.readResource(path);
            CmsXmlContent content = CmsXmlContentFactory.unmarshal(cms, cms.readFile(resource));
            CmsUserDataRequestConfig result = new CmsUserDataRequestConfig(cms, content, cms.getRequestContext().getLocale());
            return Optional.of(result);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return Optional.empty();
        }
    }

    public void startUserDataRequest(CmsObject cms, CmsUserDataRequestConfig config, CmsUser user) throws AddressException, EmailException {
        Document doc = Jsoup.parseBodyFragment((String)"");
        Element root = doc.body().appendElement("div");
        CmsUserDataRequestInfo info = new CmsUserDataRequestInfo();
        info.setUser(user.getName());
        info.setType(CmsUserDataRequestType.singleUser);
        info.setEmail(user.getEmail());
        info.setExpiration(System.currentTimeMillis() + config.getRequestLifetime());
        for (I_CmsUserDataDomain userDomain : this.getAllDomains()) {
            if (!userDomain.matchesUser(cms, CmsUserDataRequestType.singleUser, user)) continue;
            userDomain.appendInfoHtml(cms, CmsUserDataRequestType.singleUser, Collections.singletonList(user), root);
        }
        info.setInfoHtml(root.toString());
        this.m_requestStore.save(info);
        this.sendMail(cms, config, user.getEmail(), info.getId());
    }

    public void startUserDataRequest(CmsObject cms, CmsUserDataRequestConfig config, String email) throws CmsUserDataRequestException, EmailException, AddressException {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(email)) {
            throw new IllegalArgumentException("Can not use empty email address for user data request by email.");
        }
        try {
            List<CmsUser> users = CmsUserDataRequestManager.getUsersByEmail(this.m_adminCms, email);
            Document doc = Jsoup.parseBodyFragment((String)"");
            Element root = doc.body().appendElement("div");
            boolean foundDomain = false;
            for (I_CmsUserDataDomain userDomain : this.getAllDomains()) {
                ArrayList<CmsUser> usersForDomain = new ArrayList<CmsUser>();
                for (CmsUser user : users) {
                    if (!userDomain.matchesUser(cms, CmsUserDataRequestType.email, user)) continue;
                    usersForDomain.add(user);
                    foundDomain = true;
                }
                if (usersForDomain.isEmpty()) continue;
                userDomain.appendInfoHtml(cms, CmsUserDataRequestType.email, usersForDomain, root);
            }
            if (!foundDomain) {
                throw new CmsUserDataRequestException("no users found with the given email address.");
            }
            CmsUserDataRequestInfo info = new CmsUserDataRequestInfo();
            info.setType(CmsUserDataRequestType.email);
            info.setEmail(email);
            info.setInfoHtml(root.toString());
            info.setExpiration(System.currentTimeMillis() + config.getRequestLifetime());
            this.m_requestStore.save(info);
            this.sendMail(cms, config, email, info.getId());
        }
        catch (CmsException e) {
            throw new CmsUserDataRequestException(e);
        }
    }

    public String toString() {
        String collectorsStr = this.getAllDomains().stream().map(domain -> domain.toString()).collect(Collectors.joining(", "));
        return this.getClass().getName() + "[" + collectorsStr + "]";
    }

    protected void setAutoload(boolean autoload) {
        this.checkNotInitialized();
        this.m_autoload = autoload;
    }

    private boolean internalGetInfoForEmail(CmsObject cms, I_CmsUserDataDomain.Mode mode, String email, List<String> searchStrings, Element root, I_CmsReport report) throws CmsException {
        Document doc = root.ownerDocument();
        String oldHtml = doc.toString();
        List<CmsUser> users = CmsUserDataRequestManager.getUsersByEmail(this.m_adminCms, email);
        boolean foundDomain = false;
        int i = 0;
        for (I_CmsUserDataDomain userDomain : this.getAllDomains()) {
            report.print(Messages.get().container("RPT_USERDATADOMAIN_COUNT_2", "" + ++i, "" + this.getAllDomains().size()));
            report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"), 0);
            if (!userDomain.isAvailableForMode(mode)) {
                report.println(org.opencms.report.Messages.get().container("RPT_SKIPPED_0"), 0);
                continue;
            }
            ArrayList<CmsUser> usersForDomain = new ArrayList<CmsUser>();
            for (CmsUser user : users) {
                if (!userDomain.matchesUser(cms, CmsUserDataRequestType.email, user)) continue;
                usersForDomain.add(user);
                foundDomain = true;
            }
            if (!usersForDomain.isEmpty()) {
                userDomain.appendInfoHtml(cms, CmsUserDataRequestType.email, usersForDomain, root);
            }
            userDomain.appendlInfoForEmail(cms, email, searchStrings, root);
            report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
        }
        String newHtml = doc.toString();
        boolean changed = !newHtml.equals(oldHtml);
        return changed;
    }

    private boolean internalGetInfoForUser(CmsObject cms, I_CmsUserDataDomain.Mode mode, CmsUser user, Element root, I_CmsReport report) {
        Document doc = root.ownerDocument();
        String oldHtml = doc.toString();
        int i = 0;
        for (I_CmsUserDataDomain userDomain : this.getAllDomains()) {
            report.print(Messages.get().container("RPT_USERDATADOMAIN_COUNT_2", "" + ++i, "" + this.getAllDomains().size()));
            report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"), 0);
            if (!userDomain.isAvailableForMode(mode)) {
                report.println(org.opencms.report.Messages.get().container("RPT_SKIPPED_0"), 0);
                continue;
            }
            ArrayList<CmsUser> usersForDomain = new ArrayList<CmsUser>();
            if (userDomain.matchesUser(cms, CmsUserDataRequestType.email, user)) {
                usersForDomain.add(user);
            }
            if (!usersForDomain.isEmpty()) {
                userDomain.appendInfoHtml(cms, CmsUserDataRequestType.email, usersForDomain, root);
            }
            report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
        }
        String newHtml = doc.toString();
        boolean changed = !newHtml.equals(oldHtml);
        return changed;
    }

    private boolean isAutoload() {
        return this.m_autoload;
    }

    private List<I_CmsUserDataDomain> loadUserDataDomainsFromClasses() {
        ArrayList<I_CmsUserDataDomain> result = new ArrayList<I_CmsUserDataDomain>();
        ServiceLoader<I_CmsUserDataDomainProvider> loader = ServiceLoader.load(I_CmsUserDataDomainProvider.class);
        for (I_CmsUserDataDomainProvider provider : loader) {
            for (I_CmsUserDataDomain domain : provider.getUserDataDomains()) {
                result.add(domain);
            }
        }
        return result;
    }

    private void sendMail(CmsObject cms, CmsUserDataRequestConfig config, String email, String id) throws EmailException, AddressException {
        CmsHtmlMail mail = new CmsHtmlMail();
        mail.setCharset("UTF-8");
        mail.setSubject(config.getMailSubject());
        mail.setTo(Arrays.asList(InternetAddress.parse((String)email)));
        String link = CmsJspStandardContextBean.getFunctionDetailLink(cms, "function@", FUNCTION_NAME, true) + "?" + "udrid" + "=" + id + "&" + "action" + "=" + "view";
        mail.setHtmlMsg(config.getMailText() + "<a href=\"" + link + "\">" + link + "</a>");
        mail.send();
    }
}

