/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.util.AbstractCollection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.Transformer;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.jsp.CmsJspResourceWrapper;
import org.opencms.jsp.util.CmsJspContainerPageWrapper;
import org.opencms.jsp.util.CmsJspElFunctions;
import org.opencms.jsp.util.CmsJspImageBean;
import org.opencms.jsp.util.CmsJspInstanceDateBean;
import org.opencms.jsp.util.CmsJspLinkWrapper;
import org.opencms.jsp.util.CmsJspObjectValueWrapper;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;

abstract class A_CmsJspValueWrapper
extends AbstractCollection<String> {
    private static final Log LOG = CmsLog.getLog(A_CmsJspValueWrapper.class);
    protected CmsObject m_cms;
    private Boolean m_boolean;
    private CmsJspContainerPageWrapper m_containerPageWrapper;
    private Map<Object, Boolean> m_contains;
    private Date m_date;
    private Double m_double;
    private CmsJspImageBean m_imageBean;
    private CmsJspInstanceDateBean m_instanceDate;
    private Map<Object, Boolean> m_isEqual;
    private String m_link;
    private Long m_long;
    private CmsJspResourceWrapper m_resource;
    private String m_string;
    private String m_stripHtml;
    private Map<Object, String> m_trimToSize;
    protected Optional<CmsJspLinkWrapper> m_linkObj;

    A_CmsJspValueWrapper() {
    }

    public static String substituteLink(CmsObject cms, String target) {
        if (cms != null) {
            return OpenCms.getLinkManager().substituteLinkForUnknownTarget(cms, CmsLinkManager.getAbsoluteUri(String.valueOf(target), cms.getRequestContext().getUri()));
        }
        return "";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            return this.hashCode() == ((A_CmsJspValueWrapper)obj).hashCode();
        }
        return false;
    }

    public CmsObject getCmsObject() {
        return this.m_cms;
    }

    public Map<Object, Boolean> getContains() {
        if (this.m_contains == null) {
            this.m_contains = CmsCollectionsGenericWrapper.createLazyMap(new CmsContainsTransformer());
        }
        return this.m_contains;
    }

    public abstract boolean getExists();

    public abstract boolean getIsEmpty();

    public abstract boolean getIsEmptyOrWhitespaceOnly();

    public Map<Object, Boolean> getIsEqual() {
        if (this.m_isEqual == null) {
            this.m_isEqual = CmsCollectionsGenericWrapper.createLazyMap(new CmsIsEqualTransformer());
        }
        return this.m_isEqual;
    }

    public boolean getIsSet() {
        return !this.getIsEmptyOrWhitespaceOnly();
    }

    public boolean getIsSetNotNone() {
        return this.getIsEmptyOrWhitespaceOnly() ? false : !"none".equals(this.getToString());
    }

    public Long getMathCeil() {
        return CmsJspElFunctions.mathCeil(this.getToDouble());
    }

    public Long getMathFloor() {
        return CmsJspElFunctions.mathFloor(this.getToDouble());
    }

    public Long getMathRound() {
        return CmsJspElFunctions.mathRound(this.getToDouble());
    }

    public abstract Object getObjectValue();

    @Deprecated
    public String getStringValue() {
        return this.getToString();
    }

    public String getStripHtml() {
        if (this.m_stripHtml == null) {
            this.m_stripHtml = CmsJspElFunctions.stripHtml(this);
        }
        return this.m_stripHtml;
    }

    public boolean getToBoolean() {
        if (this.m_boolean == null) {
            this.m_boolean = Boolean.parseBoolean(this.getToString());
        }
        return this.m_boolean;
    }

    public CmsJspContainerPageWrapper getToContainerPage() {
        if (this.m_containerPageWrapper != null) {
            return this.m_containerPageWrapper;
        }
        CmsJspResourceWrapper res = this.getToResource();
        if (res == null) {
            return null;
        }
        try {
            CmsXmlContainerPage page = CmsXmlContainerPageFactory.unmarshal(this.m_cms, this.m_cms.readFile(res), true, true);
            this.m_containerPageWrapper = new CmsJspContainerPageWrapper(page.getContainerPage(this.m_cms));
            return this.m_containerPageWrapper;
        }
        catch (Exception e) {
            LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public Date getToDate() {
        if (this.m_date == null) {
            this.m_date = CmsJspElFunctions.convertDate(this.getToString());
        }
        return this.m_date;
    }

    public Double getToDouble() {
        if (this.m_double == null) {
            try {
                this.m_double = Double.parseDouble(this.getToString());
            }
            catch (NumberFormatException e) {
                LOG.info((Object)e.getLocalizedMessage());
            }
        }
        return this.m_double;
    }

    public Double getToFloat() {
        return this.getToDouble();
    }

    public CmsJspImageBean getToImage() {
        if (this.m_imageBean == null) {
            try {
                this.m_imageBean = new CmsJspImageBean(this.getCmsObject(), this.getToString());
            }
            catch (CmsException e) {
                LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return this.m_imageBean;
    }

    public CmsJspInstanceDateBean getToInstanceDate() {
        if (this.m_instanceDate == null) {
            this.m_instanceDate = new CmsJspInstanceDateBean(this.getToDate(), this.m_cms.getRequestContext().getLocale());
        }
        return this.m_instanceDate;
    }

    public Long getToInteger() {
        return this.getToLong();
    }

    public CmsJspLinkWrapper getToLink() {
        if (this.m_linkObj == null) {
            String target = this.toString();
            this.m_linkObj = target != null ? Optional.of(new CmsJspLinkWrapper(this.getCmsObject(), target)) : Optional.empty();
        }
        return this.m_linkObj.orElse(null);
    }

    public String getToLinkStr() {
        if (this.m_link == null) {
            String target = this.toString();
            this.m_link = CmsStringUtil.isNotEmptyOrWhitespaceOnly(target) ? A_CmsJspValueWrapper.substituteLink(this.getCmsObject(), target) : "";
        }
        return this.m_link;
    }

    public Locale getToLocale() {
        return CmsJspElFunctions.convertLocale(this.getObjectValue());
    }

    public Long getToLong() {
        if (this.m_long == null) {
            try {
                this.m_long = Long.parseLong(this.getToString());
            }
            catch (NumberFormatException e) {
                LOG.info((Object)e.getLocalizedMessage());
            }
        }
        return this.m_long;
    }

    public CmsJspResourceWrapper getToResource() {
        block3: {
            if (this.m_resource == null) {
                try {
                    this.m_resource = CmsJspElFunctions.convertResource(this.m_cms, this.getToString());
                }
                catch (CmsException e) {
                    if (!LOG.isInfoEnabled()) break block3;
                    LOG.info((Object)("Failed to convert wrapper \"" + this.getToString() + "\" to a resource."), (Throwable)e);
                }
            }
        }
        return this.m_resource;
    }

    public String getToString() {
        if (this.m_string == null) {
            this.m_string = this.toString();
        }
        return this.m_string;
    }

    public Map<Object, String> getTrimToSize() {
        if (this.m_trimToSize == null) {
            this.m_trimToSize = CmsCollectionsGenericWrapper.createLazyMap(new CmsTrimToSizeTransformer());
        }
        return this.m_trimToSize;
    }

    @Override
    public abstract int hashCode();

    @Override
    public boolean isEmpty() {
        return this.getIsEmptyOrWhitespaceOnly();
    }

    public boolean isValid(List<String> allowedValues) {
        return allowedValues != null && !this.getIsEmptyOrWhitespaceOnly() && allowedValues.contains(this.toString());
    }

    @Override
    public Iterator<String> iterator() {
        Iterator<String> it = new Iterator<String>(){
            private boolean isFirst = true;

            @Override
            public boolean hasNext() {
                return this.isFirst && !A_CmsJspValueWrapper.this.isEmpty();
            }

            @Override
            public String next() {
                this.isFirst = false;
                return A_CmsJspValueWrapper.this.getToString();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return it;
    }

    @Override
    public int size() {
        return this.isEmpty() ? 0 : 1;
    }

    public Double toDouble(Double def) {
        if (this.getToDouble() == null) {
            return def;
        }
        return this.m_double;
    }

    public Double toFloat(Double def) {
        return this.toDouble(def);
    }

    public Long toInteger(Long def) {
        return this.toLong(def);
    }

    public Long toLong(Long def) {
        if (this.getToLong() == null) {
            return def;
        }
        return this.m_long;
    }

    public A_CmsJspValueWrapper useDefault(Object defaultValue) {
        if (this.getIsEmptyOrWhitespaceOnly()) {
            return CmsJspObjectValueWrapper.createWrapper(this.getCmsObject(), defaultValue);
        }
        return this;
    }

    public A_CmsJspValueWrapper validate(List<String> allowedValues) {
        return this.isValid(allowedValues) ? this : CmsJspObjectValueWrapper.NULL_VALUE_WRAPPER;
    }

    public A_CmsJspValueWrapper validate(List<String> allowedValues, Object defaultValue) {
        return this.isValid(allowedValues) ? this : CmsJspObjectValueWrapper.createWrapper(this.getCmsObject(), defaultValue);
    }

    public class CmsContainsTransformer
    implements Transformer {
        public Object transform(Object input) {
            Object o = A_CmsJspValueWrapper.this.getObjectValue();
            if (o instanceof A_CmsJspValueWrapper && input != null) {
                return ((A_CmsJspValueWrapper)o).getToString().indexOf(input.toString()) > -1;
            }
            return Boolean.FALSE;
        }
    }

    public class CmsIsEqualTransformer
    implements Transformer {
        public Object transform(Object input) {
            Object o = A_CmsJspValueWrapper.this.getObjectValue();
            if (o instanceof A_CmsJspValueWrapper && input instanceof String) {
                return ((A_CmsJspValueWrapper)o).getToString().equals(input);
            }
            if (o == null) {
                return input == null;
            }
            return o.equals(input);
        }
    }

    public class CmsTrimToSizeTransformer
    implements Transformer {
        public Object transform(Object input) {
            try {
                int lenght = Integer.parseInt(String.valueOf(input));
                return CmsJspElFunctions.trimToSize(A_CmsJspValueWrapper.this.getToString(), lenght);
            }
            catch (Exception e) {
                return A_CmsJspValueWrapper.this.getToString();
            }
        }
    }
}

