/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.file.CmsObject;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.jsp.util.CmsFormatterInfoWrapper;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.jsp.util.CmsResourceTypeInfoWrapper;
import org.opencms.jsp.util.I_CmsFormatterInfo;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.OpenCms;
import org.opencms.xml.containerpage.CmsFormatterBean;
import org.opencms.xml.containerpage.CmsFunctionFormatterBean;
import org.opencms.xml.containerpage.I_CmsFormatterBean;

public class CmsContainerTypeInfoWrapper {
    private CmsObject m_cms;
    private CmsADEConfigData m_config;
    private String m_containerType;
    private Set<String> m_matchingResourceTypes = new TreeSet<String>();
    private List<CmsFunctionFormatterBean> m_matchingFunctions = new ArrayList<CmsFunctionFormatterBean>();
    private CmsJspStandardContextBean m_context;

    public CmsContainerTypeInfoWrapper(CmsJspStandardContextBean context, CmsObject cms, CmsADEConfigData config, String type) {
        this.m_cms = cms;
        this.m_config = config;
        this.m_context = context;
        this.m_containerType = type;
        for (I_CmsFormatterBean formatter : this.m_config.getActiveFormatters().values()) {
            if (formatter.getContainerTypes() == null || !formatter.getContainerTypes().contains(this.m_containerType)) continue;
            if (formatter instanceof CmsFunctionFormatterBean) {
                this.m_matchingFunctions.add((CmsFunctionFormatterBean)formatter);
                continue;
            }
            if (!(formatter instanceof CmsFormatterBean)) continue;
            this.m_matchingResourceTypes.addAll(formatter.getResourceTypeNames());
        }
    }

    public List<I_CmsFormatterInfo> getAllowedElements() {
        ArrayList<I_CmsFormatterInfo> result = new ArrayList<I_CmsFormatterInfo>();
        result.addAll(this.getAllowedResourceTypes());
        result.addAll(this.getAllowedFunctions());
        return result;
    }

    public List<CmsFormatterInfoWrapper> getAllowedFunctions() {
        return this.m_context.wrapFormatters(this.m_matchingFunctions);
    }

    public List<I_CmsFormatterInfo> getAllowedResourceTypes() {
        ArrayList<I_CmsFormatterInfo> result = new ArrayList<I_CmsFormatterInfo>();
        for (String name : this.m_matchingResourceTypes) {
            try {
                I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(name);
                CmsResourceTypeInfoWrapper wrapper = new CmsResourceTypeInfoWrapper(this.m_context, this.m_cms, this.m_config, type);
                result.add(wrapper);
            }
            catch (CmsLoaderException cmsLoaderException) {}
        }
        return result;
    }
}

