/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.flex.CmsFlexController;
import org.opencms.jsp.CmsJspTagContainer;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.I_CmsFormatterBean;

public class CmsJspContainerPageWrapper {
    private static final Log LOG = CmsLog.getLog(CmsJspContainerPageWrapper.class);
    private CmsContainerPageBean m_page;

    public CmsJspContainerPageWrapper(CmsContainerPageBean page) {
        this.m_page = page;
    }

    public String renderContainer(CmsJspStandardContextBean context, String name) {
        CmsContainerBean container = this.findContainer(name);
        if (container == null) {
            return null;
        }
        return this.render(context, container);
    }

    private CmsContainerBean findContainer(String name) {
        CmsContainerBean result = this.m_page.getContainers().get(name);
        if (result == null) {
            for (Map.Entry<String, CmsContainerBean> entry : this.m_page.getContainers().entrySet()) {
                if (!entry.getKey().endsWith("-" + name)) continue;
                result = entry.getValue();
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String render(CmsJspStandardContextBean context, CmsContainerBean container) {
        CmsFlexController controller = CmsFlexController.getController(context.getRequest());
        CmsObject m_cms = context.getCmsObject();
        CmsContainerBean oldContainer = context.getContainer();
        CmsJspStandardContextBean.CmsContainerElementWrapper oldElement = context.getElement();
        CmsContainerPageBean oldPage = context.getPage();
        boolean oldForceDisableEdit = context.isForceDisableEditMode();
        Locale locale = m_cms.getRequestContext().getLocale();
        context.getRequest();
        try {
            String resultHtml;
            context.setContainer(container);
            context.setPage(this.m_page);
            context.setForceDisableEditMode(true);
            int containerWidth = -1;
            try {
                containerWidth = Integer.parseInt(container.getWidth());
            }
            catch (Exception e) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            CmsADEConfigData adeConfig = context.getSitemapConfigInternal();
            StringBuilder buffer = new StringBuilder();
            for (CmsContainerElementBean element : container.getElements()) {
                try {
                    element.initResource(m_cms);
                    I_CmsFormatterBean formatterBean = CmsJspTagContainer.ensureValidFormatterSettings(m_cms, element, adeConfig, container.getName(), container.getType(), containerWidth);
                    element.initSettings(m_cms, adeConfig, formatterBean, locale, (ServletRequest)controller.getCurrentRequest(), null);
                    context.setElement(element);
                    CmsResource formatterRes = m_cms.readResource(formatterBean.getJspStructureId(), CmsResourceFilter.IGNORE_EXPIRATION);
                    byte[] formatterOutput = OpenCms.getResourceManager().getLoader(formatterRes).dump(m_cms, formatterRes, null, locale, (HttpServletRequest)controller.getCurrentRequest(), (HttpServletResponse)controller.getCurrentResponse());
                    String encoding = controller.getCurrentResponse().getEncoding();
                    String formatterOutputStr = new String(formatterOutput, encoding);
                    buffer.append(formatterOutputStr);
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            String string = resultHtml = buffer.toString();
            return string;
        }
        finally {
            context.setPage(oldPage);
            context.setContainer(oldContainer);
            context.setElement(oldElement);
            context.setForceDisableEditMode(oldForceDisableEdit);
        }
    }
}

