/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.Transformer;
import org.apache.commons.logging.Log;
import org.opencms.jsp.util.CmsJspDateSeriesBean;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsCollectionsGenericWrapper;

public class CmsJspInstanceDateBean {
    static final Log LOG = CmsLog.getLog(CmsJspInstanceDateBean.class);
    private static final String DATE_SEPARATOR = " - ";
    private Date m_start;
    private Date m_end;
    private Date m_explicitEnd;
    private Boolean m_explicitWholeDay;
    private Locale m_explicitLocale;
    private CmsJspDateSeriesBean m_series;
    private String m_formatLong;
    private String m_formatShort;
    private Map<String, String> m_formattedDates;

    public CmsJspInstanceDateBean() {
    }

    public CmsJspInstanceDateBean(Date start, CmsJspDateSeriesBean series) {
        this.m_start = start;
        this.m_series = series;
    }

    public CmsJspInstanceDateBean(Date start, Locale locale) {
        this(start, new CmsJspDateSeriesBean(Long.toString(start.getTime()), locale));
    }

    public Date getEnd() {
        if (this.m_explicitEnd != null) {
            return this.isWholeDay() ? this.adjustForWholeDay(this.m_explicitEnd, true) : this.m_explicitEnd;
        }
        if (this.m_end == null && this.m_series.getInstanceDuration() != null) {
            this.m_end = new Date(this.m_start.getTime() + this.m_series.getInstanceDuration());
        }
        if (this.m_end == null) {
            this.m_end = new Date(this.getStart().getTime());
        }
        return this.m_end.getTime() > 0L && this.isWholeDay() && !this.m_series.isWholeDay() ? this.adjustForWholeDay(this.m_end, true) : this.m_end;
    }

    public CmsJspInstanceDateBean getEndInstance() {
        return new CmsJspInstanceDateBean(this.getEnd(), this.m_series.getLocale());
    }

    public Map<String, String> getFormat() {
        if (null == this.m_formattedDates) {
            this.m_formattedDates = CmsCollectionsGenericWrapper.createLazyMap(new CmsDateFormatTransformer(this.m_series.getLocale()));
        }
        return this.m_formattedDates;
    }

    public String getFormatLong() {
        if (this.m_formatLong == null) {
            this.m_formatLong = this.getFormattedDate(1);
        }
        return this.m_formatLong;
    }

    public String getFormatShort() {
        if (this.m_formatShort == null) {
            this.m_formatShort = this.getFormattedDate(3);
        }
        return this.m_formatShort;
    }

    public boolean getIsSet() {
        return this.m_start != null && this.m_start.getTime() != 0L;
    }

    public Date getLastDay() {
        return this.isWholeDay() ? new Date(this.getEnd().getTime() - 86400000L) : this.getEnd();
    }

    public Date getStart() {
        if (this.m_start == null) {
            this.m_start = new Date(0L);
        }
        return this.m_start.getTime() > 0L && this.isWholeDay() && !this.m_series.isWholeDay() ? this.adjustForWholeDay(this.m_start, false) : this.m_start;
    }

    public CmsJspInstanceDateBean getStartInstance() {
        return new CmsJspInstanceDateBean(this.getStart(), this.m_series.getLocale());
    }

    public void init(Date start, Locale locale) {
        this.m_start = start;
        this.m_series = new CmsJspDateSeriesBean(Long.toString(start.getTime()), locale);
    }

    public void init(Date start, String localeStr) {
        this.init(start, new Locale(localeStr));
    }

    public boolean isMultiDay() {
        if (null != this.m_explicitEnd || null != this.m_explicitWholeDay) {
            return this.isSingleMultiDay();
        }
        return this.m_series.isMultiDay();
    }

    public boolean isWholeDay() {
        return null == this.m_explicitWholeDay ? this.m_series.isWholeDay() : this.m_explicitWholeDay.booleanValue();
    }

    public void setEnd(Date endDate) {
        this.m_explicitEnd = null == endDate || this.getStart().after(endDate) ? null : endDate;
    }

    public void setEnd(long endDate) {
        this.m_formatLong = null;
        this.m_formatShort = null;
        this.setEnd(new Date(endDate));
    }

    public void setWholeDay(Boolean isWholeDay) {
        this.m_formatLong = null;
        this.m_formatShort = null;
        this.m_explicitWholeDay = isWholeDay;
    }

    String getFormattedDate(CmsDateFormatOption formatOption) {
        String result;
        if (null == formatOption) {
            return this.getFormattedDate(3);
        }
        if (this.isWholeDay()) {
            String to;
            result = formatOption.formatDate(this.getStart());
            if (this.getLastDay().after(this.getStart()) && !(to = formatOption.formatDate(this.getLastDay())).isEmpty()) {
                result = result + DATE_SEPARATOR + to;
            }
        } else {
            String to;
            result = formatOption.formatDateTime(this.getStart());
            if (this.getEnd().after(this.getStart()) && !(to = this.isMultiDay() ? formatOption.formatDateTime(this.getEnd()) : formatOption.formatTime(this.getEnd())).isEmpty()) {
                result = result + DATE_SEPARATOR + to;
            }
        }
        return result;
    }

    private Date adjustForWholeDay(Date date, boolean isEnd) {
        GregorianCalendar result = new GregorianCalendar();
        result.setTime(date);
        result.set(11, 0);
        result.set(12, 0);
        result.set(13, 0);
        result.set(14, 0);
        if (isEnd) {
            ((Calendar)result).add(5, 1);
        }
        return result.getTime();
    }

    private String getFormattedDate(int dateTimeFormat) {
        String result;
        if (this.isWholeDay()) {
            DateFormat df = DateFormat.getDateInstance(dateTimeFormat, this.m_series.getLocale());
            result = df.format(this.getStart());
            if (this.getLastDay().after(this.getStart())) {
                result = result + DATE_SEPARATOR + df.format(this.getLastDay());
            }
        } else {
            DateFormat df = DateFormat.getDateTimeInstance(dateTimeFormat, 3, this.m_series.getLocale());
            result = df.format(this.getStart());
            if (this.getEnd().after(this.getStart())) {
                if (this.isMultiDay()) {
                    result = result + DATE_SEPARATOR + df.format(this.getEnd());
                } else {
                    df = DateFormat.getTimeInstance(3, this.m_series.getLocale());
                    result = result + DATE_SEPARATOR + df.format(this.getEnd());
                }
            }
        }
        return result;
    }

    private boolean isSingleMultiDay() {
        long duration = this.getEnd().getTime() - this.getStart().getTime();
        if (duration > 86400000L) {
            return true;
        }
        if (this.isWholeDay() && duration <= 86400000L) {
            return false;
        }
        GregorianCalendar start = new GregorianCalendar();
        start.setTime(this.getStart());
        GregorianCalendar end = new GregorianCalendar();
        end.setTime(this.getEnd());
        return start.get(5) != end.get(5);
    }

    public class CmsDateFormatTransformer
    implements Transformer {
        Locale m_locale;

        public CmsDateFormatTransformer(Locale locale) {
            this.m_locale = locale;
        }

        public String transform(Object formatOption) {
            CmsDateFormatOption option = null;
            try {
                option = new CmsDateFormatOption(formatOption.toString(), this.m_locale);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)"At least one of the provided date/time patterns are illegal. Defaulting to short default date format.", (Throwable)e);
            }
            return CmsJspInstanceDateBean.this.getFormattedDate(option);
        }
    }

    public static class CmsDateFormatOption {
        SimpleDateFormat m_dateFormat;
        SimpleDateFormat m_timeFormat;
        SimpleDateFormat m_dateTimeFormat;

        public CmsDateFormatOption(String configString, Locale locale) throws IllegalArgumentException {
            if (null != configString) {
                String[] config = configString.split("\\|");
                String datePattern = config[0];
                if (!datePattern.trim().isEmpty()) {
                    this.m_dateFormat = new SimpleDateFormat(datePattern, locale);
                }
                if (config.length > 1) {
                    String timePattern = config[1];
                    if (!timePattern.trim().isEmpty()) {
                        this.m_timeFormat = new SimpleDateFormat(timePattern, locale);
                    }
                    if (config.length > 2) {
                        String dateTimePattern = config[2];
                        if (!dateTimePattern.trim().isEmpty()) {
                            this.m_dateTimeFormat = new SimpleDateFormat(dateTimePattern, locale);
                        }
                    } else if (null != this.m_dateFormat && null != this.m_timeFormat) {
                        this.m_dateTimeFormat = new SimpleDateFormat(this.m_dateFormat.toPattern() + " " + this.m_timeFormat.toPattern(), locale);
                    }
                }
            }
        }

        String formatDate(Date d) {
            return null != this.m_dateFormat ? this.m_dateFormat.format(d) : "";
        }

        String formatDateTime(Date d) {
            return null != this.m_dateTimeFormat ? this.m_dateTimeFormat.format(d) : (null != this.m_dateFormat ? this.m_dateFormat.format(d) : (this.m_timeFormat != null ? this.m_timeFormat.format(d) : ""));
        }

        String formatTime(Date d) {
            return null != this.m_timeFormat ? this.m_timeFormat.format(d) : "";
        }
    }
}

