/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsKeyDummyMacroResolver
extends CmsMacroResolver {
    public static final Pattern PATTERN_MESSAGE = Pattern.compile("^%\\(key\\.([^\\)]++)\\)$");
    private static final Pattern UUID_PATTERN = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}");
    private CmsMacroResolver m_delegate;
    private Map<CmsUUID, String> m_keys = new HashMap<CmsUUID, String>();

    public CmsKeyDummyMacroResolver(CmsMacroResolver delegate) {
        this.m_delegate = delegate;
    }

    public static String getKey(String s) {
        if (s == null) {
            return null;
        }
        Matcher matcher = PATTERN_MESSAGE.matcher(s);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String getKey(String s, CmsMacroResolver delegate) {
        if (s == null) {
            return null;
        }
        CmsKeyDummyMacroResolver resolver = new CmsKeyDummyMacroResolver(delegate);
        String resolved = resolver.resolveMacros(s);
        return CmsKeyDummyMacroResolver.getKey(resolved);
    }

    @Override
    public String getMacroValue(String macro) {
        if (macro.startsWith("key.")) {
            String key = macro.substring("key.".length());
            CmsUUID id = new CmsUUID();
            this.m_keys.put(id, key);
            return id.toString();
        }
        String result = this.m_delegate.getMacroValue(macro);
        return result;
    }

    @Override
    public String resolveMacros(String input) {
        String processedInput = super.resolveMacros(input);
        String result = CmsStringUtil.substitute(UUID_PATTERN, processedInput, (s, matcher) -> {
            CmsUUID id = new CmsUUID(matcher.group());
            if (this.m_keys.containsKey(id)) {
                return "%(key." + this.m_keys.get(id) + ")";
            }
            return matcher.group();
        });
        return result;
    }
}

