/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.opencms.acacia.shared.CmsTabInfo;
import org.opencms.ade.contenteditor.CmsContentTypeVisitor;
import org.opencms.ade.contenteditor.CmsWidgetUtil;
import org.opencms.file.CmsObject;
import org.opencms.gwt.Messages;
import org.opencms.i18n.CmsMessages;
import org.opencms.i18n.CmsMultiMessages;
import org.opencms.jsp.util.CmsKeyDummyMacroResolver;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.content.CmsDefaultXmlContentHandler;
import org.opencms.xml.content.I_CmsXmlContentHandler;
import org.opencms.xml.types.CmsXmlNestedContentDefinition;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public class CmsSchemaInfo {
    private static final Log LOG = CmsLog.getLog(CmsSchemaInfo.class);
    private CmsObject m_cms;
    private Locale m_locale;
    private CmsMultiMessages m_messages;
    private Field m_root;
    private List<Tab> m_tabs;

    public CmsSchemaInfo(CmsObject cms, CmsXmlContentDefinition contentDef) {
        this.m_cms = cms;
        this.m_locale = cms.getRequestContext().getLocale();
        this.m_root = new Field(contentDef);
        CmsMessages messages = null;
        this.m_messages = new CmsMultiMessages(this.m_locale);
        this.m_messages.setFallbackHandler(contentDef.getContentHandler().getMessageKeyHandler());
        try {
            messages = OpenCms.getWorkplaceManager().getMessages(this.m_locale);
            if (messages != null) {
                this.m_messages.addMessages(messages);
            }
            if ((messages = contentDef.getContentHandler().getMessages(this.m_locale)) != null) {
                this.m_messages.addMessages(messages);
            }
        }
        catch (Exception e) {
            LOG.debug((Object)e.getMessage(), (Throwable)e);
        }
        this.initTabs();
    }

    static String combinePaths(String a, String b) {
        if ("".equals(a)) {
            return b;
        }
        return a + "/" + b;
    }

    public Field getRoot() {
        return this.m_root;
    }

    public List<Tab> getTabs() {
        return this.m_tabs;
    }

    public boolean hasTabs() {
        return this.m_tabs.get(0).getDisplayName() == null;
    }

    private void initTabs() {
        List<CmsTabInfo> tabs = CmsContentTypeVisitor.collectTabInfos(this.m_cms, this.m_root.getContentDefinition(), this.m_messages);
        ArrayList<Tab> result = new ArrayList<Tab>();
        if (tabs == null || tabs.size() == 0) {
            Tab defaultTab = new Tab();
            result.add(defaultTab);
            defaultTab.getFields().addAll(this.m_root.getChildren());
        } else {
            int index = 0;
            for (Field node : this.m_root.getChildren()) {
                if (index < tabs.size() && node.getName().equals(tabs.get(index).getStartName())) {
                    Tab tab = new Tab();
                    tab.setDisplayName(tabs.get(index).getTabName());
                    tab.setDisplayNameKey(tabs.get(index).getTabNameKey());
                    tab.setDescriptionKey(tabs.get(index).getDescriptionKey());
                    tab.setDescription(tabs.get(index).getDescription());
                    result.add(tab);
                    ++index;
                }
                if (result.size() <= 0) continue;
                ((Tab)result.get(result.size() - 1)).add(node);
            }
        }
        this.m_tabs = result;
    }

    public class Field {
        private LinkedHashMap<String, Field> m_children = new LinkedHashMap();
        private CmsXmlContentDefinition m_contentDefinition;
        private I_CmsXmlSchemaType m_field;
        private String m_path = "";
        private CmsWidgetUtil.WidgetInfo m_widgetInfo;

        public Field(CmsXmlContentDefinition contentDef) {
            this.m_contentDefinition = contentDef;
            this.m_path = "";
            this.processContentDefinition(this.m_contentDefinition);
        }

        public Field(I_CmsXmlSchemaType field, String path) {
            this.m_path = path;
            this.m_field = field;
            if (field instanceof CmsXmlNestedContentDefinition) {
                CmsXmlNestedContentDefinition nestedDef = (CmsXmlNestedContentDefinition)field;
                this.m_contentDefinition = nestedDef.getNestedContentDefinition();
                this.processContentDefinition(this.m_contentDefinition);
            }
        }

        public Collection<Field> getChildren() {
            return this.m_children.values();
        }

        public CmsXmlContentDefinition getContentDefinition() {
            return this.m_contentDefinition;
        }

        public String getDefaultValue() {
            if (this.m_field == null) {
                return null;
            }
            return CmsSchemaInfo.this.m_root.getContentDefinition().getContentHandler().getDefault(CmsSchemaInfo.this.m_cms, null, this.m_field, this.m_path, CmsSchemaInfo.this.m_locale);
        }

        public String getDescription() {
            return this.getDescription(false);
        }

        public String getDescriptionKey() {
            return this.getDescription(true);
        }

        public String getDisplayName() {
            return this.getDisplayName(false);
        }

        public String getDisplayNameKey() {
            return this.getDisplayName(true);
        }

        public boolean getIsChoice() {
            return this.m_field.isChoiceType();
        }

        public boolean getIsNestedContent() {
            return this.m_contentDefinition != null;
        }

        public int getMaxOccurs() {
            return this.m_field.getMaxOccurs();
        }

        public int getMinOccurs() {
            return this.m_field.getMinOccurs();
        }

        public String getName() {
            if (this.m_field == null) {
                return null;
            }
            return this.m_field.getName();
        }

        public List<CmsSelectWidgetOption> getParsedSelectOptions() {
            String widgetConfig = this.getWidgetConfig();
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(widgetConfig)) {
                return null;
            }
            try {
                List<CmsSelectWidgetOption> options = CmsSelectWidgetOption.parseOptions(widgetConfig);
                ArrayList<CmsSelectWidgetOption> result = new ArrayList<CmsSelectWidgetOption>();
                Set values = options.stream().map(option -> option.getValue()).collect(Collectors.toSet());
                String defaultValue = this.getDefaultValue();
                Locale locale = CmsSchemaInfo.this.m_cms.getRequestContext().getLocale();
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(defaultValue) || !values.contains(defaultValue)) {
                    CmsSelectWidgetOption noValue = new CmsSelectWidgetOption("", true, Messages.get().getBundle(locale).key("GUI_SELECTBOX_EMPTY_SELECTION_0"));
                    result.add(noValue);
                }
                result.addAll(options);
                return result;
            }
            catch (Exception e) {
                LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                return null;
            }
        }

        public String getType() {
            return this.m_field.getTypeName();
        }

        public String getValidationError() {
            if (this.m_field == null) {
                return null;
            }
            I_CmsXmlContentHandler handler = this.m_field.getContentDefinition().getContentHandler();
            if (!(handler instanceof CmsDefaultXmlContentHandler)) {
                return null;
            }
            CmsDefaultXmlContentHandler defaultHandler = (CmsDefaultXmlContentHandler)handler;
            return defaultHandler.getValidationWarningOrErrorMessage(CmsSchemaInfo.this.m_cms, CmsSchemaInfo.this.m_locale, this.m_field.getName(), false, false);
        }

        public String getValidationErrorKey() {
            if (this.m_field == null) {
                return null;
            }
            I_CmsXmlContentHandler handler = this.m_field.getContentDefinition().getContentHandler();
            if (!(handler instanceof CmsDefaultXmlContentHandler)) {
                return null;
            }
            CmsDefaultXmlContentHandler defaultHandler = (CmsDefaultXmlContentHandler)handler;
            return defaultHandler.getValidationWarningOrErrorMessage(CmsSchemaInfo.this.m_cms, CmsSchemaInfo.this.m_locale, this.m_field.getName(), false, true);
        }

        public String getValidationWarning() {
            if (this.m_field == null) {
                return null;
            }
            I_CmsXmlContentHandler handler = this.m_field.getContentDefinition().getContentHandler();
            if (!(handler instanceof CmsDefaultXmlContentHandler)) {
                return null;
            }
            CmsDefaultXmlContentHandler defaultHandler = (CmsDefaultXmlContentHandler)handler;
            return defaultHandler.getValidationWarningOrErrorMessage(CmsSchemaInfo.this.m_cms, CmsSchemaInfo.this.m_locale, this.m_field.getName(), true, false);
        }

        public String getValidationWarningKey() {
            if (this.m_field == null) {
                return null;
            }
            I_CmsXmlContentHandler handler = this.m_field.getContentDefinition().getContentHandler();
            if (!(handler instanceof CmsDefaultXmlContentHandler)) {
                return null;
            }
            CmsDefaultXmlContentHandler defaultHandler = (CmsDefaultXmlContentHandler)handler;
            return defaultHandler.getValidationWarningOrErrorMessage(CmsSchemaInfo.this.m_cms, CmsSchemaInfo.this.m_locale, this.m_field.getName(), true, true);
        }

        public String getWidget() {
            if (this.m_contentDefinition != null) {
                return null;
            }
            CmsWidgetUtil.WidgetInfo widgetInfo = this.getWidgetInfo();
            if (widgetInfo != null) {
                return widgetInfo.getWidget().getClass().getName();
            }
            LOG.error((Object)("Widget info not defined for " + this.m_path + " in " + CmsSchemaInfo.this.m_root.getContentDefinition()));
            return null;
        }

        public String getWidgetConfig() {
            if (this.m_contentDefinition != null) {
                return null;
            }
            CmsWidgetUtil.WidgetInfo widgetInfo = this.getWidgetInfo();
            if (widgetInfo != null) {
                return widgetInfo.getWidget().getConfiguration();
            }
            LOG.error((Object)("Widget info not defined for " + this.m_path + " in " + CmsSchemaInfo.this.m_root.getContentDefinition()));
            return null;
        }

        private String getDescription(boolean keyOnly) {
            CmsDefaultXmlContentHandler defaultHandler;
            String help;
            if (this.m_field == null) {
                return null;
            }
            StringBuffer result = new StringBuffer(64);
            I_CmsXmlContentHandler handler = this.m_field.getContentDefinition().getContentHandler();
            if (handler instanceof CmsDefaultXmlContentHandler && (help = (defaultHandler = (CmsDefaultXmlContentHandler)handler).getFieldHelp().get(this.m_field.getName())) != null) {
                CmsMacroResolver resolver = new CmsMacroResolver();
                if (keyOnly) {
                    resolver = new CmsKeyDummyMacroResolver(resolver);
                }
                resolver.setCmsObject(CmsSchemaInfo.this.m_cms);
                resolver.setKeepEmptyMacros(true);
                resolver.setMessages(CmsSchemaInfo.this.m_messages);
                String val = resolver.resolveMacros(help);
                if (keyOnly) {
                    return CmsKeyDummyMacroResolver.getKey(val);
                }
                return val;
            }
            result.append("label.");
            result.append(this.getTypeKey(this.m_field));
            result.append(".help");
            if (keyOnly) {
                return result.toString();
            }
            return CmsSchemaInfo.this.m_messages.keyDefault(result.toString(), null);
        }

        private String getDisplayName(boolean keyOnly) {
            CmsDefaultXmlContentHandler defaultHandler;
            String label;
            if (this.m_field == null) {
                return null;
            }
            I_CmsXmlContentHandler handler = this.m_field.getContentDefinition().getContentHandler();
            if (handler instanceof CmsDefaultXmlContentHandler && (label = (defaultHandler = (CmsDefaultXmlContentHandler)handler).getFieldLabels().get(this.m_field.getName())) != null) {
                CmsMacroResolver resolver = new CmsMacroResolver();
                if (keyOnly) {
                    resolver = new CmsKeyDummyMacroResolver(resolver);
                }
                resolver.setCmsObject(CmsSchemaInfo.this.m_cms);
                resolver.setKeepEmptyMacros(true);
                resolver.setMessages(CmsSchemaInfo.this.m_messages);
                String val = resolver.resolveMacros(label);
                if (keyOnly) {
                    return CmsKeyDummyMacroResolver.getKey(val);
                }
                return val;
            }
            StringBuffer result = new StringBuffer(64);
            result.append("label.");
            result.append(this.getTypeKey(this.m_field));
            if (keyOnly) {
                return result.toString();
            }
            return CmsSchemaInfo.this.m_messages.keyDefault(result.toString(), this.m_field.getName());
        }

        private String getTypeKey(I_CmsXmlSchemaType value) {
            StringBuffer result = new StringBuffer(64);
            result.append(value.getContentDefinition().getInnerName());
            result.append('.');
            result.append(value.getName());
            return result.toString();
        }

        private CmsWidgetUtil.WidgetInfo getWidgetInfo() {
            if (this.m_widgetInfo == null) {
                this.m_widgetInfo = CmsWidgetUtil.collectWidgetInfo(CmsSchemaInfo.this.m_cms, CmsSchemaInfo.this.m_root.getContentDefinition(), this.m_path, null);
            }
            return this.m_widgetInfo;
        }

        private void processContentDefinition(CmsXmlContentDefinition contentDef) {
            List<I_CmsXmlSchemaType> fields = contentDef.getTypeSequence();
            for (I_CmsXmlSchemaType field : fields) {
                String name = field.getName();
                this.m_children.put(name, new Field(field, CmsSchemaInfo.combinePaths(this.m_path, name)));
            }
        }
    }

    public class Tab {
        private String m_displayName;
        private String m_displayNameKey;
        private String m_description;
        private String m_descriptionKey;
        private List<Field> m_fields = new ArrayList<Field>();

        public void add(Field field) {
            this.m_fields.add(field);
        }

        public String getDescription() {
            return this.m_description;
        }

        public String getDescriptionKey() {
            return this.m_descriptionKey;
        }

        public String getDisplayName() {
            return this.m_displayName;
        }

        public String getDisplayNameKey() {
            return this.m_displayNameKey;
        }

        public List<Field> getFields() {
            return this.m_fields;
        }

        public void setDescription(String description) {
            this.m_description = description;
        }

        public void setDescriptionKey(String descriptionKey) {
            this.m_descriptionKey = descriptionKey;
        }

        public void setDisplayName(String displayName) {
            this.m_displayName = displayName;
        }

        public void setDisplayNameKey(String displayNameKey) {
            this.m_displayNameKey = displayNameKey;
        }
    }
}

