/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.gwt.Messages;
import org.opencms.jsp.util.CmsKeyDummyMacroResolver;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.content.CmsXmlContentPropertyHelper;

public class CmsSettingDefinitionWrapper {
    private static final Log LOG = CmsLog.getLog(CmsSettingDefinitionWrapper.class);
    private CmsXmlContentProperty m_definitionWithKeys;
    private CmsXmlContentProperty m_rawDefinition;
    private CmsXmlContentProperty m_resolvedDefinition;
    private CmsObject m_cms;

    public CmsSettingDefinitionWrapper(CmsObject cms, CmsXmlContentProperty settingDef, CmsMacroResolver resolver) {
        this.m_rawDefinition = settingDef;
        this.m_cms = cms;
        this.m_resolvedDefinition = CmsXmlContentPropertyHelper.resolveMacrosInProperty(settingDef, resolver);
        CmsKeyDummyMacroResolver keyResolver = new CmsKeyDummyMacroResolver(resolver);
        this.m_definitionWithKeys = CmsXmlContentPropertyHelper.resolveMacrosInProperty(settingDef, keyResolver);
    }

    public String getDefaultValue() {
        return this.m_resolvedDefinition.getDefault();
    }

    public String getDescription() {
        return this.m_resolvedDefinition.getDescription();
    }

    public String getDescriptionKey() {
        return CmsKeyDummyMacroResolver.getKey(this.m_definitionWithKeys.getDescription());
    }

    public String getDisplayName() {
        return this.m_resolvedDefinition.getNiceName();
    }

    public String getDisplayNameKey() {
        return CmsKeyDummyMacroResolver.getKey(this.m_definitionWithKeys.getNiceName());
    }

    public List<CmsSelectWidgetOption> getParsedSelectOptions() {
        String widgetConfig = this.getWidgetConfig();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(widgetConfig)) {
            return null;
        }
        try {
            List<CmsSelectWidgetOption> options = CmsSelectWidgetOption.parseOptions(widgetConfig);
            ArrayList<CmsSelectWidgetOption> result = new ArrayList<CmsSelectWidgetOption>();
            Set values = options.stream().map(option -> option.getValue()).collect(Collectors.toSet());
            String defaultValue = this.getDefaultValue();
            Locale locale = this.m_cms.getRequestContext().getLocale();
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(defaultValue) || !values.contains(defaultValue)) {
                CmsSelectWidgetOption noValue = new CmsSelectWidgetOption("", true, Messages.get().getBundle(locale).key("GUI_SELECTBOX_EMPTY_SELECTION_0"));
                result.add(noValue);
            }
            result.addAll(options);
            return result;
        }
        catch (Exception e) {
            LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public String getPropertyName() {
        return this.m_resolvedDefinition.getName();
    }

    public String getVisibility() {
        return "" + (Object)((Object)this.m_resolvedDefinition.getVisibility(CmsXmlContentProperty.Visibility.elementAndParentIndividual));
    }

    public String getWidget() {
        return this.m_resolvedDefinition.getWidget();
    }

    public String getWidgetConfig() {
        return this.m_resolvedDefinition.getWidgetConfiguration();
    }

    public String toString() {
        try {
            return BeanUtils.describe((Object)this).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "???";
        }
    }
}

