/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.letsencrypt;

import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsElementWithAttrsParamConfigHelper;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.configuration.I_CmsConfigurationParameterHandler;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;

public class CmsLetsEncryptConfiguration
implements I_CmsConfigurationParameterHandler {
    public static final String ATTR_CERTCONFIG = "certconfig";
    public static final String ATTR_HOST = "host";
    public static final String ATTR_MODE = "mode";
    public static final String ATTR_PORT = "port";
    public static final String ATTR_TRIGGER = "trigger";
    public static final String N_LETSENCRYPT = "letsencrypt";
    public static final CmsElementWithAttrsParamConfigHelper CONFIG_HELPER = new CmsElementWithAttrsParamConfigHelper("*/system", "letsencrypt", CmsLetsEncryptConfiguration.class, "host", "port", "mode", "certconfig", "trigger");
    private static final Log LOG = CmsLog.getLog(CmsLetsEncryptConfiguration.class);
    public static final Trigger DEFAULT_TRIGGER = Trigger.siteConfig;
    private CmsParameterConfiguration m_config = new CmsParameterConfiguration();

    @Override
    public void addConfigurationParameter(String paramName, String paramValue) {
        this.m_config.put(paramName, paramValue);
    }

    public String getCertConfigPath() {
        return this.m_config.get(ATTR_CERTCONFIG);
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        return CmsParameterConfiguration.unmodifiableVersion(this.m_config);
    }

    public String getHost() {
        return this.m_config.get(ATTR_HOST);
    }

    public Mode getMode() {
        try {
            return Mode.valueOf(this.m_config.get(ATTR_MODE));
        }
        catch (Exception e) {
            LOG.error((Object)("Error getting letsencrypt mode: " + e.getLocalizedMessage()), (Throwable)e);
            return null;
        }
    }

    public int getPort() {
        try {
            String portStr = this.m_config.get(ATTR_PORT);
            return Integer.valueOf(portStr);
        }
        catch (Exception e) {
            LOG.error((Object)("Error getting letsencrypt port: " + e.getLocalizedMessage()), (Throwable)e);
            return -1;
        }
    }

    public Trigger getTrigger() {
        try {
            String triggerStr = this.m_config.get(ATTR_TRIGGER);
            if (triggerStr == null) {
                return DEFAULT_TRIGGER;
            }
            Trigger trigger = Trigger.valueOf(triggerStr);
            return trigger;
        }
        catch (Exception e) {
            LOG.error((Object)("Error getting configured letsencrypt trigger: " + e.getLocalizedMessage()), (Throwable)e);
            return DEFAULT_TRIGGER;
        }
    }

    @Override
    public void initConfiguration() {
    }

    public boolean isValidAndEnabled() {
        return this.getMode() != null && this.getMode() != Mode.disabled && this.getPort() > -1 && !CmsStringUtil.isEmptyOrWhitespaceOnly(this.getCertConfigPath()) && !CmsStringUtil.isEmptyOrWhitespaceOnly(this.getHost());
    }

    public static enum Mode {
        all,
        disabled,
        sites,
        workplace;

    }

    public static enum Trigger {
        siteConfig,
        webserverThread;

    }
}

