/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.letsencrypt;

import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.opencms.letsencrypt.CmsLetsEncryptConfiguration;
import org.opencms.letsencrypt.I_CmsLetsEncryptUpdater;
import org.opencms.main.CmsLog;

public class CmsLetsEncryptUpdater
implements I_CmsLetsEncryptUpdater {
    private static final Log LOG = CmsLog.getLog(CmsLetsEncryptUpdater.class);
    private CmsLetsEncryptConfiguration m_config;

    public CmsLetsEncryptUpdater(CmsLetsEncryptConfiguration config) {
        this.m_config = config;
    }

    @Override
    public boolean update(String certConfig) {
        if (this.m_config.isValidAndEnabled()) {
            LOG.debug((Object)("Trying to write certificate configuration: " + certConfig));
            String certConfigPath = this.m_config.getCertConfigPath();
            try (FileOutputStream fos = new FileOutputStream(certConfigPath);){
                fos.write(certConfig.getBytes("UTF-8"));
            }
            catch (IOException e) {
                LOG.error((Object)("Error writing certificate configuration: " + e.getLocalizedMessage()), (Throwable)e);
                return false;
            }
            String host = this.m_config.getHost();
            int port = this.m_config.getPort();
            try (Socket socket = new Socket(host, port);){
                socket.getOutputStream().write("update".getBytes("UTF-8"));
            }
            catch (Exception e) {
                LOG.error((Object)("Couldn't notify LetsEncrypt container: " + e.getLocalizedMessage()), (Throwable)e);
                return false;
            }
            return true;
        }
        LOG.info((Object)"LetsEncrypt configuration is invalid or disabled. ");
        return false;
    }
}

