/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.loader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.opencms.cache.CmsVfsMemoryObjectCache;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.json.JSONObject;
import org.opencms.json.JSONTokener;
import org.opencms.jsp.util.I_CmsJspDeviceSelector;
import org.opencms.loader.CmsClientVariant;
import org.opencms.loader.CmsJsonMessageContainer;
import org.opencms.loader.CmsTemplateContext;
import org.opencms.loader.I_CmsTemplateContextProvider;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;

public class CmsDefaultTemplateContextProvider
implements I_CmsTemplateContextProvider {
    public static final String A_HEIGHT = "height";
    public static final String A_NICE_NAME = "niceName";
    public static final String A_PATH = "path";
    public static final String A_VARIANTS = "variants";
    public static final String A_WIDTH = "width";
    public static final String PARAM_CONFIGURATION = "configuration";
    private static final Log LOG = CmsLog.getLog(CmsDefaultTemplateContextProvider.class);
    private CmsVfsMemoryObjectCache m_cache = new CmsVfsMemoryObjectCache();
    private CmsObject m_cms;
    private Map<String, String> m_params;

    @Override
    public synchronized Map<String, CmsTemplateContext> getAllContexts() {
        return Collections.unmodifiableMap(this.getContextMap());
    }

    public String getConfigurationPropertyPath() {
        if (this.m_params.containsKey(PARAM_CONFIGURATION)) {
            return this.m_params.get(PARAM_CONFIGURATION);
        }
        return OpenCms.getSystemInfo().getConfigFilePath(this.m_cms, "templatecontexts.json");
    }

    @Override
    public String getEditorStyleSheet(CmsObject cms, String editedResourcePath) {
        String templatePath = this.getAllContexts().get("desktop").getTemplatePath();
        String result = null;
        try {
            CmsProperty property = cms.readPropertyObject(templatePath, "template", true);
            if (!property.isNullProperty()) {
                result = property.getValue();
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    public String getOverrideCookieName() {
        return "templatecontext";
    }

    @Override
    public synchronized CmsTemplateContext getTemplateContext(CmsObject cms, HttpServletRequest request, CmsResource resource) {
        I_CmsJspDeviceSelector selector = OpenCms.getSystemInfo().getDeviceSelector();
        String deviceType = request != null ? selector.getDeviceType(request) : null;
        Map<String, CmsTemplateContext> contextMap = this.getAllContexts();
        if (deviceType != null && contextMap.containsKey(deviceType)) {
            return contextMap.get(deviceType);
        }
        return contextMap.get("desktop");
    }

    @Override
    public void initialize(CmsObject cms, String config) {
        this.m_cms = cms;
        this.m_params = CmsStringUtil.isEmptyOrWhitespaceOnly(config) ? new HashMap<String, String>() : CmsStringUtil.splitAsMap(config, ",", "=");
        this.getAllContexts();
    }

    @Override
    public String readCommonProperty(CmsObject cms, String propertyName, String fallbackValue) throws CmsException {
        String templatePath = this.getAllContexts().get("desktop").getTemplatePath();
        return cms.readPropertyObject(templatePath, propertyName, false).getValue(fallbackValue);
    }

    private Map<String, CmsTemplateContext> getContextMap() {
        Object cachedObj = this.m_cache.getCachedObject(this.m_cms, this.getConfigurationPropertyPath());
        if (cachedObj != null) {
            return (Map)cachedObj;
        }
        try {
            Map<String, CmsTemplateContext> map = this.initMap();
            this.m_cache.putCachedObject(this.m_cms, this.getConfigurationPropertyPath(), map);
            return map;
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private Map<String, CmsTemplateContext> initMap() throws Exception {
        LinkedHashMap<String, CmsTemplateContext> result = new LinkedHashMap<String, CmsTemplateContext>();
        String path = this.getConfigurationPropertyPath();
        CmsResource resource = this.m_cms.readResource(path);
        CmsFile file = this.m_cms.readFile(resource);
        String fileContent = new String(file.getContents(), "UTF-8");
        CmsMacroResolver resolver = new CmsMacroResolver();
        resolver.setCmsObject(this.m_cms);
        for (Map.Entry<String, String> param : this.m_params.entrySet()) {
            resolver.addMacro(param.getKey(), param.getValue());
        }
        fileContent = resolver.resolveMacros(fileContent);
        JSONTokener tok = new JSONTokener(fileContent);
        tok.setOrdered(true);
        JSONObject root = new JSONObject(tok, true);
        for (String templateContextName : root.keySet()) {
            JSONObject templateContextJson = (JSONObject)root.opt(templateContextName);
            CmsJsonMessageContainer jsonMessage = new CmsJsonMessageContainer(templateContextJson.opt(A_NICE_NAME));
            String templatePath = (String)templateContextJson.opt(A_PATH);
            JSONObject variantsJson = (JSONObject)templateContextJson.opt(A_VARIANTS);
            ArrayList<CmsClientVariant> variants = new ArrayList<CmsClientVariant>();
            if (variantsJson != null) {
                for (String variantName : variantsJson.keySet()) {
                    JSONObject variantJson = (JSONObject)variantsJson.opt(variantName);
                    CmsJsonMessageContainer variantMessage = new CmsJsonMessageContainer(variantJson.opt(A_NICE_NAME));
                    int width = variantJson.optInt(A_WIDTH, 800);
                    int height = variantJson.optInt(A_HEIGHT, 600);
                    CmsClientVariant variant = new CmsClientVariant(variantName, variantMessage, width, height, new HashMap<String, String>());
                    variants.add(variant);
                }
            }
            CmsTemplateContext templateContext = new CmsTemplateContext(templateContextName, templatePath, jsonMessage, this, variants, false);
            result.put(templateContextName, templateContext);
        }
        return result;
    }
}

