/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.loader;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.loader.CmsDumpLoader;
import org.opencms.loader.CmsLoaderException;
import org.opencms.loader.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;

public class CmsPointerLoader
extends CmsDumpLoader {
    public static final String CONFIGURATION_REQUEST_PARAM_SUPPORT_ENABLED = "pointer.requestparamsupport.enabled";
    public static final int RESOURCE_POINTER_LOADER_ID = 4;
    protected static boolean m_requestParamSupportEnabled;
    private static String EXPORT_PREFIX;
    private static String EXPORT_SUFFIX;

    public static boolean isRequestParamSupportEnabled() {
        return m_requestParamSupportEnabled;
    }

    private static String appendLinkParams(String pointerLink, HttpServletRequest req) {
        Map params;
        String result = pointerLink;
        if (CmsPointerLoader.isRequestParamSupportEnabled() && (params = req.getParameterMap()).size() > 0) {
            result = CmsRequestUtil.appendParameters(result, params, false);
        }
        return result;
    }

    @Override
    public void addConfigurationParameter(String paramName, String paramValue) {
        if (CmsStringUtil.isNotEmpty(paramName) && CmsStringUtil.isNotEmpty(paramValue) && CONFIGURATION_REQUEST_PARAM_SUPPORT_ENABLED.equals(paramName)) {
            m_requestParamSupportEnabled = Boolean.valueOf(paramValue);
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public byte[] dump(CmsObject cms, CmsResource resource, String element, Locale locale, HttpServletRequest req, HttpServletResponse res) throws CmsException {
        return cms.readFile(resource).getContents();
    }

    @Override
    public byte[] export(CmsObject cms, CmsResource resource, HttpServletRequest req, HttpServletResponse res) throws IOException, CmsException {
        String pointer = new String(cms.readFile(resource).getContents(), CmsLocaleManager.getResourceEncoding(cms, resource));
        StringBuffer result = new StringBuffer(128);
        result.append(EXPORT_PREFIX);
        pointer = CmsPointerLoader.appendLinkParams(pointer, req);
        if (pointer.indexOf(58) < 0) {
            result.append(OpenCms.getLinkManager().substituteLink(cms, pointer));
        } else {
            result.append(pointer);
        }
        result.append(EXPORT_SUFFIX);
        this.load(cms, resource, req, res);
        return result.toString().getBytes(OpenCms.getSystemInfo().getDefaultEncoding());
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        CmsParameterConfiguration result = new CmsParameterConfiguration();
        CmsParameterConfiguration config = super.getConfiguration();
        if (config != null) {
            result.putAll(config);
        }
        result.put(CONFIGURATION_REQUEST_PARAM_SUPPORT_ENABLED, String.valueOf(m_requestParamSupportEnabled));
        return result;
    }

    @Override
    public int getLoaderId() {
        return 4;
    }

    @Override
    public String getResourceLoaderInfo() {
        return Messages.get().getBundle().key("GUI_LOADER_POINTER_DEFAULT_DESC_0");
    }

    @Override
    public void initConfiguration() {
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_LOADER_INITIALIZED_1", this.getClass().getName()));
        }
    }

    @Override
    public boolean isStaticExportEnabled() {
        return !m_requestParamSupportEnabled;
    }

    @Override
    public boolean isStaticExportProcessable() {
        return false;
    }

    @Override
    public boolean isUsableForTemplates() {
        return false;
    }

    @Override
    public boolean isUsingUriWhenLoadingTemplate() {
        return false;
    }

    @Override
    public void load(CmsObject cms, CmsResource resource, HttpServletRequest req, HttpServletResponse res) throws IOException, CmsException {
        if (res == null || res.isCommitted()) {
            return;
        }
        String pointer = new String(cms.readFile(resource).getContents(), CmsLocaleManager.getResourceEncoding(cms, resource));
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(pointer)) {
            throw new CmsLoaderException(Messages.get().container("ERR_INVALID_POINTER_FILE_1", resource.getName()));
        }
        pointer = pointer.indexOf(58) < 0 ? OpenCms.getLinkManager().substituteLink(cms, pointer) : CmsEncoder.convertHostToPunycode(pointer);
        pointer = CmsPointerLoader.appendLinkParams(pointer, req);
        res.sendRedirect(pointer);
    }

    @Override
    public void service(CmsObject cms, CmsResource file, ServletRequest req, ServletResponse res) {
        throw new CmsRuntimeException(Messages.get().container("ERR_SERVICE_UNSUPPORTED_1", this.getClass().getName()));
    }

    static {
        EXPORT_PREFIX = "<html>\n<head>\n<meta http-equiv=\"refresh\" content=\"0; url=";
        EXPORT_SUFFIX = "\">\n</head>\n<body></body>\n</html>";
    }
}

