/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsResourceInitException;
import org.opencms.main.I_CmsResourceInit;
import org.opencms.main.Messages;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionViolationException;
import org.opencms.util.CmsUUID;

public class CmsPermalinkResourceHandler
implements I_CmsResourceInit {
    public static final String CAPTURE_UUID_REGEX = "([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})";
    public static final String PERMALINK_HANDLER = "/permalink/";
    public static final String SUFFIX_REGEX = "(?:\\.[a-zA-Z0-9]*)?$";
    private static final Log LOG = CmsLog.getLog(CmsPermalinkResourceHandler.class);
    private Pattern m_detailPattern;
    private Pattern m_simplePermalinkPattern;

    public CmsPermalinkResourceHandler() {
        String uriRegex = "/permalink/([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})(?:\\.[a-zA-Z0-9]*)?$";
        String detailUriRegex = "/permalink/([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}):([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})(?:\\.[a-zA-Z0-9]*)?$";
        this.m_simplePermalinkPattern = Pattern.compile(uriRegex);
        this.m_detailPattern = Pattern.compile(detailUriRegex);
    }

    @Override
    public CmsResource initResource(CmsResource resource, CmsObject cms, HttpServletRequest req, HttpServletResponse res) throws CmsResourceInitException, CmsPermissionViolationException {
        if (resource == null) {
            String uri = cms.getRequestContext().getUri();
            Matcher matcher = this.m_simplePermalinkPattern.matcher(uri);
            if (matcher.find()) {
                CmsResource resource1 = resource;
                String id = matcher.group(1);
                String storedSiteRoot = cms.getRequestContext().getSiteRoot();
                try {
                    cms.getRequestContext().setSiteRoot("/");
                    boolean online = cms.getRequestContext().getCurrentProject().isOnlineProject();
                    CmsResourceFilter filter = online ? CmsResourceFilter.DEFAULT : CmsResourceFilter.IGNORE_EXPIRATION;
                    resource1 = cms.readDefaultFile(id, filter);
                }
                catch (CmsPermissionViolationException e) {
                    throw e;
                }
                catch (Throwable e) {
                    CmsMessageContainer msg = Messages.get().container("ERR_PERMALINK_1", id);
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)msg.key(), e);
                    }
                    throw new CmsResourceInitException(msg, e);
                }
                finally {
                    cms.getRequestContext().setSiteRoot(storedSiteRoot);
                    if (resource1 != null) {
                        cms.getRequestContext().setUri(cms.getSitePath(resource1));
                    }
                }
                resource = resource1;
            } else {
                matcher = this.m_detailPattern.matcher(uri);
                if (matcher.find()) {
                    try {
                        CmsUUID pageId = new CmsUUID(matcher.group(1));
                        CmsUUID detailId = new CmsUUID(matcher.group(2));
                        CmsResource pageResource = cms.readResource(pageId);
                        if (res != null) {
                            CmsResource detailResource = cms.readResource(detailId);
                            String detailName = cms.getDetailName(detailResource, cms.getRequestContext().getLocale(), OpenCms.getLocaleManager().getDefaultLocales());
                            CmsResource parentFolder = pageResource.isFile() ? cms.readParentFolder(pageResource.getStructureId()) : pageResource;
                            String baseLink = OpenCms.getLinkManager().substituteLink(cms, parentFolder);
                            String redirectLink = baseLink + (baseLink.endsWith("/") ? "" : "/") + detailName;
                            CmsResourceInitException resInitException = new CmsResourceInitException(this.getClass());
                            resInitException.setClearErrors(true);
                            res.sendRedirect(redirectLink);
                            throw resInitException;
                        }
                        return pageResource;
                    }
                    catch (CmsResourceInitException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        throw new CmsResourceInitException(this.getClass());
                    }
                }
                return null;
            }
        }
        if (resource != null && resource.isInternalOrInInternalFolder()) {
            return null;
        }
        return resource;
    }
}

