/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.lang.reflect.Method;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Enumeration;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsInitException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsSingleThreadDumperThread;
import org.opencms.main.Messages;
import org.opencms.main.OpenCmsCore;

public class OpenCmsListener
implements ServletContextListener,
HttpSessionListener {
    private static final Log LOG = CmsLog.getLog(OpenCmsListener.class);

    public void contextDestroyed(ServletContextEvent event) {
        try {
            OpenCmsCore.getInstance().shutDown();
            this.shutDownSqlDrivers();
        }
        catch (CmsInitException e) {
            if (e.isNewError()) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_ERROR_GENERIC_0"), t);
        }
    }

    public void contextInitialized(ServletContextEvent event) {
        String basePath = event.getServletContext().getRealPath("/");
        String path = basePath + "/WEB-INF/logs/startup-stacktraces.zip";
        String summaryPath = basePath + "/WEB-INF/logs/startup-summary.xml";
        CmsSingleThreadDumperThread dumpThread = new CmsSingleThreadDumperThread(path, summaryPath, Thread.currentThread().getId());
        boolean enableThreadDumps = "true".equalsIgnoreCase(System.getProperty("opencms.profile.startup.stacktraces"));
        try {
            if (enableThreadDumps) {
                dumpThread.start();
            }
            OpenCmsCore.getInstance().upgradeRunlevel(event.getServletContext());
        }
        catch (CmsInitException e) {
            if (e.isNewError()) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_ERROR_GENERIC_0"), t);
            throw new CmsInitException(Messages.get().container("ERR_CRITICAL_INIT_GENERIC_1", t.getMessage()));
        }
        finally {
            dumpThread.interrupt();
        }
    }

    public void sessionCreated(HttpSessionEvent event) {
        try {
            OpenCmsCore.getInstance().getSessionManager().sessionCreated(event);
        }
        catch (CmsInitException e) {
            if (e.isNewError()) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_ERROR_GENERIC_0"), t);
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        try {
            OpenCmsCore.getInstance().getSessionManager().sessionDestroyed(event);
        }
        catch (CmsInitException e) {
            if (e.isNewError()) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_ERROR_GENERIC_0"), t);
        }
    }

    private void shutDownSqlDrivers() {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            try {
                DriverManager.deregisterDriver(driver);
            }
            catch (Throwable e) {
                System.out.println(Messages.get().getBundle().key("ERR_DEREGISTERING_JDBC_DRIVER_1", driver.getClass().getName()));
                e.printStackTrace(System.out);
            }
        }
        try {
            Method shutdownMethod;
            Class<?> cls = Class.forName("com.mysql.jdbc.AbandonedConnectionCleanupThread");
            Method method = shutdownMethod = cls == null ? null : cls.getMethod("shutdown", new Class[0]);
            if (shutdownMethod != null) {
                shutdownMethod.invoke(null, new Object[0]);
            }
        }
        catch (Throwable e) {
            System.out.println("Failed to shutdown MySQL connection cleanup thread: " + e.getMessage());
        }
    }
}

