/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.CmsDuplicateRemovingLogBuffer;
import org.opencms.main.CmsException;
import org.opencms.main.CmsInitException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsServletContainerSettings;
import org.opencms.main.I_CmsRequestHandler;
import org.opencms.main.Messages;
import org.opencms.main.OpenCms;
import org.opencms.main.OpenCmsCore;
import org.opencms.site.CmsSite;
import org.opencms.staticexport.CmsStaticExportRequest;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsThreadLocalStack;
import org.opencms.util.CmsUUID;

public class OpenCmsServlet
extends HttpServlet
implements I_CmsRequestHandler {
    public static final CmsThreadLocalStack<HttpServletRequest> currentRequestStack = new CmsThreadLocalStack();
    public static final ConcurrentHashMap<CmsUUID, RequestInfo> activeRequests = new ConcurrentHashMap();
    private static final CmsThreadLocalStack<RequestCache> requestCacheStack = new CmsThreadLocalStack();
    public static final String HANDLE_GWT = ".gwt";
    public static final String HANDLE_PATH = "/handle";
    public static final String SERVLET_PARAM_DEFAULT_WEB_APPLICATION = "DefaultWebApplication";
    public static final String SERVLET_PARAM_OPEN_CMS_HOME = "OpenCmsHome";
    public static final String SERVLET_PARAM_OPEN_CMS_SERVLET = "OpenCmsServlet";
    public static final String SERVLET_PARAM_WEB_APPLICATION_CONTEXT = "WebApplicationContext";
    private static final String HANDLE_VFS_PATH = "/system/handler/handle";
    private static final String HANDLE_VFS_SUFFIX = ".html";
    private static final String[] HANDLER_NAMES = new String[]{"404"};
    private static final Log LOG = CmsLog.getLog(OpenCmsServlet.class);
    private static final long serialVersionUID = 4729951599966070050L;
    public static final String HANDLE_BUILTIN_SERVICE = "/handleBuiltinService/";

    public static RequestCache getRequestCache() {
        RequestCache result = requestCacheStack.top();
        return result;
    }

    public static void withRequestCache(Consumer<RequestCache> handler) {
        RequestCache cache = OpenCmsServlet.getRequestCache();
        if (cache != null) {
            handler.accept(cache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        currentRequestStack.push(req);
        requestCacheStack.push(new RequestCache());
        CmsUUID requestId = new CmsUUID();
        RequestInfo reqInfo = new RequestInfo(req.getRequestURL().toString() + (req.getQueryString() != null ? "?" + req.getQueryString() : ""), System.currentTimeMillis());
        activeRequests.put(requestId, reqInfo);
        try {
            String path;
            int runlevel = OpenCmsCore.getInstance().getRunLevel();
            res.setHeader("Server", OpenCmsCore.getInstance().getSystemInfo().getVersion());
            if (runlevel != 4) {
                if (runlevel == 3) {
                    this.init(this.getServletConfig());
                } else {
                    res.sendError(403);
                    return;
                }
            }
            if ((path = OpenCmsCore.getPathInfo(req)).startsWith(HANDLE_BUILTIN_SERVICE)) {
                String remainder = path.substring(HANDLE_BUILTIN_SERVICE.length() - 1);
                OpenCmsCore.getInstance().invokeBuiltinService(remainder, req, res);
            } else if (path.startsWith(HANDLE_PATH)) {
                this.invokeHandler(req, res);
            } else if (path.endsWith(HANDLE_GWT)) {
                String serviceName = CmsResource.getName(path);
                serviceName = serviceName.substring(0, serviceName.length() - HANDLE_GWT.length());
                OpenCmsCore.getInstance().invokeGwtService(serviceName, req, res, this.getServletConfig());
            } else {
                OpenCmsCore.getInstance().showResource(req, res);
            }
        }
        finally {
            currentRequestStack.pop();
            requestCacheStack.pop().close();
            activeRequests.remove(requestId);
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doGet(req, res);
    }

    @Override
    public String[] getHandlerNames() {
        return HANDLER_NAMES;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void handle(HttpServletRequest req, HttpServletResponse res, String name) throws IOException, ServletException {
        try {
            errorCode = Integer.valueOf(name);
        }
        catch (NumberFormatException nf) {
            res.sendError(403);
            OpenCmsServlet.LOG.debug((Object)"Error parsing handler name.", (Throwable)nf);
            return;
        }
        switch (errorCode) {
            case 404: {
                cms = null;
                exportData = null;
                try {
                    cms = OpenCms.initCmsObject(OpenCms.getDefaultUsers().getUserExport());
                    exportData = OpenCms.getStaticExportManager().getExportData(req, cms);
                }
                catch (CmsException e) {
                    if (!OpenCmsServlet.LOG.isWarnEnabled()) ** GOTO lbl19
                    OpenCmsServlet.LOG.warn((Object)Messages.get().getBundle().key("LOG_INIT_CMSOBJECT_IN_HANDLER_2", name, OpenCmsCore.getPathInfo(req)), (Throwable)e);
                }
lbl19:
                // 3 sources

                if (exportData != null) {
                    try {
                        exportReq = new CmsStaticExportRequest(req, exportData);
                        res.setStatus(OpenCms.getStaticExportManager().export((HttpServletRequest)exportReq, res, cms, exportData));
                    }
                    catch (Throwable t) {
                        if (OpenCmsServlet.LOG.isWarnEnabled()) {
                            OpenCmsServlet.LOG.warn((Object)Messages.get().getBundle().key("LOG_ERROR_EXPORT_1", exportData), t);
                        }
                        this.openErrorHandler(req, res, errorCode);
                    }
                    break;
                }
                this.openErrorHandler(req, res, errorCode);
                break;
            }
            default: {
                this.openErrorHandler(req, res, errorCode);
            }
        }
    }

    public synchronized void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            OpenCmsCore.getInstance().upgradeRunlevel(config.getServletContext());
            OpenCmsCore.getInstance().initServlet(this);
        }
        catch (CmsInitException e) {
            if ("ERR_CRITICAL_INIT_WIZARD_0".equals(e.getMessageContainer().getKey())) {
                if (CmsServletContainerSettings.isServletThrowsException()) {
                    throw new ServletException(e.getMessage());
                }
                LOG.error((Object)Messages.get().getBundle().key("LOG_ERROR_GENERIC_0"), (Throwable)e);
            }
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_ERROR_GENERIC_0"), t);
        }
    }

    protected void invokeHandler(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String pathInfo = OpenCmsCore.getPathInfo(req);
        String name = pathInfo.substring(HANDLE_PATH.length());
        I_CmsRequestHandler handler = OpenCmsCore.getInstance().getRequestHandler(name);
        if (handler == null && name.contains("/")) {
            name = name.substring(0, name.indexOf("/"));
            handler = OpenCmsCore.getInstance().getRequestHandler(name);
        }
        if (handler != null) {
            handler.handle(req, res, name);
        } else {
            LOG.warn((Object)("Invalid request handler call: " + pathInfo));
            this.openErrorHandler(req, res, 500);
        }
    }

    protected void openErrorHandler(HttpServletRequest req, HttpServletResponse res, int errorCode) throws IOException, ServletException {
        CmsObject cms;
        String handlerUri = new StringBuffer(64).append(HANDLE_VFS_PATH).append(errorCode).append(HANDLE_VFS_SUFFIX).toString();
        req.setAttribute("org.opencms.util.CmsErrorCode", (Object)errorCode);
        try {
            cms = OpenCms.initCmsObject(OpenCms.getDefaultUsers().getUserGuest());
            cms.getRequestContext().setSecureRequest(OpenCms.getSiteManager().usesSecureSite(req));
        }
        catch (CmsException e) {
            CmsMessageContainer container = Messages.get().container("LOG_INIT_CMSOBJECT_IN_HANDLER_2", errorCode, handlerUri);
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)org.opencms.jsp.Messages.getLocalizedMessage(container, (ServletRequest)req), (Throwable)e);
            }
            if (!res.isCommitted()) {
                res.sendError(errorCode, e.getLocalizedMessage());
            }
            return;
        }
        try {
            if (!this.tryCustomErrorPage(cms, req, res, errorCode)) {
                cms.getRequestContext().setUri(handlerUri);
                cms.getRequestContext().setSecureRequest(OpenCms.getSiteManager().usesSecureSite(req));
                CmsFile file = cms.readFile(handlerUri, CmsResourceFilter.IGNORE_EXPIRATION);
                OpenCms.getResourceManager().loadResource(cms, file, req, res);
            }
        }
        catch (CmsException e) {
            CmsMessageContainer container = Messages.get().container("ERR_SHOW_ERR_HANDLER_RESOURCE_2", errorCode, handlerUri);
            throw new ServletException(org.opencms.jsp.Messages.getLocalizedMessage(container, (ServletRequest)req), (Throwable)e);
        }
    }

    private boolean loadCustomErrorPage(CmsObject cms, HttpServletRequest req, HttpServletResponse res, String rootPath) {
        try {
            CmsSite errorSite = OpenCms.getSiteManager().getSiteForRootPath(rootPath);
            cms.getRequestContext().setSiteRoot(errorSite.getSiteRoot());
            String relPath = cms.getRequestContext().removeSiteRoot(rootPath);
            if (cms.existsResource(relPath)) {
                cms.getRequestContext().setUri(relPath);
                OpenCms.getResourceManager().loadResource(cms, cms.readResource(relPath), req, res);
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            LOG.error((Object)e.getMessage(), e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryCustomErrorPage(CmsObject cms, HttpServletRequest req, HttpServletResponse res, int errorCode) {
        String siteRoot = OpenCms.getSiteManager().matchRequest(req).getSiteRoot();
        CmsSite site = OpenCms.getSiteManager().getSiteForSiteRoot(siteRoot);
        if (site != null) {
            String currentSiteRoot = cms.getRequestContext().getSiteRoot();
            String currentUri = cms.getRequestContext().getUri();
            try {
                String rootPath;
                if (site.getErrorPage() != null && this.loadCustomErrorPage(cms, req, res, rootPath = site.getErrorPage())) {
                    boolean bl = true;
                    return bl;
                }
                rootPath = CmsStringUtil.joinPaths(siteRoot, "/.errorpages/handle" + errorCode + HANDLE_VFS_SUFFIX);
                if (this.loadCustomErrorPage(cms, req, res, rootPath)) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                cms.getRequestContext().setSiteRoot(currentSiteRoot);
                cms.getRequestContext().setUri(currentUri);
            }
        }
        return false;
    }

    public static class RequestCache {
        private Map<String, CmsADEConfigData> m_configCache = new HashMap<String, CmsADEConfigData>();
        private Map<String, Object> m_attributes = new HashMap<String, Object>();
        private CmsDuplicateRemovingLogBuffer m_logBuffer = new CmsDuplicateRemovingLogBuffer();

        public void addLog(String channel, String level, String message) {
            this.m_logBuffer.add(channel, level, message);
        }

        public void close() {
            this.m_logBuffer.flush();
        }

        public Object getAttribute(String key) {
            return this.m_attributes.get(key);
        }

        public Object getAttribute(String key, Function<String, Object> provider) {
            return this.m_attributes.computeIfAbsent(key, provider);
        }

        public CmsADEConfigData getCachedConfig(String key) {
            return this.m_configCache.get(key);
        }

        public void setAttribute(String key, Object value) {
            this.m_attributes.put(key, value);
        }

        public void setCachedConfig(String key, CmsADEConfigData config) {
            this.m_configCache.put(key, config);
        }
    }

    public static class RequestInfo {
        private long m_startTime;
        private String m_uri;
        private long m_threadId;

        public RequestInfo(String uri, long startTime) {
            this.m_startTime = startTime;
            this.m_uri = uri;
            this.m_threadId = Thread.currentThread().getId();
        }

        public long getStartTime() {
            return this.m_startTime;
        }

        public long getThreadId() {
            return this.m_threadId;
        }

        public String getUri() {
            return this.m_uri;
        }
    }
}

