/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.module;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsExportPoint;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModuleDependency;
import org.opencms.module.CmsModuleVersion;
import org.opencms.module.I_CmsModuleAction;
import org.opencms.module.Messages;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;

public class CmsModule
implements Comparable<CmsModule>,
Serializable {
    public static final long DEFAULT_DATE = 0L;
    private static final Log LOG = CmsLog.getLog(CmsModule.class);
    private static final String MODULE_PROPERTY_ADDITIONAL_RESOURCES = "additionalresources";
    private static final String MODULE_PROPERTY_ADDITIONAL_RESOURCES_SEPARATOR = ";";
    private static final long serialVersionUID = -2639349161445831665L;
    private String m_actionClass;
    private transient I_CmsModuleAction m_actionInstance;
    private String m_authorEmail;
    private String m_authorName;
    private boolean m_autoIncrement;
    private long m_checkpointTime;
    private transient boolean m_createClassesFolder;
    private transient boolean m_createElementsFolder;
    private transient boolean m_createFormattersFolder;
    private transient boolean m_createI18NFolder;
    private transient boolean m_createLibFolder;
    private transient boolean m_createModuleFolder;
    private transient boolean m_createResourcesFolder;
    private transient boolean m_createSchemasFolder;
    private transient boolean m_createTemplateFolder;
    private long m_dateCreated;
    private long m_dateInstalled;
    private List<CmsModuleDependency> m_dependencies;
    private String m_description;
    private List<String> m_excluderesources;
    private List<CmsExplorerTypeSettings> m_explorerTypeSettings;
    private ExportMode m_exportMode;
    private List<CmsExportPoint> m_exportPoints;
    private String m_exportVersion;
    private transient boolean m_frozen;
    private String m_group;
    private boolean m_hasImportSite;
    private String m_importScript;
    private String m_name;
    private String m_niceName;
    private long m_objectCreateTime = System.currentTimeMillis();
    private SortedMap<String, String> m_parameters;
    private List<String> m_resources;
    private transient List<I_CmsResourceType> m_resourceTypes;
    private String m_site;
    private String m_userInstalled;
    private CmsModuleVersion m_version;

    public CmsModule() {
        this.m_version = new CmsModuleVersion("0.1");
        this.m_resources = Collections.emptyList();
        this.m_excluderesources = Collections.emptyList();
        this.m_exportPoints = Collections.emptyList();
        this.m_dependencies = Collections.emptyList();
        this.m_resourceTypes = Collections.emptyList();
        this.m_explorerTypeSettings = Collections.emptyList();
        this.m_parameters = new TreeMap<String, String>();
        this.m_exportMode = ExportMode.DEFAULT;
    }

    public CmsModule(String name, String niceName, String group, String actionClass, String importScript, String site, boolean isImportSite, ExportMode exportMode, String description, CmsModuleVersion version, String authorName, String authorEmail, long dateCreated, String userInstalled, long dateInstalled, List<CmsModuleDependency> dependencies, List<CmsExportPoint> exportPoints, List<String> resources, List<String> excluderesources, Map<String, String> parameters) {
        this.m_name = name;
        this.setNiceName(niceName);
        this.setActionClass(actionClass);
        this.setGroup(group);
        this.m_exportMode = null == exportMode ? ExportMode.DEFAULT : exportMode;
        this.m_description = CmsStringUtil.isEmpty(description) ? "" : description;
        this.m_version = version;
        this.m_authorName = CmsStringUtil.isEmpty(authorName) ? "" : authorName;
        this.m_authorEmail = CmsStringUtil.isEmpty(authorEmail) ? "" : authorEmail;
        this.m_dateCreated = dateCreated / 1000L * 1000L;
        this.m_userInstalled = CmsStringUtil.isEmpty(userInstalled) ? "" : userInstalled;
        this.m_dateInstalled = dateInstalled / 1000L * 1000L;
        this.m_dependencies = dependencies == null ? Collections.emptyList() : Collections.unmodifiableList(dependencies);
        this.m_exportPoints = exportPoints == null ? Collections.emptyList() : Collections.unmodifiableList(exportPoints);
        this.m_resources = resources == null ? Collections.emptyList() : Collections.unmodifiableList(resources);
        this.m_excluderesources = excluderesources == null ? Collections.emptyList() : Collections.unmodifiableList(excluderesources);
        this.m_parameters = parameters == null ? new TreeMap<String, String>() : new TreeMap<String, String>(parameters);
        this.m_site = site;
        this.m_hasImportSite = isImportSite;
        this.m_importScript = importScript;
        this.initOldAdditionalResources();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_MODULE_INSTANCE_CREATED_1", this.m_name));
        }
        this.m_resourceTypes = Collections.emptyList();
        this.m_explorerTypeSettings = Collections.emptyList();
    }

    public static void addCalculatedModuleResources(List<CmsResource> result, CmsObject cms, List<CmsResource> moduleResources, List<String> excludeResources) throws CmsException {
        for (CmsResource resource : moduleResources) {
            String sitePath = cms.getSitePath(resource);
            List<String> excludedSubResources = CmsModule.getExcludedForResource(sitePath, excludeResources);
            if (excludedSubResources.isEmpty()) {
                result.add(resource);
                continue;
            }
            if (CmsStringUtil.comparePaths(sitePath, excludedSubResources.get(0))) continue;
            List<CmsResource> subResources = cms.readResources(sitePath, CmsResourceFilter.ALL, false);
            CmsModule.addCalculatedModuleResources(result, cms, subResources, excludedSubResources);
        }
    }

    public static List<String> calculateModuleResourceNames(CmsObject cms, CmsModule module) throws CmsException {
        CmsObject cmsClone = CmsModule.adjustSiteRootIfNecessary(cms, module);
        List<CmsResource> moduleResources = CmsModule.calculateModuleResources(cmsClone, module);
        ArrayList<String> moduleResouceNames = new ArrayList<String>(moduleResources.size());
        for (CmsResource resource : moduleResources) {
            moduleResouceNames.add(cmsClone.getSitePath(resource));
        }
        return moduleResouceNames;
    }

    public static List<CmsResource> calculateModuleResources(CmsObject cms, CmsModule module) throws CmsException {
        CmsObject cmsClone = CmsModule.adjustSiteRootIfNecessary(cms, module);
        ArrayList<CmsResource> result = null;
        List<String> excluded = CmsFileUtil.removeRedundancies(module.getExcludeResources());
        excluded = CmsModule.removeNonAccessible(cmsClone, excluded);
        List<String> resourceSitePaths = CmsFileUtil.removeRedundancies(module.getResources());
        resourceSitePaths = CmsModule.removeNonAccessible(cmsClone, resourceSitePaths);
        ArrayList<CmsResource> moduleResources = new ArrayList<CmsResource>(resourceSitePaths.size());
        for (String resourceSitePath : resourceSitePaths) {
            CmsResource resource = cmsClone.readResource(resourceSitePath, CmsResourceFilter.IGNORE_EXPIRATION);
            moduleResources.add(resource);
        }
        if (excluded.isEmpty()) {
            result = moduleResources;
        } else {
            result = new ArrayList();
            CmsModule.addCalculatedModuleResources(result, cmsClone, moduleResources, excluded);
        }
        return result;
    }

    private static CmsObject adjustSiteRootIfNecessary(CmsObject cms, CmsModule module) throws CmsException {
        CmsObject cmsClone;
        if (null == module.getSite() || cms.getRequestContext().getSiteRoot().equals(module.getSite())) {
            cmsClone = cms;
        } else {
            cmsClone = OpenCms.initCmsObject(cms);
            cmsClone.getRequestContext().setSiteRoot(module.getSite());
        }
        return cmsClone;
    }

    private static List<String> getExcludedForResource(String sitePath, List<String> excluded) {
        ArrayList<String> result = new ArrayList<String>();
        for (String exclude : excluded) {
            if (!CmsStringUtil.isPrefixPath(sitePath, exclude)) continue;
            result.add(exclude);
        }
        return result;
    }

    private static List<String> removeNonAccessible(CmsObject cms, List<String> sitePaths) {
        ArrayList<String> result = new ArrayList<String>(sitePaths.size());
        for (String sitePath : sitePaths) {
            if (!cms.existsResource(sitePath, CmsResourceFilter.IGNORE_EXPIRATION)) continue;
            result.add(sitePath);
        }
        return result;
    }

    public CmsModuleDependency checkDependency(CmsModule module) {
        CmsModuleDependency otherDepdendency = new CmsModuleDependency(module.getName(), module.getVersion());
        for (int i = 0; i < this.m_dependencies.size(); ++i) {
            CmsModuleDependency dependency = this.m_dependencies.get(i);
            if (!dependency.dependesOn(otherDepdendency)) continue;
            return dependency;
        }
        return null;
    }

    public void checkResources(CmsObject cms) throws CmsIllegalArgumentException {
        CmsFileUtil.checkResources(cms, this.getResources());
    }

    public CmsModule clone() {
        CmsModule result = new CmsModule(this.m_name, this.m_niceName, this.m_group, this.m_actionClass, this.m_importScript, this.m_site, this.m_hasImportSite, this.m_exportMode, this.m_description, this.m_version, this.m_authorName, this.m_authorEmail, this.m_dateCreated, this.m_userInstalled, this.m_dateInstalled, this.m_dependencies, this.m_exportPoints, this.m_resources, this.m_excluderesources, this.m_parameters);
        result.m_frozen = false;
        if (this.getExplorerTypes() != null) {
            ArrayList<CmsExplorerTypeSettings> settings = new ArrayList<CmsExplorerTypeSettings>();
            for (CmsExplorerTypeSettings setting : this.getExplorerTypes()) {
                settings.add((CmsExplorerTypeSettings)setting.clone());
            }
            result.setExplorerTypes(settings);
        }
        if (this.getResourceTypes() != null) {
            result.setResourceTypes(new ArrayList<I_CmsResourceType>(this.getResourceTypes()));
        }
        if (this.getDependencies() != null) {
            ArrayList<CmsModuleDependency> deps = new ArrayList<CmsModuleDependency>();
            for (CmsModuleDependency dep : this.getDependencies()) {
                deps.add((CmsModuleDependency)dep.clone());
            }
            result.setDependencies(new ArrayList<CmsModuleDependency>(this.getDependencies()));
        }
        if (this.getExportPoints() != null) {
            ArrayList<CmsExportPoint> exps = new ArrayList<CmsExportPoint>();
            for (CmsExportPoint exp : this.getExportPoints()) {
                exps.add((CmsExportPoint)exp.clone());
            }
            result.setExportPoints(exps);
        }
        result.setAutoIncrement(this.m_autoIncrement);
        result.setCheckpointTime(this.m_checkpointTime);
        result.setCreateClassesFolder(this.m_createClassesFolder);
        result.setCreateElementsFolder(this.m_createElementsFolder);
        result.setCreateLibFolder(this.m_createLibFolder);
        result.setCreateModuleFolder(this.m_createModuleFolder);
        result.setCreateResourcesFolder(this.m_createResourcesFolder);
        result.setCreateSchemasFolder(this.m_createSchemasFolder);
        result.setCreateTemplateFolder(this.m_createTemplateFolder);
        result.setCreateFormattersFolder(this.m_createFormattersFolder);
        result.setResources(new ArrayList<String>(this.m_resources));
        result.setExcludeResources(new ArrayList<String>(this.m_excluderesources));
        return result;
    }

    @Override
    public int compareTo(CmsModule obj) {
        if (obj == this) {
            return 0;
        }
        return this.m_name.compareTo(obj.m_name);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsModule) {
            return ((CmsModule)obj).m_name.equals(this.m_name);
        }
        return false;
    }

    public String getActionClass() {
        return this.m_actionClass;
    }

    public I_CmsModuleAction getActionInstance() {
        return this.m_actionInstance;
    }

    public String getAuthorEmail() {
        return this.m_authorEmail;
    }

    public String getAuthorName() {
        return this.m_authorName;
    }

    public long getCheckpointTime() {
        return this.m_checkpointTime;
    }

    public String getConfigurationPath() {
        String parameter = this.getParameter("config.sitemap");
        if (parameter != null) {
            return parameter;
        }
        return "/system/modules/" + this.getName() + "/.config";
    }

    public long getDateCreated() {
        return this.m_dateCreated;
    }

    public long getDateInstalled() {
        return this.m_dateInstalled;
    }

    public List<CmsModuleDependency> getDependencies() {
        return this.m_dependencies;
    }

    public String getDescription() {
        return this.m_description;
    }

    public List<String> getExcludeResources() {
        return this.m_excluderesources;
    }

    public List<CmsExplorerTypeSettings> getExplorerTypes() {
        return this.m_explorerTypeSettings;
    }

    public ExportMode getExportMode() {
        return this.m_exportMode;
    }

    public List<CmsExportPoint> getExportPoints() {
        return this.m_exportPoints;
    }

    public String getExportVersion() {
        return this.m_exportVersion;
    }

    public String getGroup() {
        return this.m_group;
    }

    public boolean getHasImportSite() {
        return this.hasImportSite();
    }

    public String getImportScript() {
        return this.m_importScript;
    }

    public String getImportSite() {
        if (this.m_hasImportSite) {
            return this.m_site;
        }
        return null;
    }

    public String getName() {
        return this.m_name;
    }

    public String getNiceName() {
        return this.m_niceName;
    }

    public long getObjectCreateTime() {
        return this.m_objectCreateTime;
    }

    public String getParameter(String key) {
        return (String)this.m_parameters.get(key);
    }

    public String getParameter(String key, String defaultValue) {
        String value = (String)this.m_parameters.get(key);
        return value != null ? value : defaultValue;
    }

    public SortedMap<String, String> getParameters() {
        return this.m_parameters;
    }

    public List<String> getResources() {
        return this.m_resources;
    }

    public List<I_CmsResourceType> getResourceTypes() {
        return this.m_resourceTypes;
    }

    public String getSite() {
        return this.m_site;
    }

    public String getUserInstalled() {
        return this.m_userInstalled;
    }

    public CmsModuleVersion getVersion() {
        return this.m_version;
    }

    public String getVersionStr() {
        return this.m_version.toString();
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    public boolean hasImportSite() {
        return this.m_hasImportSite;
    }

    public boolean hasModuleResourcesWithUndefinedSite() {
        if (this.getSite() == null) {
            for (String modRes : this.getResources()) {
                if (CmsStringUtil.isPrefixPath("/system/", modRes) || OpenCms.getSiteManager().startsWithShared(modRes)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasOnlySystemAndSharedResources() {
        for (String modRes : this.getResources()) {
            if (CmsStringUtil.isPrefixPath("/system/", modRes) || OpenCms.getSiteManager().startsWithShared(modRes)) continue;
            return false;
        }
        return true;
    }

    public boolean isAutoIncrement() {
        return this.m_autoIncrement;
    }

    public boolean isCreateClassesFolder() {
        return this.m_createClassesFolder;
    }

    public boolean isCreateElementsFolder() {
        return this.m_createElementsFolder;
    }

    public boolean isCreateFormattersFolder() {
        return this.m_createFormattersFolder;
    }

    public boolean isCreateI18NFolder() {
        return this.m_createI18NFolder;
    }

    public boolean isCreateLibFolder() {
        return this.m_createLibFolder;
    }

    public boolean isCreateModuleFolder() {
        return this.m_createModuleFolder;
    }

    public boolean isCreateResourcesFolder() {
        return this.m_createResourcesFolder;
    }

    public boolean isCreateSchemasFolder() {
        return this.m_createSchemasFolder;
    }

    public boolean isCreateTemplateFolder() {
        return this.m_createTemplateFolder;
    }

    public boolean isIdentical(CmsModule other) {
        if (!this.isEqual(this.m_name, other.m_name)) {
            return false;
        }
        if (!this.isEqual(this.m_niceName, other.m_niceName)) {
            return false;
        }
        if (!this.isEqual(this.m_version, other.m_version)) {
            return false;
        }
        if (!this.isEqual(this.m_actionClass, other.m_actionClass)) {
            return false;
        }
        if (!this.isEqual(this.m_description, other.m_description)) {
            return false;
        }
        if (!this.isEqual(this.m_authorName, other.m_authorName)) {
            return false;
        }
        if (!this.isEqual(this.m_authorEmail, other.m_authorEmail)) {
            return false;
        }
        return this.m_dateCreated == other.m_dateCreated;
    }

    public boolean isReducedExportMode() {
        return ExportMode.REDUCED.equals((Object)this.m_exportMode);
    }

    public void setActionClass(String value) {
        this.checkFrozen();
        if (CmsStringUtil.isEmpty(value)) {
            this.m_actionClass = null;
        } else {
            if (!CmsStringUtil.isValidJavaClassName(value)) {
                throw new CmsIllegalArgumentException(Messages.get().container("ERR_MODULE_ACTION_CLASS_2", value, this.getName()));
            }
            this.m_actionClass = value;
        }
    }

    public void setAuthorEmail(String value) {
        this.checkFrozen();
        this.m_authorEmail = value.trim();
    }

    public void setAuthorName(String value) {
        this.checkFrozen();
        this.m_authorName = value.trim();
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.m_autoIncrement = autoIncrement;
    }

    public void setCheckpointTime(long checkpointTime) {
        this.m_checkpointTime = checkpointTime;
    }

    public void setCreateClassesFolder(boolean createClassesFolder) {
        this.m_createClassesFolder = createClassesFolder;
    }

    public void setCreateElementsFolder(boolean createElementsFolder) {
        this.m_createElementsFolder = createElementsFolder;
    }

    public void setCreateFormattersFolder(boolean createFormattersFolder) {
        this.m_createFormattersFolder = createFormattersFolder;
    }

    public void setCreateI18NFolder(boolean createI18NFolder) {
        this.m_createI18NFolder = createI18NFolder;
    }

    public void setCreateLibFolder(boolean createLibFolder) {
        this.m_createLibFolder = createLibFolder;
    }

    public void setCreateModuleFolder(boolean createModuleFolder) {
        this.m_createModuleFolder = createModuleFolder;
    }

    public void setCreateResourcesFolder(boolean createResourcesFolder) {
        this.m_createResourcesFolder = createResourcesFolder;
    }

    public void setCreateSchemasFolder(boolean createSchemasFolder) {
        this.m_createSchemasFolder = createSchemasFolder;
    }

    public void setCreateTemplateFolder(boolean createTemplateFolder) {
        this.m_createTemplateFolder = createTemplateFolder;
    }

    public void setDateCreated(long value) {
        this.checkFrozen();
        this.m_dateCreated = value;
    }

    public void setDateInstalled(long value) {
        this.checkFrozen();
        this.m_dateInstalled = value;
    }

    public void setDependencies(List<CmsModuleDependency> dependencies) {
        this.checkFrozen();
        this.m_dependencies = dependencies;
    }

    public void setDescription(String value) {
        this.checkFrozen();
        this.m_description = value.trim();
    }

    public void setExcludeResources(List<String> value) {
        this.checkFrozen();
        this.m_excluderesources = value;
    }

    public void setExplorerTypes(List<CmsExplorerTypeSettings> explorerTypeSettings) {
        this.m_explorerTypeSettings = explorerTypeSettings;
    }

    public void setExportPoints(List<CmsExportPoint> exportPoints) {
        this.m_exportPoints = exportPoints;
    }

    public void setExportVersion(String exportVersion) {
        this.m_exportVersion = exportVersion;
    }

    public void setGroup(String value) {
        this.checkFrozen();
        this.m_group = value;
    }

    public void setHasImportSite(boolean isImportSite) {
        this.checkFrozen();
        this.m_hasImportSite = isImportSite;
    }

    public void setImportScript(String importScript) {
        this.checkFrozen();
        this.m_importScript = importScript;
    }

    public void setImportSite(String importSite) {
        this.checkFrozen();
        if (importSite != null) {
            importSite = importSite.trim();
        }
        this.m_site = importSite;
        this.m_hasImportSite = true;
    }

    public void setName(String value) {
        this.checkFrozen();
        if (!CmsStringUtil.isValidJavaClassName(value)) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_MODULE_NAME_1", value));
        }
        this.m_name = value;
    }

    public void setNiceName(String value) {
        this.checkFrozen();
        this.m_niceName = CmsStringUtil.isEmptyOrWhitespaceOnly(value) ? this.getName() : value.trim();
    }

    public void setParameters(SortedMap<String, String> parameters) {
        this.checkFrozen();
        this.m_parameters = parameters;
    }

    public void setReducedExportMode(boolean reducedExportMode) {
        this.m_exportMode = reducedExportMode ? ExportMode.REDUCED : ExportMode.DEFAULT;
    }

    public void setResources(List<String> value) {
        this.checkFrozen();
        this.m_resources = value;
    }

    public void setResourceTypes(List<I_CmsResourceType> resourceTypes) {
        this.m_resourceTypes = Collections.unmodifiableList(resourceTypes);
    }

    public void setSite(String siteRoot) {
        if (siteRoot == null) {
            this.m_hasImportSite = false;
        }
        this.m_site = siteRoot;
    }

    public void setUserInstalled(String value) {
        this.checkFrozen();
        this.m_userInstalled = value.trim();
    }

    public void setVersionStr(String versionString) {
        this.checkFrozen();
        this.m_version = new CmsModuleVersion(versionString);
    }

    public boolean shouldIncrementVersionBasedOnResources(CmsObject cms) throws CmsException {
        if (this.m_checkpointTime == 0L) {
            return true;
        }
        CmsObject cmsClone = CmsModule.adjustSiteRootIfNecessary(cms, this);
        List<CmsResource> moduleResources = CmsModule.calculateModuleResources(cmsClone, this);
        for (CmsResource resource : moduleResources) {
            try {
                ArrayList resourcesToCheck = Lists.newArrayList();
                resourcesToCheck.add(resource);
                if (resource.isFolder()) {
                    resourcesToCheck.addAll(cms.readResources(resource, CmsResourceFilter.IGNORE_EXPIRATION, true));
                }
                for (CmsResource resourceToCheck : resourcesToCheck) {
                    if (resourceToCheck.getDateLastModified() <= this.m_checkpointTime) continue;
                    return true;
                }
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public String toString() {
        if (this.m_name != null) {
            return "[CmsModule: " + this.m_name + "]";
        }
        return super.toString();
    }

    protected void checkFrozen() throws CmsIllegalArgumentException {
        if (this.m_frozen) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_MODULE_FROZEN_1", this.getName()));
        }
    }

    protected void initialize(CmsObject cms) throws CmsRoleViolationException {
        this.checkFrozen();
        OpenCms.getRoleManager().checkRole(cms, CmsRole.DATABASE_MANAGER);
        this.m_frozen = true;
        this.m_resources = Collections.unmodifiableList(this.m_resources);
        this.m_excluderesources = Collections.unmodifiableList(this.m_excluderesources);
    }

    void setActionInstance(I_CmsModuleAction actionInstance) {
        this.m_actionInstance = actionInstance;
    }

    private void initOldAdditionalResources() {
        TreeMap<String, String> parameters = new TreeMap<String, String>(this.m_parameters);
        ArrayList<String> resources = new ArrayList<String>(this.m_resources);
        String additionalResources = (String)parameters.get(MODULE_PROPERTY_ADDITIONAL_RESOURCES);
        if (additionalResources != null) {
            StringTokenizer tok = new StringTokenizer(additionalResources, MODULE_PROPERTY_ADDITIONAL_RESOURCES_SEPARATOR);
            while (tok.hasMoreTokens()) {
                String resource = tok.nextToken().trim();
                if ("-".equals(resource) || resources.contains(resource)) continue;
                resources.add(resource);
            }
        }
        this.m_resources = resources;
    }

    private boolean isEqual(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static enum ExportMode {
        DEFAULT,
        REDUCED;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

