/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.relations;

import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypePointer;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsExternalLinksValidationResult;
import org.opencms.relations.Messages;
import org.opencms.report.CmsLogReport;
import org.opencms.report.I_CmsReport;
import org.opencms.scheduler.I_CmsScheduledJob;
import org.opencms.util.CmsUriSplitter;

public class CmsExternalLinksValidator
implements I_CmsScheduledJob {
    private I_CmsReport m_report;

    public static boolean checkUrl(CmsObject cms, String check) {
        URI uri = null;
        try {
            uri = new CmsUriSplitter(check, true).toURI();
        }
        catch (URISyntaxException exc) {
            return false;
        }
        try {
            if (!uri.isAbsolute()) {
                return cms.existsResource(cms.getRequestContext().removeSiteRoot(uri.getPath()));
            }
            URL url = uri.toURL();
            if ("http".equals(url.getProtocol())) {
                HttpURLConnection httpcon = (HttpURLConnection)url.openConnection();
                int responseCode = httpcon.getResponseCode();
                return responseCode >= 200 && responseCode < 400;
            }
            return true;
        }
        catch (MalformedURLException mue) {
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public String launch(CmsObject cms, Map<String, String> parameters) throws CmsException {
        if (Boolean.valueOf(parameters.get("writeLog")).booleanValue()) {
            this.m_report = new CmsLogReport(cms.getRequestContext().getLocale(), CmsExternalLinksValidator.class);
        }
        this.validateLinks(cms);
        return "CmsExternLinkValidator.launch(): Links checked.";
    }

    public void setReport(I_CmsReport report) {
        this.m_report = report;
    }

    public void validateLinks(CmsObject cms) throws CmsException {
        if (this.m_report == null) {
            this.m_report = new CmsLogReport(cms.getRequestContext().getLocale(), CmsExternalLinksValidator.class);
        }
        this.m_report.println(Messages.get().container("RPT_VALIDATE_EXTERNAL_LINKS_BEGIN_0"), 2);
        int pointerId = OpenCms.getResourceManager().getResourceType(CmsResourceTypePointer.getStaticTypeName()).getTypeId();
        CmsResourceFilter filter = CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireType(pointerId);
        List<CmsResource> links = cms.readResources("/", filter);
        Iterator<CmsResource> iterator = links.iterator();
        HashMap<String, String> brokenLinks = new HashMap<String, String>();
        int i = 1;
        while (iterator.hasNext()) {
            CmsFile link = cms.readFile(cms.getSitePath(iterator.next()), filter);
            String linkUrl = new String(link.getContents());
            this.m_report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_1", i, links.size()), 3);
            this.m_report.print(Messages.get().container("RPT_VALIDATE_LINK_0"), 3);
            this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", link.getRootPath()));
            this.m_report.print(Messages.get().container("GUI_LINK_POINTING_TO_0"), 3);
            this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", linkUrl));
            this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
            if (!CmsExternalLinksValidator.checkUrl(cms, linkUrl)) {
                brokenLinks.put(link.getRootPath(), linkUrl);
                this.m_report.println(Messages.get().container("RPT_BROKEN_0"), 5);
            } else {
                this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
            }
            ++i;
        }
        this.m_report.println(Messages.get().container("RPT_LINK_VALIDATION_STAT_2", links.size(), brokenLinks.size()), 2);
        this.m_report.println(Messages.get().container("RPT_VALIDATE_EXTERNAL_LINKS_END_0"), 2);
        OpenCms.getLinkManager().setPointerLinkValidationResult(new CmsExternalLinksValidationResult(brokenLinks));
    }
}

