/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.repository;

import com.google.common.cache.CacheBuilder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsObject;
import org.opencms.file.wrapper.CmsObjectWrapper;
import org.opencms.file.wrapper.I_CmsResourceWrapper;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.repository.A_CmsRepository;
import org.opencms.repository.CmsRepositoryManager;
import org.opencms.repository.CmsRepositorySession;
import org.opencms.repository.I_CmsRepositorySession;
import org.opencms.security.CmsRole;
import org.opencms.workplace.CmsWorkplace;

public class CmsRepository
extends A_CmsRepository {
    private static final Log LOG = CmsLog.getLog(CmsRepository.class);
    private static String m_passwordSalt = RandomStringUtils.randomAlphanumeric((int)10);
    private static final String PARAM_WRAPPER = "wrapper";
    private Map<String, CmsObject> m_cmsObjectCache;
    private List<I_CmsResourceWrapper> m_wrappers = new ArrayList<I_CmsResourceWrapper>();

    public CmsRepository() {
        CacheBuilder builder = CacheBuilder.newBuilder().concurrencyLevel(4).expireAfterWrite(30L, TimeUnit.SECONDS);
        this.m_cmsObjectCache = builder.build().asMap();
    }

    private static String getLoginKey(String user, String password) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(user.getBytes("UTF-8"));
            md5.update(new byte[]{0});
            md5.update(password.getBytes("UTF-8"));
            md5.update(new byte[]{0});
            md5.update(m_passwordSalt.getBytes("UTF-8"));
            return Hex.encodeHexString((byte[])md5.digest());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void initConfiguration() throws CmsConfigurationException {
        CmsParameterConfiguration config = this.getConfiguration();
        List<I_CmsResourceWrapper> wrapperObjects = CmsRepositoryManager.createResourceWrappersFromConfiguration(config, PARAM_WRAPPER, LOG);
        this.m_wrappers = Collections.unmodifiableList(wrapperObjects);
        super.initConfiguration();
    }

    @Override
    public void initializeCms(CmsObject cms) {
    }

    @Override
    public I_CmsRepositorySession login(String userName, String password) throws CmsException {
        CmsObject cms;
        String cacheKey = CmsRepository.getLoginKey(userName, password);
        CmsObject origCms = this.m_cmsObjectCache.get(cacheKey);
        String configuredProject = this.getConfiguration().getString("project", null);
        String configuredSite = this.getConfiguration().getString("root", null);
        String roleStr = this.getConfiguration().getString("role", CmsRole.WORKPLACE_USER.getRoleName());
        CmsRole requiredRole = null;
        if (!"any".equals(roleStr)) {
            requiredRole = roleStr.indexOf("/") == -1 ? CmsRole.valueOfRoleName(roleStr).forOrgUnit(null) : CmsRole.valueOfRoleName(roleStr);
        }
        String project = configuredProject;
        String site = configuredSite;
        if (origCms != null) {
            cms = OpenCms.initCmsObject(origCms);
        } else {
            cms = OpenCms.initCmsObject(OpenCms.getDefaultUsers().getUserGuest());
            cms.loginUser(userName, password);
            if (requiredRole != null) {
                OpenCms.getRoleManager().checkRole(cms, requiredRole);
            }
            if (site == null || project == null) {
                CmsUserSettings settings = new CmsUserSettings(cms);
                if (site == null) {
                    site = CmsWorkplace.getStartSiteRoot(cms, settings);
                }
                if (project == null) {
                    project = settings.getStartProject();
                }
            }
            cms.getRequestContext().setSiteRoot(site);
            cms.getRequestContext().setCurrentProject(cms.readProject(project));
            this.m_cmsObjectCache.put(cacheKey, OpenCms.initCmsObject(cms));
        }
        CmsObjectWrapper objWrapper = new CmsObjectWrapper(cms, this.m_wrappers);
        boolean addBOM = this.getConfiguration().getBoolean("addBOM", true);
        objWrapper.setAddByteOrderMark(addBOM);
        cms.getRequestContext().setAttribute("org.opencms.file.wrapper.CmsObjectWrapper", objWrapper);
        return new CmsRepositorySession(objWrapper, this.getFilter(), this.isTranslationEnabled() ? this.getTranslation() : null);
    }
}

