/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.repository;

import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsVfsResourceAlreadyExistsException;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.wrapper.CmsObjectWrapper;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.repository.A_CmsRepositorySession;
import org.opencms.repository.CmsPropertyName;
import org.opencms.repository.CmsRepositoryFilter;
import org.opencms.repository.CmsRepositoryItem;
import org.opencms.repository.CmsRepositoryLockInfo;
import org.opencms.repository.I_CmsRepositoryItem;
import org.opencms.repository.Messages;
import org.opencms.security.CmsSecurityException;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsResourceTranslator;
import org.opencms.util.CmsStringUtil;

public class CmsRepositorySession
extends A_CmsRepositorySession {
    private static final Log LOG = CmsLog.getLog(CmsRepositorySession.class);
    public static final String PROPERTY_NAMESPACE = "http://opencms.org/ns/property";
    public static final String EXTERNAL_PREFIX = "xDAV_";
    private static final BaseEncoding PROPERTY_NS_CODEC = BaseEncoding.base64Url().withPadChar('$');
    private CmsResourceTranslator m_translation;
    private final CmsObjectWrapper m_cms;

    public CmsRepositorySession(CmsObjectWrapper cms, CmsRepositoryFilter filter, CmsResourceTranslator translation) {
        this.m_cms = cms;
        this.setFilter(filter);
        this.m_translation = translation;
    }

    public static String decodeNamespace(String code) throws Exception {
        code = code.replace("~", "_");
        return new String(PROPERTY_NS_CODEC.decode((CharSequence)code), "UTF-8");
    }

    public static String encodeNamespace(String data) throws Exception {
        String s = BaseEncoding.base64Url().withPadChar('$').encode(data.getBytes("UTF-8"));
        s = s.replace('_', '~');
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void copy(String src, String dest, boolean overwrite, boolean shallow) throws CmsException {
        block12: {
            src = this.validatePath(src);
            dest = this.validatePath(dest);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_COPY_ITEM_2", src, dest));
            }
            if (this.exists(dest)) {
                if (overwrite) {
                    CmsResource srcRes = this.m_cms.readResource(src, CmsResourceFilter.DEFAULT);
                    CmsResource destRes = this.m_cms.readResource(dest, CmsResourceFilter.DEFAULT);
                    if (srcRes.isFile() && destRes.isFile()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)Messages.get().getBundle().key("LOG_DELETE_DEST_0"));
                        }
                        this.delete(dest);
                        break block12;
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)Messages.get().getBundle().key("ERR_OVERWRITE_0"));
                        }
                        throw new CmsException(Messages.get().container("ERR_OVERWRITE_0"));
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("ERR_DEST_EXISTS_0"));
                }
                throw new CmsVfsResourceAlreadyExistsException(Messages.get().container("ERR_DEST_EXISTS_0"));
            }
        }
        if (shallow) {
            this.m_cms.getRequestContext().setAttribute("shallow_folder_copy", Boolean.TRUE);
        }
        try {
            this.m_cms.copyResource(src, dest, CmsResource.COPY_PRESERVE_SIBLING);
        }
        finally {
            this.m_cms.getRequestContext().removeAttribute("shallow_folder_copy");
        }
        this.m_cms.unlockResource(dest);
    }

    @Override
    public void create(String path) throws CmsException {
        CmsResource res;
        path = this.validatePath(path);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_CREATE_ITEM_1", path));
        }
        if (!this.m_cms.getLock(res = this.m_cms.createResource(path, 0)).isInherited()) {
            this.m_cms.unlockResource(path);
        }
    }

    @Override
    public void delete(String path) throws CmsException {
        path = this.validatePath(path);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_DELETE_ITEM_1", path));
        }
        CmsRepositoryLockInfo lock = this.getLock(path);
        this.m_cms.lockResource(path);
        this.m_cms.deleteResource(path, CmsResource.DELETE_PRESERVE_SIBLINGS);
        try {
            if (lock == null) {
                this.m_cms.unlockResource(path);
            }
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
    }

    @Override
    public boolean exists(String path) {
        try {
            path = this.validatePath(path);
            return this.m_cms.existsResource(path);
        }
        catch (CmsException ex) {
            return false;
        }
    }

    @Override
    public I_CmsRepositoryItem getItem(String path) throws CmsException {
        path = this.validatePath(path);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_READ_ITEM_1", path));
        }
        CmsResource res = this.m_cms.readResource(path, CmsResourceFilter.DEFAULT);
        CmsRepositoryItem item = new CmsRepositoryItem(res, this.m_cms);
        return item;
    }

    @Override
    public CmsRepositoryLockInfo getLock(String path) {
        try {
            CmsRepositoryLockInfo lockInfo = new CmsRepositoryLockInfo();
            path = this.validatePath(path);
            CmsResource res = this.m_cms.readResource(path, CmsResourceFilter.DEFAULT);
            CmsLock cmsLock = this.m_cms.getLock(res);
            if (!cmsLock.isUnlocked()) {
                lockInfo.setPath(path);
                CmsUser owner = this.m_cms.readUser(cmsLock.getUserId());
                if (owner != null) {
                    lockInfo.setUsername(owner.getName());
                    lockInfo.setOwner(owner.getName() + "||" + owner.getEmail());
                }
                return lockInfo;
            }
            return null;
        }
        catch (CmsException ex) {
            return null;
        }
    }

    @Override
    public Map<CmsPropertyName, String> getProperties(String path) throws CmsException {
        Map<String, CmsProperty> props = this.m_cms.readProperties(path);
        HashMap<CmsPropertyName, String> out = new HashMap<CmsPropertyName, String>();
        for (Map.Entry<String, CmsProperty> entry : props.entrySet()) {
            String outName;
            String name = entry.getKey();
            CmsProperty prop = entry.getValue();
            if (name.startsWith(EXTERNAL_PREFIX)) {
                try {
                    String remainder = name.substring(EXTERNAL_PREFIX.length());
                    int pos = remainder.indexOf("_");
                    String nsEncoded = remainder.substring(0, pos);
                    String actualName = remainder.substring(pos + 1);
                    String ns = CmsRepositorySession.decodeNamespace(nsEncoded);
                    CmsPropertyName pn = new CmsPropertyName(ns, actualName);
                    out.put(pn, prop.getStructureValue());
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                continue;
            }
            if (prop.getStructureValue() != null) {
                outName = name + ".s";
                out.put(new CmsPropertyName(PROPERTY_NAMESPACE, outName), prop.getStructureValue());
            }
            if (prop.getResourceValue() == null) continue;
            outName = name + ".r";
            out.put(new CmsPropertyName(PROPERTY_NAMESPACE, outName), prop.getResourceValue());
        }
        return out;
    }

    @Override
    public List<I_CmsRepositoryItem> list(String path) throws CmsException {
        ArrayList<I_CmsRepositoryItem> ret = new ArrayList<I_CmsRepositoryItem>();
        path = this.validatePath(path);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_LIST_ITEMS_1", path));
        }
        List<CmsResource> resources = this.m_cms.getResourcesInFolder(path, CmsResourceFilter.DEFAULT);
        for (CmsResource res : resources) {
            if (this.isFiltered(this.m_cms.getRequestContext().removeSiteRoot(res.getRootPath()))) continue;
            try {
                CmsResource org = this.m_cms.readResource(res.getStructureId(), CmsResourceFilter.DEFAULT);
                if (this.isFiltered(this.m_cms.getRequestContext().removeSiteRoot(org.getRootPath()))) continue;
                ret.add(new CmsRepositoryItem(res, this.m_cms));
            }
            catch (CmsVfsResourceNotFoundException e) {
                ret.add(new CmsRepositoryItem(res, this.m_cms));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_LIST_ITEMS_SUCESS_1", ret.size()));
        }
        return ret;
    }

    @Override
    public boolean lock(String path, CmsRepositoryLockInfo lock) throws CmsException {
        path = this.validatePath(path);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_LOCK_ITEM_1", path));
        }
        this.m_cms.lockResource(path);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void move(String src, String dest, boolean overwrite) throws CmsException {
        block8: {
            src = this.validatePath(src);
            dest = this.validatePath(dest);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_MOVE_ITEM_2", src, dest));
            }
            if (this.exists(dest)) {
                if (overwrite) {
                    CmsResource srcRes = this.m_cms.readResource(src, CmsResourceFilter.DEFAULT);
                    CmsResource destRes = this.m_cms.readResource(dest, CmsResourceFilter.DEFAULT);
                    if (srcRes.isFile() && destRes.isFile()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)Messages.get().getBundle().key("LOG_DELETE_DEST_0"));
                        }
                        this.delete(dest);
                        break block8;
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)Messages.get().getBundle().key("ERR_OVERWRITE_0"));
                        }
                        throw new CmsException(Messages.get().container("ERR_OVERWRITE_0"));
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("ERR_DEST_EXISTS_0"));
                }
                throw new CmsVfsResourceAlreadyExistsException(Messages.get().container("ERR_DEST_EXISTS_0"));
            }
        }
        this.m_cms.lockResource(src);
        this.m_cms.moveResource(src, dest);
        this.m_cms.unlockResource(dest);
    }

    @Override
    public void save(String path, InputStream inputStream, boolean overwrite) throws CmsException, IOException {
        block8: {
            path = this.validatePath(path);
            byte[] content = CmsFileUtil.readFully(inputStream);
            try {
                CmsFile file = this.m_cms.readFile(path, CmsResourceFilter.DEFAULT);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_UPDATE_ITEM_1", path));
                }
                if (overwrite) {
                    file.setContents(content);
                    CmsLock lock = this.m_cms.getLock(file);
                    if (!lock.isInherited()) {
                        this.m_cms.lockResource(path);
                    }
                    this.m_cms.writeFile(file);
                    if (lock.isNullLock()) {
                        this.m_cms.unlockResource(path);
                    }
                    break block8;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("ERR_DEST_EXISTS_0"));
                }
                throw new CmsVfsResourceAlreadyExistsException(Messages.get().container("ERR_DEST_EXISTS_0"));
            }
            catch (CmsVfsResourceNotFoundException ex) {
                int type;
                CmsResource res;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_CREATE_ITEM_1", path));
                }
                if (this.m_cms.getLock(res = this.m_cms.createResource(path, type = OpenCms.getResourceManager().getDefaultTypeForName(path).getTypeId(), content, null)).isInherited()) break block8;
                this.m_cms.unlockResource(path);
            }
        }
    }

    @Override
    public void unlock(String path) {
        block3: {
            try {
                path = this.validatePath(path);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_UNLOCK_ITEM_1", path));
                }
                this.m_cms.unlockResource(path);
            }
            catch (CmsException ex) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)Messages.get().getBundle().key("ERR_UNLOCK_FAILED_0"), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateProperties(String path, Map<CmsPropertyName, String> properties) throws CmsException {
        HashMap<String, CmsProperty> propsToWrite = new HashMap<String, CmsProperty>();
        for (Map.Entry<CmsPropertyName, String> entry : properties.entrySet()) {
            CmsProperty prop;
            CmsPropertyName pn = entry.getKey();
            String value = entry.getValue();
            if (pn.getNamespace().equals(PROPERTY_NAMESPACE)) {
                String baseName = pn.getName().substring(0, pn.getName().length() - 2);
                if (!propsToWrite.containsKey(baseName)) {
                    prop = new CmsProperty(baseName, null, null);
                    propsToWrite.put(baseName, prop);
                }
                prop = (CmsProperty)propsToWrite.get(baseName);
                if (pn.getName().endsWith(".s")) {
                    prop.setStructureValue(value);
                    continue;
                }
                if (pn.getName().endsWith(".r")) {
                    prop.setResourceValue(value);
                    continue;
                }
                LOG.error((Object)"Invalid name for repository property, must end with .s or .r");
                continue;
            }
            try {
                String propName = EXTERNAL_PREFIX + CmsRepositorySession.encodeNamespace(pn.getNamespace()) + "_" + pn.getName();
                prop = new CmsProperty(propName, value, null);
                propsToWrite.put(propName, prop);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        boolean needUnlock = false;
        if (null == this.getLock(path)) {
            this.m_cms.lockResource(path);
            needUnlock = true;
        }
        try {
            LOG.debug((Object)("Writing properties: " + propsToWrite));
            this.m_cms.writeProperties(path, propsToWrite);
        }
        finally {
            if (needUnlock) {
                this.m_cms.unlockResource(path);
            }
        }
    }

    @Override
    protected boolean isFiltered(String name) {
        boolean ret = super.isFiltered(this.m_cms.getRequestContext().addSiteRoot(name));
        if (ret && LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("ERR_ITEM_FILTERED_1", name));
        }
        return ret;
    }

    private CmsResourceTranslator getEffectiveResourceTranslator() {
        if (this.m_translation != null) {
            return this.m_translation;
        }
        return this.m_cms.getRequestContext().getFileTranslator();
    }

    private String validatePath(String path) throws CmsSecurityException {
        CmsResourceTranslator translator = this.getEffectiveResourceTranslator();
        String ret = CmsStringUtil.translatePathComponents(translator, path);
        if ("/system".equals(ret)) {
            ret = ret.concat("/");
        }
        if (this.isFiltered(ret)) {
            throw new CmsSecurityException(Messages.get().container("ERR_ITEM_FILTERED_1", path));
        }
        return ret;
    }
}

