/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.scheduler;

import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.scheduler.CmsSchedulerThread;
import org.opencms.scheduler.Messages;
import org.quartz.SchedulerConfigException;
import org.quartz.spi.ThreadPool;

public class CmsSchedulerThreadPool
implements ThreadPool {
    private static final Log LOG = CmsLog.getLog(CmsSchedulerThreadPool.class);
    private int m_currentThreadCount;
    private boolean m_inheritGroup = true;
    private boolean m_inheritLoader = true;
    private int m_initialThreadCount;
    private boolean m_isShutdown;
    private boolean m_makeThreadsDaemons = true;
    private int m_maxThreadCount;
    private Runnable m_nextRunnable;
    private Object m_nextRunnableLock = new Object();
    private ThreadGroup m_threadGroup;
    private String m_threadNamePrefix = "OpenCms: Scheduler Thread ";
    private int m_threadPriority;
    private CmsSchedulerThread[] m_workers;
    private String schedulerInstanceName;
    private String schedulerInstanceId;

    public CmsSchedulerThreadPool() {
        this(0, 10, 5);
    }

    public CmsSchedulerThreadPool(int initialThreadCount, int maxThreadCount, int threadPriority) {
        this.m_initialThreadCount = initialThreadCount;
        this.m_currentThreadCount = 0;
        this.m_maxThreadCount = maxThreadCount;
        this.m_threadPriority = threadPriority;
    }

    public int blockForAvailableThreads() {
        return 1;
    }

    public int getPoolSize() {
        return this.m_currentThreadCount;
    }

    public int getThreadPriority() {
        return this.m_threadPriority;
    }

    public void initialize() throws SchedulerConfigException {
        if (this.m_maxThreadCount <= 0 || this.m_maxThreadCount > 200) {
            throw new SchedulerConfigException(Messages.get().getBundle().key("ERR_MAX_THREAD_COUNT_BOUNDS_0"));
        }
        if (this.m_initialThreadCount < 0 || this.m_initialThreadCount > this.m_maxThreadCount) {
            throw new SchedulerConfigException(Messages.get().getBundle().key("ERR_INIT_THREAD_COUNT_BOUNDS_0"));
        }
        if (this.m_threadPriority <= 0 || this.m_threadPriority > 9) {
            throw new SchedulerConfigException(Messages.get().getBundle().key("ERR_SCHEDULER_PRIORITY_BOUNDS_0"));
        }
        if (this.m_inheritGroup) {
            this.m_threadGroup = Thread.currentThread().getThreadGroup();
        } else {
            ThreadGroup parent = this.m_threadGroup = Thread.currentThread().getThreadGroup();
            while (!parent.getName().equals("main")) {
                this.m_threadGroup = parent;
                parent = this.m_threadGroup.getParent();
            }
            this.m_threadGroup = new ThreadGroup(parent, this.getClass().getName());
        }
        if (this.m_inheritLoader) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_USING_THREAD_CLASSLOADER_1", Thread.currentThread().getName()));
        }
        this.m_workers = new CmsSchedulerThread[this.m_maxThreadCount];
        for (int i = 0; i < this.m_initialThreadCount; ++i) {
            this.growThreadPool();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runInThread(Runnable runnable) {
        boolean hasNextRunnable;
        if (runnable == null) {
            return false;
        }
        if (this.m_isShutdown) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_THREAD_POOL_UNAVAILABLE_0"));
            return false;
        }
        Object object = this.m_nextRunnableLock;
        synchronized (object) {
            hasNextRunnable = this.m_nextRunnable != null;
        }
        if (hasNextRunnable || this.m_currentThreadCount == 0) {
            this.growThreadPool();
        }
        object = this.m_nextRunnableLock;
        synchronized (object) {
            while (this.m_nextRunnable != null && !this.m_isShutdown) {
                try {
                    this.m_nextRunnableLock.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.m_isShutdown) {
                this.m_nextRunnable = runnable;
                this.m_nextRunnableLock.notifyAll();
            }
        }
        if (this.m_isShutdown) {
            CmsSchedulerThread thread = new CmsSchedulerThread(this, this.m_threadGroup, this.m_threadNamePrefix + "(final)", this.m_threadPriority, false, runnable);
            thread.start();
        }
        return true;
    }

    public void shutdown() {
        this.shutdown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean waitForJobsToComplete) {
        this.m_isShutdown = true;
        for (int i = 0; i < this.m_currentThreadCount; ++i) {
            if (this.m_workers[i] == null) continue;
            this.m_workers[i].shutdown();
        }
        Object i = this.m_nextRunnableLock;
        synchronized (i) {
            this.m_nextRunnableLock.notifyAll();
        }
        if (waitForJobsToComplete) {
            int alive = this.m_currentThreadCount;
            while (alive > 0) {
                alive = 0;
                for (int i2 = 0; i2 < this.m_currentThreadCount; ++i2) {
                    if (!this.m_workers[i2].isAlive()) continue;
                    try {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)Messages.get().getBundle().key("LOG_THREAD_POOL_WAITING_1", i2));
                        }
                        ++alive;
                        this.m_workers[i2].join(200L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            int activeCount = this.m_threadGroup.activeCount();
            if (activeCount > 0 && LOG.isInfoEnabled()) {
                LOG.info((Object)Messages.get().getBundle().key("LOG_THREAD_POOL_STILL_ACTIVE_1", activeCount));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_THREAD_POOL_SHUTDOWN_0"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Runnable getNextRunnable() throws InterruptedException {
        Runnable toRun = null;
        Object object = this.m_nextRunnableLock;
        synchronized (object) {
            if (this.m_nextRunnable == null) {
                this.m_nextRunnableLock.wait(1000L);
            }
            if (this.m_nextRunnable != null) {
                toRun = this.m_nextRunnable;
                this.m_nextRunnable = null;
                this.m_nextRunnableLock.notifyAll();
            }
        }
        return toRun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void growThreadPool() {
        if (this.m_currentThreadCount < this.m_maxThreadCount) {
            Object object = this.m_nextRunnableLock;
            synchronized (object) {
                this.m_workers[this.m_currentThreadCount] = new CmsSchedulerThread(this, this.m_threadGroup, this.m_threadNamePrefix + this.m_currentThreadCount, this.m_threadPriority, this.m_makeThreadsDaemons);
                this.m_workers[this.m_currentThreadCount].start();
                if (this.m_inheritLoader) {
                    this.m_workers[this.m_currentThreadCount].setContextClassLoader(Thread.currentThread().getContextClassLoader());
                }
                ++this.m_currentThreadCount;
                this.m_nextRunnableLock.notifyAll();
            }
        }
    }

    public void setInstanceId(String schedInstId) {
        this.schedulerInstanceId = schedInstId;
    }

    public void setInstanceName(String schedName) {
        this.schedulerInstanceName = schedName;
    }
}

