/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.scheduler.jobs;

import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.main.OpenCms;
import org.opencms.scheduler.I_CmsScheduledJob;
import org.opencms.util.CmsStringUtil;

public class CmsUnsubscribeDeletedResourcesJob
implements I_CmsScheduledJob {
    public static final String PARAM_DELETEDDAYS = "deleteddays";
    private static final long MILLIS_PER_DAY = 86400000L;

    @Override
    public String launch(CmsObject cms, Map<String, String> parameters) throws Exception {
        int deletedDays = 30;
        String deleteddaysParam = parameters.get(PARAM_DELETEDDAYS);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(deleteddaysParam)) {
            try {
                deletedDays = Integer.parseInt(deleteddaysParam);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        long deletedTo = System.currentTimeMillis() - 86400000L * (long)deletedDays;
        OpenCms.getSubscriptionManager().unsubscribeAllDeletedResources(cms, deletedTo);
        return null;
    }
}

