/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.I_CmsReport;
import org.opencms.search.CmsIndexException;
import org.opencms.search.CmsSearchException;
import org.opencms.search.CmsSearchIndexSource;
import org.opencms.search.I_CmsIndexWriter;
import org.opencms.search.I_CmsSearchIndex;
import org.opencms.search.Messages;
import org.opencms.search.documents.I_CmsDocumentFactory;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.search.fields.I_CmsSearchFieldConfiguration;
import org.opencms.util.CmsStringUtil;

public abstract class A_CmsSearchIndex
implements I_CmsSearchIndex {
    public static final String PROPERTY_SEARCH_EXCLUDE_VALUE_ALL = "all";
    public static final String PROPERTY_SEARCH_EXCLUDE_VALUE_GALLERY = "gallery";
    public static final String USE_ALL_LOCALE = "all";
    private static final Log LOG = CmsLog.getLog(A_CmsSearchIndex.class);
    private static final long serialVersionUID = 5831386499514765251L;
    private Map<String, List<String>> m_documenttypes;
    private boolean m_enabled = true;
    private boolean m_extractContent = true;
    private I_CmsSearchFieldConfiguration m_fieldConfiguration;
    private String m_fieldConfigurationName;
    private transient I_CmsIndexWriter m_indexWriter;
    private boolean m_languageDetection;
    private Locale m_locale;
    private String m_name;
    private String m_path;
    private String m_project;
    private String m_rebuild;
    private List<String> m_sourceNames = new ArrayList<String>();
    private List<CmsSearchIndexSource> m_sources;

    public A_CmsSearchIndex() {
        this.m_documenttypes = new HashMap<String, List<String>>();
    }

    public A_CmsSearchIndex(String name) throws CmsIllegalArgumentException {
        this();
        this.setName(name);
    }

    @Override
    public void addConfigurationParameter(String key, String value) {
    }

    @Override
    public void addSourceName(String sourceName) {
        this.m_sourceNames.add(sourceName);
    }

    @Override
    public boolean checkConfiguration(CmsObject cms) {
        if (this.isEnabled()) {
            try {
                cms.readProject(this.getProject());
                this.setEnabled(true);
            }
            catch (CmsException e) {
                this.setEnabled(false);
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_SEARCHINDEX_CREATE_BAD_PROJECT_2", this.getProject(), this.getName()));
                }
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_SEARCHINDEX_DISABLED_1", this.getName()));
        }
        return this.isEnabled();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (null != obj && this.getClass().getName().equals(obj.getClass().getName())) {
            return ((I_CmsSearchIndex)obj).getName().equals(this.m_name);
        }
        return false;
    }

    @Override
    public boolean excludeFromIndex(CmsObject cms, CmsResource resource) {
        boolean excludeFromIndex;
        block5: {
            excludeFromIndex = false;
            if (resource.isInternal() || resource.isFolder() || resource.isTemporaryFile() || resource.getDateExpired() <= System.currentTimeMillis()) {
                return true;
            }
            try {
                String propValue = cms.readPropertyObject(resource, "search.exclude", true).getValue();
                excludeFromIndex = Boolean.valueOf(propValue);
                if (!excludeFromIndex && propValue != null) {
                    excludeFromIndex = "all".equalsIgnoreCase(propValue.trim());
                }
            }
            catch (CmsException e) {
                if (!LOG.isDebugEnabled()) break block5;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_UNABLE_TO_READ_PROPERTY_1", resource.getRootPath()));
            }
        }
        if (!excludeFromIndex && !"all".equalsIgnoreCase(this.getLocale().getLanguage())) {
            List<Locale> locales = OpenCms.getLocaleManager().getDefaultLocales(cms, resource);
            Locale match = OpenCms.getLocaleManager().getFirstMatchingLocale(Collections.singletonList(this.getLocale()), locales);
            excludeFromIndex = match == null;
        }
        return excludeFromIndex;
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        return new CmsParameterConfiguration();
    }

    @Override
    public I_CmsExtractionResult getContentIfUnchanged(CmsResource resource) {
        return null;
    }

    @Override
    public I_CmsDocumentFactory getDocumentFactory(CmsResource res) {
        if (res != null && this.getSources() != null) {
            List<String> documentTypeKeys = OpenCms.getSearchManager().getDocumentTypeKeys(res);
            for (String documentTypeKey : documentTypeKeys) {
                for (CmsSearchIndexSource source : this.getSources()) {
                    if (!source.isIndexing(res.getRootPath(), documentTypeKey)) continue;
                    return source.getDocumentFactory(documentTypeKey);
                }
            }
        }
        return null;
    }

    @Override
    public I_CmsSearchFieldConfiguration getFieldConfiguration() {
        return this.m_fieldConfiguration;
    }

    @Override
    public String getFieldConfigurationName() {
        return this.m_fieldConfigurationName;
    }

    @Override
    public I_CmsIndexWriter getIndexWriter(I_CmsReport report, boolean create) throws CmsIndexException {
        if (this.m_indexWriter != null) {
            if (!create) {
                return this.m_indexWriter;
            }
            try {
                this.m_indexWriter.close();
                this.m_indexWriter = null;
            }
            catch (IOException e) {
                throw new CmsIndexException(Messages.get().container("LOG_IO_INDEX_WRITER_CLOSE_2", this.getPath(), this.getName()), (Throwable)e);
            }
        }
        I_CmsIndexWriter indexWriter = this.createIndexWriter(create, report);
        if (!create) {
            this.m_indexWriter = indexWriter;
        }
        return indexWriter;
    }

    @Override
    public Locale getLocale() {
        return this.m_locale;
    }

    @Override
    public Locale getLocaleForResource(CmsObject cms, CmsResource resource, List<Locale> availableLocales) {
        Locale result = null;
        List<Locale> defaultLocales = OpenCms.getLocaleManager().getDefaultLocales(cms, resource);
        if (availableLocales != null && availableLocales.size() > 0) {
            result = OpenCms.getLocaleManager().getBestMatchingLocale(defaultLocales.get(0), defaultLocales, availableLocales);
        }
        if (result == null) {
            result = availableLocales != null && availableLocales.isEmpty() ? availableLocales.get(0) : defaultLocales.get(0);
        }
        return result;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getPath() {
        return this.m_path;
    }

    @Override
    public String getProject() {
        return this.m_project;
    }

    @Override
    public String getRebuildMode() {
        return this.m_rebuild;
    }

    @Override
    public List<String> getSourceNames() {
        return this.m_sourceNames;
    }

    @Override
    public List<CmsSearchIndexSource> getSources() {
        return this.m_sources;
    }

    public int hashCode() {
        return this.m_name != null ? this.m_name.hashCode() : 0;
    }

    @Override
    public void initConfiguration() {
    }

    @Override
    public void initialize() throws CmsSearchException {
        if (!this.isEnabled()) {
            return;
        }
        String sourceName = null;
        CmsSearchIndexSource indexSource = null;
        List<String> searchIndexSourceDocumentTypes = null;
        List<String> resourceNames = null;
        String resourceName = null;
        this.m_sources = new ArrayList<CmsSearchIndexSource>();
        this.m_path = this.getPath();
        int n = this.m_sourceNames.size();
        for (int i = 0; i < n; ++i) {
            try {
                sourceName = this.m_sourceNames.get(i);
                indexSource = OpenCms.getSearchManager().getIndexSource(sourceName);
                this.m_sources.add(indexSource);
                resourceNames = indexSource.getResourcesNames();
                searchIndexSourceDocumentTypes = indexSource.getDocumentTypes();
                int m = resourceNames.size();
                for (int j = 0; j < m; ++j) {
                    resourceName = resourceNames.get(j);
                    this.m_documenttypes.put(resourceName, searchIndexSourceDocumentTypes);
                }
                continue;
            }
            catch (Exception e) {
                this.setEnabled(false);
                throw new CmsSearchException(Messages.get().container("ERR_INDEX_SOURCE_ASSOCIATION_1", sourceName), (Throwable)e);
            }
        }
        if (this.m_fieldConfigurationName == null) {
            this.m_fieldConfigurationName = "standard";
        }
        this.m_fieldConfiguration = OpenCms.getSearchManager().getFieldConfiguration(this.m_fieldConfigurationName);
        if (this.m_fieldConfiguration == null) {
            throw new CmsSearchException(Messages.get().container("ERR_FIELD_CONFIGURATION_UNKNOWN_2", this.m_name, this.m_fieldConfigurationName));
        }
        this.onIndexChanged(true);
    }

    @Override
    public boolean isEnabled() {
        return this.m_enabled;
    }

    @Override
    public boolean isExtractingContent() {
        return this.m_extractContent;
    }

    @Override
    public boolean isInitialized() {
        return this.m_sources != null;
    }

    @Override
    public boolean isLanguageDetection() {
        return this.m_languageDetection;
    }

    @Override
    public boolean isUpdatedIncremental() {
        return this.m_indexWriter != null;
    }

    @Override
    public void onIndexChanged(boolean force) {
    }

    @Override
    public void removeSourceName(String sourceName) {
        Iterator<CmsSearchIndexSource> it = this.m_sources.iterator();
        while (it.hasNext()) {
            if (!Objects.equals(it.next().getName(), sourceName)) continue;
            it.remove();
        }
        this.m_sourceNames.remove(sourceName);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    public void setFieldConfiguration(I_CmsSearchFieldConfiguration fieldConfiguration) {
        this.m_fieldConfiguration = fieldConfiguration;
    }

    @Override
    public void setFieldConfigurationName(String fieldConfigurationName) {
        this.m_fieldConfigurationName = fieldConfigurationName;
    }

    public void setLanguageDetection(boolean languageDetection) {
        this.m_languageDetection = languageDetection;
    }

    @Override
    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    @Override
    public void setLocaleString(String locale) {
        this.setLocale(CmsLocaleManager.getLocale(locale));
    }

    @Override
    public void setName(String name) throws CmsIllegalArgumentException {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(name)) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_SEARCHINDEX_CREATE_MISSING_NAME_0"));
        }
        if (!name.equals(this.m_name) && OpenCms.getRunLevel() > 2) {
            Iterator<String> itIdxNames = OpenCms.getSearchManager().getIndexNames().iterator();
            while (itIdxNames.hasNext()) {
                if (!itIdxNames.next().equals(name)) continue;
                throw new CmsIllegalArgumentException(Messages.get().container("ERR_SEARCHINDEX_CREATE_INVALID_NAME_1", name));
            }
        }
        this.m_name = name;
    }

    public void setPath(String path) {
        this.m_path = path;
    }

    @Override
    public void setProject(String project) {
        this.m_project = project;
    }

    @Override
    public void setRebuildMode(String rebuildMode) {
        this.m_rebuild = rebuildMode;
    }

    @Override
    public void shutDown() {
        if (this.m_indexWriter != null) {
            try {
                this.m_indexWriter.commit();
                this.m_indexWriter.close();
            }
            catch (IOException e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_IO_INDEX_WRITER_CLOSE_2", this.getPath(), this.getName()), (Throwable)e);
            }
        }
    }

    protected abstract I_CmsIndexWriter createIndexWriter(boolean var1, I_CmsReport var2) throws CmsIndexException;

    protected boolean isIndexing(CmsResource res) {
        return this.getDocumentFactory(res) != null;
    }

    protected void setExtractContent(boolean extract) {
        this.m_extractContent = extract;
    }

    protected void setIndexWriter(I_CmsIndexWriter writer) {
        this.m_indexWriter = writer;
    }
}

