/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.solr.uninverting.UninvertingReader;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.I_CmsReport;
import org.opencms.search.A_CmsSearchIndex;
import org.opencms.search.CmsIndexException;
import org.opencms.search.CmsLuceneDocument;
import org.opencms.search.CmsLuceneIndexWriter;
import org.opencms.search.CmsSearchCategoryCollector;
import org.opencms.search.CmsSearchException;
import org.opencms.search.CmsSearchParameters;
import org.opencms.search.CmsSearchResult;
import org.opencms.search.CmsSearchResultList;
import org.opencms.search.CmsSearchSimilarity;
import org.opencms.search.I_CmsIndexWriter;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.search.Messages;
import org.opencms.search.documents.I_CmsTermHighlighter;
import org.opencms.search.extractors.CmsExtractionResult;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.search.fields.CmsLuceneFieldConfiguration;
import org.opencms.search.fields.CmsSearchField;
import org.opencms.search.fields.CmsSearchFieldConfiguration;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;

public class CmsSearchIndex
extends A_CmsSearchIndex {
    public static final String A_PARAM_PREFIX = "org.opencms.search.CmsSearchIndex";
    public static final String BACKUP_REINDEXING = "org.opencms.search.CmsSearchIndex.useBackupReindexing";
    public static final String[] DATES = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"};
    public static final String[] DOC_META_FIELDS = new String[]{"meta", "content"};
    public static final String EXCERPT = "org.opencms.search.CmsSearchIndex.createExcerpt";
    public static final String EXTRACT_CONTENT = "org.opencms.search.CmsSearchIndex.extractContent";
    public static final String IGNORE_EXPIRATION = "org.opencms.search.CmsSearchIndex.ignoreExpiration";
    public static final String LANGUAGEDETECTION = "search.solr.useLanguageDetection";
    public static final String LUCENE_AUTO_COMMIT = "lucene.AutoCommit";
    public static final String LUCENE_RAM_BUFFER_SIZE_MB = "lucene.RAMBufferSizeMB";
    public static final String MAX_HITS = "org.opencms.search.CmsSearchIndex.maxHits";
    public static final int MAX_HITS_DEFAULT = 5000;
    public static final int MAX_YEAR_RANGE = 25;
    public static final String PERMISSIONS = "org.opencms.search.CmsSearchIndex.checkPermissions";
    public static final String PRIORITY = "org.opencms.search.CmsSearchIndex.priority";
    public static final String TIME_RANGE = "org.opencms.search.CmsSearchIndex.checkTimeRange";
    protected static final StoredFieldVisitor VISITOR = new StoredFieldVisitor(){

        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) {
            return !CmsSearchFieldConfiguration.LAZY_FIELDS.contains(fieldInfo.name) ? StoredFieldVisitor.Status.YES : StoredFieldVisitor.Status.NO;
        }
    };
    private static final Log LOG = CmsLog.getLog(CmsSearchIndex.class);
    private static final long serialVersionUID = 8461682478204452718L;
    private transient Analyzer m_analyzer;
    private boolean m_backupReindexing;
    private boolean m_checkPermissions = true;
    private boolean m_checkTimeRange = false;
    private boolean m_createExcerpt = true;
    private transient Map<String, Query> m_displayFilters;
    private boolean m_ignoreExpiration;
    private transient IndexSearcher m_indexSearcher;
    private Double m_luceneRAMBufferSizeMB;
    private int m_maxHits = 5000;
    private int m_priority = -1;
    private boolean m_requireViewPermission;
    private final transient Similarity m_sim = new CmsSearchSimilarity();

    public CmsSearchIndex() {
    }

    public CmsSearchIndex(String name) throws CmsIllegalArgumentException {
        this();
        this.setName(name);
    }

    public static List<String> getDateRangeSpan(long startDate, long endDate) {
        if (startDate > endDate) {
            long temp = endDate;
            endDate = startDate;
            startDate = temp;
        }
        ArrayList<String> result = new ArrayList<String>(100);
        Calendar calStart = Calendar.getInstance(OpenCms.getLocaleManager().getTimeZone());
        Calendar calEnd = Calendar.getInstance(calStart.getTimeZone());
        calStart.setTimeInMillis(startDate);
        calEnd.setTimeInMillis(endDate);
        int startDay = calStart.get(5);
        int endDay = calEnd.get(5);
        int maxDayInStartMonth = calStart.getActualMaximum(5);
        int startMonth = calStart.get(2) + 1;
        int endMonth = calEnd.get(2) + 1;
        int startYear = calStart.get(1);
        int endYear = calEnd.get(1);
        result.addAll(CmsSearchIndex.getYearSpan(startYear + 1, endYear - 1));
        if (startYear != endYear) {
            result.addAll(CmsSearchIndex.getMonthSpan(startMonth + 1, 12, startYear));
            result.addAll(CmsSearchIndex.getMonthSpan(1, endMonth - 1, endYear));
            result.addAll(CmsSearchIndex.getDaySpan(startDay, maxDayInStartMonth, startMonth, startYear));
            result.addAll(CmsSearchIndex.getDaySpan(1, endDay, endMonth, endYear));
        } else if (startMonth != endMonth) {
            result.addAll(CmsSearchIndex.getMonthSpan(startMonth + 1, endMonth - 1, startYear));
            result.addAll(CmsSearchIndex.getDaySpan(startDay, maxDayInStartMonth, startMonth, startYear));
            result.addAll(CmsSearchIndex.getDaySpan(1, endDay, endMonth, endYear));
        } else {
            result.addAll(CmsSearchIndex.getDaySpan(startDay, endDay, endMonth, endYear));
        }
        Collections.sort(result);
        return result;
    }

    private static List<String> getDaySpan(int startDay, int endDay, int month, int year) {
        ArrayList<String> result = new ArrayList<String>();
        String yearMonthStr = String.valueOf(year) + DATES[month];
        for (int i = startDay; i <= endDay; ++i) {
            String dateStr = yearMonthStr + DATES[i];
            result.add(dateStr);
        }
        return result;
    }

    private static List<String> getMonthSpan(int startMonth, int endMonth, int year) {
        ArrayList<String> result = new ArrayList<String>();
        String yearStr = String.valueOf(year);
        for (int i = startMonth; i <= endMonth; ++i) {
            String dateStr = yearStr + DATES[i];
            result.add(dateStr);
        }
        return result;
    }

    private static List<String> getYearSpan(int startYear, int endYear) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = startYear; i <= endYear; ++i) {
            String dateStr = String.valueOf(i);
            result.add(dateStr);
        }
        return result;
    }

    @Override
    public void addConfigurationParameter(String key, String value) {
        if (PERMISSIONS.equals(key)) {
            this.m_checkPermissions = Boolean.valueOf(value);
        } else if (EXTRACT_CONTENT.equals(key)) {
            this.setExtractContent(Boolean.valueOf(value));
        } else if (BACKUP_REINDEXING.equals(key)) {
            this.m_backupReindexing = Boolean.valueOf(value);
        } else if (LANGUAGEDETECTION.equals(key)) {
            this.setLanguageDetection(Boolean.valueOf(value));
        } else if (IGNORE_EXPIRATION.equals(key)) {
            this.m_ignoreExpiration = Boolean.valueOf(value);
        } else if (PRIORITY.equals(key)) {
            this.m_priority = Integer.parseInt(value);
            if (this.m_priority < 1) {
                this.m_priority = 1;
                LOG.error((Object)Messages.get().getBundle().key("LOG_SEARCH_PRIORITY_TOO_LOW_2", value, 1));
            } else if (this.m_priority > 10) {
                this.m_priority = 10;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_SEARCH_PRIORITY_TOO_HIGH_2", value, 10));
            }
        }
        if (MAX_HITS.equals(key)) {
            try {
                this.m_maxHits = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_INVALID_PARAM_3", value, key, this.getName()));
            }
            if (this.m_maxHits < 50) {
                this.m_maxHits = 5000;
                LOG.error((Object)Messages.get().getBundle().key("LOG_INVALID_PARAM_3", value, key, this.getName()));
            }
        } else if (TIME_RANGE.equals(key)) {
            this.m_checkTimeRange = Boolean.valueOf(value);
        } else if (EXCERPT.equals(key)) {
            this.m_createExcerpt = Boolean.valueOf(value);
        } else if (LUCENE_RAM_BUFFER_SIZE_MB.equals(key)) {
            try {
                this.m_luceneRAMBufferSizeMB = Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_INVALID_PARAM_3", value, key, this.getName()));
            }
        }
    }

    @Override
    public I_CmsSearchDocument createEmptyDocument(CmsResource resource) {
        return new CmsLuceneDocument(new Document());
    }

    public Analyzer getAnalyzer() {
        return this.m_analyzer;
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        CmsParameterConfiguration result = new CmsParameterConfiguration();
        if (this.getPriority() > 0) {
            result.put(PRIORITY, String.valueOf(this.m_priority));
        }
        if (!this.isExtractingContent()) {
            result.put(EXTRACT_CONTENT, String.valueOf(this.isExtractingContent()));
        }
        if (!this.isCheckingPermissions()) {
            result.put(PERMISSIONS, String.valueOf(this.m_checkPermissions));
        }
        if (this.isBackupReindexing()) {
            result.put(BACKUP_REINDEXING, String.valueOf(this.m_backupReindexing));
        }
        if (this.isLanguageDetection()) {
            result.put(LANGUAGEDETECTION, String.valueOf(this.isLanguageDetection()));
        }
        if (this.getMaxHits() != 5000) {
            result.put(MAX_HITS, String.valueOf(this.getMaxHits()));
        }
        if (!this.isCreatingExcerpt()) {
            result.put(EXCERPT, String.valueOf(this.m_createExcerpt));
        }
        if (this.m_luceneRAMBufferSizeMB != null) {
            result.put(LUCENE_RAM_BUFFER_SIZE_MB, String.valueOf(this.m_luceneRAMBufferSizeMB));
        }
        result.put(TIME_RANGE, String.valueOf(this.m_checkTimeRange));
        return result;
    }

    @Override
    public I_CmsExtractionResult getContentIfUnchanged(CmsResource resource) {
        long contentDateIndex;
        I_CmsSearchDocument oldDoc = this.getDocument("path", resource.getRootPath());
        if (oldDoc != null && oldDoc.getFieldValueAsDate("contentdate") != null && (contentDateIndex = oldDoc.getFieldValueAsDate("contentdate").getTime()) == resource.getDateContent()) {
            return CmsExtractionResult.fromBytes(oldDoc.getContentBlob());
        }
        return null;
    }

    public I_CmsSearchDocument getDocument(int docId) {
        try {
            IndexSearcher searcher = this.getSearcher();
            return new CmsLuceneDocument(searcher.doc(docId));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Deprecated
    public Document getDocument(String rootPath) {
        if (this.getDocument("path", rootPath) != null) {
            return (Document)this.getDocument("path", rootPath).getDocument();
        }
        return null;
    }

    public I_CmsSearchDocument getDocument(String field, String term) {
        Document result = null;
        IndexSearcher searcher = this.getSearcher();
        if (searcher != null) {
            Term resultTerm = new Term(field, term);
            try {
                TopDocs hits = searcher.search((Query)new TermQuery(resultTerm), 1);
                if (hits.scoreDocs.length > 0) {
                    result = searcher.doc(hits.scoreDocs[0].doc);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (result != null) {
            return new CmsLuceneDocument(result);
        }
        return null;
    }

    @Override
    public Locale getLocaleForResource(CmsObject cms, CmsResource resource, List<Locale> availableLocales) {
        List<Locale> defaultLocales = OpenCms.getLocaleManager().getDefaultLocales(cms, resource);
        List<Locale> locales = availableLocales;
        if (locales == null || locales.size() == 0) {
            locales = defaultLocales;
        }
        Locale result = OpenCms.getLocaleManager().getBestMatchingLocale(this.getLocale(), defaultLocales, locales);
        return result;
    }

    public String getLocaleString() {
        return this.getLocale().toString();
    }

    public int getMaxHits() {
        return this.m_maxHits;
    }

    @Override
    public String getPath() {
        if (super.getPath() == null) {
            this.setPath(this.generateIndexDirectory());
        }
        return super.getPath();
    }

    public int getPriority() {
        return this.m_priority;
    }

    public IndexSearcher getSearcher() {
        return this.m_indexSearcher;
    }

    @Override
    public void initialize() throws CmsSearchException {
        super.initialize();
        Analyzer baseAnalyzer = OpenCms.getSearchManager().getAnalyzer(this.getLocale());
        if (this.getFieldConfiguration() instanceof CmsLuceneFieldConfiguration) {
            CmsLuceneFieldConfiguration fc = (CmsLuceneFieldConfiguration)this.getFieldConfiguration();
            this.setAnalyzer(fc.getAnalyzer(baseAnalyzer));
        }
    }

    public boolean isBackupReindexing() {
        return this.m_backupReindexing;
    }

    public boolean isCheckingPermissions() {
        return this.m_checkPermissions;
    }

    public boolean isCheckingTimeRange() {
        return this.m_checkTimeRange;
    }

    public boolean isCheckPermissions() {
        return this.m_checkPermissions;
    }

    public boolean isCreatingExcerpt() {
        return this.m_createExcerpt;
    }

    public boolean isIgnoreExpiration() {
        return this.m_ignoreExpiration;
    }

    @Override
    public boolean isInitialized() {
        return super.isInitialized() && null != this.getPath();
    }

    public boolean isRequireViewPermission() {
        return this.m_requireViewPermission;
    }

    @Override
    public void onIndexChanged(boolean force) {
        if (force) {
            this.indexSearcherOpen(this.getPath());
        } else {
            this.indexSearcherUpdate();
        }
    }

    public CmsSearchResultList search(CmsObject cms, CmsSearchParameters params) throws CmsSearchException {
        long timeResultProcessing;
        TopDocs hits;
        long timeLucene;
        long timeTotal = -System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_SEARCH_PARAMS_2", params, this.getName()));
        }
        CmsSearchResultList searchResults = new CmsSearchResultList();
        int previousPriority = Thread.currentThread().getPriority();
        try {
            float maxScore;
            CmsObject searchCms = OpenCms.initCmsObject(cms);
            if (this.getPriority() > 0) {
                Thread.currentThread().setPriority(this.getPriority());
            }
            searchCms.getRequestContext().setCurrentProject(searchCms.readProject(this.getProject()));
            timeLucene = -System.currentTimeMillis();
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder = this.appendPathFilter(searchCms, builder, params.getRoots());
            builder = this.appendCategoryFilter(searchCms, builder, params.getCategories());
            builder = this.appendResourceTypeFilter(searchCms, builder, params.getResourceTypes());
            builder = this.appendDateLastModifiedFilter(builder, params.getMinDateLastModified(), params.getMaxDateLastModified());
            builder = this.appendDateCreatedFilter(builder, params.getMinDateCreated(), params.getMaxDateCreated());
            MatchAllDocsQuery query = null;
            Query fieldsQuery = null;
            this.indexSearcherUpdate();
            IndexSearcher searcher = this.getSearcher();
            if (!params.isIgnoreQuery()) {
                QueryParser p;
                if (params.getParsedQuery() != null) {
                    p = new QueryParser("content", this.getAnalyzer());
                    fieldsQuery = p.parse(params.getParsedQuery());
                } else if (params.getFieldQueries() != null) {
                    BooleanQuery.Builder mustOccur = null;
                    BooleanQuery.Builder shouldOccur = null;
                    for (CmsSearchParameters.CmsSearchFieldQuery fq : params.getFieldQueries()) {
                        QueryParser p2 = new QueryParser(fq.getFieldName(), this.getAnalyzer());
                        Query keywordQuery = null;
                        if (fq.getSearchTerms().size() == 1) {
                            keywordQuery = p2.parse(fq.getSearchTerms().get(0));
                        } else {
                            BooleanQuery.Builder keywordListQuery = new BooleanQuery.Builder();
                            for (String keyword : fq.getSearchTerms()) {
                                keywordListQuery.add(p2.parse(keyword), fq.getTermOccur());
                            }
                            keywordQuery = keywordListQuery.build();
                        }
                        if (BooleanClause.Occur.SHOULD.equals((Object)fq.getOccur())) {
                            if (shouldOccur == null) {
                                shouldOccur = new BooleanQuery.Builder();
                            }
                            shouldOccur.add(keywordQuery, fq.getOccur());
                            continue;
                        }
                        if (mustOccur == null) {
                            mustOccur = new BooleanQuery.Builder();
                        }
                        mustOccur.add(keywordQuery, fq.getOccur());
                    }
                    BooleanQuery.Builder booleanFieldsQuery = new BooleanQuery.Builder();
                    if (mustOccur != null) {
                        booleanFieldsQuery.add((Query)mustOccur.build(), BooleanClause.Occur.MUST);
                    }
                    if (shouldOccur != null) {
                        booleanFieldsQuery.add((Query)shouldOccur.build(), BooleanClause.Occur.MUST);
                    }
                    fieldsQuery = searcher.rewrite((Query)booleanFieldsQuery.build());
                } else if (params.getFields() != null && params.getFields().size() > 0) {
                    BooleanQuery.Builder booleanFieldsQuery = new BooleanQuery.Builder();
                    for (int i = 0; i < params.getFields().size(); ++i) {
                        QueryParser p3 = new QueryParser(params.getFields().get(i), this.getAnalyzer());
                        p3.setMultiTermRewriteMethod(MultiTermQuery.SCORING_BOOLEAN_REWRITE);
                        booleanFieldsQuery.add(p3.parse(params.getQuery()), BooleanClause.Occur.SHOULD);
                    }
                    fieldsQuery = searcher.rewrite((Query)booleanFieldsQuery.build());
                } else {
                    p = new QueryParser("content", this.getAnalyzer());
                    fieldsQuery = searcher.rewrite(p.parse(params.getQuery()));
                }
                query = fieldsQuery;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_BASE_QUERY_1", query));
            }
            if (query == null) {
                query = new MatchAllDocsQuery();
            } else {
                params.setParsedQuery(query.toString("content"));
            }
            BooleanQuery.Builder finalQueryBuilder = new BooleanQuery.Builder();
            finalQueryBuilder.add((Query)query, BooleanClause.Occur.MUST);
            finalQueryBuilder.add((Query)builder.build(), BooleanClause.Occur.FILTER);
            BooleanQuery finalQuery = finalQueryBuilder.build();
            if (params.isCalculateCategories()) {
                CmsSearchCategoryCollector categoryCollector = new CmsSearchCategoryCollector(searcher);
                searcher.search((Query)finalQuery, (Collector)categoryCollector);
                searchResults.setCategories(categoryCollector.getCategoryCountResult());
            }
            TopDocs scoreHits = searcher.search((Query)query, 1);
            float f = maxScore = scoreHits.scoreDocs.length == 0 ? Float.NaN : scoreHits.scoreDocs[0].score;
            if (params.getSort() == null || params.getSort() == CmsSearchParameters.SORT_DEFAULT) {
                hits = searcher.search((Query)finalQuery, this.getMaxHits());
            } else {
                boolean isSortScore = this.isSortScoring(searcher, params.getSort());
                hits = searcher.search((Query)finalQuery, this.getMaxHits(), params.getSort(), isSortScore);
            }
            timeLucene += System.currentTimeMillis();
            timeResultProcessing = -System.currentTimeMillis();
            if (hits != null) {
                long hitCount = hits.totalHits.value > (long)hits.scoreDocs.length ? (long)hits.scoreDocs.length : hits.totalHits.value;
                int page = params.getSearchPage();
                long start = -1L;
                long end = -1L;
                if (params.getMatchesPerPage() > 0 && page > 0 && hitCount > 0L) {
                    start = params.getMatchesPerPage() * (page - 1);
                    end = start + (long)params.getMatchesPerPage();
                    start = start > hitCount ? hitCount : start;
                    end = end > hitCount ? hitCount : end;
                } else {
                    start = 0L;
                    end = hitCount;
                }
                Set<String> returnFields = ((CmsLuceneFieldConfiguration)this.getFieldConfiguration()).getReturnFields();
                Set<String> excerptFields = ((CmsLuceneFieldConfiguration)this.getFieldConfiguration()).getExcerptFields();
                long visibleHitCount = hitCount;
                int i = 0;
                int cnt = 0;
                while ((long)i < hitCount && (long)cnt < end) {
                    block43: {
                        try {
                            Document doc = searcher.doc(hits.scoreDocs[i].doc, returnFields);
                            CmsLuceneDocument searchDoc = new CmsLuceneDocument(doc);
                            searchDoc.setScore(hits.scoreDocs[i].score);
                            if (this.isInTimeRange(doc, params) && this.hasReadPermission(searchCms, searchDoc)) {
                                if ((long)cnt >= start) {
                                    String excerpt = null;
                                    if (this.isCreatingExcerpt() && fieldsQuery != null) {
                                        Document exDoc = searcher.doc(hits.scoreDocs[i].doc, excerptFields);
                                        I_CmsTermHighlighter highlighter = OpenCms.getSearchManager().getHighlighter();
                                        excerpt = highlighter.getExcerpt(exDoc, this, params, fieldsQuery, this.getAnalyzer());
                                    }
                                    int score = Math.round(maxScore != Float.NaN ? hits.scoreDocs[i].score / maxScore * 100.0f : 0.0f);
                                    searchResults.add(new CmsSearchResult(score, doc, excerpt));
                                }
                                ++cnt;
                            } else {
                                --visibleHitCount;
                            }
                        }
                        catch (Exception e) {
                            if (!LOG.isWarnEnabled()) break block43;
                            LOG.warn((Object)Messages.get().getBundle().key("LOG_RESULT_ITERATION_FAILED_0"), (Throwable)e);
                        }
                    }
                    ++i;
                }
                searchResults.setHitCount((int)visibleHitCount);
            } else {
                searchResults.setHitCount(0);
            }
            timeResultProcessing += System.currentTimeMillis();
        }
        catch (RuntimeException e) {
            throw new CmsSearchException(Messages.get().container("ERR_SEARCH_PARAMS_1", params), (Throwable)e);
        }
        catch (Exception e) {
            throw new CmsSearchException(Messages.get().container("ERR_SEARCH_PARAMS_1", params), (Throwable)e);
        }
        finally {
            Thread.currentThread().setPriority(previousPriority);
        }
        if (LOG.isDebugEnabled()) {
            Object[] logParams = new Object[]{hits == null ? 0L : hits.totalHits.value, timeTotal += System.currentTimeMillis(), timeLucene, timeResultProcessing};
            LOG.debug((Object)Messages.get().getBundle().key("LOG_STAT_RESULTS_TIME_4", logParams));
        }
        return searchResults;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.m_analyzer = analyzer;
    }

    public void setCheckPermissions(boolean checkPermissions) {
        this.m_checkPermissions = checkPermissions;
    }

    public void setIgnoreExpiration(boolean ignoreExpiration) {
        this.m_ignoreExpiration = ignoreExpiration;
    }

    public void setMaxHits(int maxHits) {
        if (this.m_maxHits >= 50) {
            this.m_maxHits = maxHits;
        }
    }

    public void setRequireViewPermission(boolean requireViewPermission) {
        this.m_requireViewPermission = requireViewPermission;
    }

    @Override
    public void shutDown() {
        super.shutDown();
        this.indexSearcherClose();
        if (this.m_analyzer != null) {
            this.m_analyzer.close();
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SHUTDOWN_INDEX_1", this.getName()));
        }
    }

    public String toString() {
        return this.getName();
    }

    protected BooleanQuery.Builder appendCategoryFilter(CmsObject cms, BooleanQuery.Builder filter, List<String> categories) {
        if (categories != null && categories.size() > 0) {
            ArrayList<String> lowerCaseCategories = new ArrayList<String>();
            for (String category : categories) {
                lowerCaseCategories.add(category.toLowerCase());
            }
            filter.add(new BooleanClause(this.getMultiTermQueryFilter("category", lowerCaseCategories), BooleanClause.Occur.MUST));
        }
        return filter;
    }

    protected BooleanQuery.Builder appendDateCreatedFilter(BooleanQuery.Builder filter, long startTime, long endTime) {
        Query dateFilter = this.createDateRangeFilter("created_lookup", startTime, endTime);
        if (dateFilter != null) {
            filter.add(new BooleanClause(dateFilter, BooleanClause.Occur.MUST));
        }
        return filter;
    }

    protected BooleanQuery.Builder appendDateLastModifiedFilter(BooleanQuery.Builder filter, long startTime, long endTime) {
        Query dateFilter = this.createDateRangeFilter("lastmodified_lookup", startTime, endTime);
        if (dateFilter != null) {
            filter.add(new BooleanClause(dateFilter, BooleanClause.Occur.MUST));
        }
        return filter;
    }

    protected BooleanQuery.Builder appendPathFilter(CmsObject cms, BooleanQuery.Builder filter, List<String> roots) {
        ArrayList<Term> terms = new ArrayList<Term>();
        if (roots != null && roots.size() > 0) {
            for (int i = 0; i < roots.size(); ++i) {
                String searchRoot = cms.getRequestContext().addSiteRoot(roots.get(i));
                this.extendPathFilter(terms, searchRoot);
            }
        } else {
            this.extendPathFilter(terms, cms.getRequestContext().getSiteRoot());
            if (OpenCms.getSiteManager().getSharedFolder() != null) {
                this.extendPathFilter(terms, OpenCms.getSiteManager().getSharedFolder());
            }
        }
        BooleanQuery.Builder build = new BooleanQuery.Builder();
        terms.forEach(term -> build.add((Query)new TermQuery(term), BooleanClause.Occur.SHOULD));
        filter.add(new BooleanClause((Query)build.build(), BooleanClause.Occur.MUST));
        return filter;
    }

    protected BooleanQuery.Builder appendResourceTypeFilter(CmsObject cms, BooleanQuery.Builder filter, List<String> resourceTypes) {
        if (resourceTypes != null && resourceTypes.size() > 0) {
            filter.add(new BooleanClause(this.getMultiTermQueryFilter("type", resourceTypes), BooleanClause.Occur.MUST));
        }
        return filter;
    }

    protected Query createDateRangeFilter(String fieldName, long startTime, long endTime) {
        BooleanQuery filter = null;
        if (startTime != Long.MIN_VALUE || endTime != Long.MAX_VALUE) {
            Calendar cal;
            if (startTime == Long.MIN_VALUE) {
                cal = Calendar.getInstance(OpenCms.getLocaleManager().getTimeZone());
                cal.setTimeInMillis(endTime);
                cal.set(cal.get(1) - 25, 11, 31, 0, 0, 0);
                startTime = cal.getTimeInMillis();
            } else if (endTime == Long.MAX_VALUE) {
                cal = Calendar.getInstance(OpenCms.getLocaleManager().getTimeZone());
                cal.setTimeInMillis(startTime);
                cal.set(cal.get(1) + 25, 0, 1, 0, 0, 0);
                endTime = cal.getTimeInMillis();
            }
            List<String> dateRange = CmsSearchIndex.getDateRangeSpan(startTime, endTime);
            ArrayList<Term> terms = new ArrayList<Term>();
            for (String range : dateRange) {
                terms.add(new Term(fieldName, range));
            }
            BooleanQuery.Builder build = new BooleanQuery.Builder();
            terms.forEach(term -> build.add((Query)new TermQuery(term), BooleanClause.Occur.SHOULD));
            filter = build.build();
        }
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createIndexBackup() {
        if (!this.isBackupReindexing()) {
            return null;
        }
        File file = new File(this.getPath());
        if (!file.exists()) {
            return null;
        }
        String backupPath = this.getPath() + "_backup";
        FSDirectory oldDir = null;
        FSDirectory newDir = null;
        try {
            oldDir = FSDirectory.open((Path)file.toPath());
            newDir = FSDirectory.open((Path)Paths.get(backupPath, new String[0]));
            for (String fileName : oldDir.listAll()) {
                newDir.copyFrom((Directory)oldDir, fileName, fileName, IOContext.DEFAULT);
            }
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_IO_INDEX_BACKUP_CREATE_3", this.getName(), this.getPath(), backupPath), (Throwable)e);
            backupPath = null;
        }
        finally {
            if (oldDir != null) {
                try {
                    oldDir.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (newDir != null) {
                try {
                    newDir.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return backupPath;
    }

    @Override
    protected I_CmsIndexWriter createIndexWriter(boolean create, I_CmsReport report) throws CmsIndexException {
        IndexWriter indexWriter = null;
        FSDirectory dir = null;
        try {
            File f = new File(this.getPath());
            if (!f.exists()) {
                if ((f = f.getParentFile()) != null && !f.exists()) {
                    f.mkdirs();
                }
                create = true;
            }
            dir = FSDirectory.open((Path)Paths.get(this.getPath(), new String[0]));
            IndexWriterConfig indexConfig = new IndexWriterConfig(this.getAnalyzer());
            if (this.m_luceneRAMBufferSizeMB != null) {
                indexConfig.setRAMBufferSizeMB(this.m_luceneRAMBufferSizeMB.doubleValue());
            }
            if (create) {
                indexConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
            } else {
                indexConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            }
            indexConfig.setSimilarity(this.m_sim);
            indexWriter = new IndexWriter((Directory)dir, indexConfig);
        }
        catch (Exception e) {
            if (dir != null) {
                try {
                    dir.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (indexWriter != null) {
                try {
                    indexWriter.close();
                }
                catch (IOException closeExeception) {
                    throw new CmsIndexException(Messages.get().container("ERR_IO_INDEX_WRITER_OPEN_2", this.getPath(), this.getName()), (Throwable)e);
                }
            }
            throw new CmsIndexException(Messages.get().container("ERR_IO_INDEX_WRITER_OPEN_2", this.getPath(), this.getName()), (Throwable)e);
        }
        return new CmsLuceneIndexWriter(indexWriter, this);
    }

    protected void extendPathFilter(List<Term> terms, String searchRoot) {
        if (!CmsResource.isFolder(searchRoot)) {
            searchRoot = searchRoot + "/";
        }
        terms.add(new Term("parent-folders", searchRoot));
    }

    protected String generateIndexDirectory() {
        return OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(OpenCms.getSearchManager().getDirectory() + "/" + this.getName());
    }

    protected Query getMultiTermQueryFilter(String field, List<String> terms) {
        return this.getMultiTermQueryFilter(field, null, terms);
    }

    protected Query getMultiTermQueryFilter(String field, String terms) {
        return this.getMultiTermQueryFilter(field, terms, null);
    }

    protected Query getMultiTermQueryFilter(String field, String termsStr, List<String> termsList) {
        Query result;
        if (termsStr == null) {
            StringBuffer buf = new StringBuffer(64);
            for (int i = 0; i < termsList.size(); ++i) {
                if (i > 0) {
                    buf.append(' ');
                }
                buf.append(termsList.get(i));
            }
            termsStr = buf.toString();
        }
        if ((result = this.m_displayFilters.get(new StringBuffer(64).append(field).append('|').append(termsStr).toString())) == null) {
            ArrayList<Term> terms = new ArrayList<Term>();
            if (termsList == null) {
                termsList = CmsStringUtil.splitAsList(termsStr, ' ');
            }
            for (int i = 0; i < termsList.size(); ++i) {
                terms.add(new Term(field, termsList.get(i)));
            }
            BooleanQuery.Builder build = new BooleanQuery.Builder();
            terms.forEach(term -> build.add((Query)new TermQuery(term), BooleanClause.Occur.SHOULD));
            BooleanQuery termsQuery = build.build();
            try {
                result = termsQuery.createWeight(this.m_indexSearcher, ScoreMode.COMPLETE_NO_SCORES, 1.0f).getQuery();
                this.m_displayFilters.put(field + termsStr, result);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    protected CmsResource getResource(CmsObject cms, I_CmsSearchDocument doc) {
        CmsResourceFilter filter = CmsResourceFilter.DEFAULT;
        if (this.isRequireViewPermission()) {
            filter = CmsResourceFilter.DEFAULT_ONLY_VISIBLE;
        } else if (this.isIgnoreExpiration()) {
            filter = CmsResourceFilter.IGNORE_EXPIRATION;
        }
        return this.getResource(cms, doc, filter);
    }

    protected CmsResource getResource(CmsObject cms, I_CmsSearchDocument doc, CmsResourceFilter filter) {
        try {
            CmsObject clone = OpenCms.initCmsObject(cms);
            clone.getRequestContext().setSiteRoot("");
            return clone.readResource(doc.getPath(), filter);
        }
        catch (CmsException cmsException) {
            return null;
        }
    }

    protected Query getTermQueryFilter(String field, String term) {
        return this.getMultiTermQueryFilter(field, term, Collections.singletonList(term));
    }

    protected boolean hasReadPermission(CmsObject cms, I_CmsSearchDocument doc) {
        return !this.needsPermissionCheck(doc) ? true : null != this.getResource(cms, doc);
    }

    protected synchronized void indexSearcherClose() {
        this.indexSearcherClose(this.m_indexSearcher);
    }

    protected synchronized void indexSearcherClose(IndexSearcher searcher) {
        if (searcher != null && searcher.getIndexReader() != null) {
            try {
                searcher.getIndexReader().close();
            }
            catch (Exception e) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_INDEX_SEARCHER_CLOSE_1", this.getName()), (Throwable)e);
            }
        }
    }

    protected synchronized void indexSearcherOpen(String path) {
        IndexSearcher oldSearcher;
        block7: {
            oldSearcher = null;
            FSDirectory indexDirectory = null;
            try {
                indexDirectory = FSDirectory.open((Path)Paths.get(path, new String[0]));
                if (DirectoryReader.indexExists((Directory)indexDirectory)) {
                    DirectoryReader reader = UninvertingReader.wrap((DirectoryReader)DirectoryReader.open((Directory)indexDirectory), this.createUninvertingMap());
                    if (this.m_indexSearcher != null) {
                        oldSearcher = this.m_indexSearcher;
                    }
                    this.m_indexSearcher = new IndexSearcher((IndexReader)reader);
                    this.m_indexSearcher.setSimilarity(this.m_sim);
                    this.m_displayFilters = new HashMap<String, Query>();
                }
            }
            catch (IOException e) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_INDEX_SEARCHER_1", this.getName()), (Throwable)e);
                if (indexDirectory == null) break block7;
                try {
                    indexDirectory.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (oldSearcher != null) {
            this.indexSearcherClose(oldSearcher);
        }
    }

    protected synchronized void indexSearcherUpdate() {
        IndexSearcher oldSearcher = this.m_indexSearcher;
        if (oldSearcher != null && oldSearcher.getIndexReader() != null) {
            try {
                DirectoryReader newReader;
                if (oldSearcher.getIndexReader() instanceof DirectoryReader && (newReader = DirectoryReader.openIfChanged((DirectoryReader)((DirectoryReader)oldSearcher.getIndexReader()))) != null) {
                    this.m_indexSearcher = new IndexSearcher((IndexReader)newReader);
                    this.m_indexSearcher.setSimilarity(this.m_sim);
                    this.indexSearcherClose(oldSearcher);
                }
            }
            catch (Exception e) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_INDEX_SEARCHER_REOPEN_1", this.getName()), (Throwable)e);
            }
        } else {
            this.indexSearcherOpen(this.getPath());
        }
    }

    protected boolean isInTimeRange(Document doc, CmsSearchParameters params) {
        if (!this.isCheckingTimeRange()) {
            return true;
        }
        try {
            Date dateCreated = DateTools.stringToDate((String)doc.getField("created").stringValue());
            if (dateCreated.getTime() < params.getMinDateCreated()) {
                return false;
            }
            if (dateCreated.getTime() > params.getMaxDateCreated()) {
                return false;
            }
            Date dateLastModified = DateTools.stringToDate((String)doc.getField("lastmodified").stringValue());
            if (dateLastModified.getTime() < params.getMinDateLastModified()) {
                return false;
            }
            if (dateLastModified.getTime() > params.getMaxDateLastModified()) {
                return false;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return true;
    }

    protected boolean isSortScoring(IndexSearcher searcher, Sort sort) {
        boolean doScoring = false;
        if (sort != null) {
            if (sort == CmsSearchParameters.SORT_DEFAULT || sort == CmsSearchParameters.SORT_TITLE) {
                doScoring = true;
            } else if (sort == CmsSearchParameters.SORT_DATE_CREATED || sort == CmsSearchParameters.SORT_DATE_LASTMODIFIED) {
                doScoring = false;
            } else {
                SortField[] fields;
                for (SortField field : fields = sort.getSort()) {
                    if (field != SortField.FIELD_SCORE) continue;
                    doScoring = true;
                    break;
                }
            }
        }
        return doScoring;
    }

    protected boolean needsPermissionCheck(I_CmsSearchDocument doc) {
        if (!this.isCheckingPermissions()) {
            return false;
        }
        if (doc.getType() == null || doc.getPath() == null) {
            return false;
        }
        return "VFS".equals(doc.getType()) || OpenCms.getResourceManager().hasResourceType(doc.getType());
    }

    protected void removeIndexBackup(String path) {
        if (!this.isBackupReindexing()) {
            return;
        }
        File file = new File(path);
        if (!file.exists()) {
            return;
        }
        try {
            FSDirectory dir = FSDirectory.open((Path)file.toPath());
            dir.close();
            CmsFileUtil.purgeDirectory(file);
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_IO_INDEX_BACKUP_REMOVE_2", this.getName(), path), (Throwable)e);
        }
    }

    private Map<String, UninvertingReader.Type> createUninvertingMap() {
        HashMap<String, UninvertingReader.Type> uninvertingMap = new HashMap<String, UninvertingReader.Type>();
        CmsSearchField.addUninvertingMappings(uninvertingMap);
        this.getFieldConfiguration().addUninvertingMappings(uninvertingMap);
        return uninvertingMap;
    }
}

