/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.opencms.ade.containerpage.CmsDetailOnlyContainerUtil;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.db.CmsPublishedResource;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.loader.CmsLoaderException;
import org.opencms.loader.CmsResourceManager;
import org.opencms.main.CmsBroadcast;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.CmsLog;
import org.opencms.main.I_CmsEventListener;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.relations.CmsRelationType;
import org.opencms.report.CmsLogReport;
import org.opencms.report.CmsShellLogReport;
import org.opencms.report.I_CmsReport;
import org.opencms.scheduler.I_CmsScheduledJob;
import org.opencms.search.CmsIndexException;
import org.opencms.search.CmsIndexingThreadManager;
import org.opencms.search.CmsSearchAnalyzer;
import org.opencms.search.CmsSearchDocumentType;
import org.opencms.search.CmsSearchException;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.CmsSearchIndexSource;
import org.opencms.search.CmsSearchIndexUpdateData;
import org.opencms.search.I_CmsIndexWriter;
import org.opencms.search.I_CmsIndexer;
import org.opencms.search.I_CmsSearchIndex;
import org.opencms.search.Messages;
import org.opencms.search.documents.A_CmsVfsDocument;
import org.opencms.search.documents.CmsExtractionResultCache;
import org.opencms.search.documents.I_CmsDocumentFactory;
import org.opencms.search.documents.I_CmsTermHighlighter;
import org.opencms.search.fields.CmsLuceneField;
import org.opencms.search.fields.CmsLuceneFieldConfiguration;
import org.opencms.search.fields.CmsSearchField;
import org.opencms.search.fields.CmsSearchFieldMapping;
import org.opencms.search.fields.I_CmsSearchFieldConfiguration;
import org.opencms.search.solr.CmsSolrConfiguration;
import org.opencms.search.solr.CmsSolrFieldConfiguration;
import org.opencms.search.solr.CmsSolrIndex;
import org.opencms.search.solr.I_CmsSolrIndexWriter;
import org.opencms.search.solr.spellchecking.CmsSolrSpellchecker;
import org.opencms.search.solr.spellchecking.CmsSpellcheckDictionaryIndexer;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.util.A_CmsModeStringEnumeration;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.util.CmsWaitHandle;

public class CmsSearchManager
implements I_CmsScheduledJob,
I_CmsEventListener {
    private static final ReentrantLock SEARCH_MANAGER_LOCK = new ReentrantLock(true);
    public static final int DEFAULT_EXCERPT_LENGTH = 1024;
    public static final float DEFAULT_EXTRACTION_CACHE_MAX_AGE = 672.0f;
    public static final int DEFAULT_MAX_MODIFICATIONS_BEFORE_COMMIT = 500;
    public static final int DEFAULT_OFFLINE_UPDATE_FREQNENCY = 15000;
    public static final int DEFAULT_MAX_INDEX_WAITTIME = 30000;
    public static final int DEFAULT_TIMEOUT = 60000;
    public static final String JOB_PARAM_INDEXLIST = "indexList";
    public static final String JOB_PARAM_WRITELOG = "writeLog";
    public static final String LUCENE_ANALYZER = "org.apache.lucene.analysis.core.";
    protected static final Log LOG = CmsLog.getLog(CmsSearchManager.class);
    private static final String[] groupTypes = new String[]{"modelgroup", "groupcontainer", "inheritance_group"};
    protected CmsObject m_adminCms;
    protected List<I_CmsSearchIndex> m_offlineIndexes;
    protected CmsSearchOfflineIndexThread m_offlineIndexThread;
    private HashMap<Locale, CmsSearchAnalyzer> m_analyzers;
    private long m_configuredOfflineIndexingFrequency;
    private CoreContainer m_coreContainer;
    private List<CmsSearchDocumentType> m_documentTypeConfigs;
    private Map<String, Map<String, I_CmsDocumentFactory>> m_documentTypes;
    private Set<String> m_extractionKeys;
    private float m_extractionCacheMaxAge = 672.0f;
    private CmsExtractionResultCache m_extractionResultCache;
    private Map<String, I_CmsSearchFieldConfiguration> m_fieldConfigurations;
    private CmsSearchForceUnlockMode m_forceUnlockMode;
    private I_CmsTermHighlighter m_highlighter;
    private List<I_CmsSearchIndex> m_indexes;
    private int m_indexLockMaxWaitSeconds = 10;
    private Map<String, CmsSearchIndexSource> m_indexSources;
    private int m_maxExcerptLength = 1024;
    private int m_maxModificationsBeforeCommit = 500;
    private CmsSearchOfflineHandler m_offlineHandler;
    private long m_offlineUpdateFrequency = 15000L;
    private long m_maxIndexWaitTime = 30000L;
    private String m_path;
    private CmsSolrConfiguration m_solrConfig;
    private long m_timeout;
    private final Set<CmsUUID> m_pauseRequests = new HashSet<CmsUUID>();

    public CmsSearchManager() {
        this.m_documentTypes = new HashMap<String, Map<String, I_CmsDocumentFactory>>();
        this.m_extractionKeys = new HashSet<String>();
        this.m_documentTypeConfigs = new ArrayList<CmsSearchDocumentType>();
        this.m_analyzers = new HashMap();
        this.m_indexes = new ArrayList<I_CmsSearchIndex>();
        this.m_indexSources = new TreeMap<String, CmsSearchIndexSource>();
        this.m_offlineHandler = new CmsSearchOfflineHandler();
        this.m_fieldConfigurations = new HashMap<String, I_CmsSearchFieldConfiguration>();
        this.addFieldConfiguration(CmsLuceneFieldConfiguration.DEFAULT_STANDARD);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_START_SEARCH_CONFIG_0"));
        }
    }

    public static Analyzer getAnalyzer(String className) throws Exception {
        Class<?> analyzerClass;
        Object analyzer = null;
        try {
            analyzerClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            analyzerClass = Class.forName(LUCENE_ANALYZER + className);
        }
        analyzer = StandardAnalyzer.class.equals(analyzerClass) ? new StandardAnalyzer(new CharArraySet(0, false)) : (Analyzer)analyzerClass.newInstance();
        return analyzer;
    }

    public static final CmsSolrIndex getIndexSolr(CmsObject cms, Map<String, String[]> params) {
        List<CmsSolrIndex> solrs;
        String indexName = null;
        CmsSolrIndex index = null;
        if (params != null) {
            String string = params.get("core") != null ? params.get("core")[0] : (indexName = params.get("index") != null ? params.get("index")[0] : null);
        }
        if (indexName == null) {
            String string = indexName = cms.getRequestContext().getCurrentProject().isOnlineProject() ? "Solr Online" : "Solr Offline";
        }
        if ((index = OpenCms.getSearchManager().getIndexSolr(indexName)) == null && (solrs = OpenCms.getSearchManager().getAllSolrIndexes()) != null && !solrs.isEmpty() && solrs.size() == 1) {
            index = solrs.get(0);
        }
        return index;
    }

    public static boolean isLuceneIndex(String indexName) {
        I_CmsSearchIndex i = OpenCms.getSearchManager().getIndex(indexName);
        return i instanceof CmsSearchIndex && !(i instanceof CmsSolrIndex);
    }

    public void addAnalyzer(CmsSearchAnalyzer analyzer) {
        this.m_analyzers.put(analyzer.getLocale(), analyzer);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADD_ANALYZER_2", analyzer.getLocale(), analyzer.getClassName()));
        }
    }

    public void addDocumentTypeConfig(CmsSearchDocumentType documentType) {
        this.m_documentTypeConfigs.add(documentType);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SEARCH_DOC_TYPES_2", documentType.getName(), documentType.getClassName()));
        }
    }

    public void addFieldConfiguration(I_CmsSearchFieldConfiguration fieldConfiguration) {
        this.m_fieldConfigurations.put(fieldConfiguration.getName(), fieldConfiguration);
    }

    public void addSearchIndex(I_CmsSearchIndex searchIndex) {
        String name;
        if (!searchIndex.isInitialized() && OpenCms.getRunLevel() > 2) {
            try {
                searchIndex.initialize();
            }
            catch (CmsException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(name = searchIndex.getName())) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_SEARCHINDEX_CREATE_MISSING_NAME_0"));
        }
        if (this.m_indexSources.keySet().contains(name)) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_SEARCHINDEX_CREATE_INVALID_NAME_1", name));
        }
        this.m_indexes.add(searchIndex);
        if (this.m_adminCms != null) {
            this.initOfflineIndexes();
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADD_SEARCH_INDEX_2", searchIndex.getName(), searchIndex.getProject()));
        }
    }

    public void addSearchIndexSource(CmsSearchIndexSource searchIndexSource) {
        this.m_indexSources.put(searchIndexSource.getName(), searchIndexSource);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SEARCH_INDEX_SOURCE_2", searchIndexSource.getName(), searchIndexSource.getIndexerClassName()));
        }
    }

    @Override
    public void cmsEvent(CmsEvent event) {
        switch (event.getType()) {
            case 32: {
                List<String> indexNames = null;
                if (event.getData() != null && CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)event.getData().get("indexNames"))) {
                    indexNames = CmsStringUtil.splitAsList((String)event.getData().get("indexNames"), ",", true);
                }
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_EVENT_REBUILD_SEARCHINDEX_1", indexNames == null ? "" : CmsStringUtil.collectionAsString(indexNames, ",")), (Throwable)new Exception());
                    }
                    if (indexNames == null) {
                        this.rebuildAllIndexes(this.getEventReport(event));
                        break;
                    }
                    this.rebuildIndexes(indexNames, this.getEventReport(event));
                }
                catch (CmsException e) {
                    if (!LOG.isErrorEnabled()) break;
                    LOG.error((Object)Messages.get().getBundle().key("ERR_EVENT_REBUILD_SEARCHINDEX_1", indexNames == null ? "" : CmsStringUtil.collectionAsString(indexNames, ",")), (Throwable)e);
                }
                break;
            }
            case 5: {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_EVENT_CLEAR_CACHES_0"), (Throwable)new Exception());
                break;
            }
            case 2: {
                CmsUUID publishHistoryId = new CmsUUID((String)event.getData().get("publishHistoryId"));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_EVENT_PUBLISH_PROJECT_1", publishHistoryId));
                }
                this.updateAllIndexes(this.m_adminCms, publishHistoryId, this.getEventReport(event));
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_EVENT_PUBLISH_PROJECT_FINISHED_1", publishHistoryId));
                break;
            }
            case 34: 
            case 35: {
                boolean isOnline = 34 == event.getType();
                Map<String, Object> eventData = event.getData();
                CmsUUID userId = (CmsUUID)eventData.get("userId");
                CmsUser user = null;
                if (userId != null) {
                    try {
                        user = this.m_adminCms.readUser(userId);
                    }
                    catch (Throwable t) {
                        LOG.debug((Object)t.getMessage(), t);
                    }
                }
                try {
                    SEARCH_MANAGER_LOCK.lock();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_EVENT_REINDEX_STARTED_0"));
                    }
                    CmsObject cms = this.m_adminCms;
                    if (!isOnline) {
                        OpenCms.initCmsObject(this.m_adminCms);
                        cms.getRequestContext().setCurrentProject(cms.readProject((CmsUUID)eventData.get("projectId")));
                    }
                    List resources = (List)eventData.get("resources");
                    I_CmsReport report = (I_CmsReport)eventData.get("report");
                    ArrayList<CmsResource> resourcesToIndex = new ArrayList<CmsResource>();
                    for (CmsResource res2 : resources) {
                        if (res2.isFile()) {
                            resourcesToIndex.add(res2);
                            continue;
                        }
                        try {
                            resourcesToIndex.addAll(cms.readResources(res2, CmsResourceFilter.IGNORE_EXPIRATION, true));
                        }
                        catch (CmsException e) {
                            LOG.error((Object)e, (Throwable)e);
                        }
                    }
                    this.cleanExtractionCache();
                    List<CmsPublishedResource> publishedResourcesToIndex = resourcesToIndex.stream().map(res -> new CmsPublishedResource((CmsResource)res)).collect(Collectors.toList());
                    if (Boolean.TRUE.equals(eventData.get("related"))) {
                        this.addAdditionallyAffectedResources(cms, publishedResourcesToIndex);
                    }
                    if (isOnline) {
                        this.updateAllIndexes(this.m_adminCms, publishedResourcesToIndex, (I_CmsReport)new CmsShellLogReport(CmsLocaleManager.MASTER_LOCALE));
                    } else {
                        this.updateIndexOffline(report, publishedResourcesToIndex);
                    }
                    cms = null;
                    SEARCH_MANAGER_LOCK.unlock();
                    if (null != user) {
                        Locale l = OpenCms.getWorkplaceManager().getWorkplaceLocale(user);
                        OpenCms.getSessionManager().sendBroadcast(null, Messages.get().getBundle(l).key("GUI_REINDEXING_SUCCESS_0"), user, CmsBroadcast.ContentMode.html);
                    }
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_EVENT_REINDEX_FINISHED_0"));
                }
                catch (Throwable e) {
                    if (SEARCH_MANAGER_LOCK.isHeldByCurrentThread()) {
                        SEARCH_MANAGER_LOCK.unlock();
                    }
                    if (null != user) {
                        Locale l = OpenCms.getWorkplaceManager().getWorkplaceLocale(user);
                        OpenCms.getSessionManager().sendBroadcast(null, Messages.get().getBundle(l).key("GUI_REINDEXING_FAILED_0"), user, CmsBroadcast.ContentMode.html);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.error((Object)Messages.get().getBundle().key("ERR_EVENT_REINDEX_FAILED_1", event.getData()), e);
                        break;
                    }
                    if (!LOG.isErrorEnabled()) break;
                    LOG.error((Object)Messages.get().getBundle().key("ERR_EVENT_REINDEX_FAILED_1", event.getData()));
                }
                break;
            }
        }
    }

    public List<CmsSolrIndex> getAllSolrIndexes() {
        ArrayList<CmsSolrIndex> result = new ArrayList<CmsSolrIndex>();
        for (String indexName : this.getIndexNames()) {
            CmsSolrIndex index = this.getIndexSolr(indexName);
            if (index == null) continue;
            result.add(index);
        }
        return result;
    }

    public Analyzer getAnalyzer(Locale locale) throws CmsSearchException {
        Analyzer analyzer = null;
        Object className = null;
        CmsSearchAnalyzer analyzerConf = this.m_analyzers.get(locale);
        if (analyzerConf == null) {
            throw new CmsSearchException(Messages.get().container("ERR_ANALYZER_NOT_FOUND_1", locale));
        }
        try {
            analyzer = CmsSearchManager.getAnalyzer(analyzerConf.getClassName());
        }
        catch (Exception e) {
            throw new CmsSearchException(Messages.get().container("ERR_LOAD_ANALYZER_1", (Object)className), (Throwable)e);
        }
        return analyzer;
    }

    public Map<Locale, CmsSearchAnalyzer> getAnalyzers() {
        return Collections.unmodifiableMap(this.m_analyzers);
    }

    public CmsSearchAnalyzer getCmsSearchAnalyzer(Locale locale) {
        return this.m_analyzers.get(locale);
    }

    public String getDirectory() {
        return this.m_path;
    }

    public String getDirectorySolr() {
        return this.m_solrConfig != null ? this.m_solrConfig.getHome() : null;
    }

    public I_CmsDocumentFactory getDocumentFactoryForName(String docTypeName) {
        Iterator<I_CmsDocumentFactory> factoryIt;
        Map<String, I_CmsDocumentFactory> factoryMap = this.m_documentTypes.get(docTypeName);
        if (factoryMap != null && (factoryIt = factoryMap.values().iterator()).hasNext()) {
            return factoryMap.values().iterator().next();
        }
        return null;
    }

    public CmsSearchDocumentType getDocumentTypeConfig(String name) {
        for (int i = 0; i < this.m_documentTypeConfigs.size(); ++i) {
            CmsSearchDocumentType type = this.m_documentTypeConfigs.get(i);
            if (!type.getName().equals(name)) continue;
            return type;
        }
        return null;
    }

    public List<CmsSearchDocumentType> getDocumentTypeConfigs() {
        return Collections.unmodifiableList(this.m_documentTypeConfigs);
    }

    public List<String> getDocumentTypeKeys(CmsResource resource) {
        String mimeType = OpenCms.getResourceManager().getMimeType(resource.getRootPath(), null, "unknown");
        String resourceType = null;
        try {
            resourceType = OpenCms.getResourceManager().getResourceType(resource.getTypeId()).getTypeName();
        }
        catch (CmsLoaderException e) {
            LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return this.getDocumentTypeKeys(resourceType, mimeType);
    }

    public List<String> getDocumentTypeKeys(String resourceType, String mimeType) {
        ArrayList<String> result = new ArrayList<String>(8);
        if (null != resourceType) {
            String currentKey = A_CmsVfsDocument.getDocumentKey(resourceType, mimeType);
            result.add(currentKey);
            if (!this.m_extractionKeys.contains(currentKey)) {
                currentKey = A_CmsVfsDocument.getDocumentKey(resourceType, null);
                result.add(currentKey);
                if (!this.m_extractionKeys.contains(currentKey)) {
                    boolean hasGlobalMatch = false;
                    try {
                        String containerpageTypeName = CmsResourceTypeXmlContainerPage.getStaticTypeName();
                        I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(resourceType);
                        if (!resourceType.equals(containerpageTypeName) && type instanceof CmsResourceTypeXmlContainerPage && !resourceType.equals(CmsResourceTypeXmlContainerPage.getStaticTypeName())) {
                            currentKey = A_CmsVfsDocument.getDocumentKey(containerpageTypeName, mimeType);
                            result.add(currentKey);
                            hasGlobalMatch = this.m_extractionKeys.contains(currentKey);
                            if (!hasGlobalMatch) {
                                currentKey = A_CmsVfsDocument.getDocumentKey(containerpageTypeName, null);
                                result.add(currentKey);
                                hasGlobalMatch = this.m_extractionKeys.contains(currentKey);
                            }
                        }
                        String xmlcontentTypeName = CmsResourceTypeXmlContent.getStaticTypeName();
                        if (!resourceType.equals(containerpageTypeName) && !hasGlobalMatch && type instanceof CmsResourceTypeXmlContent) {
                            currentKey = A_CmsVfsDocument.getDocumentKey(xmlcontentTypeName, mimeType);
                            result.add(currentKey);
                            hasGlobalMatch = this.m_extractionKeys.contains(currentKey);
                            if (!hasGlobalMatch) {
                                currentKey = A_CmsVfsDocument.getDocumentKey(xmlcontentTypeName, null);
                                result.add(currentKey);
                                hasGlobalMatch = this.m_extractionKeys.contains(currentKey);
                            }
                        }
                    }
                    catch (Throwable t) {
                        LOG.warn((Object)("Could not read type for name \"" + resourceType + "\"."), t);
                    }
                    if (!hasGlobalMatch) {
                        result.add(A_CmsVfsDocument.getDocumentKey("__unconfigured__", mimeType));
                        result.add(A_CmsVfsDocument.getDocumentKey("__unconfigured__", null));
                    }
                }
            }
            result.add(A_CmsVfsDocument.getDocumentKey("__all__", mimeType));
            result.add(A_CmsVfsDocument.getDocumentKey("__all__", null));
        }
        return result;
    }

    public Map<String, I_CmsDocumentFactory> getDocumentTypeMapForTypeNames(List<String> documentTypeNames) {
        LinkedHashMap<String, I_CmsDocumentFactory> result = new LinkedHashMap<String, I_CmsDocumentFactory>();
        if (null != documentTypeNames) {
            ListIterator<String> typesIterator = documentTypeNames.listIterator(documentTypeNames.size());
            while (typesIterator.hasPrevious()) {
                Map<String, I_CmsDocumentFactory> factories = this.m_documentTypes.get(typesIterator.previous());
                if (null == factories) continue;
                result.putAll(factories);
            }
        }
        return result;
    }

    public float getExtractionCacheMaxAge() {
        return this.m_extractionCacheMaxAge;
    }

    public I_CmsSearchFieldConfiguration getFieldConfiguration(String name) {
        return this.m_fieldConfigurations.get(name);
    }

    public List<I_CmsSearchFieldConfiguration> getFieldConfigurations() {
        ArrayList<I_CmsSearchFieldConfiguration> result = new ArrayList<I_CmsSearchFieldConfiguration>(this.m_fieldConfigurations.values());
        Collections.sort(result);
        return Collections.unmodifiableList(result);
    }

    public List<CmsLuceneFieldConfiguration> getFieldConfigurationsLucene() {
        ArrayList<CmsLuceneFieldConfiguration> result = new ArrayList<CmsLuceneFieldConfiguration>();
        for (I_CmsSearchFieldConfiguration conf : this.m_fieldConfigurations.values()) {
            if (!(conf instanceof CmsLuceneFieldConfiguration)) continue;
            result.add((CmsLuceneFieldConfiguration)conf);
        }
        Collections.sort(result);
        return Collections.unmodifiableList(result);
    }

    public List<CmsSolrFieldConfiguration> getFieldConfigurationsSolr() {
        ArrayList<CmsSolrFieldConfiguration> result = new ArrayList<CmsSolrFieldConfiguration>();
        for (I_CmsSearchFieldConfiguration conf : this.m_fieldConfigurations.values()) {
            if (!(conf instanceof CmsSolrFieldConfiguration)) continue;
            result.add((CmsSolrFieldConfiguration)conf);
        }
        Collections.sort(result);
        return Collections.unmodifiableList(result);
    }

    public CmsSearchForceUnlockMode getForceunlock() {
        return this.m_forceUnlockMode;
    }

    public I_CmsTermHighlighter getHighlighter() {
        return this.m_highlighter;
    }

    public I_CmsSearchIndex getIndex(String indexName) {
        for (I_CmsSearchIndex index : this.m_indexes) {
            if (!indexName.equalsIgnoreCase(index.getName())) continue;
            return index;
        }
        return null;
    }

    public int getIndexLockMaxWaitSeconds() {
        return this.m_indexLockMaxWaitSeconds;
    }

    public List<String> getIndexNames() {
        ArrayList<String> indexNames = new ArrayList<String>();
        int n = this.m_indexes.size();
        for (int i = 0; i < n; ++i) {
            indexNames.add(this.m_indexes.get(i).getName());
        }
        return indexNames;
    }

    public CmsSolrIndex getIndexSolr(String indexName) {
        I_CmsSearchIndex index = this.getIndex(indexName);
        if (index instanceof CmsSolrIndex) {
            return (CmsSolrIndex)index;
        }
        return null;
    }

    public CmsSearchIndexSource getIndexSource(String sourceName) {
        return this.m_indexSources.get(sourceName);
    }

    public int getMaxExcerptLength() {
        return this.m_maxExcerptLength;
    }

    public long getMaxIndexWaitTime() {
        return this.m_maxIndexWaitTime;
    }

    public int getMaxModificationsBeforeCommit() {
        return this.m_maxModificationsBeforeCommit;
    }

    public long getOfflineUpdateFrequency() {
        return this.m_offlineUpdateFrequency;
    }

    public List<I_CmsSearchIndex> getSearchIndexes() {
        return Collections.unmodifiableList(this.m_indexes);
    }

    public List<I_CmsSearchIndex> getSearchIndexesAll() {
        return Collections.unmodifiableList(this.m_indexes);
    }

    public List<CmsSolrIndex> getSearchIndexesSolr() {
        ArrayList<CmsSolrIndex> indexes = new ArrayList<CmsSolrIndex>();
        for (I_CmsSearchIndex index : this.m_indexes) {
            if (!(index instanceof CmsSolrIndex)) continue;
            indexes.add((CmsSolrIndex)index);
        }
        return Collections.unmodifiableList(indexes);
    }

    public Map<String, CmsSearchIndexSource> getSearchIndexSources() {
        return Collections.unmodifiableMap(this.m_indexSources);
    }

    public CmsSolrSpellchecker getSolrDictionary() {
        if (this.m_coreContainer == null) {
            this.m_coreContainer = this.createCoreContainer();
        }
        return CmsSolrSpellchecker.getInstance(this.m_coreContainer);
    }

    public CmsSolrConfiguration getSolrServerConfiguration() {
        return this.m_solrConfig;
    }

    public long getTimeout() {
        return this.m_timeout;
    }

    public void initialize(CmsObject cms) throws CmsRoleViolationException {
        OpenCms.getRoleManager().checkRole(cms, CmsRole.WORKPLACE_MANAGER);
        try {
            this.m_adminCms = OpenCms.initCmsObject(cms);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        this.m_adminCms.getRequestContext().setSiteRoot("/");
        this.m_extractionResultCache = new CmsExtractionResultCache(OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(this.getDirectory()), "/extractCache");
        this.initializeFieldConfigurations();
        this.initializeIndexes();
        this.initOfflineIndexes();
        OpenCms.addCmsEventListener(this, new int[]{5, 2, 32, 35, 34});
    }

    public void initializeFieldConfigurations() {
        for (I_CmsSearchFieldConfiguration config : this.m_fieldConfigurations.values()) {
            config.init();
        }
    }

    public void initializeIndexes() {
        this.initAvailableDocumentTypes();
        this.initIndexSources();
        this.initSearchIndexes();
    }

    public void initOfflineIndexes() {
        ArrayList<I_CmsSearchIndex> offlineIndexes = new ArrayList<I_CmsSearchIndex>();
        for (I_CmsSearchIndex index : this.m_indexes) {
            if (!"offline".equals(index.getRebuildMode())) continue;
            offlineIndexes.add(index);
        }
        this.m_offlineIndexes = offlineIndexes;
        this.m_offlineHandler.initialize();
    }

    public void initSpellcheckIndex(final CmsObject adminCms) {
        CmsSolrSpellchecker spellchecker;
        if (CmsSpellcheckDictionaryIndexer.updatingIndexNecessesary(adminCms) && (spellchecker = OpenCms.getSearchManager().getSolrDictionary()) != null) {
            Runnable initRunner = new Runnable(){

                @Override
                public void run() {
                    try {
                        spellchecker.parseAndAddDictionaries(adminCms);
                    }
                    catch (CmsRoleViolationException e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            };
            new Thread(initRunner).start();
        }
    }

    public boolean isOfflineIndexingPaused() {
        return this.m_offlineUpdateFrequency == Long.MAX_VALUE;
    }

    @Override
    public String launch(CmsObject cms, Map<String, String> parameters) throws Exception {
        CmsSearchManager manager = OpenCms.getSearchManager();
        CmsLogReport report = null;
        boolean writeLog = Boolean.valueOf(parameters.get(JOB_PARAM_WRITELOG));
        if (writeLog) {
            report = new CmsLogReport(cms.getRequestContext().getLocale(), CmsSearchManager.class);
        }
        ArrayList<String> updateList = null;
        String indexList = parameters.get(JOB_PARAM_INDEXLIST);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(indexList)) {
            updateList = new ArrayList<String>();
            String[] indexNames = CmsStringUtil.splitAsArray(indexList, '|');
            for (int i = 0; i < indexNames.length; ++i) {
                if (manager.getIndex(indexNames[i]) != null) {
                    updateList.add(indexNames[i]);
                    continue;
                }
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)Messages.get().getBundle().key("LOG_NO_INDEX_WITH_NAME_1", indexNames[i]));
            }
        }
        long startTime = System.currentTimeMillis();
        if (updateList == null) {
            manager.rebuildAllIndexes(report);
        } else {
            manager.rebuildIndexes(updateList, report);
        }
        long runTime = System.currentTimeMillis() - startTime;
        String finishMessage = Messages.get().getBundle().key("LOG_REBUILD_INDEXES_FINISHED_1", CmsStringUtil.formatRuntime(runTime));
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)finishMessage);
        }
        return finishMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsUUID pauseOfflineIndexing() {
        CmsUUID pauseId = new CmsUUID();
        Set<CmsUUID> set = this.m_pauseRequests;
        synchronized (set) {
            if (this.m_pauseRequests.isEmpty()) {
                LOG.info((Object)"Pausing offline indexing.");
                this.m_configuredOfflineIndexingFrequency = this.m_offlineUpdateFrequency;
                this.m_offlineUpdateFrequency = Long.MAX_VALUE;
                this.updateOfflineIndexes(0L);
            }
            this.m_pauseRequests.add(pauseId);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Added pause request with id " + pauseId));
            }
        }
        return pauseId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildAllIndexes(I_CmsReport report) throws CmsException {
        try {
            SEARCH_MANAGER_LOCK.lock();
            CmsMessageContainer container = null;
            int n = this.m_indexes.size();
            for (int i = 0; i < n; ++i) {
                I_CmsSearchIndex searchIndex = this.m_indexes.get(i);
                try {
                    this.updateIndex(searchIndex, report, null);
                    continue;
                }
                catch (CmsException e) {
                    container = new CmsMessageContainer(Messages.get(), "ERR_INDEX_REBUILD_ALL_1", searchIndex.getName());
                    LOG.error((Object)Messages.get().getBundle().key("ERR_INDEX_REBUILD_ALL_1", searchIndex.getName()), (Throwable)e);
                }
            }
            this.cleanExtractionCache();
            if (container != null) {
                throw new CmsSearchException(container);
            }
        }
        finally {
            SEARCH_MANAGER_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildIndex(String indexName, I_CmsReport report) throws CmsException {
        try {
            SEARCH_MANAGER_LOCK.lock();
            I_CmsSearchIndex index = this.getIndex(indexName);
            this.updateIndex(index, report, null);
            this.cleanExtractionCache();
        }
        finally {
            SEARCH_MANAGER_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildIndexes(List<String> indexNames, I_CmsReport report) throws CmsException {
        try {
            SEARCH_MANAGER_LOCK.lock();
            for (String indexName : indexNames) {
                I_CmsSearchIndex index = this.getIndex(indexName);
                if (index != null) {
                    this.updateIndex(index, report, null);
                    continue;
                }
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)Messages.get().getBundle().key("LOG_NO_INDEX_WITH_NAME_1", indexName));
            }
            this.cleanExtractionCache();
        }
        finally {
            SEARCH_MANAGER_LOCK.unlock();
        }
    }

    public void registerSolrIndex(CmsSolrIndex index) throws CmsConfigurationException {
        if (this.m_solrConfig == null || !this.m_solrConfig.isEnabled()) {
            throw new CmsConfigurationException(Messages.get().container("ERR_SOLR_NOT_ENABLED_0"));
        }
        if (index.getServerUrl() != null) {
            index.setSolrServer((SolrClient)new HttpSolrClient.Builder().withBaseSolrUrl(index.getServerUrl()).build());
        } else if (this.m_solrConfig.getServerUrl() != null) {
            index.setSolrServer((SolrClient)new HttpSolrClient.Builder().withBaseSolrUrl(this.m_solrConfig.getServerUrl()).build());
        } else {
            File instanceDir;
            if (this.m_coreContainer == null) {
                this.m_coreContainer = this.createCoreContainer();
            }
            if (this.m_coreContainer.getAllCoreNames().contains(index.getCoreName())) {
                this.m_coreContainer.unload(index.getCoreName(), false, false, true);
            }
            this.ensureIndexIsUnlocked(index.getPath());
            File dataDir = new File(index.getPath());
            if (!dataDir.exists()) {
                dataDir.mkdirs();
                if (CmsLog.INIT.isInfoEnabled()) {
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SOLR_INDEX_DIR_CREATED_2", index.getName(), index.getPath()));
                }
            }
            if (!(instanceDir = new File(this.m_solrConfig.getHome() + FileSystems.getDefault().getSeparator() + index.getName())).exists()) {
                instanceDir.mkdirs();
                if (CmsLog.INIT.isInfoEnabled()) {
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SOLR_INDEX_DIR_CREATED_2", index.getName(), index.getPath()));
                }
            }
            SolrCore core = null;
            try {
                HashMap<String, String> properties = new HashMap<String, String>(3);
                properties.put("dataDir", dataDir.getAbsolutePath());
                properties.put("configSet", "default");
                core = this.m_coreContainer.create(index.getCoreName(), instanceDir.toPath(), properties, false);
            }
            catch (NullPointerException e) {
                if (core != null) {
                    core.close();
                }
                throw new CmsConfigurationException(Messages.get().container("ERR_SOLR_SERVER_NOT_CREATED_3", index.getName() + " (" + index.getCoreName() + ")", index.getPath(), this.m_solrConfig.getSolrConfigFile().getAbsolutePath()), (Throwable)e);
            }
            if (index.isNoSolrServerSet()) {
                index.setSolrServer((SolrClient)new EmbeddedSolrServer(this.m_coreContainer, index.getCoreName()));
            }
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SOLR_SERVER_CREATED_1", index.getName() + " (" + index.getCoreName() + ")"));
            }
        }
    }

    public boolean removeSearchFieldConfiguration(I_CmsSearchFieldConfiguration fieldConfiguration) throws CmsIllegalStateException {
        if (fieldConfiguration.getName().equals("standard")) {
            throw new CmsIllegalStateException(Messages.get().container("ERR_INDEX_CONFIGURATION_DELETE_STANDARD_1", fieldConfiguration.getName()));
        }
        Iterator<I_CmsSearchIndex> itIndexes = this.m_indexes.iterator();
        ArrayList<I_CmsSearchIndex> referrers = new ArrayList<I_CmsSearchIndex>();
        while (itIndexes.hasNext()) {
            I_CmsSearchIndex idx = itIndexes.next();
            I_CmsSearchFieldConfiguration refFieldConfig = idx.getFieldConfiguration();
            if (!refFieldConfig.equals(fieldConfiguration)) continue;
            referrers.add(idx);
        }
        if (referrers.size() > 0) {
            throw new CmsIllegalStateException(Messages.get().container("ERR_INDEX_CONFIGURATION_DELETE_2", fieldConfiguration.getName(), ((Object)referrers).toString()));
        }
        return this.m_fieldConfigurations.remove(fieldConfiguration.getName()) != null;
    }

    public boolean removeSearchFieldConfigurationField(I_CmsSearchFieldConfiguration fieldConfiguration, CmsSearchField field) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_REMOVE_FIELDCONFIGURATION_FIELD_INDEX_2", field.getName(), fieldConfiguration.getName()));
        }
        return fieldConfiguration.getFields().remove(field);
    }

    public boolean removeSearchFieldMapping(CmsLuceneField field, CmsSearchFieldMapping mapping) throws CmsIllegalStateException {
        if (field.getMappings().size() < 2) {
            throw new CmsIllegalStateException(Messages.get().container("ERR_FIELD_MAPPING_DELETE_2", mapping.getType().toString(), field.getName()));
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_REMOVE_FIELD_MAPPING_INDEX_2", mapping.toString(), field.getName()));
        }
        return field.getMappings().remove(mapping);
    }

    public void removeSearchIndex(I_CmsSearchIndex searchIndex) {
        searchIndex.shutDown();
        if (searchIndex instanceof CmsSolrIndex) {
            CmsSolrIndex solrIndex = (CmsSolrIndex)searchIndex;
            this.m_coreContainer.unload(solrIndex.getCoreName(), true, true, true);
        }
        this.m_indexes.remove(searchIndex);
        this.initOfflineIndexes();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_REMOVE_SEARCH_INDEX_2", searchIndex.getName(), searchIndex.getProject()));
        }
    }

    public void removeSearchIndexes(List<String> indexNames) {
        for (String indexName : indexNames) {
            I_CmsSearchIndex index = this.getIndex(indexName);
            if (index != null) {
                this.removeSearchIndex(index);
                continue;
            }
            if (!LOG.isWarnEnabled()) continue;
            LOG.warn((Object)Messages.get().getBundle().key("LOG_NO_INDEX_WITH_NAME_1", indexName));
        }
    }

    public boolean removeSearchIndexSource(CmsSearchIndexSource indexsource) throws CmsIllegalStateException {
        Iterator<I_CmsSearchIndex> itIndexes = this.m_indexes.iterator();
        ArrayList<I_CmsSearchIndex> referrers = new ArrayList<I_CmsSearchIndex>();
        while (itIndexes.hasNext()) {
            I_CmsSearchIndex idx = itIndexes.next();
            List<CmsSearchIndexSource> refsources = idx.getSources();
            if (refsources == null || !refsources.contains(indexsource)) continue;
            referrers.add(idx);
        }
        if (referrers.size() > 0) {
            throw new CmsIllegalStateException(Messages.get().container("ERR_INDEX_SOURCE_DELETE_2", indexsource.getName(), ((Object)referrers).toString()));
        }
        return this.m_indexSources.remove(indexsource.getName()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeOfflineIndexing(CmsUUID pauseId) {
        Set<CmsUUID> set = this.m_pauseRequests;
        synchronized (set) {
            if (!this.m_pauseRequests.contains(pauseId)) {
                try {
                    throw new IllegalArgumentException();
                }
                catch (IllegalArgumentException e) {
                    LOG.warn((Object)("Cannot resume for pause request " + pauseId + ". The request id is unknown."), (Throwable)e);
                }
            } else {
                this.m_pauseRequests.remove(pauseId);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Removed pause request " + pauseId + " from pause requests. Remaining pauses are: " + this.m_pauseRequests));
                }
                if (this.m_pauseRequests.isEmpty()) {
                    LOG.info((Object)"Resuming offline indexing.");
                    this.setOfflineUpdateFrequency(this.m_configuredOfflineIndexingFrequency > 0L ? this.m_configuredOfflineIndexingFrequency : 15000L);
                }
            }
        }
    }

    public void setDirectory(String value) {
        this.m_path = value;
    }

    public void setExtractionCacheMaxAge(float extractionCacheMaxAge) {
        this.m_extractionCacheMaxAge = extractionCacheMaxAge;
    }

    public void setExtractionCacheMaxAge(String extractionCacheMaxAge) {
        try {
            this.setExtractionCacheMaxAge(Float.parseFloat(extractionCacheMaxAge));
        }
        catch (NumberFormatException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_PARSE_EXTRACTION_CACHE_AGE_FAILED_2", extractionCacheMaxAge, Float.valueOf(672.0f)), (Throwable)e);
            this.setExtractionCacheMaxAge(672.0f);
        }
    }

    public void setForceunlock(String value) {
        this.m_forceUnlockMode = CmsSearchForceUnlockMode.valueOf(value);
    }

    public void setHighlighter(String highlighter) {
        try {
            this.m_highlighter = (I_CmsTermHighlighter)Class.forName(highlighter).newInstance();
        }
        catch (Exception e) {
            this.m_highlighter = null;
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void setIndexLockMaxWaitSeconds(int value) {
        this.m_indexLockMaxWaitSeconds = value;
    }

    public void setMaxExcerptLength(int maxExcerptLength) {
        this.m_maxExcerptLength = maxExcerptLength;
    }

    public void setMaxExcerptLength(String maxExcerptLength) {
        try {
            this.setMaxExcerptLength(Integer.parseInt(maxExcerptLength));
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_PARSE_EXCERPT_LENGTH_FAILED_2", maxExcerptLength, 1024), (Throwable)e);
            this.setMaxExcerptLength(1024);
        }
    }

    public void setMaxIndexWaitTime(long maxIndexWaitTime) {
        this.m_maxIndexWaitTime = maxIndexWaitTime;
    }

    public void setMaxIndexWaitTime(String maxIndexWaitTime) {
        try {
            this.setMaxIndexWaitTime(Long.parseLong(maxIndexWaitTime));
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_PARSE_MAX_INDEX_WAITTIME_FAILED_2", maxIndexWaitTime, 30000L), (Throwable)e);
            this.setMaxIndexWaitTime(30000L);
        }
    }

    public void setMaxModificationsBeforeCommit(int maxModificationsBeforeCommit) {
        this.m_maxModificationsBeforeCommit = maxModificationsBeforeCommit;
    }

    public void setMaxModificationsBeforeCommit(String value) {
        try {
            this.setMaxModificationsBeforeCommit(Integer.parseInt(value));
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_PARSE_MAXCOMMIT_FAILED_2", value, 500), (Throwable)e);
            this.setMaxModificationsBeforeCommit(500);
        }
    }

    public void setOfflineUpdateFrequency(long offlineUpdateFrequency) {
        this.m_offlineUpdateFrequency = offlineUpdateFrequency;
        this.updateOfflineIndexes(0L);
    }

    public void setOfflineUpdateFrequency(String offlineUpdateFrequency) {
        try {
            this.setOfflineUpdateFrequency(Long.parseLong(offlineUpdateFrequency));
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_PARSE_OFFLINE_UPDATE_FAILED_2", offlineUpdateFrequency, 15000L), (Throwable)e);
            this.setOfflineUpdateFrequency(15000L);
        }
    }

    public void setSolrServerConfiguration(CmsSolrConfiguration config) {
        this.m_solrConfig = config;
    }

    public void setTimeout(long value) {
        this.m_timeout = value;
    }

    public void setTimeout(String value) {
        try {
            this.setTimeout(Long.parseLong(value));
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_PARSE_TIMEOUT_FAILED_2", value, 60000L), (Throwable)e);
            this.setTimeout(60000L);
        }
    }

    public void shutDown() {
        if (this.m_offlineIndexThread != null) {
            this.m_offlineIndexThread.shutDown();
        }
        if (this.m_offlineHandler != null) {
            OpenCms.removeCmsEventListener(this.m_offlineHandler);
        }
        for (I_CmsSearchIndex index : this.m_indexes) {
            index.shutDown();
            Object var2_2 = null;
        }
        this.m_indexes.clear();
        this.shutDownSolrContainer();
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SHUTDOWN_MANAGER_0"));
        }
    }

    public void updateOfflineIndexes() {
        this.updateOfflineIndexes(this.getMaxIndexWaitTime());
    }

    public void updateOfflineIndexes(long waitTime) {
        if (this.m_offlineIndexThread != null && this.m_offlineIndexThread.isAlive()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_OI_UPDATE_INTERRUPT_0"));
            }
            this.m_offlineIndexThread.interrupt();
            if (waitTime > 0L) {
                this.m_offlineIndexThread.getWaitHandle().enter(waitTime);
            }
        }
    }

    protected List<CmsPublishedResource> addAdditionallyAffectedResources(CmsObject adminCms, List<CmsPublishedResource> updateResources) {
        if (updateResources.size() > 0) {
            HashSet<CmsPublishedResource> updateResourceSet = new HashSet<CmsPublishedResource>(updateResources);
            Collection<Object> resourcesToCheck = updateResourceSet;
            Collection<Object> additionalResources = Collections.emptySet();
            do {
                additionalResources = this.findRelatedContainerPages(adminCms, updateResourceSet, resourcesToCheck);
                additionalResources.addAll(this.addIndexContentRelatedResources(adminCms, updateResourceSet, resourcesToCheck));
                updateResources.addAll(additionalResources);
                updateResourceSet.addAll(additionalResources);
            } while ((resourcesToCheck = additionalResources).size() > 0);
        }
        return updateResources;
    }

    protected Collection<CmsPublishedResource> addIndexContentRelatedResources(CmsObject adminCms, Collection<CmsPublishedResource> updateResources, Collection<CmsPublishedResource> updateResourcesToCheck) {
        HashSet<CmsPublishedResource> additionalUpdateResources = new HashSet<CmsPublishedResource>();
        for (CmsPublishedResource checkedRes : updateResourcesToCheck) {
            try {
                CmsRelationFilter filter = CmsRelationFilter.relationsToStructureId(checkedRes.getStructureId());
                filter = filter.filterType(CmsRelationType.INDEX_CONTENT);
                List<CmsRelation> relations = adminCms.readRelations(filter);
                for (CmsRelation relation : relations) {
                    CmsResource res = relation.getSource(adminCms, CmsResourceFilter.ALL);
                    CmsPublishedResource additionalPubRes = new CmsPublishedResource(res);
                    if (updateResources.contains(additionalPubRes)) continue;
                    additionalUpdateResources.add(additionalPubRes);
                }
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return additionalUpdateResources;
    }

    protected void cleanExtractionCache() {
        this.m_extractionResultCache.cleanCache(this.m_extractionCacheMaxAge);
    }

    protected Collection<CmsPublishedResource> findRelatedContainerPages(CmsObject adminCms, Collection<CmsPublishedResource> updateResources, Collection<CmsPublishedResource> updateResourcesToCheck) {
        CmsResourceManager resMan = OpenCms.getResourceManager();
        HashSet<CmsPublishedResource> additionalUpdateResources = new HashSet<CmsPublishedResource>();
        HashSet<CmsResource> containerPages = new HashSet<CmsResource>();
        int containerPageTypeId = -1;
        try {
            containerPageTypeId = CmsResourceTypeXmlContainerPage.getContainerPageTypeId();
        }
        catch (CmsLoaderException e) {
            LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        if (containerPageTypeId != -1) {
            for (CmsPublishedResource pubRes : updateResourcesToCheck) {
                try {
                    if (resMan.getResourceType(pubRes.getType()) instanceof CmsResourceTypeXmlContent && !this.isGroup(pubRes.getType())) {
                        CmsRelationFilter filter = CmsRelationFilter.relationsToStructureId(pubRes.getStructureId()).filterStrong();
                        List<CmsRelation> relations = adminCms.readRelations(filter);
                        for (CmsRelation relation : relations) {
                            CmsResource res = relation.getSource(adminCms, CmsResourceFilter.ALL);
                            if (!CmsResourceTypeXmlContainerPage.isContainerPage(res)) continue;
                            containerPages.add(res);
                            if (!CmsDetailOnlyContainerUtil.isDetailContainersPage(adminCms, adminCms.getSitePath(res))) continue;
                            this.addDetailContent(adminCms, containerPages, adminCms.getSitePath(res));
                        }
                    }
                    if (containerPageTypeId != pubRes.getType()) continue;
                    this.addDetailContent(adminCms, containerPages, adminCms.getRequestContext().removeSiteRoot(pubRes.getRootPath()));
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            for (CmsResource page : containerPages) {
                CmsPublishedResource pubCont = new CmsPublishedResource(page);
                if (updateResources.contains(pubCont)) continue;
                additionalUpdateResources.add(pubCont);
            }
        }
        return additionalUpdateResources;
    }

    protected List<String> getDocumentTypes() {
        return Collections.unmodifiableList(new ArrayList<String>(this.m_documentTypes.keySet()));
    }

    protected CmsProject getOfflineIndexProject() {
        CmsProject result = null;
        for (I_CmsSearchIndex index : this.m_offlineIndexes) {
            try {
                result = this.m_adminCms.readProject(index.getProject());
                if (result.isOnlineProject()) continue;
                break;
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    protected CmsIndexingThreadManager getThreadManager() {
        return new CmsIndexingThreadManager(this.m_timeout, this.m_maxModificationsBeforeCommit);
    }

    protected void initAvailableDocumentTypes() {
        CmsSearchDocumentType documenttype = null;
        String className = null;
        String name = null;
        I_CmsDocumentFactory documentFactory = null;
        List<String> resourceTypes = null;
        List<String> mimeTypes = null;
        Class<?> c = null;
        this.m_documentTypes = new LinkedHashMap<String, Map<String, I_CmsDocumentFactory>>();
        int n = this.m_documentTypeConfigs.size();
        for (int i = 0; i < n; ++i) {
            documenttype = this.m_documentTypeConfigs.get(i);
            name = documenttype.getName();
            try {
                className = documenttype.getClassName();
                resourceTypes = documenttype.getResourceTypes();
                mimeTypes = documenttype.getMimeTypes();
                if (name == null) {
                    throw new CmsIndexException(Messages.get().container("ERR_DOCTYPE_NO_NAME_0"));
                }
                if (className == null) {
                    throw new CmsIndexException(Messages.get().container("ERR_DOCTYPE_NO_CLASS_DEF_0"));
                }
                if (resourceTypes.size() == 0) {
                    throw new CmsIndexException(Messages.get().container("ERR_DOCTYPE_NO_RESOURCETYPE_DEF_0"));
                }
                try {
                    c = Class.forName(className);
                    documentFactory = (I_CmsDocumentFactory)c.getConstructor(String.class).newInstance(name);
                }
                catch (ClassNotFoundException exc) {
                    throw new CmsIndexException(Messages.get().container("ERR_DOCCLASS_NOT_FOUND_1", className), (Throwable)exc);
                }
                catch (Exception exc) {
                    throw new CmsIndexException(Messages.get().container("ERR_DOCCLASS_INIT_1", className), (Throwable)exc);
                }
                if (documentFactory.isUsingCache()) {
                    documentFactory.setCache(this.m_extractionResultCache);
                }
                HashMap<String, I_CmsDocumentFactory> matchingTypes = new HashMap<String, I_CmsDocumentFactory>();
                for (String key : documentFactory.getDocumentKeys(resourceTypes, mimeTypes)) {
                    matchingTypes.put(key, documentFactory);
                    this.m_extractionKeys.add(key);
                }
                this.m_documentTypes.put(name, matchingTypes);
                continue;
            }
            catch (CmsException e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)Messages.get().getBundle().key("LOG_DOCTYPE_CONFIG_FAILED_1", name), (Throwable)e);
            }
        }
    }

    protected void initIndexSources() {
        for (CmsSearchIndexSource source : this.m_indexSources.values()) {
            source.init();
        }
    }

    protected void initSearchIndexes() {
        I_CmsSearchIndex index = null;
        int n = this.m_indexes.size();
        for (int i = 0; i < n; ++i) {
            block5: {
                index = this.m_indexes.get(i);
                index.setEnabled(true);
                if (index.checkConfiguration(this.m_adminCms)) {
                    try {
                        index.initialize();
                    }
                    catch (Exception e) {
                        if (!CmsLog.INIT.isWarnEnabled()) break block5;
                        CmsLog.INIT.warn((Object)Messages.get().getBundle().key("INIT_SEARCH_INIT_FAILED_1", index), (Throwable)e);
                    }
                }
            }
            if (!CmsLog.INIT.isInfoEnabled()) continue;
            if (index.isEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_INDEX_CONFIGURED_2", index, index.getProject()));
                continue;
            }
            CmsLog.INIT.warn((Object)Messages.get().getBundle().key("INIT_INDEX_NOT_CONFIGURED_2", index, index.getProject()));
        }
    }

    protected boolean shouldUpdateAtAll(I_CmsSearchIndex index) {
        if ("never".equals(index.getRebuildMode())) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_SKIP_REBUILD_FOR_MODE_NEVER_1", index.getName()));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAllIndexes(CmsObject adminCms, CmsUUID publishHistoryId, I_CmsReport report) {
        int oldPriority = Thread.currentThread().getPriority();
        try {
            List<CmsPublishedResource> publishedResources;
            SEARCH_MANAGER_LOCK.lock();
            Thread.currentThread().setPriority(1);
            try {
                publishedResources = adminCms.readPublishedResources(publishHistoryId);
            }
            catch (CmsException e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_READING_CHANGED_RESOURCES_FAILED_1", publishHistoryId), (Throwable)e);
                SEARCH_MANAGER_LOCK.unlock();
                Thread.currentThread().setPriority(oldPriority);
                return;
            }
            Set<CmsUUID> bothNewAndDeleted = this.getIdsOfPublishResourcesWhichAreBothNewAndDeleted(publishedResources);
            ArrayList<CmsPublishedResource> updateResources = new ArrayList<CmsPublishedResource>();
            for (CmsPublishedResource res : publishedResources) {
                if (res.isFolder() || res.getState().isUnchanged() || !res.getState().isDeleted() && !res.getState().isNew() && !res.getState().isChanged()) continue;
                if (updateResources.contains(res)) {
                    boolean hasMoved;
                    boolean bl = hasMoved = bothNewAndDeleted.contains(res.getStructureId()) || res.getMovedState() == CmsPublishedResource.STATE_MOVED_DESTINATION || res.getMovedState() == CmsPublishedResource.STATE_MOVED_SOURCE;
                    if (!hasMoved) {
                        updateResources.remove(res);
                    }
                    updateResources.add(res);
                    continue;
                }
                updateResources.add(res);
                if (res.getState().isDeleted() || res.getSiblingCount() <= 1) continue;
                try {
                    List<CmsResource> siblings = adminCms.readSiblings(res.getRootPath(), CmsResourceFilter.ALL);
                    for (CmsResource sibling : siblings) {
                        CmsPublishedResource sib = new CmsPublishedResource(sibling);
                        if (updateResources.contains(sib)) continue;
                        updateResources.add(sib);
                    }
                }
                catch (CmsException e) {
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_UNABLE_TO_READ_SIBLINGS_1", res.getRootPath()), (Throwable)e);
                }
            }
            this.addAdditionallyAffectedResources(adminCms, updateResources);
            this.updateAllIndexes(adminCms, updateResources, report);
        }
        finally {
            SEARCH_MANAGER_LOCK.unlock();
            Thread.currentThread().setPriority(oldPriority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAllIndexes(CmsObject adminCms, List<CmsPublishedResource> updateResources, I_CmsReport report) {
        try {
            SEARCH_MANAGER_LOCK.lock();
            if (!updateResources.isEmpty()) {
                Collections.sort(updateResources);
                for (I_CmsSearchIndex index : this.m_indexes) {
                    if (!"auto".equals(index.getRebuildMode())) continue;
                    try {
                        this.updateIndex(index, report, updateResources);
                    }
                    catch (CmsException e) {
                        LOG.error((Object)Messages.get().getBundle().key("LOG_UPDATE_INDEX_FAILED_1", index.getName()), (Throwable)e);
                    }
                }
            }
            this.cleanExtractionCache();
        }
        finally {
            SEARCH_MANAGER_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateIndex(I_CmsSearchIndex index, I_CmsReport report, List<CmsPublishedResource> resourcesToIndex) throws CmsException {
        if (this.shouldUpdateAtAll(index)) {
            try {
                SEARCH_MANAGER_LOCK.lock();
                CmsObject cms = OpenCms.initCmsObject(this.m_adminCms);
                if (report == null) {
                    report = new CmsLogReport(cms.getRequestContext().getLocale(), CmsSearchManager.class);
                }
                if (!index.checkConfiguration(cms)) {
                    return;
                }
                cms.getRequestContext().setSiteRoot("/");
                cms.getRequestContext().setCurrentProject(cms.readProject(index.getProject()));
                if (resourcesToIndex == null || resourcesToIndex.isEmpty()) {
                    this.updateIndexCompletely(cms, index, report);
                } else {
                    this.updateIndexIncremental(cms, index, report, resourcesToIndex);
                }
            }
            finally {
                SEARCH_MANAGER_LOCK.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateIndexCompletely(CmsObject cms, I_CmsSearchIndex index, I_CmsReport report) throws CmsIndexException {
        CmsIndexingThreadManager threadManager = this.getThreadManager();
        boolean isOfflineIndex = false;
        if ("offline".equals(index.getRebuildMode())) {
            isOfflineIndex = true;
            index.setRebuildMode("manual");
            this.initOfflineIndexes();
        }
        I_CmsIndexWriter writer = null;
        try {
            CmsSearchIndex indexInternal = null;
            String backup = null;
            if (index instanceof CmsSearchIndex && (backup = (indexInternal = (CmsSearchIndex)index).createIndexBackup()) != null) {
                indexInternal.indexSearcherOpen(backup);
            }
            if ((writer = index.getIndexWriter(report, true)) instanceof I_CmsSolrIndexWriter) {
                try {
                    ((I_CmsSolrIndexWriter)writer).deleteAllDocuments();
                }
                catch (IOException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            report.println(Messages.get().container("RPT_SEARCH_INDEXING_REBUILD_BEGIN_1", index.getName()), 2);
            for (CmsSearchIndexSource source : index.getSources()) {
                block23: {
                    I_CmsIndexer indexer = source.getIndexer().newInstance(cms, report, index);
                    indexer.rebuildIndex(writer, threadManager, source);
                    while (threadManager.isRunning()) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    try {
                        writer.commit();
                    }
                    catch (IOException e) {
                        if (!LOG.isWarnEnabled()) break block23;
                        LOG.warn((Object)Messages.get().getBundle().key("LOG_IO_INDEX_WRITER_COMMIT_2", index.getName(), index.getPath()), (Throwable)e);
                    }
                }
                try {
                    writer.optimize();
                }
                catch (IOException e) {
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_IO_INDEX_WRITER_OPTIMIZE_2", index.getName(), index.getPath()), (Throwable)e);
                }
            }
            if (backup != null) {
                indexInternal.indexSearcherClose();
                indexInternal.removeIndexBackup(backup);
            }
            report.println(Messages.get().container("RPT_SEARCH_INDEXING_REBUILD_END_1", index.getName()), 2);
        }
        finally {
            block25: {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        if (!LOG.isWarnEnabled()) break block25;
                        LOG.warn((Object)Messages.get().getBundle().key("LOG_IO_INDEX_WRITER_CLOSE_2", index.getPath(), index.getName()), (Throwable)e);
                    }
                }
            }
            if (isOfflineIndex) {
                index.setRebuildMode("offline");
                this.initOfflineIndexes();
            }
            index.onIndexChanged(true);
        }
        threadManager.reportStatistics(report);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateIndexIncremental(CmsObject cms, I_CmsSearchIndex index, I_CmsReport report, List<CmsPublishedResource> resourcesToIndex) throws CmsException {
        block19: {
            try {
                SEARCH_MANAGER_LOCK.lock();
                ArrayList<CmsSearchIndexUpdateData> updateCollections = new ArrayList<CmsSearchIndexUpdateData>();
                boolean hasResourcesToDelete = false;
                boolean hasResourcesToUpdate = false;
                for (CmsSearchIndexSource source : index.getSources()) {
                    I_CmsIndexer indexer = source.getIndexer().newInstance(cms, report, index);
                    CmsSearchIndexUpdateData updateData = indexer.getUpdateData(source, resourcesToIndex);
                    if (updateData.isEmpty()) continue;
                    updateCollections.add(updateData);
                    hasResourcesToDelete |= updateData.hasResourcesToDelete();
                    hasResourcesToUpdate |= updateData.hasResourceToUpdate();
                }
                if (!hasResourcesToDelete && !hasResourcesToUpdate) break block19;
                report.println(Messages.get().container("RPT_SEARCH_INDEXING_UPDATE_BEGIN_1", index.getName()), 2);
                I_CmsIndexWriter writer = null;
                try {
                    writer = index.getIndexWriter(report, false);
                    if (hasResourcesToDelete) {
                        for (CmsSearchIndexUpdateData updateCollection : updateCollections) {
                            if (!updateCollection.hasResourcesToDelete()) continue;
                            updateCollection.getIndexer().deleteResources(writer, updateCollection.getResourcesToDelete());
                        }
                    }
                    if (hasResourcesToUpdate) {
                        CmsIndexingThreadManager threadManager = this.getThreadManager();
                        for (CmsSearchIndexUpdateData updateCollection : updateCollections) {
                            if (!updateCollection.hasResourceToUpdate()) continue;
                            updateCollection.getIndexer().updateResources(writer, threadManager, updateCollection.getResourcesToUpdate());
                        }
                        while (threadManager.isRunning()) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e) {
                                LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                            }
                        }
                    }
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.commit();
                        }
                        catch (IOException e) {
                            LOG.error((Object)Messages.get().getBundle().key("LOG_IO_INDEX_WRITER_COMMIT_2", index.getName(), index.getPath()), (Throwable)e);
                        }
                    }
                    index.onIndexChanged(false);
                }
                report.println(Messages.get().container("RPT_SEARCH_INDEXING_UPDATE_END_1", index.getName()), 2);
            }
            finally {
                SEARCH_MANAGER_LOCK.unlock();
            }
        }
    }

    protected void updateIndexOffline(I_CmsReport report, List<CmsPublishedResource> resourcesToIndex) {
        CmsObject cms = this.m_adminCms;
        try {
            cms = OpenCms.initCmsObject(this.m_adminCms);
            cms.getRequestContext().setSiteRoot("/");
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        for (I_CmsSearchIndex index : this.m_offlineIndexes) {
            if (index.getSources() == null) continue;
            try {
                cms.getRequestContext().setCurrentProject(cms.readProject(index.getProject()));
                this.updateIndexIncremental(cms, index, report, resourcesToIndex);
            }
            catch (CmsException e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_UPDATE_INDEX_FAILED_1", index.getName()), (Throwable)e);
            }
        }
    }

    private void addDetailContent(CmsObject adminCms, Set<CmsResource> containerPages, String containerPage) {
        block3: {
            if (CmsDetailOnlyContainerUtil.isDetailContainersPage(adminCms, containerPage)) {
                try {
                    CmsResource detailRes = adminCms.readResource(CmsDetailOnlyContainerUtil.getDetailContentPath(containerPage), CmsResourceFilter.IGNORE_EXPIRATION);
                    containerPages.add(detailRes);
                }
                catch (Throwable e) {
                    if (!LOG.isWarnEnabled()) break block3;
                    LOG.warn((Object)e.getLocalizedMessage(), e);
                }
            }
        }
    }

    private CoreContainer createCoreContainer() {
        CoreContainer container = null;
        try {
            container = CoreContainer.createAndLoad((Path)Paths.get(this.m_solrConfig.getHome(), new String[0]), (Path)this.m_solrConfig.getSolrFile().toPath());
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SOLR_CORE_CONTAINER_CREATED_2", this.m_solrConfig.getHome(), this.m_solrConfig.getSolrFile().getName()));
            }
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("ERR_SOLR_CORE_CONTAINER_NOT_CREATED_1", this.m_solrConfig.getSolrFile().getAbsolutePath()), (Throwable)e);
        }
        return container;
    }

    private void ensureIndexIsUnlocked(String dataDir) {
        ArrayList<File> lockFiles = new ArrayList<File>(2);
        lockFiles.add(new File(CmsFileUtil.addTrailingSeparator(CmsFileUtil.addTrailingSeparator(dataDir) + "index") + "write.lock"));
        lockFiles.add(new File(CmsFileUtil.addTrailingSeparator(CmsFileUtil.addTrailingSeparator(dataDir) + "spellcheck") + "write.lock"));
        for (File lockFile : lockFiles) {
            if (!lockFile.exists()) continue;
            lockFile.delete();
            LOG.warn((Object)("Forcely unlocking index with data dir \"" + dataDir + "\" by removing file \"" + lockFile.getAbsolutePath() + "\"."));
        }
    }

    private I_CmsReport getEventReport(CmsEvent event) {
        I_CmsReport report = null;
        if (event.getData() != null) {
            report = (I_CmsReport)event.getData().get("report");
        }
        if (report == null) {
            report = new CmsLogReport(Locale.ENGLISH, this.getClass());
        }
        return report;
    }

    private Set<CmsUUID> getIdsOfPublishResourcesWhichAreBothNewAndDeleted(List<CmsPublishedResource> publishedResources) {
        HashSet<CmsUUID> result = new HashSet<CmsUUID>();
        HashSet<CmsUUID> deletedSet = new HashSet<CmsUUID>();
        for (CmsPublishedResource pubRes : publishedResources) {
            if (pubRes.getState().isNew()) {
                result.add(pubRes.getStructureId());
            }
            if (!pubRes.getState().isDeleted()) continue;
            deletedSet.add(pubRes.getStructureId());
        }
        result.retainAll(deletedSet);
        return result;
    }

    private boolean isGroup(int type) {
        for (String groupType : groupTypes) {
            if (!OpenCms.getResourceManager().matchResourceType(groupType, type)) continue;
            return true;
        }
        return false;
    }

    private void shutDownSolrContainer() {
        if (this.m_coreContainer != null) {
            for (SolrCore core : this.m_coreContainer.getCores()) {
                if (core.getName().equals("spellcheck")) continue;
                this.m_coreContainer.unload(core.getName(), false, false, true);
            }
            this.m_coreContainer.shutdown();
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SOLR_SHUTDOWN_SUCCESS_0"));
            }
            this.m_coreContainer = null;
        }
    }

    protected class CmsSearchOfflineHandler
    implements I_CmsEventListener {
        private boolean m_isEventRegistered;
        private List<CmsPublishedResource> m_resourcesToIndex = new ArrayList<CmsPublishedResource>();

        protected CmsSearchOfflineHandler() {
        }

        @Override
        public void cmsEvent(CmsEvent event) {
            Object change = event.getData().get("change");
            switch (event.getType()) {
                case 11: 
                case 14: 
                case 15: 
                case 23: {
                    if (change != null && change.equals(0)) {
                        return;
                    }
                    Object skip = event.getData().get("skipindex");
                    if (skip != null) {
                        return;
                    }
                    List<CmsResource> resources = Collections.singletonList((CmsResource)event.getData().get("resource"));
                    this.reIndexResources(resources);
                    break;
                }
                case 25: {
                    List eventResources = (List)event.getData().get("resources");
                    ArrayList<CmsResource> resourcesToDelete = new ArrayList<CmsResource>(eventResources);
                    for (CmsResource res : resourcesToDelete) {
                        if (!res.getState().isNew()) continue;
                        res.setState(CmsResourceState.STATE_DELETED);
                    }
                    this.reIndexResources(resourcesToDelete);
                    break;
                }
                case 27: {
                    if ("createSibling".equals(change)) {
                        List resList = (List)event.getData().get("resources");
                        if (resList == null || resList.size() < 3) break;
                        System.out.println("Sibling creation case, resource = " + ((CmsResource)resList.get(1)).getRootPath());
                        this.reIndexResources(Collections.singletonList((CmsResource)resList.get(1)));
                        break;
                    }
                    this.reIndexResources((List)event.getData().get("resources"));
                    break;
                }
                case 12: 
                case 22: 
                case 24: {
                    this.reIndexResources((List)event.getData().get("resources"));
                    break;
                }
            }
        }

        protected synchronized void addResourcesToIndex(List<CmsPublishedResource> resourcesToIndex) {
            this.m_resourcesToIndex.addAll(resourcesToIndex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<CmsPublishedResource> getResourcesToIndex() {
            List<CmsPublishedResource> result;
            CmsSearchOfflineHandler cmsSearchOfflineHandler = this;
            synchronized (cmsSearchOfflineHandler) {
                result = this.m_resourcesToIndex;
                this.m_resourcesToIndex = new ArrayList<CmsPublishedResource>();
            }
            try {
                CmsObject cms = CmsSearchManager.this.m_adminCms;
                CmsProject offline = CmsSearchManager.this.getOfflineIndexProject();
                if (offline != null) {
                    cms = OpenCms.initCmsObject(CmsSearchManager.this.m_adminCms);
                    cms.getRequestContext().setCurrentProject(offline);
                }
                CmsSearchManager.this.addAdditionallyAffectedResources(cms, result);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return result;
        }

        protected void initialize() {
            if (CmsSearchManager.this.m_offlineIndexes.size() > 0) {
                if (CmsSearchManager.this.m_offlineIndexThread == null || !CmsSearchManager.this.m_offlineIndexThread.isAlive()) {
                    CmsSearchManager.this.m_offlineIndexThread = new CmsSearchOfflineIndexThread(this);
                    CmsSearchManager.this.m_offlineIndexThread.start();
                }
            } else if (CmsSearchManager.this.m_offlineIndexThread != null && CmsSearchManager.this.m_offlineIndexThread.isAlive()) {
                CmsSearchManager.this.m_offlineIndexThread.shutDown();
                CmsSearchManager.this.m_offlineIndexThread = null;
            }
            if (!this.m_isEventRegistered && CmsSearchManager.this.m_offlineIndexes.size() > 0) {
                this.m_isEventRegistered = true;
                OpenCms.addCmsEventListener(this, new int[]{14, 23, 15, 11, 27, 22, 25, 24, 12});
            }
        }

        protected synchronized void reIndexResources(List<CmsResource> resources) {
            ArrayList<CmsPublishedResource> resourcesToIndex = new ArrayList<CmsPublishedResource>(resources.size());
            for (CmsResource res : resources) {
                CmsPublishedResource pubRes = new CmsPublishedResource(res);
                resourcesToIndex.add(pubRes);
            }
            if (resourcesToIndex.size() > 0) {
                this.addResourcesToIndex(resourcesToIndex);
            }
        }
    }

    public static final class CmsSearchForceUnlockMode
    extends A_CmsModeStringEnumeration {
        public static final CmsSearchForceUnlockMode ALWAYS = new CmsSearchForceUnlockMode("always");
        public static final CmsSearchForceUnlockMode NEVER = new CmsSearchForceUnlockMode("never");
        public static final CmsSearchForceUnlockMode ONLYFULL = new CmsSearchForceUnlockMode("onlyfull");
        private static final long serialVersionUID = 74746076708908673L;

        protected CmsSearchForceUnlockMode(String mode) {
            super(mode);
        }

        public static CmsSearchForceUnlockMode valueOf(String type) {
            if (type.equals(ALWAYS.toString())) {
                return ALWAYS;
            }
            if (type.equals(NEVER.toString())) {
                return NEVER;
            }
            return ONLYFULL;
        }
    }

    protected class CmsSearchOfflineIndexThread
    extends Thread {
        CmsSearchOfflineHandler m_handler;
        boolean m_isAlive;
        private boolean m_isUpdating;
        private boolean m_updateTriggered;
        private CmsWaitHandle m_waitHandle;

        protected CmsSearchOfflineIndexThread(CmsSearchOfflineHandler handler) {
            super("OpenCms: Offline Search Indexer");
            this.m_waitHandle = new CmsWaitHandle();
            this.m_handler = handler;
        }

        public CmsWaitHandle getWaitHandle() {
            return this.m_waitHandle;
        }

        @Override
        public void interrupt() {
            super.interrupt();
            this.m_updateTriggered = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CmsLogReport report = new CmsLogReport(CmsSearchManager.this.m_adminCms.getRequestContext().getLocale(), CmsSearchManager.class);
            long offlineUpdateFrequency = CmsSearchManager.this.getOfflineUpdateFrequency();
            this.m_updateTriggered = false;
            try {
                while (this.m_isAlive) {
                    if (!this.m_updateTriggered) {
                        try {
                            CmsSearchOfflineIndexThread.sleep(offlineUpdateFrequency);
                        }
                        catch (InterruptedException e) {
                            if (!this.m_isAlive) continue;
                            if (offlineUpdateFrequency != CmsSearchManager.this.getOfflineUpdateFrequency()) {
                                offlineUpdateFrequency = CmsSearchManager.this.getOfflineUpdateFrequency();
                            }
                            LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    if (!this.m_isAlive) continue;
                    this.m_updateTriggered = false;
                    List<CmsPublishedResource> resourcesToIndex = this.getResourcesToIndex();
                    if (resourcesToIndex.size() > 0) {
                        this.startOfflineUpdateThread(report, resourcesToIndex);
                    } else {
                        this.getWaitHandle().release();
                    }
                    CmsSearchOfflineIndexThread.interrupted();
                }
            }
            finally {
                this.m_isAlive = false;
            }
        }

        @Override
        public synchronized void start() {
            this.m_isAlive = true;
            super.start();
        }

        protected List<CmsPublishedResource> getResourcesToIndex() {
            List<CmsPublishedResource> resourcesToIndex = this.m_handler.getResourcesToIndex();
            ArrayList<CmsPublishedResource> result = new ArrayList<CmsPublishedResource>(resourcesToIndex.size());
            Collections.reverse(resourcesToIndex);
            for (CmsPublishedResource pubRes : resourcesToIndex) {
                boolean addResource = true;
                for (CmsPublishedResource resRes : result) {
                    if (!pubRes.equals(resRes) || pubRes.getState() != resRes.getState() || pubRes.getMovedState() != resRes.getMovedState() || !pubRes.getRootPath().equals(resRes.getRootPath())) continue;
                    addResource = false;
                    break;
                }
                if (!addResource) continue;
                result.add(pubRes);
            }
            Collections.reverse(result);
            return this.changeStateOfMoveOriginsToDeleted(result);
        }

        protected void shutDown() {
            this.m_isAlive = false;
            this.interrupt();
            if (this.m_isUpdating) {
                long waitTime = CmsSearchManager.this.getOfflineUpdateFrequency() / 2L;
                int waitSteps = 0;
                do {
                    try {
                        Thread.sleep(waitTime);
                    }
                    catch (InterruptedException e) {
                        LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                } while (++waitSteps < 5 && this.m_isUpdating);
            }
        }

        protected void startOfflineUpdateThread(I_CmsReport report, List<CmsPublishedResource> resourcesToIndex) {
            CmsSearchOfflineIndexWorkThread thread = new CmsSearchOfflineIndexWorkThread(report, resourcesToIndex);
            long startTime = System.currentTimeMillis();
            long waitTime = CmsSearchManager.this.getOfflineUpdateFrequency() / 2L;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_OI_UPDATE_START_1", resourcesToIndex.size()));
            }
            this.m_isUpdating = true;
            thread.start();
            do {
                try {
                    thread.join(waitTime);
                }
                catch (InterruptedException e) {
                    LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                if (!thread.isAlive()) continue;
                LOG.warn((Object)Messages.get().getBundle().key("LOG_OI_UPDATE_LONG_2", resourcesToIndex.size(), System.currentTimeMillis() - startTime));
            } while (thread.isAlive());
            this.m_isUpdating = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_OI_UPDATE_FINISH_2", resourcesToIndex.size(), System.currentTimeMillis() - startTime));
            }
        }

        private List<CmsPublishedResource> changeStateOfMoveOriginsToDeleted(List<CmsPublishedResource> resourcesToIndex) {
            HashMap<CmsUUID, String> lastValidPaths = new HashMap<CmsUUID, String>();
            for (CmsPublishedResource resource : resourcesToIndex) {
                if (resource.getState().isDeleted()) continue;
                lastValidPaths.put(resource.getStructureId(), resource.getRootPath());
            }
            ArrayList<CmsPublishedResource> result = new ArrayList<CmsPublishedResource>();
            for (CmsPublishedResource resource : resourcesToIndex) {
                if (resource.getState().isDeleted()) {
                    result.add(resource);
                    continue;
                }
                String lastValidPath = (String)lastValidPaths.get(resource.getStructureId());
                if (resource.getRootPath().equals(lastValidPath) || resource.getStructureId().isNullUUID()) {
                    result.add(resource);
                    continue;
                }
                result.add(new CmsPublishedResource(resource.getStructureId(), resource.getResourceId(), resource.getPublishTag(), resource.getRootPath(), resource.getType(), resource.isFolder(), CmsResource.STATE_DELETED, resource.getSiblingCount()));
            }
            return result;
        }
    }

    protected class CmsSearchOfflineIndexWorkThread
    extends Thread {
        I_CmsReport m_report;
        List<CmsPublishedResource> m_resourcesToIndex;

        protected CmsSearchOfflineIndexWorkThread(I_CmsReport report, List<CmsPublishedResource> resourcesToIndex) {
            super("OpenCms: Offline Search Index Worker");
            this.m_report = report;
            this.m_resourcesToIndex = resourcesToIndex;
        }

        @Override
        public void run() {
            CmsSearchManager.this.updateIndexOffline(this.m_report, this.m_resourcesToIndex);
            if (CmsSearchManager.this.m_offlineIndexThread != null) {
                CmsSearchManager.this.m_offlineIndexThread.getWaitHandle().release();
            }
        }
    }
}

