/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.logging.Log;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.opencms.i18n.CmsEncoder;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.I_CmsSearchIndex;
import org.opencms.search.Messages;
import org.opencms.util.CmsStringUtil;

public class CmsSearchParameters {
    public static final Sort SORT_DATE_CREATED = new Sort(new SortField("created", SortField.Type.STRING, true));
    public static final Sort SORT_DATE_LASTMODIFIED = new Sort(new SortField("lastmodified", SortField.Type.STRING, true));
    public static final Sort SORT_DEFAULT = Sort.RELEVANCE;
    public static final String[] SORT_NAMES = new String[]{"SORT_DEFAULT", "SORT_DATE_CREATED", "SORT_DATE_LASTMODIFIED", "SORT_TITLE"};
    public static final Sort SORT_TITLE = new Sort(new SortField[]{new SortField("title-key", SortField.Type.STRING), SortField.FIELD_SCORE});
    private static final Log LOG = CmsLog.getLog(CmsSearchParameters.class);
    protected int m_displayPages;
    protected int m_matchesPerPage;
    private boolean m_calculateCategories;
    private List<String> m_categories;
    private boolean m_excerptOnlySearchedFields;
    private List<CmsSearchFieldQuery> m_fieldQueries;
    private List<String> m_fields;
    private CmsSearchIndex m_index;
    private boolean m_isIgnoreQuery;
    private long m_maxDateCreated;
    private long m_maxDateLastModified;
    private long m_minDateCreated;
    private long m_minDateLastModified;
    private int m_page;
    private String m_parsedQuery;
    private String m_query;
    private int m_queryLength;
    private List<String> m_resourceTypes;
    private List<String> m_roots;
    private Sort m_sort;

    public CmsSearchParameters() {
        this("");
    }

    public CmsSearchParameters(String query) {
        this(query, null, null, null, null, false, null);
    }

    public CmsSearchParameters(String query, List<String> fields, List<String> roots, List<String> categories, List<String> resourceTypes, boolean calculateCategories, Sort sort) {
        String string = this.m_query = query == null ? "" : query;
        if (fields == null) {
            fields = new ArrayList<String>(2);
            fields.add(CmsSearchIndex.DOC_META_FIELDS[0]);
            fields.add(CmsSearchIndex.DOC_META_FIELDS[1]);
        }
        this.m_fields = fields;
        if (roots == null) {
            roots = new ArrayList<String>(2);
        }
        this.m_roots = roots;
        this.m_categories = categories == null ? new ArrayList() : categories;
        this.m_resourceTypes = resourceTypes == null ? new ArrayList() : resourceTypes;
        this.m_calculateCategories = calculateCategories;
        this.m_sort = sort;
        this.m_page = 1;
        this.m_queryLength = -1;
        this.m_matchesPerPage = 10;
        this.m_displayPages = 10;
        this.m_isIgnoreQuery = false;
        this.m_minDateCreated = Long.MIN_VALUE;
        this.m_maxDateCreated = Long.MAX_VALUE;
        this.m_minDateLastModified = Long.MIN_VALUE;
        this.m_maxDateLastModified = Long.MAX_VALUE;
    }

    public void addFieldQuery(CmsSearchFieldQuery query) {
        if (this.m_fieldQueries == null) {
            this.m_fieldQueries = new ArrayList<CmsSearchFieldQuery>();
            this.m_fields = new ArrayList<String>();
        }
        this.m_fieldQueries.add(query);
        if (!this.m_fields.contains(query.getFieldName())) {
            this.m_fields.add(query.getFieldName());
        }
    }

    public void addFieldQuery(String fieldName, String searchQuery, BooleanClause.Occur occur) {
        CmsSearchFieldQuery newQuery = new CmsSearchFieldQuery(fieldName, searchQuery, occur);
        this.addFieldQuery(newQuery);
    }

    public boolean getCalculateCategories() {
        return this.m_calculateCategories;
    }

    public List<String> getCategories() {
        return this.m_categories;
    }

    public int getDisplayPages() {
        return this.m_displayPages;
    }

    public List<CmsSearchFieldQuery> getFieldQueries() {
        return this.m_fieldQueries;
    }

    public List<String> getFields() {
        return this.m_fields;
    }

    public String getIndex() {
        return this.m_index.getName();
    }

    public int getMatchesPerPage() {
        return this.m_matchesPerPage;
    }

    public long getMaxDateCreated() {
        return this.m_maxDateCreated;
    }

    public long getMaxDateLastModified() {
        return this.m_maxDateLastModified;
    }

    public long getMinDateCreated() {
        return this.m_minDateCreated;
    }

    public long getMinDateLastModified() {
        return this.m_minDateLastModified;
    }

    public String getParsedQuery() {
        return this.m_parsedQuery;
    }

    public String getQuery() {
        return this.m_query;
    }

    public int getQueryLength() {
        return this.m_queryLength;
    }

    public List<String> getResourceTypes() {
        return this.m_resourceTypes;
    }

    public List<String> getRoots() {
        return this.m_roots;
    }

    public String getSearchCategories() {
        return this.toSeparatedString(this.getCategories(), ',');
    }

    public CmsSearchIndex getSearchIndex() {
        return this.m_index;
    }

    public int getSearchPage() {
        return this.m_page;
    }

    public String getSearchRoots() {
        return this.toSeparatedString(this.m_roots, ',');
    }

    public Sort getSort() {
        return this.m_sort;
    }

    public String getSortName() {
        if (this.m_sort == SORT_DATE_CREATED) {
            return SORT_NAMES[1];
        }
        if (this.m_sort == SORT_DATE_LASTMODIFIED) {
            return SORT_NAMES[2];
        }
        if (this.m_sort == SORT_TITLE) {
            return SORT_NAMES[3];
        }
        return SORT_NAMES[0];
    }

    public boolean isCalculateCategories() {
        return this.m_calculateCategories;
    }

    public boolean isExcerptOnlySearchedFields() {
        return this.m_excerptOnlySearchedFields;
    }

    public boolean isIgnoreQuery() {
        return this.m_isIgnoreQuery;
    }

    public CmsSearchParameters restrict(CmsSearchParameters restriction) {
        StringBuffer query = new StringBuffer(256);
        if (this.getQuery() != null) {
            boolean closure;
            boolean bl = closure = !this.getQuery().startsWith("+(");
            if (closure) {
                query.append("+(");
            }
            query.append(this.getQuery());
            if (closure) {
                query.append(")");
            }
        }
        if (restriction.getQuery() != null && query.indexOf(restriction.getQuery()) < 0) {
            query.append(" +(");
            query.append(restriction.getQuery());
            query.append(")");
        }
        List<Object> fields = null;
        fields = this.m_fields != null && this.m_fields.size() > 0 ? (restriction.getFields() != null && restriction.getFields().size() > 0 ? ListUtils.intersection(this.m_fields, restriction.getFields()) : this.m_fields) : restriction.getFields();
        List<Object> roots = null;
        roots = this.m_roots != null && this.m_roots.size() > 0 ? (restriction.getRoots() != null && restriction.getRoots().size() > 0 ? ListUtils.intersection(this.m_roots, restriction.getRoots()) : this.m_roots) : restriction.getRoots();
        List<Object> categories = null;
        categories = this.m_categories != null && this.m_categories.size() > 0 ? (restriction.getCategories() != null && restriction.getCategories().size() > 0 ? ListUtils.intersection(this.m_categories, restriction.getCategories()) : this.m_categories) : restriction.getCategories();
        List<Object> resourceTypes = null;
        resourceTypes = this.m_resourceTypes != null && this.m_resourceTypes.size() > 0 ? (restriction.getResourceTypes() != null && restriction.getResourceTypes().size() > 0 ? ListUtils.intersection(this.m_resourceTypes, restriction.getResourceTypes()) : this.m_resourceTypes) : restriction.getResourceTypes();
        CmsSearchParameters result = new CmsSearchParameters(query.toString(), (List<String>)fields, (List<String>)roots, (List<String>)categories, resourceTypes, this.m_calculateCategories, this.m_sort);
        result.setIndex(this.getIndex());
        return result;
    }

    public void setCalculateCategories(boolean flag) {
        this.m_calculateCategories = flag;
    }

    public void setCategories(List<String> categories) {
        this.m_categories = categories;
    }

    public void setDisplayPages(int value) {
        this.m_displayPages = value;
    }

    public void setExcerptOnlySearchedFields(boolean excerptOnlySearchedFields) {
        this.m_excerptOnlySearchedFields = excerptOnlySearchedFields;
    }

    public void setFields(List<String> fields) {
        this.m_fields = fields;
    }

    public void setIgnoreQuery(boolean isIgnoreQuery) {
        this.m_isIgnoreQuery = isIgnoreQuery;
    }

    public void setIndex(String indexName) {
        block4: {
            if (CmsStringUtil.isNotEmpty(indexName)) {
                try {
                    CmsSearchIndex index;
                    I_CmsSearchIndex idx = OpenCms.getSearchManager().getIndex(indexName);
                    CmsSearchIndex cmsSearchIndex = index = idx instanceof CmsSearchIndex ? (CmsSearchIndex)idx : null;
                    if (index == null) {
                        throw new CmsException(Messages.get().container("ERR_INDEX_NOT_FOUND_1", indexName));
                    }
                    this.setSearchIndex(index);
                }
                catch (Exception exc) {
                    if (!LOG.isErrorEnabled()) break block4;
                    LOG.error((Object)Messages.get().getBundle().key("LOG_INDEX_ACCESS_FAILED_1", indexName), (Throwable)exc);
                }
            }
        }
    }

    public void setMatchesPerPage(int matches) {
        this.m_matchesPerPage = matches;
    }

    public void setMaxDateCreated(long maxDateCreated) {
        this.m_maxDateCreated = maxDateCreated;
    }

    public void setMaxDateLastModified(long maxDateLastModified) {
        this.m_maxDateLastModified = maxDateLastModified;
    }

    public void setMinDateCreated(long minDateCreated) {
        this.m_minDateCreated = minDateCreated;
    }

    public void setMinDateLastModified(long minDateLastModified) {
        this.m_minDateLastModified = minDateLastModified;
    }

    public void setParsedQuery(String parsedQuery) {
        this.m_parsedQuery = parsedQuery;
    }

    public void setQuery(String query) {
        if (query.trim().length() < this.getQueryLength()) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_QUERY_TOO_SHORT_1", this.getQueryLength()));
        }
        this.m_query = query;
    }

    public void setQueryLength(int length) {
        this.m_queryLength = length;
    }

    public void setResourceTypes(List<String> resourceTypes) {
        this.m_resourceTypes = resourceTypes;
    }

    public void setRoots(List<String> roots) {
        this.m_roots = roots;
    }

    public void setSearchCategories(String categories) {
        this.setCategories(CmsStringUtil.splitAsList(categories, ','));
    }

    public void setSearchIndex(CmsSearchIndex index) throws CmsIllegalArgumentException {
        if (index == null) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_INDEX_NULL_0"));
        }
        this.m_index = index;
    }

    public void setSearchPage(int page) {
        this.m_page = page;
    }

    public void setSearchRoots(String rootNameList) {
        this.m_roots = CmsStringUtil.splitAsList(rootNameList, ',');
    }

    public void setSort(Sort sortOrder) {
        this.m_sort = sortOrder;
    }

    public void setSortName(String sortName) {
        this.m_sort = sortName.equals(SORT_NAMES[1]) ? SORT_DATE_CREATED : (sortName.equals(SORT_NAMES[2]) ? SORT_DATE_LASTMODIFIED : (sortName.equals(SORT_NAMES[3]) ? SORT_TITLE : SORT_DEFAULT));
    }

    public String toQueryString() {
        Iterator<String> it;
        StringBuffer result = new StringBuffer(128);
        result.append("?action=search");
        if (this.getParsedQuery() != null) {
            result.append("&parsedQuery=");
            result.append(CmsEncoder.encodeParameter(this.getParsedQuery()));
        } else {
            result.append("&query=");
            result.append(CmsEncoder.encodeParameter(this.getQuery()));
        }
        result.append("&matchesPerPage=");
        result.append(this.getMatchesPerPage());
        result.append("&displayPages=");
        result.append(this.getDisplayPages());
        result.append("&index=");
        result.append(CmsEncoder.encodeParameter(this.getIndex()));
        Sort sort = this.getSort();
        if (sort != SORT_DEFAULT) {
            result.append("&sort=");
            if (sort == SORT_TITLE) {
                result.append("title");
            } else if (sort == SORT_DATE_CREATED) {
                result.append("date-created");
            } else if (sort == SORT_DATE_LASTMODIFIED) {
                result.append("date-lastmodified");
            }
        }
        if (this.getCategories() != null && this.getCategories().size() > 0) {
            result.append("&category=");
            it = this.getCategories().iterator();
            while (it.hasNext()) {
                result.append(it.next());
                if (!it.hasNext()) continue;
                result.append(',');
            }
        }
        if (this.getMinDateCreated() > Long.MIN_VALUE) {
            result.append("&minDateCreated=");
            result.append(this.getMinDateCreated());
        }
        if (this.getMinDateLastModified() > Long.MIN_VALUE) {
            result.append("&minDateLastModified=");
            result.append(this.getMinDateLastModified());
        }
        if (this.getMaxDateCreated() < Long.MAX_VALUE) {
            result.append("&maxDateCreated=");
            result.append(this.getMaxDateCreated());
        }
        if (this.getMaxDateLastModified() < Long.MAX_VALUE) {
            result.append("&maxDateLastModified=");
            result.append(this.getMaxDateLastModified());
        }
        if (this.getRoots() != null && this.getRoots().size() > 0) {
            result.append("&searchRoots=");
            it = this.getRoots().iterator();
            while (it.hasNext()) {
                result.append(CmsEncoder.encode(it.next()));
                if (!it.hasNext()) continue;
                result.append(',');
            }
        }
        if (this.isExcerptOnlySearchedFields()) {
            result.append("&excerptOnlySearchedFields=true");
        }
        return result.toString();
    }

    public String toString() {
        int i;
        StringBuffer result = new StringBuffer();
        result.append("query:[");
        result.append(this.m_query);
        result.append("] ");
        if (this.m_fields != null && this.m_fields.size() > 0) {
            result.append("fields:[");
            for (i = 0; i < this.m_fields.size(); ++i) {
                result.append(this.m_fields.get(i));
                if (i + 1 >= this.m_fields.size()) continue;
                result.append(", ");
            }
            result.append("] ");
        }
        if (this.m_roots != null && this.m_roots.size() > 0) {
            result.append("roots:[");
            for (i = 0; i < this.m_roots.size(); ++i) {
                result.append(this.m_roots.get(i));
                if (i + 1 >= this.m_roots.size()) continue;
                result.append(", ");
            }
            result.append("] ");
        }
        if (this.m_categories != null && this.m_categories.size() > 0) {
            result.append("categories:[");
            for (i = 0; i < this.m_categories.size(); ++i) {
                result.append(this.m_categories.get(i));
                if (i + 1 >= this.m_categories.size()) continue;
                result.append(", ");
            }
            result.append("] ");
        }
        if (this.m_resourceTypes != null && this.m_resourceTypes.size() > 0) {
            result.append("resourceTypes:[");
            for (i = 0; i < this.m_resourceTypes.size(); ++i) {
                result.append(this.m_resourceTypes.get(i));
                if (i + 1 >= this.m_resourceTypes.size()) continue;
                result.append(", ");
            }
            result.append("] ");
        }
        if (this.m_calculateCategories) {
            result.append("calculate-categories ");
        }
        if (this.m_excerptOnlySearchedFields) {
            result.append("excerpt-searched-fields-only ");
        }
        result.append("sort:[");
        if (this.m_sort == SORT_DEFAULT) {
            result.append("default");
        } else if (this.m_sort == SORT_TITLE) {
            result.append("title");
        } else if (this.m_sort == SORT_DATE_CREATED) {
            result.append("date-created");
        } else if (this.m_sort == SORT_DATE_LASTMODIFIED) {
            result.append("date-lastmodified");
        } else {
            result.append("unknown");
        }
        result.append("]");
        return result.toString();
    }

    private String toSeparatedString(List<String> stringList, char separator) {
        StringBuffer result = new StringBuffer();
        Iterator<String> it = stringList.iterator();
        while (it.hasNext()) {
            result.append(it.next());
            if (!it.hasNext()) continue;
            result.append(separator);
        }
        return result.toString();
    }

    public static class CmsSearchFieldQuery {
        private String m_fieldName;
        private BooleanClause.Occur m_fieldOccur;
        private List<String> m_searchTerms;
        private BooleanClause.Occur m_termOccur;

        public CmsSearchFieldQuery(String fieldName, BooleanClause.Occur fieldOccur, List<String> termList, BooleanClause.Occur termOccur) {
            this.m_fieldName = fieldName;
            this.m_fieldOccur = fieldOccur;
            this.m_searchTerms = termList;
            this.m_termOccur = termOccur;
        }

        public CmsSearchFieldQuery(String fieldName, String searchTerm, BooleanClause.Occur fieldOccur) {
            this(fieldName, fieldOccur, Arrays.asList(searchTerm), null);
        }

        public String getFieldName() {
            return this.m_fieldName;
        }

        public BooleanClause.Occur getOccur() {
            return this.m_fieldOccur;
        }

        @Deprecated
        public String getSearchQuery() {
            return this.m_searchTerms.get(0);
        }

        public List<String> getSearchTerms() {
            return this.m_searchTerms;
        }

        public BooleanClause.Occur getTermOccur() {
            return this.m_termOccur;
        }

        public void setFieldName(String fieldName) {
            this.m_fieldName = fieldName;
        }

        public void setOccur(BooleanClause.Occur occur) {
            this.m_fieldOccur = occur;
        }

        @Deprecated
        public void setSearchQuery(String searchQuery) {
            this.setSearchTerms(Arrays.asList(searchQuery));
        }

        public void setSearchTerms(List<String> searchTerms) {
            this.m_searchTerms = searchTerms;
        }
    }
}

