/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.documents;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.search.I_CmsSearchIndex;
import org.opencms.search.documents.CmsExtractionResultCache;
import org.opencms.search.documents.CmsIndexNoContentException;
import org.opencms.search.documents.I_CmsDocumentFactory;
import org.opencms.search.documents.Messages;
import org.opencms.search.extractors.I_CmsExtractionResult;

public abstract class A_CmsVfsDocument
implements I_CmsDocumentFactory {
    public static final String DEFAULT_ALL_UNCONFIGURED_TYPES = "__unconfigured__";
    public static final String DEFAULT_ALL_TYPES = "__all__";
    private static final Log LOG = CmsLog.getLog(A_CmsVfsDocument.class);
    protected String m_name;
    private CmsExtractionResultCache m_cache;

    public A_CmsVfsDocument(String name) {
        this.m_name = name;
    }

    public static String getDocumentKey(String type, String mimeType) {
        StringBuffer result = new StringBuffer(16);
        result.append("VFS");
        result.append('_');
        result.append(type);
        if (mimeType != null) {
            result.append(':');
            result.append(mimeType);
        }
        return result.toString();
    }

    @Override
    public I_CmsSearchDocument createDocument(CmsObject cms, CmsResource resource, I_CmsSearchIndex index) throws CmsException {
        I_CmsExtractionResult content = null;
        if (index.isExtractingContent()) {
            CmsExtractionResultCache cache = this.getCache();
            String cacheName = null;
            if (cache != null && resource.getSiblingCount() > 1) {
                cacheName = cache.getCacheName(resource, this.isLocaleDependend() ? index.getLocaleForResource(cms, resource, null) : null, this.getName());
                content = cache.getCacheObject(cacheName);
            }
            if (content == null) {
                content = index.getContentIfUnchanged(resource);
            }
            if (content == null) {
                try {
                    content = this.extractContent(cms, resource, index);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Extracting content for '" + resource.getRootPath() + "' successful."));
                    }
                    if (cache != null && resource.getSiblingCount() > 1) {
                        cache.saveCacheObject(cacheName, content);
                    }
                }
                catch (CmsIndexNoContentException e) {
                    LOG.info((Object)(Messages.get().getBundle().key("ERR_TEXT_EXTRACTION_1", resource.getRootPath()) + " " + e.getMessage()));
                }
                catch (Throwable e) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_TEXT_EXTRACTION_1", resource.getRootPath()), e);
                }
            }
        }
        return index.getFieldConfiguration().createDocument(cms, resource, index, content);
    }

    @Override
    public CmsExtractionResultCache getCache() {
        return this.m_cache;
    }

    @Override
    public List<String> getDocumentKeys(List<String> resourceTypes, List<String> mimeTypes) throws CmsException {
        ArrayList<String> keys = new ArrayList<String>();
        try {
            for (String typeName : resourceTypes) {
                if (typeName.equals("*")) {
                    typeName = DEFAULT_ALL_UNCONFIGURED_TYPES;
                }
                if (typeName.equals("**")) {
                    typeName = DEFAULT_ALL_TYPES;
                }
                Iterator<String> j = mimeTypes.iterator();
                while (j.hasNext()) {
                    keys.add(A_CmsVfsDocument.getDocumentKey(typeName, j.next()));
                }
                if (!mimeTypes.isEmpty()) continue;
                keys.add(A_CmsVfsDocument.getDocumentKey(typeName, null));
            }
        }
        catch (Exception exc) {
            throw new CmsException(Messages.get().container("ERR_CREATE_DOC_KEY_0"), (Throwable)exc);
        }
        return keys;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public void setCache(CmsExtractionResultCache cache) {
        this.m_cache = cache;
    }

    protected void logContentExtraction(CmsResource resource, I_CmsSearchIndex index) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_EXTRACT_CONTENT_2", resource.getRootPath(), index.getName()));
        }
    }

    protected CmsFile readFile(CmsObject cms, CmsResource resource) throws CmsException, CmsIndexNoContentException {
        CmsFile file = cms.readFile(resource);
        if (file.getLength() <= 0) {
            throw new CmsIndexNoContentException(Messages.get().container("ERR_NO_CONTENT_1", resource.getRootPath()));
        }
        return file;
    }
}

