/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.solr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.solr.core.ConfigSetService;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.IndexSchemaFactory;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.solr.Messages;
import org.opencms.util.CmsStringUtil;

public class CmsSolrConfiguration {
    public static final String DEFAULT_CONFIGSET_FOLDER = File.separatorChar + "configsets" + File.separatorChar + "default";
    public static final String CONF_FOLDER = File.separatorChar + "conf" + File.separatorChar;
    public static final String SOLR_CONFIG_FILE = "solr.xml";
    public static final int DEFAULT_MAX_PROCESSED_RESULTS = 400;
    public static final long SOLR_DEFAULT_COMMIT_MS = 10000L;
    public static final String SOLR_HOME_DEFAULT = "solr" + File.separatorChar;
    public static final String SOLR_HOME_PROPERTY = "solr.solr.home";
    public static final String SOLR_SCHEMA_NAME = "OpenCms SOLR schema";
    public static final String SOLR_CONFIG_NAME = "OpenCms SOLR configuration";
    private static final Log LOG = CmsLog.getLog(CmsSolrConfiguration.class);
    private long m_commitMs = 10000L;
    private boolean m_enabled;
    private String m_home;
    private String m_homeFolderPath;
    private IndexSchema m_schema;
    private String m_serverUrl;
    private SolrConfig m_solrConfig;
    private File m_solrFile;
    private String m_solrFileName;
    private int m_maxProcessedResults = 400;

    public String getHome() {
        if (this.m_homeFolderPath == null) {
            this.m_home = CmsStringUtil.isNotEmpty(System.getProperty(SOLR_HOME_PROPERTY)) ? System.getProperty(SOLR_HOME_PROPERTY) : OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(SOLR_HOME_DEFAULT);
            this.m_home = this.m_home.endsWith(File.separator) ? this.m_home.substring(0, this.m_home.lastIndexOf(File.separator)) : this.m_home;
        } else {
            this.m_home = this.m_homeFolderPath;
        }
        return this.m_home;
    }

    public String getHomeFolderPath() {
        return this.m_homeFolderPath;
    }

    public int getMaxProcessedResults() {
        return this.m_maxProcessedResults;
    }

    public String getServerUrl() {
        return this.m_serverUrl;
    }

    public long getSolrCommitMs() {
        return this.m_commitMs;
    }

    public SolrConfig getSolrConfig() {
        if (this.m_solrConfig == null) {
            try (FileInputStream fis = new FileInputStream(this.getSolrConfigFile());){
                Path instanceDir = Paths.get(this.getHome(), DEFAULT_CONFIGSET_FOLDER);
                SolrResourceLoader loader = new SolrResourceLoader(instanceDir);
                this.m_solrConfig = SolrConfig.readFromResourceLoader((SolrResourceLoader)loader, (String)this.getSolrConfigFile().getName(), (boolean)true, (Properties)loader.getCoreProperties());
            }
            catch (FileNotFoundException e) {
                CmsConfigurationException ex = new CmsConfigurationException(Messages.get().container("LOG_SOLR_ERR_CONFIG_XML_NOT_FOUND_1", this.getSolrConfigFile()), (Throwable)e);
                LOG.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
            }
            catch (Exception e) {
                CmsConfigurationException ex = new CmsConfigurationException(Messages.get().container("LOG_SOLR_ERR_CONFIG_XML_NOT_READABLE_1", this.getSolrConfigFile()), (Throwable)e);
                LOG.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
        return this.m_solrConfig;
    }

    public File getSolrConfigFile() {
        return new File(this.getHome() + DEFAULT_CONFIGSET_FOLDER + CONF_FOLDER + "solrconfig.xml");
    }

    public File getSolrFile() {
        if (this.m_solrFile == null) {
            String solrFileName = this.m_solrFileName != null ? this.m_solrFileName : SOLR_CONFIG_FILE;
            this.m_solrFile = new File(this.getHome() + File.separator + solrFileName);
        }
        return this.m_solrFile;
    }

    public String getSolrFileName() {
        return this.m_solrFileName;
    }

    public IndexSchema getSolrSchema() {
        if (this.m_schema == null) {
            try (FileInputStream fis = new FileInputStream(this.getSolrSchemaFile());){
                ConfigSetService.ConfigResource configRes = IndexSchemaFactory.getConfigResource(null, (InputStream)fis, (SolrResourceLoader)this.getSolrConfig().getResourceLoader(), (String)SOLR_CONFIG_NAME);
                this.m_schema = new IndexSchema(SOLR_SCHEMA_NAME, configRes, this.getSolrConfig().luceneMatchVersion, this.getSolrConfig().getResourceLoader(), this.getSolrConfig().getSubstituteProperties());
            }
            catch (IOException e) {
                CmsConfigurationException ex = new CmsConfigurationException(Messages.get().container("LOG_SOLR_ERR_SCHEMA_XML_NOT_FOUND_1", this.getSolrSchemaFile().getPath()), (Throwable)e);
                LOG.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
        return this.m_schema;
    }

    public File getSolrSchemaFile() {
        String dir = this.getHome() + DEFAULT_CONFIGSET_FOLDER + CONF_FOLDER;
        File file = new File(dir, "managed-schema");
        if (file.exists()) {
            return file;
        }
        file = new File(dir, "schema.xml");
        return file;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void setEnabled(String isEnabled) {
        this.m_enabled = Boolean.valueOf(isEnabled);
    }

    public void setHomeFolderPath(String homeFolderPath) {
        this.m_homeFolderPath = homeFolderPath;
    }

    public void setMaxProcessedResults(String maxProcessedResults) {
        try {
            this.m_maxProcessedResults = Integer.parseInt(maxProcessedResults);
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not parse value " + maxProcessedResults + " as Integer to set the limit for the number of results a Solr index can return."));
        }
        if (this.m_maxProcessedResults <= 0) {
            this.m_maxProcessedResults = 400;
            LOG.warn((Object)"The maximal number of results to return by a Solr index should be greater than 0. Reset it to the default value 400.");
        }
    }

    public void setServerUrl(String url) {
        this.m_serverUrl = url;
    }

    public void setSolrCommitMs(String time) {
        this.m_commitMs = Long.parseLong(time);
    }

    public void setSolrFileName(String name) {
        this.m_solrFileName = name;
    }
}

