/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.solr;

import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.schema.DatePointField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsCategory;
import org.opencms.search.CmsSearchUtil;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.search.documents.CmsDocumentDependency;
import org.opencms.search.fields.CmsSearchField;
import org.opencms.search.solr.CmsSolrField;
import org.opencms.search.solr.Messages;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsSolrDocument
implements I_CmsSearchDocument {
    private static final Log LOG = CmsLog.getLog(CmsSolrDocument.class);
    private SolrInputDocument m_doc;
    private float m_score;

    public CmsSolrDocument(SolrDocument doc) {
        this();
        this.m_doc = CmsSearchUtil.toSolrInputDocument(doc);
    }

    public CmsSolrDocument(SolrInputDocument doc) {
        this();
        this.m_doc = doc;
    }

    private CmsSolrDocument() {
    }

    @Override
    public void addCategoryField(List<CmsCategory> categories) {
        if (categories != null && categories.size() > 0) {
            for (CmsCategory category : categories) {
                this.m_doc.addField("category", (Object)category.getPath());
            }
        }
    }

    @Override
    public void addContentField(byte[] data) {
        this.m_doc.setField("contentblob", (Object)ByteBuffer.wrap(data));
    }

    @Override
    public void addContentLocales(Collection<Locale> locales) {
        if (locales != null && !locales.isEmpty()) {
            for (Locale locale : locales) {
                this.m_doc.addField("con_locales", (Object)locale.toString());
            }
        }
    }

    @Override
    public void addDateField(String name, long time, boolean analyzed) {
        String val = CmsSearchUtil.getDateAsIso8601(time);
        this.m_doc.addField(name, (Object)val);
        if (analyzed) {
            this.m_doc.addField(name + "_lookup", (Object)val);
        }
    }

    public void addDocumentDependency(CmsObject cms, CmsDocumentDependency resDeps) {
        if (resDeps != null) {
            this.m_doc.addField("dependencyType", (Object)resDeps.getType());
            if (resDeps.getMainDocument() != null && resDeps.getType() != null) {
                this.m_doc.addField("dep_" + resDeps.getType().toString(), (Object)resDeps.getMainDocument().toDependencyString(cms));
            }
            for (CmsDocumentDependency dep : resDeps.getVariants()) {
                this.m_doc.addField("dep_" + dep.getType().toString(), (Object)dep.toDependencyString(cms));
            }
            for (CmsDocumentDependency dep : resDeps.getAttachments()) {
                this.m_doc.addField("dep_" + dep.getType().toString(), (Object)dep.toDependencyString(cms));
            }
        }
    }

    @Override
    public void addFileSizeField(int length) {
        if (OpenCms.getSearchManager().getSolrServerConfiguration().getSolrSchema().hasExplicitField("size")) {
            this.m_doc.addField("size", (Object)length);
        }
    }

    public void addMultiValuedField(String fieldName, List<String> values) {
        if (values != null && values.size() > 0) {
            for (String value : values) {
                this.m_doc.addField(fieldName, (Object)value);
            }
        }
    }

    @Override
    public void addPathField(String rootPath) {
        String folderName = CmsResource.getFolderPath(rootPath);
        for (int i = 0; i < folderName.length(); ++i) {
            char c = folderName.charAt(i);
            if (c != '/') continue;
            this.m_doc.addField("parent-folders", (Object)folderName.substring(0, i + 1));
        }
    }

    @Override
    public void addResourceLocales(Collection<Locale> locales) {
        if (locales != null && !locales.isEmpty()) {
            for (Locale locale : locales) {
                this.m_doc.addField("res_locales", (Object)locale.toString());
            }
        }
    }

    @Override
    public void addRootPathField(String rootPath) {
        this.m_doc.addField("path", (Object)rootPath);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addSearchField(CmsSearchField sfield, String value) {
        CmsSolrField field = (CmsSolrField)sfield;
        ArrayList<String> fieldsToAdd = new ArrayList<String>(Collections.singletonList(field.getName()));
        if (field.getCopyFields() != null && !field.getCopyFields().isEmpty()) {
            fieldsToAdd.addAll(field.getCopyFields());
        }
        IndexSchema schema = OpenCms.getSearchManager().getSolrServerConfiguration().getSolrSchema();
        for (String fieldName : fieldsToAdd) {
            try {
                List<Object> splitedValues = new ArrayList<String>();
                boolean multi = false;
                try {
                    SchemaField f = schema.getField(fieldName);
                    if (f != null && !field.getName().startsWith("content")) {
                        multi = f.multiValued();
                    }
                }
                catch (SolrException e) {
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_SOLR_FIELD_NOT_FOUND_1", field.toString()));
                }
                if (multi) {
                    splitedValues = CmsStringUtil.splitAsList(value.toString(), "\n");
                } else {
                    splitedValues.add(value);
                }
                for (String string : splitedValues) {
                    void var11_14;
                    if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(string)) continue;
                    try {
                        FieldType fieldType = schema.getFieldType(fieldName);
                        if (fieldType instanceof DatePointField && !string.contains("Z")) {
                            String string2 = CmsSearchUtil.getDateAsIso8601(Long.valueOf(string));
                        }
                    }
                    catch (SolrException e) {
                        LOG.debug((Object)e.getMessage(), (Throwable)e);
                        throw new RuntimeException(e);
                    }
                    if (fieldName.endsWith("_excerpt")) {
                        void var11_17;
                        String string3 = CmsStringUtil.trimToSize((String)var11_17, 1000, 50, "");
                    }
                    this.m_doc.addField(fieldName, (Object)var11_14);
                }
            }
            catch (SolrException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (RuntimeException runtimeException) {
            }
        }
    }

    @Override
    public void addSuffixField(String suffix) {
        this.m_doc.addField("suffix", (Object)suffix);
    }

    @Override
    public void addTypeField(String type) {
        this.m_doc.addField("type", (Object)type);
    }

    @Override
    public byte[] getContentBlob() {
        Object o = this.m_doc.getFieldValue("contentblob");
        if (o != null) {
            if (o instanceof byte[]) {
                return (byte[])o;
            }
            return o.toString().getBytes();
        }
        return null;
    }

    @Override
    public Object getDocument() {
        return this.m_doc;
    }

    @Override
    public List<String> getFieldNames() {
        return new ArrayList<String>(this.m_doc.getFieldNames());
    }

    @Override
    public Date getFieldValueAsDate(String fieldName) {
        Object o = this.m_doc.getFieldValue(fieldName);
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o != null) {
            try {
                return CmsSearchUtil.parseDate(o.toString());
            }
            catch (ParseException e) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public String getFieldValueAsString(String fieldName) {
        List<String> values = this.getMultivaluedFieldAsStringList(fieldName);
        if (values != null && !values.isEmpty()) {
            return CmsStringUtil.listAsString(values, "\n");
        }
        Object o = this.m_doc.getFieldValue(fieldName);
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    @Override
    public List<String> getMultivaluedFieldAsStringList(String fieldName) {
        ArrayList<String> result = new ArrayList<String>();
        Collection coll = this.m_doc.getFieldValues(fieldName);
        if (coll != null) {
            for (Object o : coll) {
                if (o == null) continue;
                result.add(o.toString());
            }
            return result;
        }
        return null;
    }

    @Override
    public String getPath() {
        return this.getFieldValueAsString("path");
    }

    @Override
    public float getScore() {
        Float score = (Float)this.getSolrDocument().getFirstValue("score");
        if (score != null) {
            this.m_score = score.floatValue();
            return this.m_score;
        }
        return 0.0f;
    }

    public SolrDocument getSolrDocument() {
        return CmsSearchUtil.toSolrDocument(this.m_doc);
    }

    @Override
    public String getType() {
        return this.getFieldValueAsString("type");
    }

    public void setId(CmsUUID structureId) {
        this.m_doc.addField("id", (Object)structureId.toString());
    }

    @Override
    public void setScore(float score) {
        this.m_score = score;
    }

    public String toString() {
        return this.getFieldValueAsString("path");
    }
}

