/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.solr;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.opencms.ade.containerpage.CmsDetailOnlyContainerUtil;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsIndexException;
import org.opencms.search.CmsSearchUtil;
import org.opencms.search.I_CmsSearchIndex;
import org.opencms.search.documents.A_CmsVfsDocument;
import org.opencms.search.documents.CmsIndexNoContentException;
import org.opencms.search.documents.Messages;
import org.opencms.search.extractors.CmsExtractionResult;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.search.fields.CmsSearchFieldConfiguration;
import org.opencms.search.galleries.CmsGalleryNameMacroResolver;
import org.opencms.search.solr.CmsSolrDocumentContainerPage;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.widgets.serialdate.CmsSerialDateBeanFactory;
import org.opencms.widgets.serialdate.CmsSerialDateValue;
import org.opencms.widgets.serialdate.I_CmsSerialDateBean;
import org.opencms.xml.A_CmsXmlDocument;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.types.CmsXmlDateTimeValue;
import org.opencms.xml.types.CmsXmlHtmlValue;
import org.opencms.xml.types.CmsXmlNestedContentDefinition;
import org.opencms.xml.types.CmsXmlSerialDateValue;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public class CmsSolrDocumentXmlContent
extends A_CmsVfsDocument {
    public static final String MAPPING_GALLERY_DESCRIPTION = "galleryDescription";
    public static final String MAPPING_GALLERY_NAME = "galleryName";
    private static final Log LOG = CmsLog.getLog(CmsSolrDocumentXmlContent.class);

    public CmsSolrDocumentXmlContent(String name) {
        super(name);
    }

    public static void collectSchemaXpathsForSimpleValues(CmsObject cms, CmsXmlContentDefinition def, String path, Set<String> result) {
        List<I_CmsXmlSchemaType> nestedTypes = def.getTypeSequence();
        for (I_CmsXmlSchemaType nestedType : nestedTypes) {
            String subPath = path + "/" + nestedType.getName();
            if (nestedType instanceof CmsXmlNestedContentDefinition) {
                CmsXmlContentDefinition nestedDef = ((CmsXmlNestedContentDefinition)nestedType).getNestedContentDefinition();
                CmsSolrDocumentXmlContent.collectSchemaXpathsForSimpleValues(cms, nestedDef, subPath, result);
                continue;
            }
            result.add(subPath);
        }
    }

    public static CmsExtractionResult extractXmlContent(CmsObject cms, CmsResource resource, I_CmsSearchIndex index) throws CmsException {
        return CmsSolrDocumentXmlContent.extractXmlContent(cms, resource, index, null);
    }

    public static CmsExtractionResult extractXmlContent(CmsObject cms, CmsResource resource, I_CmsSearchIndex index, Locale forceLocale) throws CmsException {
        return CmsSolrDocumentXmlContent.extractXmlContent(cms, resource, index, forceLocale, null);
    }

    public static CmsExtractionResult extractXmlContent(CmsObject cms, CmsResource resource, I_CmsSearchIndex index, Locale forceLocale, Set<CmsUUID> alreadyExtracted) throws CmsException {
        return CmsSolrDocumentXmlContent.extractXmlContent(cms, resource, index, forceLocale, alreadyExtracted, content -> {});
    }

    public static CmsExtractionResult extractXmlContent(CmsObject cms, CmsResource resource, I_CmsSearchIndex index, Locale forceLocale, Set<CmsUUID> alreadyExtracted, Consumer<A_CmsXmlDocument> contentConsumer) throws CmsException {
        CmsFile file;
        if (null == alreadyExtracted) {
            alreadyExtracted = Collections.emptySet();
        }
        if ((file = cms.readFile(resource)).getLength() <= 0) {
            throw new CmsIndexNoContentException(Messages.get().container("ERR_NO_CONTENT_1", resource.getRootPath()));
        }
        CmsXmlContent xmlContent = CmsXmlContentFactory.unmarshal(cms, file);
        if (contentConsumer != null) {
            contentConsumer.accept(xmlContent);
        }
        HashMap<Locale, LinkedHashMap<String, String>> items = new HashMap<Locale, LinkedHashMap<String, String>>();
        HashMap<String, String> fieldMappings = new HashMap<String, String>();
        List<Locale> contentLocales = forceLocale != null ? Collections.singletonList(forceLocale) : xmlContent.getLocales();
        Locale resourceLocale = index.getLocaleForResource(cms, resource, contentLocales);
        LinkedHashMap<String, String> localeItems = null;
        GalleryNameChooser galleryNameChooser = null;
        for (Locale locale : contentLocales) {
            galleryNameChooser = new GalleryNameChooser(cms, xmlContent, locale);
            localeItems = new LinkedHashMap<String, String>();
            StringBuffer textContent = new StringBuffer();
            List<String> paths = xmlContent.getNames(locale);
            for (String string : paths) {
                String extracted = null;
                I_CmsXmlContentValue value = xmlContent.getValue(string, locale);
                try {
                    if (value instanceof CmsXmlDateTimeValue) {
                        extracted = CmsSearchUtil.getDateAsIso8601(((CmsXmlDateTimeValue)value).getDateTimeValue());
                    } else {
                        extracted = value.getPlainText(cms);
                        if (CmsStringUtil.isEmptyOrWhitespaceOnly(extracted) && value.isSimpleType() && !(value instanceof CmsXmlHtmlValue)) {
                            extracted = value.getStringValue(cms);
                        }
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)Messages.get().container("LOG_EXTRACT_VALUE_2", string, resource), (Throwable)e);
                }
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(extracted)) {
                    localeItems.put(string, extracted);
                }
                switch (xmlContent.getHandler().getSearchContentType(value)) {
                    case TRUE: {
                        if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(extracted)) break;
                        textContent.append(extracted);
                        textContent.append('\n');
                        break;
                    }
                    case CONTENT: {
                        String potentialLinkValue = value.getStringValue(cms);
                        try {
                            CmsResource linkedRes;
                            if (null != potentialLinkValue && !potentialLinkValue.isEmpty() && cms.existsResource(potentialLinkValue) && CmsResourceTypeXmlContent.isXmlContent(linkedRes = cms.readResource(potentialLinkValue)) && !alreadyExtracted.contains(linkedRes.getStructureId())) {
                                HashSet<CmsUUID> newAlreadyExtracted = new HashSet<CmsUUID>(alreadyExtracted);
                                newAlreadyExtracted.add(resource.getStructureId());
                                CmsExtractionResult exRes = CmsSolrDocumentXmlContent.extractXmlContent(cms, linkedRes, index, locale, newAlreadyExtracted);
                                String exContent = exRes.getContent(locale);
                                if (exContent != null && !exContent.trim().isEmpty()) {
                                    textContent.append(exContent.trim());
                                    textContent.append('\n');
                                    break;
                                }
                            }
                            if (!LOG.isInfoEnabled()) break;
                            LOG.info((Object)("When indexing resource " + resource.getRootPath() + ", the elements value " + value.getPath() + " in locale " + locale + " does not contain a link to an XML content. Hence, the linked element's content is not added to the content indexed for the resource itself."));
                        }
                        catch (Throwable t) {
                            LOG.error((Object)("Failed to add content of resource (site path) " + potentialLinkValue + " to content of resource (root path) " + resource.getRootPath() + " when indexing the resource for locale " + locale + ". Skipping this content part."), t);
                        }
                        break;
                    }
                }
                List<String> mappings = xmlContent.getHandler().getMappings(value.getPath());
                if (mappings.size() > 0) {
                    for (String mapping : mappings) {
                        if (mapping.startsWith("property:")) {
                            String propertyName = mapping.substring(mapping.lastIndexOf(58) + 1);
                            if (!"Title".equals(propertyName) && !"Description".equals(propertyName) || !CmsStringUtil.isNotEmptyOrWhitespaceOnly(extracted)) continue;
                            if ("Title".equals(propertyName)) {
                                galleryNameChooser.setMappedTitleValue(extracted);
                                continue;
                            }
                            galleryNameChooser.setMappedDescriptionValue(extracted);
                            continue;
                        }
                        if (mapping.equals(MAPPING_GALLERY_NAME)) {
                            galleryNameChooser.setMappedGalleryNameValue(value.getPlainText(cms));
                            continue;
                        }
                        if (!mapping.equals(MAPPING_GALLERY_DESCRIPTION)) continue;
                        galleryNameChooser.setMappedGalleryDescriptionValue(value.getPlainText(cms));
                    }
                }
                if (!(value instanceof CmsXmlSerialDateValue) || null == extracted || extracted.isEmpty()) continue;
                CmsSerialDateValue serialDateValue = new CmsSerialDateValue(extracted);
                I_CmsSerialDateBean serialDateBean = CmsSerialDateBeanFactory.createSerialDateBean(serialDateValue);
                if (null != serialDateBean) {
                    StringBuffer values = new StringBuffer();
                    StringBuffer endValues = new StringBuffer();
                    StringBuffer currentTillValues = new StringBuffer();
                    for (Long eventDate : serialDateBean.getDatesAsLong()) {
                        values.append("\n").append(eventDate.toString());
                        long endDate = null != serialDateBean.getEventDuration() ? eventDate + serialDateBean.getEventDuration() : eventDate;
                        endValues.append("\n").append(Long.toString(endDate));
                        currentTillValues.append("\n").append(serialDateValue.isCurrentTillEnd() ? Long.valueOf(serialDateValue.endsAtMidNight() && endDate > eventDate ? endDate - 1L : endDate) : eventDate);
                    }
                    fieldMappings.put("seriesdates_dts", values.substring(1));
                    fieldMappings.put("seriesdatesend_dts", endValues.substring(1));
                    fieldMappings.put("seriesdatescurrenttill_dts", currentTillValues.substring(1));
                    fieldMappings.put("seriesdatestype_s", serialDateValue.getDateType().toString());
                    continue;
                }
                LOG.warn((Object)("Serial date value \"" + value.getStringValue(cms) + "\" at element \"" + value.getPath() + "\" is invalid. No dates are indexed for resource \"" + resource.getRootPath() + "\"."));
            }
            HashSet xpaths = Sets.newHashSet();
            CmsSolrDocumentXmlContent.collectSchemaXpathsForSimpleValues(cms, xmlContent.getContentDefinition(), "", xpaths);
            for (String xpath3 : xpaths) {
                List<String> mappings = xmlContent.getHandler().getMappings(CmsXmlUtils.createXpath(xpath3, 1));
                for (String mapping : mappings) {
                    if (!mapping.equals(MAPPING_GALLERY_NAME) && !mapping.equals("property:Title")) continue;
                    String defaultValue = xmlContent.getHandler().getDefault(cms, xmlContent.getFile(), null, xpath3, locale);
                    if (mapping.equals(MAPPING_GALLERY_NAME)) {
                        galleryNameChooser.setDefaultGalleryNameValue(defaultValue);
                        continue;
                    }
                    galleryNameChooser.setDefaultTitleValue(defaultValue);
                }
            }
            String string = CmsSearchFieldConfiguration.getLocaleExtendedName("title", locale) + "_s";
            String galleryNameValue = galleryNameChooser.getGalleryName();
            fieldMappings.put(string, galleryNameValue);
            fieldMappings.put(CmsSearchFieldConfiguration.getLocaleExtendedName("description", locale) + "_s", galleryNameChooser.getDescription());
            if (textContent.length() > 0) {
                localeItems.put("__content", textContent.toString());
            }
            items.put(locale, localeItems);
        }
        if (xmlContent instanceof CmsXmlContent && xmlContent.isLocaleIndependent()) {
            if (forceLocale != null) {
                items.put(forceLocale, localeItems);
            } else {
                for (Locale l : OpenCms.getLocaleManager().getAvailableLocales()) {
                    items.put(l, localeItems);
                    if (null == galleryNameChooser) continue;
                    String galleryTitleFieldKey = CmsSearchFieldConfiguration.getLocaleExtendedName("title", l) + "_s";
                    fieldMappings.put(galleryTitleFieldKey, galleryNameChooser.getGalleryName(l));
                    fieldMappings.put(CmsSearchFieldConfiguration.getLocaleExtendedName("description", l) + "_s", galleryNameChooser.getDescription(l));
                }
            }
        }
        return new CmsExtractionResult(resourceLocale, items, fieldMappings);
    }

    @Override
    public I_CmsExtractionResult extractContent(CmsObject cms, CmsResource resource, I_CmsSearchIndex index) throws CmsException {
        this.logContentExtraction(resource, index);
        try {
            I_CmsExtractionResult result = null;
            ArrayList<I_CmsExtractionResult> ex = new ArrayList<I_CmsExtractionResult>();
            for (CmsResource detailContainers : CmsDetailOnlyContainerUtil.getDetailOnlyResources(cms, resource)) {
                CmsSolrDocumentContainerPage containerpageExtractor = new CmsSolrDocumentContainerPage("");
                String localeTemp = detailContainers.getRootPath();
                localeTemp = CmsResource.getParentFolder(localeTemp);
                localeTemp = CmsResource.getName(localeTemp);
                localeTemp = localeTemp.substring(0, localeTemp.length() - 1);
                Locale locale = CmsLocaleManager.getLocale(localeTemp);
                if (CmsDetailOnlyContainerUtil.useSingleLocaleDetailContainers(OpenCms.getSiteManager().getSiteRoot(resource.getRootPath())) && locale.equals(CmsLocaleManager.getDefaultLocale())) {
                    locale = null;
                }
                I_CmsExtractionResult containersExtractionResult = containerpageExtractor.extractContent(cms, detailContainers, index, locale);
                containersExtractionResult.getContentItems().remove("res_locales");
                ex.add(containersExtractionResult);
            }
            result = CmsSolrDocumentXmlContent.extractXmlContent(cms, resource, index);
            result = result.merge(ex);
            return result;
        }
        catch (Throwable t) {
            throw new CmsIndexException(Messages.get().container("ERR_TEXT_EXTRACTION_1", resource), t);
        }
    }

    @Override
    public boolean isLocaleDependend() {
        return false;
    }

    @Override
    public boolean isUsingCache() {
        return true;
    }

    private static class GalleryNameChooser {
        private CmsObject m_cms;
        private A_CmsXmlDocument m_content;
        private String m_defaultGalleryNameValue;
        private String m_defaultTitleValue;
        private Locale m_locale;
        private String m_mappedDescriptionValue;
        private String m_mappedGalleryDescriptionValue;
        private String m_mappedGalleryNameValue;
        private String m_mappedTitleValue;

        public GalleryNameChooser(CmsObject cms, A_CmsXmlDocument content, Locale locale) {
            this.m_cms = cms;
            this.m_content = content;
            this.m_locale = locale;
        }

        public String getDescription() throws CmsException {
            return this.getDescription(this.m_locale);
        }

        public String getDescription(Locale locale) throws CmsException {
            String result = null;
            for (String resultCandidateWithMacros : new String[]{this.m_mappedGalleryDescriptionValue, this.m_mappedDescriptionValue}) {
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(resultCandidateWithMacros)) continue;
                CmsGalleryNameMacroResolver resolver = new CmsGalleryNameMacroResolver(this.m_cms, this.m_content, locale);
                result = resolver.resolveMacros(resultCandidateWithMacros);
                return result;
            }
            result = this.m_cms.readPropertyObject(this.m_content.getFile(), "Description", false).getValue();
            return result;
        }

        public String getGalleryName() throws CmsException {
            return this.getGalleryName(this.m_locale);
        }

        public String getGalleryName(Locale locale) throws CmsException {
            String result = null;
            for (String resultCandidateWithMacros : new String[]{this.m_mappedGalleryNameValue, this.m_defaultGalleryNameValue, this.m_mappedTitleValue, this.m_defaultTitleValue}) {
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(resultCandidateWithMacros)) continue;
                CmsGalleryNameMacroResolver resolver = new CmsGalleryNameMacroResolver(this.m_cms, this.m_content, locale);
                result = resolver.resolveMacros(resultCandidateWithMacros);
                return result;
            }
            result = this.m_cms.readPropertyObject(this.m_content.getFile(), "Title", false).getValue();
            return result;
        }

        public void setDefaultGalleryNameValue(String defaultGalleryNameValue) {
            this.m_defaultGalleryNameValue = defaultGalleryNameValue;
        }

        public void setDefaultTitleValue(String defaultTitleValue) {
            this.m_defaultTitleValue = defaultTitleValue;
        }

        public void setMappedDescriptionValue(String mappedDescriptionValue) {
            this.m_mappedDescriptionValue = mappedDescriptionValue;
        }

        public void setMappedGalleryDescriptionValue(String mappedGalleryDescriptionValue) {
            this.m_mappedGalleryDescriptionValue = mappedGalleryDescriptionValue;
        }

        public void setMappedGalleryNameValue(String mappedGalleryNameValue) {
            this.m_mappedGalleryNameValue = mappedGalleryNameValue;
        }

        public void setMappedTitleValue(String mappedTitleValue) {
            this.m_mappedTitleValue = mappedTitleValue;
        }
    }
}

