/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.solr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.solr.common.SolrInputDocument;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeJsp;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.loader.CmsResourceManager;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchIndexSource;
import org.opencms.search.CmsSearchUtil;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.search.documents.CmsDocumentDependency;
import org.opencms.search.extractors.CmsExtractionResult;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.search.fields.CmsLuceneField;
import org.opencms.search.fields.CmsSearchField;
import org.opencms.search.fields.CmsSearchFieldConfiguration;
import org.opencms.search.fields.CmsSearchFieldMapping;
import org.opencms.search.fields.CmsSearchFieldMappingType;
import org.opencms.search.fields.I_CmsSearchFieldMapping;
import org.opencms.search.solr.CmsSolrDocument;
import org.opencms.search.solr.CmsSolrDocumentXmlContent;
import org.opencms.search.solr.CmsSolrField;
import org.opencms.search.solr.Messages;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;
import org.opencms.xml.content.I_CmsXmlContentHandler;

public class CmsSolrFieldConfiguration
extends CmsSearchFieldConfiguration {
    private static final Log LOG = CmsLog.getLog(CmsSolrFieldConfiguration.class);
    private Collection<Locale> m_contentLocales;
    private Map<String, CmsSolrField> m_solrFields = new HashMap<String, CmsSolrField>();

    public void addAdditionalFields(List<CmsSolrField> additionalFields) {
        if (additionalFields != null) {
            for (CmsSolrField solrField : additionalFields) {
                this.m_solrFields.put(solrField.getName(), solrField);
            }
        }
    }

    public Map<String, CmsSolrField> getSolrFields() {
        return Collections.unmodifiableMap(this.m_solrFields);
    }

    @Override
    public void init() {
        super.init();
        this.addAdditionalFields();
    }

    @Override
    protected I_CmsSearchDocument appendAdditionalValuesToDcoument(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        String mimeType = OpenCms.getResourceManager().getMimeType(resource.getName(), null);
        if (mimeType != null) {
            document.addSearchField(this.m_solrFields.get("mimetype"), mimeType);
        }
        document.addSearchField(this.m_solrFields.get("filename"), resource.getName());
        document.addSearchField(this.m_solrFields.get("version"), "" + resource.getVersion());
        try {
            I_CmsXmlContentHandler handler;
            if (CmsResourceTypeXmlContent.isXmlContent(resource) && (handler = CmsXmlContentDefinition.getContentHandlerForResource(cms, resource)) != null && handler.isContainerPageOnly()) {
                if (document.getDocument() instanceof SolrInputDocument) {
                    SolrInputDocument doc = (SolrInputDocument)document.getDocument();
                    doc.removeField("search_exclude");
                }
                document.addSearchField(this.m_solrFields.get("search_exclude"), "true");
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        List<String> searchExcludeOptions = document.getMultivaluedFieldAsStringList("search_exclude");
        if (searchExcludeOptions == null || searchExcludeOptions.isEmpty()) {
            document.addSearchField(this.m_solrFields.get("search_exclude"), "false");
        }
        if (resource.getRootPath().startsWith("/system") || CmsResourceTypeJsp.getJSPTypeId() == resource.getTypeId()) {
            document.addSearchField(this.m_solrFields.get("search_channel"), "gallery");
        } else {
            document.addSearchField(this.m_solrFields.get("search_channel"), "content");
        }
        document = this.appendFieldsForListSortOptions(document);
        if (resource.getRootPath().startsWith(OpenCms.getSiteManager().getSharedFolder()) || null != OpenCms.getSiteManager().getSiteRoot(resource.getRootPath())) {
            this.appendSpellFields(document);
        }
        return document;
    }

    @Override
    protected I_CmsSearchDocument appendDates(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        document.addDateField("created", resource.getDateCreated(), false);
        document.addDateField("lastmodified", resource.getDateLastModified(), false);
        document.addDateField("contentdate", resource.getDateContent(), false);
        document.addDateField("released", resource.getDateReleased(), false);
        document.addDateField("expired", resource.getDateExpired(), false);
        return document;
    }

    @Override
    protected I_CmsSearchDocument appendFieldMapping(I_CmsSearchDocument document, CmsSearchField sfield, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        CmsSolrField field = (CmsSolrField)sfield;
        try {
            StringBuffer text = new StringBuffer();
            for (I_CmsSearchFieldMapping mapping : field.getMappings()) {
                String value;
                if (extractionResult != null) {
                    String mapResult = null;
                    if (field.getLocale() != null && mapping.getType().equals(CmsSearchFieldMappingType.CONTENT)) {
                        mapResult = extractionResult.getContent(field.getLocale());
                        if (mapResult == null && !CmsResourceTypeXmlContent.isXmlContent(resource) && !CmsResourceTypeXmlPage.isXmlPage(resource) && this.m_contentLocales != null && this.m_contentLocales.contains(field.getLocale())) {
                            mapResult = extractionResult.getContent();
                        }
                    } else {
                        mapResult = mapping.getStringValue(cms, resource, extractionResult, properties, propertiesSearched);
                    }
                    if (text.length() > 0) {
                        text.append('\n');
                    }
                    if (mapResult != null) {
                        text.append(mapResult);
                        continue;
                    }
                    if (mapping.getDefaultValue() == null) continue;
                    text.append(mapping.getDefaultValue());
                    continue;
                }
                if (mapping.getStringValue(cms, resource, extractionResult, properties, propertiesSearched) == null || (value = mapping.getStringValue(cms, resource, extractionResult, properties, propertiesSearched)) == null) continue;
                document.addSearchField(field, value);
            }
            if (text.length() <= 0 && field.getDefaultValue() != null) {
                text.append(field.getDefaultValue());
            }
            if (text.length() > 0) {
                document.addSearchField(field, text.toString());
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return document;
    }

    @Override
    protected I_CmsSearchDocument appendFieldMappings(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        Set<CmsSearchField> mappedFields;
        ArrayList<String> systemFields = new ArrayList<String>();
        if (null != extractionResult) {
            Map<String, String> fieldMappings = extractionResult.getFieldMappings();
            for (String string : fieldMappings.keySet()) {
                String value = fieldMappings.get(string);
                CmsSolrField f = new CmsSolrField(string, null, null, null);
                document.addSearchField(f, value);
                systemFields.add(string);
            }
        }
        if ((mappedFields = this.getXSDMappings(cms, resource)) != null) {
            for (CmsSearchField cmsSearchField : mappedFields) {
                if (!systemFields.contains(cmsSearchField.getName())) {
                    document = this.appendFieldMapping(document, cmsSearchField, cms, resource, extractionResult, properties, propertiesSearched);
                    continue;
                }
                LOG.error((Object)Messages.get().getBundle().key("LOG_SOLR_ERR_MAPPING_TO_INTERNALLY_USED_FIELD_2", resource.getRootPath(), cmsSearchField.getName()));
            }
        }
        if (CmsResourceTypeXmlContainerPage.isContainerPage(resource)) {
            document = this.appendFieldMappingsFromElementsOnThePage(document, cms, resource, systemFields);
        }
        for (CmsSolrField cmsSolrField : this.m_solrFields.values()) {
            document = this.appendFieldMapping(document, cmsSolrField, cms, resource, extractionResult, properties, propertiesSearched);
        }
        return document;
    }

    protected I_CmsSearchDocument appendFieldMappingsFromElementsOnThePage(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, List<String> systemFields) {
        block8: {
            try {
                CmsFile file = cms.readFile(resource);
                CmsXmlContainerPage containerPage = CmsXmlContainerPageFactory.unmarshal(cms, file);
                CmsContainerPageBean containerBean = containerPage.getContainerPage(cms);
                if (containerBean != null) {
                    for (CmsContainerElementBean element : containerBean.getElements()) {
                        element.initResource(cms);
                        CmsResource elemResource = element.getResource();
                        Set<CmsSearchField> mappedFields = this.getXSDMappingsForPage(cms, elemResource);
                        if (mappedFields == null) continue;
                        for (CmsSearchField field : mappedFields) {
                            if (!systemFields.contains(field.getName())) {
                                try {
                                    CmsExtractionResult extractionResult = CmsSolrDocumentXmlContent.extractXmlContent(cms, elemResource, this.getIndex());
                                    document = this.appendFieldMapping(document, field, cms, elemResource, extractionResult, cms.readPropertyObjects(resource, false), cms.readPropertyObjects(resource, true));
                                }
                                catch (Exception e) {
                                    LOG.error((Object)Messages.get().getBundle().key("LOG_SOLR_ERR_MAPPING_UNREADABLE_CONTENT_3", elemResource.getRootPath(), field.getName(), resource.getRootPath()), (Throwable)e);
                                }
                                continue;
                            }
                            LOG.error((Object)Messages.get().getBundle().key("LOG_SOLR_ERR_MAPPING_TO_INTERNALLY_USED_FIELD_3", elemResource.getRootPath(), field.getName(), resource.getRootPath()));
                        }
                    }
                }
            }
            catch (CmsException e) {
                if (!LOG.isDebugEnabled()) break block8;
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return document;
    }

    @Override
    protected I_CmsSearchDocument appendLocales(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extraction, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        ArrayList<Locale> resourceLocales = new ArrayList();
        if (extraction != null && !extraction.getLocales().isEmpty()) {
            CmsResourceManager resMan = OpenCms.getResourceManager();
            resourceLocales = extraction.getLocales();
            boolean isGroup = false;
            for (String groupType : Arrays.asList("groupcontainer", "inheritance_group")) {
                if (!resMan.matchResourceType(groupType, resource.getTypeId())) continue;
                isGroup = true;
                break;
            }
            this.m_contentLocales = isGroup ? OpenCms.getLocaleManager().getAvailableLocales() : resourceLocales;
        } else {
            resourceLocales = OpenCms.getLocaleManager().getDefaultLocales(cms, resource);
            for (CmsProperty prop : propertiesSearched) {
                if (!prop.getName().equals("Title")) continue;
                String value = prop.getValue();
                List<Locale> availableLocales = OpenCms.getLocaleManager().getAvailableLocales();
                for (Locale locale : availableLocales) {
                    String lang = locale.getLanguage();
                    if (resourceLocales.contains(lang)) continue;
                    String effFieldName = CmsSearchFieldConfiguration.getLocaleExtendedName("title", locale) + "_s";
                    CmsSolrField f = new CmsSolrField(effFieldName, null, null, null);
                    document.addSearchField(f, value);
                }
            }
            this.m_contentLocales = this.getContentLocales(cms, resource, extraction);
        }
        document.addResourceLocales(resourceLocales);
        document.addContentLocales(this.m_contentLocales);
        if (this.hasLocaleDependencies()) {
            CmsDocumentDependency dep = CmsDocumentDependency.load(cms, resource);
            ((CmsSolrDocument)document).addDocumentDependency(cms, dep);
        }
        return document;
    }

    @Override
    protected I_CmsSearchDocument appendProperties(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extraction, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        String value;
        for (CmsProperty prop : propertiesSearched) {
            if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(prop.getValue())) continue;
            value = CmsSearchUtil.stripHtmlFromPropertyIfNecessary(prop.getName(), prop.getValue());
            document.addSearchField(new CmsSolrField(prop.getName() + "_prop", null, null, null), value);
            document.addSearchField(new CmsSolrField(prop.getName() + "_prop" + "_s", null, null, null), value);
        }
        for (CmsProperty prop : properties) {
            if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(prop.getValue())) continue;
            value = CmsSearchUtil.stripHtmlFromPropertyIfNecessary(prop.getName(), prop.getValue());
            document.addSearchField(new CmsSolrField(prop.getName() + "_dprop", null, null, null), value);
            document.addSearchField(new CmsSolrField(prop.getName() + "_dprop" + "_s", null, null, null), value);
        }
        return document;
    }

    protected List<Locale> getContentLocales(CmsObject cms, CmsResource resource, I_CmsExtractionResult extraction) {
        Locale detectedLocale = CmsStringUtil.getLocaleForName(resource.getRootPath());
        if (!OpenCms.getLocaleManager().getAvailableLocales(cms, resource).contains(detectedLocale)) {
            detectedLocale = null;
        }
        if (this.getIndex().isLanguageDetection() && detectedLocale == null && extraction != null && extraction.getContent() != null) {
            detectedLocale = CmsStringUtil.getLocaleForText(extraction.getContent());
        }
        ArrayList<Locale> result = new ArrayList<Locale>();
        if (detectedLocale != null) {
            result.add(detectedLocale);
        } else {
            result.addAll(OpenCms.getLocaleManager().getAvailableLocales(cms, resource));
            LOG.debug((Object)Messages.get().getBundle().key("LOG_LANGUAGE_DETECTION_FAILED_1", resource));
        }
        return result;
    }

    protected Set<CmsSearchField> getXSDMappings(CmsObject cms, CmsResource resource) {
        try {
            I_CmsXmlContentHandler handler;
            if (CmsResourceTypeXmlContent.isXmlContent(resource) && (handler = CmsXmlContentDefinition.getContentHandlerForResource(cms, resource)) != null && !handler.getSearchFields().isEmpty()) {
                return handler.getSearchFields();
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected Set<CmsSearchField> getXSDMappingsForPage(CmsObject cms, CmsResource resource) {
        try {
            I_CmsXmlContentHandler handler;
            if (CmsResourceTypeXmlContent.isXmlContent(resource) && (handler = CmsXmlContentDefinition.getContentHandlerForResource(cms, resource)) != null && !handler.getSearchFieldsForPage().isEmpty()) {
                return handler.getSearchFieldsForPage();
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private void addAdditionalFields() {
        for (CmsSearchField cmsSearchField : this.getFields()) {
            if (!(cmsSearchField instanceof CmsLuceneField)) continue;
            CmsSolrField newSolrField = new CmsSolrField((CmsLuceneField)cmsSearchField);
            this.m_solrFields.put(newSolrField.getName(), newSolrField);
        }
        CmsSolrField solrField = new CmsSolrField("content", null, null, null);
        solrField.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.CONTENT, "content"));
        this.m_solrFields.put(solrField.getName(), solrField);
        for (Locale locale : OpenCms.getLocaleManager().getAvailableLocales()) {
            solrField = new CmsSolrField(CmsSearchFieldConfiguration.getLocaleExtendedName("content", locale), Collections.singletonList(locale.toString() + "_excerpt"), locale, null);
            solrField.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.CONTENT, "content"));
            this.m_solrFields.put(solrField.getName(), solrField);
        }
        CmsSolrField cmsSolrField = new CmsSolrField("mimetype", null, null, null);
        this.m_solrFields.put(cmsSolrField.getName(), cmsSolrField);
        CmsSolrField cmsSolrField2 = new CmsSolrField("filename", null, null, null);
        this.m_solrFields.put(cmsSolrField2.getName(), cmsSolrField2);
        CmsSolrField cmsSolrField3 = new CmsSolrField("version", null, null, null);
        this.m_solrFields.put(cmsSolrField3.getName(), cmsSolrField3);
        CmsSolrField cmsSolrField4 = new CmsSolrField("search_channel", null, null, null);
        this.m_solrFields.put(cmsSolrField4.getName(), cmsSolrField4);
        CmsSolrField cmsSolrField5 = new CmsSolrField("state", null, null, null);
        CmsSearchFieldMapping map = new CmsSearchFieldMapping(CmsSearchFieldMappingType.ATTRIBUTE, "state");
        cmsSolrField5.addMapping(map);
        this.m_solrFields.put(cmsSolrField5.getName(), cmsSolrField5);
        CmsSolrField cmsSolrField6 = new CmsSolrField("userLastModified", null, null, null);
        map = new CmsSearchFieldMapping(CmsSearchFieldMappingType.ATTRIBUTE, "userLastModified");
        cmsSolrField6.addMapping(map);
        this.m_solrFields.put(cmsSolrField6.getName(), cmsSolrField6);
        CmsSolrField cmsSolrField7 = new CmsSolrField("userCreated", null, null, null);
        map = new CmsSearchFieldMapping(CmsSearchFieldMappingType.ATTRIBUTE, "userCreated");
        cmsSolrField7.addMapping(map);
        this.m_solrFields.put(cmsSolrField7.getName(), cmsSolrField7);
        CmsSolrField cmsSolrField8 = new CmsSolrField("meta", null, null, null);
        map = new CmsSearchFieldMapping(CmsSearchFieldMappingType.PROPERTY, "Title");
        cmsSolrField8.addMapping(map);
        map = new CmsSearchFieldMapping(CmsSearchFieldMappingType.PROPERTY, "Description");
        cmsSolrField8.addMapping(map);
        map = new CmsSearchFieldMapping(CmsSearchFieldMappingType.ATTRIBUTE, "name");
        cmsSolrField8.addMapping(map);
        this.m_solrFields.put(cmsSolrField8.getName(), cmsSolrField8);
        CmsSolrField cmsSolrField9 = new CmsSolrField("search_exclude", null, null, null);
        map = new CmsSearchFieldMapping(CmsSearchFieldMappingType.PROPERTY_SEARCH, "search.exclude");
        cmsSolrField9.addMapping(map);
        this.m_solrFields.put(cmsSolrField9.getName(), cmsSolrField9);
    }

    private I_CmsSearchDocument appendFieldsForListSortOptions(I_CmsSearchDocument document) {
        String dispOrder;
        String dispTitle;
        String fieldName = "instancedate_dt";
        Date instanceDate = document.getFieldValueAsDate(fieldName);
        if (null == instanceDate || instanceDate.getTime() == 0L) {
            String instanceDateCopyField = document.getFieldValueAsString("instancedate.copyfield_prop");
            if (null != instanceDateCopyField) {
                instanceDate = document.getFieldValueAsDate(instanceDateCopyField);
            }
            if (null == instanceDate || instanceDate.getTime() == 0L) {
                instanceDate = document.getFieldValueAsDate("released");
            }
            if (null == instanceDate || instanceDate.getTime() == 0L) {
                instanceDate = document.getFieldValueAsDate("lastmodified");
            }
            document.addDateField(fieldName, instanceDate.getTime(), false);
        }
        fieldName = "instancedaterange_dr";
        String instanceDateString = document.getFieldValueAsString("instancedate_dt");
        String instanceDateRangeString = "[" + instanceDateString + " TO " + instanceDateString + "]";
        ((SolrInputDocument)document.getDocument()).setField(fieldName, (Object)instanceDateRangeString);
        fieldName = "instancedatecurrenttill_dt";
        Date instanceDateCurrentTill = document.getFieldValueAsDate(fieldName);
        if (null == instanceDateCurrentTill || instanceDateCurrentTill.getTime() == 0L) {
            document.addDateField(fieldName, instanceDate.getTime(), false);
        }
        if (null == (dispTitle = document.getFieldValueAsString(fieldName = "disptitle_sort"))) {
            dispTitle = document.getFieldValueAsString("Title_dprop");
            if (null == dispTitle) {
                dispTitle = document.getFieldValueAsString("filename");
            }
            document.addSearchField(new CmsSolrField(fieldName, null, null, null), dispTitle);
        }
        if (null == (dispOrder = document.getFieldValueAsString(fieldName = "disporder_i"))) {
            dispOrder = document.getFieldValueAsString("display-order_prop");
            if (null != dispOrder) {
                try {
                    int o = Integer.parseInt(dispOrder);
                    dispOrder = String.valueOf(o);
                }
                catch (NullPointerException | NumberFormatException e) {
                    LOG.warn((Object)"Property display-order contains not a valid integer number.");
                    dispOrder = "0";
                }
            } else {
                dispOrder = "0";
            }
            document.addSearchField(new CmsSolrField(fieldName, null, null, null), dispOrder);
        }
        for (String locale : document.getMultivaluedFieldAsStringList("con_locales")) {
            fieldName = "instancedate_" + locale + "_dt";
            Date localeInstanceDate = document.getFieldValueAsDate(fieldName);
            if (null == localeInstanceDate || localeInstanceDate.getTime() == 0L) {
                localeInstanceDate = instanceDate;
                document.addDateField(fieldName, localeInstanceDate.getTime(), false);
            }
            fieldName = "instancedaterange_" + locale + "_dr";
            String localeInstanceDateString = document.getFieldValueAsString("instancedate_" + locale + "_dt");
            String localeInstanceDateRangeString = "[" + localeInstanceDateString + " TO " + localeInstanceDateString + "]";
            ((SolrInputDocument)document.getDocument()).setField(fieldName, (Object)localeInstanceDateRangeString);
            fieldName = "instancedatecurrenttill_" + locale + "_dt";
            Date localeInstanceDateCurrentTill = document.getFieldValueAsDate(fieldName);
            if (null == localeInstanceDateCurrentTill || localeInstanceDateCurrentTill.getTime() == 0L) {
                document.addDateField(fieldName, localeInstanceDate.getTime(), false);
            }
            if (null == document.getFieldValueAsString(fieldName = "disptitle_" + locale + "_sort")) {
                String localizedTitle = document.getFieldValueAsString("Title_" + locale + "_dprop");
                document.addSearchField(new CmsSolrField(fieldName, null, null, null), null == localizedTitle ? dispTitle : localizedTitle);
            }
            if (null != document.getFieldValueAsString(fieldName = "disporder_" + locale + "_i")) continue;
            String localizedOrder = document.getFieldValueAsString("display-order_" + locale + "_prop");
            if (null != localizedOrder) {
                try {
                    int o = Integer.parseInt(localizedOrder);
                    localizedOrder = String.valueOf(o);
                }
                catch (NullPointerException | NumberFormatException e) {
                    LOG.warn((Object)("Property display-order_" + locale + " contains not a valid integer number."));
                }
            }
            document.addSearchField(new CmsSolrField(fieldName, null, null, null), null == localizedOrder ? dispOrder : localizedOrder);
        }
        return document;
    }

    private void appendSpellFields(I_CmsSearchDocument document) {
        String title = document.getFieldValueAsString("Title_dprop");
        document.addSearchField(new CmsSolrField("spell", null, null, null), document.getFieldValueAsString("content") + "\n" + title);
        for (Locale locale : OpenCms.getLocaleManager().getAvailableLocales()) {
            document.addSearchField(new CmsSolrField(locale + "_" + "spell", null, locale, null), document.getFieldValueAsString(CmsSearchFieldConfiguration.getLocaleExtendedName("content", locale)) + "\n" + title);
        }
    }

    private boolean hasLocaleDependencies() {
        for (CmsSearchIndexSource source : this.getIndex().getSources()) {
            if (!source.getIndexer().isLocaleDependenciesEnable()) continue;
            return true;
        }
        return false;
    }
}

