/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.security;

import java.util.Locale;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.security.I_CmsValidationHandler;
import org.opencms.security.Messages;
import org.opencms.util.CmsStringUtil;

public class CmsDefaultValidationHandler
implements I_CmsValidationHandler {
    public static final String EMAIL_REGEX = "\\A[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc](?:[a-z0-9\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc-]*[a-z0-9\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc])?\\.)+[a-z0-9\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc](?:[a-z0-9\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc-]*[a-z0-9\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc])?\\z";
    public static final String USERNAME_CONSTRAINTS = "-._~$@";
    public static final String ZIPCODE_REGEX = "[\\w]*";

    @Override
    public void checkEmail(String email) throws CmsIllegalArgumentException {
        if (CmsStringUtil.isNotEmpty(email)) {
            email = email.trim();
            email = email.toLowerCase(Locale.ROOT);
        }
        if (!CmsStringUtil.validateRegex(email, EMAIL_REGEX, false)) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_EMAIL_VALIDATION_1", email));
        }
    }

    @Override
    public void checkFirstname(String firstname) throws CmsIllegalArgumentException {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(firstname)) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_FIRSTNAME_EMPTY_0"));
        }
    }

    @Override
    public void checkGroupName(String name) throws CmsIllegalArgumentException {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(name)) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_BAD_GROUPNAME_EMPTY_0"));
        }
    }

    @Override
    public void checkLastname(String lastname) throws CmsIllegalArgumentException {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(lastname)) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_LASTNAME_EMPTY_0"));
        }
    }

    @Override
    public void checkUserName(String userName) throws CmsIllegalArgumentException {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(userName)) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_BAD_USERNAME_EMPTY_0", userName));
        }
        CmsStringUtil.checkName(userName, USERNAME_CONSTRAINTS, "ERR_BAD_USERNAME_4", Messages.get());
    }

    @Override
    public void checkZipCode(String zipcode) throws CmsIllegalArgumentException {
        if (!CmsStringUtil.validateRegex(zipcode, ZIPCODE_REGEX, true)) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_ZIPCODE_VALIDATION_1", zipcode));
        }
    }
}

