/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.security.twofactor;

import java.util.List;
import java.util.stream.Collectors;
import org.dom4j.Element;
import org.opencms.security.twofactor.CmsTwoFactorAuthenticationUserPolicy;

public class CmsTwoFactorAuthenticationConfig {
    private Element m_element;
    private boolean m_enabled;
    private String m_issuer;
    private CmsTwoFactorAuthenticationUserPolicy m_policy;
    private String m_secret;
    private String m_setupMessage;

    public CmsTwoFactorAuthenticationConfig(Element element) {
        this.m_element = element;
        Element issuerElem = (Element)element.selectSingleNode("issuer");
        this.m_issuer = issuerElem.getTextTrim();
        this.m_enabled = Boolean.parseBoolean(((Element)element.selectSingleNode("enabled")).getTextTrim());
        this.m_secret = ((Element)element.selectSingleNode("secret")).getTextTrim();
        this.m_policy = this.parsePolicy(element);
        Element messageElem = (Element)element.selectSingleNode("setup-message");
        if (messageElem != null) {
            this.m_setupMessage = messageElem.getText();
        }
    }

    public Element getConfigElement() {
        return this.m_element;
    }

    public String getIssuer() {
        return this.m_issuer;
    }

    public CmsTwoFactorAuthenticationUserPolicy getPolicy() {
        return this.m_policy;
    }

    public String getSecret() {
        return this.m_secret;
    }

    public String getSetupMessage() {
        return this.m_setupMessage;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    private CmsTwoFactorAuthenticationUserPolicy parsePolicy(Element parent) {
        List<CmsTwoFactorAuthenticationUserPolicy.Rule> includes = this.parsePolicyRules(parent, "include-users/*");
        List<CmsTwoFactorAuthenticationUserPolicy.Rule> excludes = this.parsePolicyRules(parent, "exclude-users/*");
        return new CmsTwoFactorAuthenticationUserPolicy(includes, excludes);
    }

    private List<CmsTwoFactorAuthenticationUserPolicy.Rule> parsePolicyRules(Element parent, String xpath) {
        return parent.selectNodes(xpath).stream().map(node -> {
            Element elem = (Element)node;
            CmsTwoFactorAuthenticationUserPolicy.CheckType type = CmsTwoFactorAuthenticationUserPolicy.CheckType.valueOf(elem.getName());
            String name = elem.getTextTrim();
            return new CmsTwoFactorAuthenticationUserPolicy.Rule(type, name);
        }).collect(Collectors.toList());
    }
}

