/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.security.twofactor;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.util.CmsStringUtil;

public class CmsTwoFactorAuthenticationUserPolicy {
    private static final Log LOG = CmsLog.getLog(CmsTwoFactorAuthenticationUserPolicy.class);
    private List<Rule> m_excludes = new ArrayList<Rule>();
    private List<Rule> m_includes = new ArrayList<Rule>();

    public CmsTwoFactorAuthenticationUserPolicy(List<Rule> include, List<Rule> exclude) {
        this.m_includes = new ArrayList<Rule>(include);
        this.m_excludes = new ArrayList<Rule>(exclude);
    }

    public boolean shouldUseTwoFactorAuthentication(CmsObject cms, CmsUser user) {
        UserCheckContext context = new UserCheckContext(cms, user);
        return this.checkIncluded(context) && !this.checkExcluded(context);
    }

    private boolean check(UserCheckContext context, Rule entry) {
        if (entry.getType() == CheckType.orgunit) {
            String entryOu = this.normalizeOu(entry.getValue());
            String ou = context.getUser().getOuFqn();
            while (ou != null) {
                if (entryOu.equals(this.normalizeOu(ou))) {
                    return true;
                }
                ou = CmsOrganizationalUnit.getParentFqn(ou);
            }
        } else {
            if (entry.getType() == CheckType.group) {
                try {
                    return context.getGroupNames().contains(entry.getValue());
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    return false;
                }
            }
            if (entry.getType() == CheckType.pattern) {
                return entry.getPattern().matcher(context.getUser().getName()).matches();
            }
        }
        return false;
    }

    private boolean checkExcluded(UserCheckContext context) {
        return this.m_excludes.stream().anyMatch(exclude -> this.check(context, (Rule)exclude));
    }

    private boolean checkIncluded(UserCheckContext context) {
        if (this.m_includes.size() == 0) {
            return true;
        }
        return this.m_includes.stream().anyMatch(include -> this.check(context, (Rule)include));
    }

    private String normalizeOu(String name) {
        return CmsStringUtil.joinPaths("/", name, "/");
    }

    protected static class UserCheckContext {
        private CmsObject m_cms;
        private Set<String> m_groupNames;
        private CmsUser m_user;

        public UserCheckContext(CmsObject cms, CmsUser user) {
            this.m_cms = cms;
            this.m_user = user;
        }

        public Set<String> getGroupNames() throws CmsException {
            if (this.m_groupNames == null) {
                this.m_groupNames = this.m_cms.getGroupsOfUser(this.m_user.getName(), false).stream().map(group -> group.getName()).collect(Collectors.toSet());
            }
            return this.m_groupNames;
        }

        public CmsUser getUser() {
            return this.m_user;
        }
    }

    public static class Rule {
        private CheckType m_type;
        private String m_value;
        private Pattern m_pattern;

        public Rule(CheckType type, String value) {
            this.m_type = type;
            this.m_value = value;
            if (type == CheckType.pattern) {
                this.m_pattern = Pattern.compile(this.m_value);
            }
        }

        public Pattern getPattern() {
            return this.m_pattern;
        }

        public CheckType getType() {
            return this.m_type;
        }

        public String getValue() {
            return this.m_value;
        }
    }

    public static enum CheckType {
        group,
        pattern,
        orgunit;

    }
}

