/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.staticexport;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsSingleTreeLocaleHandler;
import org.opencms.main.OpenCms;
import org.opencms.site.CmsSite;
import org.opencms.staticexport.CmsDefaultLinkSubstitutionHandler;
import org.opencms.util.CmsPair;
import org.opencms.util.CmsStringUtil;

public class CmsLocalePrefixLinkSubstitutionHandler
extends CmsDefaultLinkSubstitutionHandler {
    @Override
    protected CmsPair<String, String> addVfsPrefix(CmsObject cms, String vfsName, CmsSite targetSite, String parameters) {
        if (CmsSite.LocalizationMode.singleTree.equals((Object)targetSite.getLocalizationMode())) {
            String localeFromParameterString;
            Pattern pattern;
            Matcher matcher;
            Locale localeFromParameter = null;
            if (null != parameters && (matcher = (pattern = Pattern.compile("(.*)__locale=([^&]*)(.*)")).matcher(parameters)).find() && (localeFromParameterString = matcher.group(2)) != null && !localeFromParameterString.isEmpty()) {
                Locale l = CmsLocaleManager.getLocale(localeFromParameterString);
                if (OpenCms.getLocaleManager().getAvailableLocales(cms, vfsName).contains(l)) {
                    localeFromParameter = l;
                    if (matcher.group(3).isEmpty()) {
                        parameters = matcher.group(1).substring(0, matcher.group(1).length() - 1);
                        if (parameters.isEmpty()) {
                            parameters = null;
                        }
                    } else {
                        parameters = matcher.group(1) + matcher.group(3).substring(1);
                    }
                }
            }
            return new CmsPair<String, String>(CmsStringUtil.joinPaths(OpenCms.getStaticExportManager().getVfsPrefix(), null != localeFromParameter ? localeFromParameter.toString() : cms.getRequestContext().getLocale().toString(), vfsName), parameters);
        }
        return super.addVfsPrefix(cms, vfsName, targetSite, parameters);
    }

    @Override
    protected String generateCacheKey(CmsObject cms, String sourceSiteRoot, String targetSiteRoot, String detailPagePart, String absoluteLink) {
        return "" + cms.getRequestContext().getCurrentUser().getId() + ":" + cms.getRequestContext().getSiteRoot() + ":" + sourceSiteRoot + ":" + targetSiteRoot + ":" + detailPagePart + absoluteLink + ":" + cms.getRequestContext().getLocale().toString();
    }

    @Override
    protected String getRootPathForSite(CmsObject cms, String path, String siteRoot, boolean isRootPath) {
        CmsSite site = OpenCms.getSiteManager().getSiteForSiteRoot(siteRoot);
        if (site != null && CmsSite.LocalizationMode.singleTree.equals((Object)site.getLocalizationMode())) {
            Locale locale;
            if (isRootPath) {
                path = path.substring(site.getSiteRoot().length());
            }
            if ((locale = CmsSingleTreeLocaleHandler.getLocaleFromPath(path)) != null) {
                path = path.substring(locale.toString().length() + 1);
            }
            return cms.getRequestContext().addSiteRoot(site.getSiteRoot(), path);
        }
        return super.getRootPathForSite(cms, path, siteRoot, isRootPath);
    }

    @Override
    protected String prepareExportParameters(CmsObject cms, String vfsName, String parameters) {
        CmsSite site = OpenCms.getSiteManager().getSiteForSiteRoot(cms.getRequestContext().getSiteRoot());
        if (site != null && CmsSite.LocalizationMode.singleTree.equals((Object)site.getLocalizationMode()) && !OpenCms.getSiteManager().startsWithShared(vfsName) && !vfsName.startsWith("/system/")) {
            parameters = parameters != null ? parameters + "&" : "?";
            parameters = parameters + "__locale=" + cms.getRequestContext().getLocale().toString();
        }
        return parameters;
    }
}

