/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ugc;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.gwt.CmsGwtService;
import org.opencms.gwt.CmsRpcException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ugc.CmsUgcSession;
import org.opencms.ugc.CmsUgcSessionFactory;
import org.opencms.ugc.I_CmsFormDataHandler;
import org.opencms.ugc.I_CmsFormDataItem;
import org.opencms.ugc.shared.CmsUgcContent;
import org.opencms.ugc.shared.CmsUgcException;
import org.opencms.ugc.shared.rpc.I_CmsUgcEditService;
import org.opencms.util.CmsUUID;
import org.opencms.xml.content.CmsXmlContentErrorHandler;

public class CmsUgcEditService
extends CmsGwtService
implements I_CmsUgcEditService {
    private static final Log LOG = CmsLog.getLog(CmsUgcEditService.class);
    private static final long serialVersionUID = 5479252081304867604L;

    @Override
    public void checkPermissions(CmsObject cms) {
    }

    @Override
    public void destroySession(CmsUUID sessionId) throws CmsUgcException {
        try {
            CmsUgcSession formSession = this.getFormSession(sessionId);
            this.getRequest().getSession().removeAttribute("" + sessionId);
            if (formSession != null) {
                formSession.onSessionDestroyed();
            }
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    @Override
    public void error(Throwable t) throws CmsUgcException {
        this.logError(t);
        CmsUgcException exception = t instanceof CmsUgcException ? (CmsUgcException)t : new CmsUgcException(t);
        throw exception;
    }

    @Override
    public CmsUgcContent getContent(CmsUUID sessionId) throws CmsUgcException {
        CmsUgcContent formContent = null;
        try {
            CmsUgcSession session = CmsUgcSessionFactory.getInstance().getSession(this.getRequest(), sessionId);
            formContent = this.readContent(session, session.getResource());
        }
        catch (Exception e) {
            this.error(e);
        }
        return formContent;
    }

    @Override
    public String getLink(String path) {
        return OpenCms.getLinkManager().substituteLink(this.getCmsObject(), path);
    }

    @Override
    public Map<String, String> saveContent(CmsUUID sessionId, Map<String, String> contentValues) throws CmsUgcException {
        Map<Object, Object> result = null;
        try {
            CmsUgcSession session = this.getFormSession(sessionId);
            if (session != null && sessionId.equals(session.getId())) {
                CmsXmlContentErrorHandler errorHandler = session.saveContent(contentValues);
                if (errorHandler.hasErrors()) {
                    result = errorHandler.getErrors(session.getMessageLocale());
                } else {
                    session.finish();
                    result = Collections.emptyMap();
                }
            }
        }
        catch (Exception e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public Map<String, String> uploadFiles(CmsUUID sessionId, final Set<String> fieldNames, final String formDataId) throws CmsRpcException {
        try {
            final CmsUgcSession session = this.getFormSession(sessionId);
            final HashMap result = Maps.newHashMap();
            session.getFormUploadHelper().consumeFormData(formDataId, new I_CmsFormDataHandler(){

                @Override
                public void handleFormData(Map<String, I_CmsFormDataItem> items) throws Exception {
                    for (String fieldName : fieldNames) {
                        I_CmsFormDataItem item = items.get(fieldName);
                        if (item != null) {
                            CmsResource createdResource = session.createUploadResource(item.getFieldName(), item.getFileName(), item.getData());
                            String sitePath = session.getCmsObject().getSitePath(createdResource);
                            result.put(fieldName, sitePath);
                            continue;
                        }
                        LOG.debug((Object)(formDataId + ": requested upload for field " + fieldName + " which was empty."));
                    }
                }
            });
            return result;
        }
        catch (Exception e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public Map<String, String> validateContent(CmsUUID sessionId, Map<String, String> contentValues) throws CmsUgcException {
        Map<Object, Object> result = Maps.newHashMap();
        try {
            CmsUgcSession session = this.getFormSession(sessionId);
            if (session != null && sessionId.equals(session.getId())) {
                CmsXmlContentErrorHandler errorHandler = session.validateContent(contentValues);
                result = errorHandler.getErrors(session.getMessageLocale());
            }
        }
        catch (Exception e) {
            this.error(e);
        }
        return result;
    }

    protected void handleUpload(HttpServletRequest request, HttpServletResponse response) {
        String sessionIdStr = request.getParameter("formSessionId");
        CmsUUID sessionId = new CmsUUID(sessionIdStr);
        CmsUgcSession session = CmsUgcSessionFactory.getInstance().getSession(request, sessionId);
        session.getFormUploadHelper().processFormSubmitRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean isMultiPart = FileUploadBase.isMultipartContent((RequestContext)new ServletRequestContext(request));
        if (isMultiPart) {
            try {
                this.handleUpload(request, response);
            }
            finally {
                this.clearThreadStorage();
            }
        } else {
            super.service(request, response);
        }
    }

    private CmsUgcSession getFormSession(CmsUUID sessionId) {
        return CmsUgcSessionFactory.getInstance().getSession(this.getRequest(), sessionId);
    }

    private CmsUgcContent readContent(CmsUgcSession session, CmsResource resource) throws CmsException {
        CmsUgcContent formContent = new CmsUgcContent();
        Map<String, String> contentValues = session.getValues();
        formContent.setContentValues(contentValues);
        formContent.setSessionId(session.getId());
        formContent.setResourceType(OpenCms.getResourceManager().getResourceType(resource).getTypeName());
        formContent.setSitePath(this.getCmsObject().getSitePath(resource));
        formContent.setStrucureId(resource.getStructureId());
        return formContent;
    }
}

