/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ugc;

import org.opencms.ugc.CmsUgcConfiguration;

public class CmsUgcSessionQueue {
    private boolean m_enabled;
    private long m_interval;
    private int m_maxLength;
    private long m_nextScheduleTime;
    private int m_waitCount;

    public CmsUgcSessionQueue(boolean enabled, long interval, int maxLength) {
        this.m_enabled = enabled;
        this.m_interval = interval;
        this.m_maxLength = maxLength;
        if (interval < 0L) {
            throw new IllegalArgumentException("Queue wait time must not be < 0");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Queue maximum length must not be < 0");
        }
    }

    public static CmsUgcSessionQueue createQueue(CmsUgcConfiguration config) {
        CmsUgcSessionQueue queue = new CmsUgcSessionQueue(config.needsQueue(), config.getQueueInterval().isPresent() ? (Long)config.getQueueInterval().get() : 0L, config.getMaxQueueLength().isPresent() ? (Integer)config.getMaxQueueLength().get() : Integer.MAX_VALUE);
        return queue;
    }

    public synchronized void updateFromConfiguration(CmsUgcConfiguration config) {
        this.m_enabled = config.needsQueue();
        this.m_interval = config.getQueueInterval().isPresent() ? (Long)config.getQueueInterval().get() : 0L;
        this.m_maxLength = config.getMaxQueueLength().isPresent() ? (Integer)config.getMaxQueueLength().get() : Integer.MAX_VALUE;
    }

    public synchronized boolean waitForSlot() {
        if (!this.m_enabled) {
            return true;
        }
        long now = System.currentTimeMillis();
        long timeToWait = this.m_nextScheduleTime - now;
        if (timeToWait <= 0L) {
            this.m_nextScheduleTime = now + this.m_interval;
            return true;
        }
        if (this.m_waitCount >= this.m_maxLength) {
            return false;
        }
        this.m_nextScheduleTime += this.m_interval;
        ++this.m_waitCount;
        try {
            this.wait(timeToWait);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        --this.m_waitCount;
        return true;
    }
}

