/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.vaadin.server.ErrorMessage;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.FontIcon;
import com.vaadin.server.Resource;
import com.vaadin.server.VaadinService;
import com.vaadin.shared.MouseEventDetails;
import com.vaadin.shared.Version;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.HasComponents;
import com.vaadin.ui.JavaScript;
import com.vaadin.ui.Panel;
import com.vaadin.ui.SingleComponentContainer;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import com.vaadin.ui.declarative.Design;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.event.ItemClickEvent;
import com.vaadin.v7.shared.ui.combobox.FilteringMode;
import com.vaadin.v7.ui.AbstractField;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.OptionGroup;
import com.vaadin.v7.ui.Table;
import com.vaadin.v7.ui.VerticalLayout;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.logging.Log;
import org.opencms.ade.galleries.CmsSiteSelectorOptionBuilder;
import org.opencms.ade.galleries.shared.CmsSiteSelectorOption;
import org.opencms.configuration.preferences.CmsLanguagePreference;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsUser;
import org.opencms.file.types.A_CmsResourceTypeFolderBase;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsMessages;
import org.opencms.i18n.I_CmsMessageBundle;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsRole;
import org.opencms.security.I_CmsPrincipal;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsCssIcon;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.apps.user.CmsOUHandler;
import org.opencms.ui.contextmenu.CmsContextMenu;
import org.opencms.ui.contextmenu.I_CmsSimpleContextMenuEntry;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceMessages;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.explorer.CmsResourceUtil;

public final class CmsVaadinUtils {
    public static final Container.Filter FILTER_NO_FOLDERS = new Container.Filter(){
        private static final long serialVersionUID = 1L;

        public boolean appliesToProperty(Object propertyId) {
            return PropertyId.isFolder.equals(propertyId);
        }

        public boolean passesFilter(Object itemId, Item item) throws UnsupportedOperationException {
            return (Boolean)item.getItemProperty((Object)PropertyId.isFolder).getValue() == false;
        }
    };
    public static final Container.Filter FILTER_XML_CONTENTS = new Container.Filter(){
        private static final long serialVersionUID = 1L;

        public boolean appliesToProperty(Object propertyId) {
            return PropertyId.isXmlContent.equals(propertyId);
        }

        public boolean passesFilter(Object itemId, Item item) throws UnsupportedOperationException {
            return (Boolean)item.getItemProperty((Object)PropertyId.isXmlContent).getValue();
        }
    };
    public static final String PROPERTY_LABEL = "label";
    public static final String PROPERTY_VALUE = "value";
    protected static final String BOOTSTRAP_SCRIPT = "vaadin.initApplication(\"%(elementId)\", {\n        \"browserDetailsUrl\": \"%(vaadinServlet)\",\n        \"serviceUrl\": \"%(vaadinServlet)\",\n        \"widgetset\": \"org.opencms.ui.WidgetSet\",\n        \"theme\": \"opencms\",\n        \"versionInfo\": {\"vaadinVersion\": \"%(vaadinVersion)\"},\n        \"vaadinDir\": \"%(vaadinDir)\",\n        \"heartbeatInterval\": 30,\n        \"debug\": false,\n        \"standalone\": false,\n        \"authErrMsg\": {\n            \"message\": \"Take note of any unsaved data, \"+\n                       \"and <u>click here<\\/u> to continue.\",\n            \"caption\": \"Authentication problem\"\n        },\n        \"comErrMsg\": {\n            \"message\": \"Take note of any unsaved data, \"+\n                       \"and <u>click here<\\/u> to continue.\",\n            \"caption\": \"Communication problem\"\n        },\n        \"sessExpMsg\": {\n            \"message\": \"Take note of any unsaved data, \"+\n                       \"and <u>click here<\\/u> to continue.\",\n            \"caption\": \"Session Expired\"\n        }\n    });";
    private static final Log LOG = CmsLog.getLog(CmsVaadinUtils.class);

    private CmsVaadinUtils() {
    }

    public static IndexedContainer buildContainerFromMap(String captionProperty, Map<String, String> map) {
        IndexedContainer container = new IndexedContainer();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            container.addItem((Object)entry.getKey()).getItemProperty((Object)captionProperty).setValue((Object)entry.getValue());
        }
        return container;
    }

    public static void centerWindow(Component component) {
        Window window = CmsVaadinUtils.getWindow(component);
        if (window != null) {
            window.center();
        }
    }

    public static void closeWindow(Component component) {
        Window window = CmsVaadinUtils.getWindow(component);
        if (window != null) {
            window.close();
        }
    }

    public static Button.ClickListener createClickListener(final Runnable action) {
        return new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                action.run();
            }
        };
    }

    public static <T> void defaultHandleContextMenuForMultiselect(Table table, CmsContextMenu menu, ItemClickEvent event, List<I_CmsSimpleContextMenuEntry<Collection<T>>> entries) {
        if (!event.isCtrlKey() && !event.isShiftKey() && event.getButton().equals((Object)MouseEventDetails.MouseButton.RIGHT)) {
            Collection oldValue = (Collection)table.getValue();
            if (oldValue.isEmpty() || !oldValue.contains(event.getItemId())) {
                table.setValue(new HashSet<Object>(Arrays.asList(event.getItemId())));
            }
            Collection selection = (Collection)table.getValue();
            menu.setEntries(entries, selection);
            menu.openForTable(event, table);
        }
    }

    public static InputStream filterUtf8ResourceStream(InputStream stream, Function<String, String> transformation) {
        try {
            byte[] streamData = CmsFileUtil.readFully(stream);
            String dataAsString = new String(streamData, "UTF-8");
            byte[] transformedData = ((String)transformation.apply((Object)dataAsString)).getBytes("UTF-8");
            return new ByteArrayInputStream(transformedData);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        catch (IOException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static IndexedContainer getAvailableGroupsContainerWithout(CmsObject cms, String ouFqn, String propCaption, String propIcon, String propOu, List<CmsGroup> blackList, java.util.function.Function<CmsGroup, CmsCssIcon> iconProvider) {
        if (blackList == null) {
            blackList = new ArrayList<CmsGroup>();
        }
        IndexedContainer res = new IndexedContainer();
        res.addContainerProperty((Object)propCaption, String.class, (Object)"");
        res.addContainerProperty((Object)propOu, String.class, (Object)"");
        if (propIcon != null) {
            res.addContainerProperty((Object)propIcon, CmsCssIcon.class, null);
        }
        try {
            for (CmsGroup group : OpenCms.getRoleManager().getManageableGroups(cms, ouFqn, true)) {
                Item item;
                if (blackList.contains(group) || (item = res.addItem((Object)group)) == null) continue;
                if (iconProvider != null) {
                    item.getItemProperty((Object)propIcon).setValue((Object)iconProvider.apply(group));
                }
                item.getItemProperty((Object)propCaption).setValue((Object)group.getSimpleName());
                item.getItemProperty((Object)propOu).setValue((Object)group.getOuFqn());
            }
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to read groups", (Throwable)e);
        }
        return res;
    }

    public static List<CmsProject> getAvailableProjects(CmsObject cms) {
        List<CmsProject> allProjects;
        try {
            String ouFqn = "";
            CmsUserSettings settings = new CmsUserSettings(cms);
            if (!settings.getListAllProjects()) {
                ouFqn = cms.getRequestContext().getCurrentUser().getOuFqn();
            }
            allProjects = new ArrayList<CmsProject>(OpenCms.getOrgUnitManager().getAllAccessibleProjects(cms, ouFqn, settings.getListAllProjects()));
            Iterator<CmsProject> itProjects = allProjects.iterator();
            while (itProjects.hasNext()) {
                CmsProject prj = itProjects.next();
                if (!prj.isHiddenFromSelector()) continue;
                itProjects.remove();
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            allProjects = Collections.emptyList();
        }
        return allProjects;
    }

    public static IndexedContainer getAvailableSitesContainer(CmsObject cms, String captionPropertyName) {
        IndexedContainer availableSites = new IndexedContainer();
        availableSites.addContainerProperty((Object)captionPropertyName, String.class, null);
        for (Map.Entry<String, String> entry : CmsVaadinUtils.getAvailableSitesMap(cms).entrySet()) {
            Item siteItem = availableSites.addItem((Object)entry.getKey());
            siteItem.getItemProperty((Object)captionPropertyName).setValue((Object)entry.getValue());
        }
        return availableSites;
    }

    public static LinkedHashMap<String, String> getAvailableSitesMap(CmsObject cms) {
        CmsSiteSelectorOptionBuilder optBuilder = new CmsSiteSelectorOptionBuilder(cms);
        optBuilder.addNormalSites(true, new CmsUserSettings(cms).getStartFolder());
        optBuilder.addSharedSite();
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (CmsSiteSelectorOption option : optBuilder.getOptions()) {
            result.put(option.getSiteRoot(), option.getMessage());
        }
        String currentSiteRoot = cms.getRequestContext().getSiteRoot();
        if (!result.containsKey(currentSiteRoot)) {
            result.put(currentSiteRoot, currentSiteRoot);
        }
        return result;
    }

    public static String getBootstrapScript(CmsObject cms, String elementId, String servicePath) throws Exception {
        String script = BOOTSTRAP_SCRIPT;
        CmsMacroResolver resolver = new CmsMacroResolver();
        String context = OpenCms.getSystemInfo().getContextPath();
        String vaadinDir = CmsStringUtil.joinPaths(context, "VAADIN/");
        String vaadinVersion = Version.getFullVersion();
        String vaadinServlet = CmsStringUtil.joinPaths(context, servicePath);
        String vaadinBootstrap = CmsStringUtil.joinPaths(context, "VAADIN/vaadinBootstrap.js");
        resolver.addMacro("vaadinDir", vaadinDir);
        resolver.addMacro("vaadinVersion", vaadinVersion);
        resolver.addMacro("elementId", elementId);
        resolver.addMacro("vaadinServlet", vaadinServlet);
        resolver.addMacro("vaadinBootstrap", vaadinBootstrap);
        script = resolver.resolveMacros(script);
        return script;
    }

    public static String getDefaultDesignPath(Component component) {
        String className = component.getClass().getName();
        String designPath = className.replace(".", "/") + ".html";
        return designPath;
    }

    public static IndexedContainer getGroupsOfUser(CmsObject cms, CmsUser user, String caption, String iconProp, String ou, String propStatus, Function<CmsGroup, CmsCssIcon> iconProvider) {
        IndexedContainer container = new IndexedContainer();
        container.addContainerProperty((Object)caption, String.class, (Object)"");
        container.addContainerProperty((Object)ou, String.class, (Object)"");
        container.addContainerProperty((Object)propStatus, Boolean.class, (Object)true);
        if (iconProvider != null) {
            container.addContainerProperty((Object)iconProp, CmsCssIcon.class, null);
        }
        try {
            for (CmsGroup group : cms.getGroupsOfUser(user.getName(), true)) {
                Item item = container.addItem((Object)group);
                item.getItemProperty((Object)caption).setValue((Object)group.getSimpleName());
                item.getItemProperty((Object)ou).setValue((Object)group.getOuFqn());
                if (iconProvider == null) continue;
                item.getItemProperty((Object)iconProp).setValue(iconProvider.apply((Object)group));
            }
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to read groups from user", (Throwable)e);
        }
        return container;
    }

    public static VerticalLayout getInfoLayout(String messageString) {
        VerticalLayout ret = new VerticalLayout();
        ret.setMargin(true);
        ret.addStyleName("o-center");
        ret.setWidth("100%");
        VerticalLayout inner = new VerticalLayout();
        inner.addStyleName("o-workplace-maxwidth");
        Panel panel = new Panel();
        panel.setWidth("100%");
        Label label = new Label(CmsVaadinUtils.getMessageText(messageString, new Object[0]));
        label.addStyleName("o-report");
        panel.setContent((Component)label);
        inner.addComponent((Component)panel);
        ret.addComponent((Component)inner);
        return ret;
    }

    public static IndexedContainer getLanguageContainer(String captionPropertyName) {
        IndexedContainer result = new IndexedContainer();
        result.addContainerProperty((Object)captionPropertyName, String.class, (Object)"");
        for (Locale locale : OpenCms.getLocaleManager().getAvailableLocales()) {
            Item item = result.addItem((Object)locale);
            item.getItemProperty((Object)captionPropertyName).setValue((Object)locale.getDisplayName(A_CmsUI.get().getLocale()));
        }
        return result;
    }

    public static String getMessageText(I_CmsMessageBundle messages, String key, Object ... args) {
        return messages.getBundle(A_CmsUI.get().getLocale()).key(key, args);
    }

    public static String getMessageText(String key, Object ... args) {
        return CmsVaadinUtils.getWpMessagesForCurrentLocale().key(key, args);
    }

    public static ComboBox getOUComboBox(CmsObject cms, String baseOu, Log log) {
        return CmsVaadinUtils.getOUComboBox(cms, baseOu, log, true);
    }

    public static ComboBox getOUComboBox(CmsObject cms, String baseOu, Log log, boolean includeWebOU) {
        ComboBox combo;
        block4: {
            combo = null;
            try {
                IndexedContainer container = new IndexedContainer();
                container.addContainerProperty((Object)"desc", String.class, (Object)"");
                for (String ou : CmsOUHandler.getManagableOUs(cms)) {
                    if (!(includeWebOU | !OpenCms.getOrgUnitManager().readOrganizationalUnit(cms, ou).hasFlagWebuser())) continue;
                    Item item = container.addItem((Object)ou);
                    if (ou == "") {
                        CmsOrganizationalUnit root = OpenCms.getOrgUnitManager().readOrganizationalUnit(cms, "");
                        item.getItemProperty((Object)"desc").setValue((Object)root.getDisplayName(A_CmsUI.get().getLocale()));
                        continue;
                    }
                    item.getItemProperty((Object)"desc").setValue((Object)OpenCms.getOrgUnitManager().readOrganizationalUnit(cms, ou).getDisplayName(A_CmsUI.get().getLocale()));
                }
                combo = new ComboBox(null, (Container)container);
                combo.setTextInputAllowed(true);
                combo.setNullSelectionAllowed(false);
                combo.setWidth("379px");
                combo.setInputPrompt(Messages.get().getBundle(UI.getCurrent().getLocale()).key("GUI_EXPLORER_CLICK_TO_EDIT_0"));
                combo.setItemCaptionPropertyId((Object)"desc");
                combo.setFilteringMode(FilteringMode.CONTAINS);
                combo.select((Object)baseOu);
            }
            catch (CmsException e) {
                if (log == null) break block4;
                log.error((Object)"Unable to read OU", (Throwable)e);
            }
        }
        return combo;
    }

    public static String getPathItemId(Container cnt, String path) {
        for (String id : Arrays.asList(path, CmsFileUtil.toggleTrailingSeparator(path))) {
            if (!cnt.containsId((Object)id)) continue;
            return id;
        }
        return null;
    }

    public static IndexedContainer getPrincipalContainer(CmsObject cms, List<? extends I_CmsPrincipal> list, String captionID, String descID, String iconID, String ouID, String icon, List<FontIcon> iconList) {
        IndexedContainer res = new IndexedContainer();
        res.addContainerProperty((Object)captionID, String.class, (Object)"");
        res.addContainerProperty((Object)ouID, String.class, (Object)"");
        res.addContainerProperty((Object)iconID, FontIcon.class, (Object)new CmsCssIcon(icon));
        if (descID != null) {
            res.addContainerProperty((Object)descID, String.class, (Object)"");
        }
        for (I_CmsPrincipal i_CmsPrincipal : list) {
            Item item = res.addItem((Object)i_CmsPrincipal);
            item.getItemProperty((Object)captionID).setValue((Object)i_CmsPrincipal.getSimpleName());
            item.getItemProperty((Object)ouID).setValue((Object)i_CmsPrincipal.getOuFqn());
            if (descID == null) continue;
            item.getItemProperty((Object)descID).setValue((Object)i_CmsPrincipal.getDescription(A_CmsUI.get().getLocale()));
        }
        for (int i = 0; i < iconList.size(); ++i) {
            res.getItem(res.getIdByIndex(i)).getItemProperty((Object)iconID).setValue((Object)iconList.get(i));
        }
        return res;
    }

    public static IndexedContainer getProjectsContainer(CmsObject cms, String captionPropertyName) {
        IndexedContainer result = new IndexedContainer();
        result.addContainerProperty((Object)captionPropertyName, String.class, null);
        for (Map.Entry<CmsUUID, String> entry : CmsVaadinUtils.getProjectsMap(cms).entrySet()) {
            Item projectItem = result.addItem((Object)entry.getKey());
            projectItem.getItemProperty((Object)captionPropertyName).setValue((Object)entry.getValue());
        }
        return result;
    }

    public static LinkedHashMap<CmsUUID, String> getProjectsMap(CmsObject cms) {
        Locale locale = A_CmsUI.get().getLocale();
        List<CmsProject> projects = CmsVaadinUtils.getAvailableProjects(cms);
        boolean isSingleOu = CmsVaadinUtils.isSingleOu(projects);
        LinkedHashMap<CmsUUID, String> result = new LinkedHashMap<CmsUUID, String>();
        for (CmsProject project : projects) {
            String projectName = project.getSimpleName();
            if (!isSingleOu && !project.isOnlineProject()) {
                try {
                    projectName = projectName + " - " + OpenCms.getOrgUnitManager().readOrganizationalUnit(cms, project.getOuFqn()).getDisplayName(locale);
                }
                catch (CmsException e) {
                    LOG.debug((Object)"Error reading project OU.", (Throwable)e);
                    projectName = projectName + " - " + project.getOuFqn();
                }
            }
            result.put(project.getUuid(), projectName);
        }
        return result;
    }

    public static HttpServletRequest getRequest() {
        return (HttpServletRequest)VaadinService.getCurrentRequest();
    }

    public static List<I_CmsResourceType> getResourceTypes() {
        ArrayList<I_CmsResourceType> res = new ArrayList<I_CmsResourceType>();
        for (I_CmsResourceType type : OpenCms.getResourceManager().getResourceTypes()) {
            CmsExplorerTypeSettings typeSetting = OpenCms.getWorkplaceManager().getExplorerTypeSetting(type.getTypeName());
            if (typeSetting == null) continue;
            res.add(type);
        }
        return res;
    }

    public static IndexedContainer getResourceTypesContainer() {
        IndexedContainer container = new IndexedContainer();
        container.addContainerProperty((Object)PropertyId.caption, String.class, null);
        container.addContainerProperty((Object)PropertyId.icon, Resource.class, null);
        container.addContainerProperty((Object)PropertyId.isFolder, Boolean.class, null);
        container.addContainerProperty((Object)PropertyId.isXmlContent, Boolean.class, null);
        List<I_CmsResourceType> types = CmsVaadinUtils.getResourceTypes();
        CmsVaadinUtils.sortResourceTypes(types);
        for (I_CmsResourceType type : types) {
            CmsExplorerTypeSettings typeSetting = OpenCms.getWorkplaceManager().getExplorerTypeSetting(type.getTypeName());
            Item typeItem = container.addItem((Object)type);
            String caption = CmsVaadinUtils.getMessageText(typeSetting.getKey(), new Object[0]) + " (" + type.getTypeName() + ")";
            typeItem.getItemProperty((Object)PropertyId.caption).setValue((Object)caption);
            typeItem.getItemProperty((Object)PropertyId.icon).setValue((Object)CmsResourceUtil.getSmallIconResource(typeSetting, null));
            typeItem.getItemProperty((Object)PropertyId.isXmlContent).setValue((Object)(type instanceof CmsResourceTypeXmlContent));
            typeItem.getItemProperty((Object)PropertyId.isFolder).setValue((Object)(type instanceof A_CmsResourceTypeFolderBase));
        }
        return container;
    }

    public static IndexedContainer getRoleContainerForUser(CmsObject cms, CmsUser user, String captionPropertyName) {
        IndexedContainer result = new IndexedContainer();
        result.addContainerProperty((Object)captionPropertyName, String.class, (Object)"");
        try {
            List<CmsRole> roles = OpenCms.getRoleManager().getRoles(cms, user.getOuFqn(), false);
            CmsRole.applySystemRoleOrder(roles);
            for (CmsRole role : roles) {
                Item item = result.addItem((Object)role);
                item.getItemProperty((Object)captionPropertyName).setValue((Object)role.getDisplayName(cms, A_CmsUI.get().getLocale()));
            }
        }
        catch (CmsException e) {
            LOG.error((Object)"Unabel to read roles for user", (Throwable)e);
        }
        return result;
    }

    public static Window getWindow(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof Window) {
            return (Window)component;
        }
        return CmsVaadinUtils.getWindow((Component)component.getParent());
    }

    public static IndexedContainer getWorkplaceLanguageContainer(String captionPropertyName) {
        IndexedContainer result = new IndexedContainer();
        result.addContainerProperty((Object)captionPropertyName, String.class, (Object)"");
        CmsLanguagePreference.getOptionMapForLanguage().forEach((locale, title) -> {
            Item item = result.addItem(locale);
            item.getItemProperty((Object)captionPropertyName).setValue(title);
        });
        return result;
    }

    public static String getWorkplaceLink() {
        return OpenCms.getSystemInfo().getWorkplaceContext();
    }

    public static String getWorkplaceLink(String appId) {
        return CmsVaadinUtils.getWorkplaceLink() + "#!" + appId;
    }

    public static String getWorkplaceLink(String appId, String appState) {
        return CmsVaadinUtils.getWorkplaceLink(appId) + "/" + appState;
    }

    public static String getWorkplaceLink(String appId, String appState, Map<String, String[]> requestParameters) {
        String result = CmsVaadinUtils.getWorkplaceLink();
        if (requestParameters != null && !requestParameters.isEmpty()) {
            boolean first = true;
            for (Map.Entry<String, String[]> param : requestParameters.entrySet()) {
                for (String value : param.getValue()) {
                    result = first ? result + "?" : result + "&";
                    result = result + param.getKey() + "=" + value;
                    first = false;
                }
            }
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(appId)) {
            result = result + "#!" + appId;
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(appState)) {
            result = result + "/" + appState;
        }
        return result;
    }

    public static ExternalResource getWorkplaceResource(String subPath) {
        return new ExternalResource(CmsWorkplace.getResourceUri(subPath));
    }

    public static CmsMessages getWpMessagesForCurrentLocale() {
        Locale locale;
        if (A_CmsUI.get() != null) {
            locale = A_CmsUI.get().getLocale();
        } else {
            if (LOG.isWarnEnabled()) {
                Exception e = new Exception("getWpMessagesForCurrentLocale called from non-Vaadin context");
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            locale = Locale.ENGLISH;
        }
        return OpenCms.getWorkplaceManager().getMessages(locale);
    }

    public static boolean hasPathAsItemId(Container cnt, String path) {
        return cnt.containsId((Object)path) || cnt.containsId((Object)CmsFileUtil.toggleTrailingSeparator(path));
    }

    public static boolean isButtonPressed(Button button) {
        if (button == null) {
            return false;
        }
        List<String> styles = Arrays.asList(button.getStyleName().split(" "));
        return styles.contains("o-button-pressed");
    }

    public static String localizeString(String baseString) {
        if (baseString == null) {
            return null;
        }
        CmsWorkplaceMessages wpMessages = OpenCms.getWorkplaceManager().getMessages(A_CmsUI.get().getLocale());
        CmsMacroResolver resolver = new CmsMacroResolver();
        resolver.setMessages(wpMessages);
        String result = resolver.resolveMacros(baseString);
        return result;
    }

    public static String messageCancel() {
        return CmsVaadinUtils.getMessageText("GUI_DIALOG_BUTTON_CANCEL_0", new Object[0]);
    }

    public static String messageClose() {
        return CmsVaadinUtils.getMessageText("GUI_DIALOG_BUTTON_CLOSE_0", new Object[0]);
    }

    public static String messageOk() {
        return CmsVaadinUtils.getMessageText("GUI_DIALOG_BUTTON_OK_0", new Object[0]);
    }

    public static void prepareComboBox(ComboBox box, Map<?, String> options) {
        IndexedContainer container = new IndexedContainer();
        container.addContainerProperty((Object)PROPERTY_VALUE, Object.class, null);
        container.addContainerProperty((Object)PROPERTY_LABEL, String.class, (Object)"");
        for (Map.Entry<?, String> entry : options.entrySet()) {
            Item item = container.addItem(entry.getKey());
            item.getItemProperty((Object)PROPERTY_VALUE).setValue(entry.getKey());
            item.getItemProperty((Object)PROPERTY_LABEL).setValue((Object)entry.getValue());
        }
        box.setContainerDataSource((Container)container);
        box.setItemCaptionPropertyId((Object)PROPERTY_LABEL);
    }

    public static void readAndLocalizeDesign(Component component, CmsMessages messages, Map<String, String> macros) {
        String filename;
        Class cls;
        Class<?> componentClass = component.getClass();
        ArrayList classes = Lists.newArrayList();
        classes.add(componentClass);
        classes.addAll(ClassUtils.getAllSuperclasses(componentClass));
        InputStream designStream = null;
        Iterator iterator = classes.iterator();
        while (iterator.hasNext() && !(cls = (Class)iterator.next()).getName().startsWith("com.vaadin") && (designStream = cls.getResourceAsStream(filename = cls.getSimpleName() + ".html")) == null) {
        }
        if (designStream == null) {
            throw new IllegalArgumentException("Design not found for : " + component.getClass());
        }
        CmsVaadinUtils.readAndLocalizeDesign(component, designStream, messages, macros);
    }

    public static InputStream readCustomLayout(Class<? extends Component> layoutClass, String relativeName) {
        CmsMacroResolver resolver = new CmsMacroResolver(){

            @Override
            public String getMacroValue(String macro) {
                return CmsEncoder.escapeXml(super.getMacroValue(macro));
            }
        };
        resolver.setMessages(CmsVaadinUtils.getWpMessagesForCurrentLocale());
        InputStream layoutStream = CmsVaadinUtils.filterUtf8ResourceStream(layoutClass.getResourceAsStream(relativeName), resolver.toFunction());
        return layoutStream;
    }

    public static void replaceComponent(Component component, Component replacement) {
        if (!component.isAttached()) {
            throw new IllegalArgumentException("Component must be attached");
        }
        HasComponents parent = component.getParent();
        if (parent instanceof ComponentContainer) {
            ((ComponentContainer)parent).replaceComponent(component, replacement);
        } else if (parent instanceof SingleComponentContainer) {
            ((SingleComponentContainer)parent).setContent(replacement);
        } else {
            throw new IllegalArgumentException("Illegal class for parent: " + parent.getClass());
        }
    }

    public static void setFilterBoxStyle(TextField searchBox) {
        searchBox.setIcon((Resource)FontOpenCms.FILTER);
        searchBox.setPlaceholder(Messages.get().getBundle(UI.getCurrent().getLocale()).key("GUI_EXPLORER_FILTER_0"));
        searchBox.addStyleName("inline-icon");
    }

    public static <T> void setReadonlyValue(AbstractField<T> field, T value) {
        boolean readonly = field.isReadOnly();
        try {
            field.setReadOnly(false);
            field.setValue(value);
        }
        finally {
            field.setReadOnly(readonly);
        }
    }

    public static void showAlert(String title, String message, final Runnable callback) {
        final Window window = new Window();
        window.setModal(true);
        Panel panel = new Panel();
        panel.setCaption(title);
        panel.setWidth("500px");
        VerticalLayout layout = new VerticalLayout();
        layout.setMargin(true);
        panel.setContent((Component)layout);
        layout.addComponent((Component)new Label(message));
        Button okButton = new Button();
        okButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                window.close();
                if (callback != null) {
                    callback.run();
                }
            }
        });
        layout.addComponent((Component)okButton);
        layout.setComponentAlignment((Component)okButton, Alignment.BOTTOM_RIGHT);
        okButton.setCaption(org.opencms.workplace.Messages.get().getBundle(A_CmsUI.get().getLocale()).key("GUI_DIALOG_BUTTON_OK_0"));
        window.setContent((Component)panel);
        window.setClosable(false);
        window.setResizable(false);
        A_CmsUI.get().addWindow(window);
    }

    public static void sortResourceTypes(List<I_CmsResourceType> resourceTypes) {
        Collections.sort(resourceTypes, (type, other) -> {
            CmsExplorerTypeSettings typeSetting = OpenCms.getWorkplaceManager().getExplorerTypeSetting(type.getTypeName());
            CmsExplorerTypeSettings otherSetting = OpenCms.getWorkplaceManager().getExplorerTypeSetting(other.getTypeName());
            if (typeSetting != null && otherSetting != null) {
                String typeName = CmsVaadinUtils.getMessageText(typeSetting.getKey(), new Object[0]);
                String otherName = CmsVaadinUtils.getMessageText(otherSetting.getKey(), new Object[0]);
                return typeName.compareTo(otherName);
            }
            return -1;
        });
    }

    public static OptionGroupBuilder startOptionGroup() {
        return new OptionGroupBuilder();
    }

    public static void toggleButton(Button button) {
        if (CmsVaadinUtils.isButtonPressed(button)) {
            button.removeStyleName("o-button-pressed");
        } else {
            button.addStyleName("o-button-pressed");
        }
    }

    public static boolean updateComponentError(AbstractComponent component, ErrorMessage error) {
        if (component.getComponentError() != error) {
            component.setComponentError(error);
            return true;
        }
        return false;
    }

    public static void visitDescendants(Component component, Predicate<Component> handler) {
        ArrayList stack = Lists.newArrayList();
        stack.add(component);
        while (!stack.isEmpty()) {
            Component currentComponent = (Component)stack.get(stack.size() - 1);
            stack.remove(stack.size() - 1);
            if (!handler.apply((Object)currentComponent)) {
                return;
            }
            if (!(currentComponent instanceof HasComponents)) continue;
            ArrayList children = Lists.newArrayList((Iterable)((HasComponents)currentComponent));
            Collections.reverse(children);
            stack.addAll(children);
        }
    }

    public static void waggleMeOnce(Component component) {
        component.addStyleName("waggler");
        JavaScript.getCurrent().execute("waggler=document.querySelectorAll(\".waggler\")[0];waggler.className=waggler.className + \" waggle\";setTimeout(function () {\nwaggler.className=waggler.className.replace(/\\bwaggle\\b/g, \"\");    }, 1500);");
    }

    protected static void readAndLocalizeDesign(Component component, InputStream designStream, CmsMessages messages, Map<String, String> macros) {
        try {
            byte[] designBytes = CmsFileUtil.readFully(designStream, true);
            String encoding = "UTF-8";
            String design = new String(designBytes, "UTF-8");
            CmsMacroResolver resolver = new CmsMacroResolver(){

                @Override
                public String getMacroValue(String macro) {
                    String result = super.getMacroValue(macro);
                    return CmsEncoder.escapeXml(result);
                }
            };
            if (macros != null) {
                for (Map.Entry<String, String> entry : macros.entrySet()) {
                    resolver.addMacro(entry.getKey(), entry.getValue());
                }
            }
            if (messages != null) {
                resolver.setMessages(messages);
            }
            String resolvedDesign = resolver.resolveMacros(design);
            Design.read((InputStream)new ByteArrayInputStream(resolvedDesign.getBytes("UTF-8")), (Component)component);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read design", e);
        }
        finally {
            try {
                designStream.close();
            }
            catch (IOException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    private static boolean isSingleOu(List<CmsProject> projects) {
        String ouFqn = null;
        for (CmsProject project : projects) {
            if (project.isOnlineProject()) continue;
            if (ouFqn == null) {
                ouFqn = project.getOuFqn();
                continue;
            }
            if (ouFqn.equals(project.getOuFqn())) continue;
            return false;
        }
        return true;
    }

    public static enum PropertyId {
        caption,
        icon,
        isFolder,
        isXmlContent;

    }

    public static class OptionGroupBuilder {
        private OptionGroup m_optionGroup = new OptionGroup();

        public OptionGroupBuilder add(String key, String text) {
            this.m_optionGroup.addItem((Object)key);
            this.m_optionGroup.setItemCaption((Object)key, text);
            return this;
        }

        public OptionGroup build() {
            return this.m_optionGroup;
        }

        public OptionGroupBuilder horizontal() {
            this.m_optionGroup.addStyleName("horizontal");
            return this;
        }
    }
}

