/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.actions;

import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.actions.A_CmsWorkplaceAction;
import org.opencms.ui.actions.I_CmsDefaultAction;
import org.opencms.ui.apps.A_CmsWorkplaceApp;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilitySingleOnly;
import org.opencms.ui.contextmenu.CmsStandardVisibilityCheck;
import org.opencms.ui.contextmenu.I_CmsHasMenuItemVisibility;
import org.opencms.util.CmsStringUtil;

public class CmsDisplayAction
extends A_CmsWorkplaceAction
implements I_CmsDefaultAction {
    public static final String ONLINE_WINDOW_NAME = "_blank";
    public static final String ACTION_ID = "display";
    public static final I_CmsHasMenuItemVisibility VISIBILITY = new CmsMenuItemVisibilitySingleOnly(CmsStandardVisibilityCheck.EDIT);

    @Override
    public void executeAction(I_CmsDialogContext context) {
        if (context.getResources().size() == 1) {
            CmsResource resource = context.getResources().get(0);
            if (OpenCms.getResourceManager().getResourceType(resource).getTypeName().equals("listconfig")) {
                CmsAppWorkplaceUi.get().showApp(OpenCms.getWorkplaceAppManager().getAppConfiguration("list-management"), A_CmsWorkplaceApp.addParamToState("", "resourceId", resource.getStructureId().toString()));
            } else {
                CmsObject cms = context.getCms();
                try {
                    cms = OpenCms.initCmsObject(cms);
                    cms.getRequestContext().setUri(cms.getSitePath(resource));
                }
                catch (CmsException cmsException) {
                    // empty catch block
                }
                boolean isOnline = cms.getRequestContext().getCurrentProject().isOnlineProject();
                String link = isOnline && !CmsStringUtil.isEmptyOrWhitespaceOnly(cms.getRequestContext().getSiteRoot()) && !OpenCms.getSiteManager().isSharedFolder(cms.getRequestContext().getSiteRoot()) ? OpenCms.getLinkManager().getOnlineLink(cms, cms.getSitePath(resource)) : OpenCms.getLinkManager().substituteLink(cms, resource);
                if (isOnline || !(OpenCms.getResourceManager().getResourceType(resource) instanceof CmsResourceTypeXmlContent)) {
                    A_CmsUI.get().openPageOrWarn(link, ONLINE_WINDOW_NAME);
                } else {
                    A_CmsUI.get().getPage().setLocation(link);
                }
            }
        }
    }

    @Override
    public int getDefaultActionRank(I_CmsDialogContext context) {
        return 10;
    }

    @Override
    public String getId() {
        return ACTION_ID;
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(CmsObject cms, List<CmsResource> resources) {
        if (resources.size() == 1 && resources.get(0).isFile() && !CmsResourceTypeXmlContainerPage.isContainerPage(resources.get(0))) {
            return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
        }
        return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
    }

    @Override
    protected String getTitleKey() {
        return "GUI_ACTION_DISPLAY_0";
    }
}

